/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMConst;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynByClassCostCalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)DynByClassCostCalReport.class.getName());
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();
    private PeriodInfo periodFrom = null;
    private PeriodInfo periodTo = null;
    Date beginDate = null;
    Date endDate = null;
    private static final String ORDER_BY = " ORDER BY FPeriodNumber,FCostCenterID,FCostObjectID,FProductID,FCostItemId ";
    public static final Object[] HeaderGroup = new Object[]{new String[]{"FPeriodNumber"}, new String[]{"FCostCenterID", "FCostCenterNumber", "FCostCenterName"}, new String[]{"FCostObjectID", "FCostObjectNumber", "FCostObjectName"}, new String[]{"FCurCompQty", "FProductID", "FProductNumber", "FProductName", "FModel", "FUnitName"}, new String[]{"FCostItemID", "FCostItemNumber", "FCostItemName"}};

    protected void initData(RptParams filter) {
        this.periodFrom = (PeriodInfo)filter.getObject("prmtPeriodFrom");
        this.periodTo = (PeriodInfo)filter.getObject("prmtPeriodTo");
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String sTableName = super.getTablename();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + sTableName + ORDER_BY));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
        return rs;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("disPlayOnlyTotalRow");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        Context ctx = this.getContext();
        String orderBy = this.getSortString(ctx, filter, orderByMode);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " ORDER BY FTotalRow2 " + orderByMode + "," + orderBy + ", FTotalRow"), (int)start, (int)rows);
        return rs;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        String[] physicalTblNames;
        Context ctx = this.getContext();
        this.initData(filter);
        String companyID = null;
        if (filter.getObject("prmtCompanyOrg") != null) {
            companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        } else {
            return null;
        }
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct cpr.FCostObjectID,co.FNumber FROM ").append(physicalTblNames[0]).append(" cpr ").append("INNER JOIN T_NCM_Period prd on cpr.FcalculatePeriodID = prd.FID\n").append("INNER JOIN T_ORG_CostCenter cc on cpr.FCostCenterID = cc.FID\n").append("INNER JOIN T_NCM_CostItem ci on cpr.FCostItemID = ci.FID ").append("INNER JOIN T_BD_CostObject co on (cpr.FCompanyID = co.FCompanyID and cpr.FCostObjectID = co.FID) \n").append("INNER JOIN T_BD_Material mat on cpr.FProductID=mat.FID\n").append(" WHERE cpr.FCompanyID = ? \n").append(" \tAND CO.FCalculateMode = ").append(3);
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)">=", (String)"prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)"<=", (String)"prmtCostCenterTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)">=", (String)"prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)"<=", (String)"prmtCostObjectTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"mat.FNumber", (String)">=", (String)"prmtProductFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"mat.FNumber", (String)"<=", (String)"prmtProductTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)">=", (String)"prmtCostItemFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)"<=", (String)"prmtCostItemTo");
        sbSQL.append(" ORDER BY co.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new Object[]{companyID});
        Integer nCountPerPage = new Integer(filter.getString("spCostObjectNum"));
        if (nCountPerPage <= 0) {
            nCountPerPage = new Integer(1);
        }
        return NCMReportHelper.getListWithDynamicRowSet((Context)ctx, (Integer)nCountPerPage, (IRowSet)rs, (String)"FCostObjectID");
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String sTableName = this.buildReportData(filter);
        this.setTablename(sTableName);
        return super.getTablename();
    }

    protected String buildReportData(RptParams filter) throws BOSException, EASBizException {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
        CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        String companyName = company.getName();
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        String sTmpTblName = this.createTmpTable();
        String sqlAll = this.getSQL(companyName, filter, physicalTblNames, sTmpTblName);
        DbUtil.execute((Context)this.getContext(), (String)sqlAll, (Object[])new Object[]{companyID});
        StringBuffer sqlResult = this.insertDataToTableSum(physicalTblNames, sTmpTblName, companyName, filter, companyID);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlResult.toString());
        return sTmpTblName;
    }

    private StringBuffer insertDataToTableSum(String[] physicalTblNames, String tempTableNameSum, String orgCompanyName, RptParams filter, String companyID) {
        Context ctx = this.getContext();
        ArrayList list = NCMReportHelper.getGroupByList((ArrayList)((ArrayList)filter.getObject("table")));
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("groupby");
            fields = fields.replaceAll("FPeriodNumber", "FPeriodID,FPeriodNumber,FPeriodName");
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FTotalRow," + fields + ", \n");
            sql.append(" FCurAllAmount ) \n");
            sql.append(" SELECT " + map.get("totalrow").toString() + "," + fields + ",");
            sql.append(" Sum(FCurAllAmount) as FCurAllAmount \n");
            sql.append(" FROM " + tempTableNameSum + "\n");
            sql.append(" WHERE FTotalRow = 0 \n");
            sql.append(" group by " + fields);
            sql.append("\n\n;");
        }
        sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
        sql.append(" FOrgName,FTotalRow, FTotalRow2, \n");
        sql.append(" FCurAllAmount\n");
        sql.append(" ) \n");
        sql.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "', ").append(200).append(", 1, ");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" where FTotalRow = 0  \n");
        sql.append("\n\n;");
        try {
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
            sql.setLength(0);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        sql.append(" Update " + tempTableNameSum).append(" as S SET (FCurCompQty)= (SELECT  ").append(" \tdbo.FFinishedQty ").append(" FROM ").append(physicalTblNames[2]).append(" dbo INNER JOIN T_NCM_Period P on dbo.FCalculatePeriodID = P.FID               \n ").append(" where dbo.FcompanyID = '").append(companyID).append("' ").append(" AND P.Fnumber = S.FPeriodNumber AND ").append(" S.FCostCenterID = dbo.FCostCenterID AND S.FCostObjectID = dbo.FCostObjectID ").append(" ) WHERE FTotalRow > ").append(5).append(" ; \n ");
        sql.append(" Update " + tempTableNameSum).append(" as S SET (FCurCompQty)= (SELECT  ").append(" \tdbo.FFinishedQty ").append(" FROM ").append(physicalTblNames[1]).append(" dbo INNER JOIN T_NCM_Period P on dbo.FCalculatePeriodID = P.FID            \n ").append(" where dbo.FcompanyID = '").append(companyID).append("' ").append(" AND P.Fnumber = S.FPeriodNumber AND S.FCostCenterID = dbo.FCostCenterID").append(" AND S.FCostObjectID = dbo.FCostObjectID AND S.FProductID = dbo.FProductID ").append(" ) WHERE FTotalRow = ").append(5).append(" or FTotalRow = ").append(4).append(" ; \n ");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + BDCMConst.LocLan + " \n");
        sql.append(" FROM T_ORG_CostCenter T2 WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID ) \n");
        sql.append(" Where FTotalRow > 0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + BDCMConst.LocLan + "\n");
        sql.append(" FROM T_BD_CostObject T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID =T2.FID ) \n ");
        sql.append(" Where FTotalRow > 0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FProductNumber,FProductName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + BDCMConst.LocLan + "\n");
        sql.append(" FROM T_BD_Material T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FProductID =T2.FID ) \n ");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostItemNumber,FCostItemName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + BDCMConst.LocLan + " \n");
        sql.append(" FROM T_NCM_CostItem T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostItemID =T2.FID ) \n ");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET FOrgName= '" + orgCompanyName + "' \n");
        sql.append(" Where FTotalRow >0 AND FTotalRow2 <> 1 ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FUnitName,FModel)= \n");
        sql.append(" (SELECT T4.FName_" + BDCMConst.LocLan + ",T3.FModel \n");
        sql.append(" FROM  ");
        sql.append(" t_bd_Material T3  \n");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FProductID=T3.FID ) \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FQtyDecimal= \n");
        sql.append(" (SELECT MAX(T4.FqtyPrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FPriceDecimal= \n");
        sql.append(" (SELECT MAX(T3.FPricePrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append("UPDATE ").append(tempTableNameSum).append(" SET (FPriceDecimal)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        String field = "";
        String fieldNumber = "";
        String fieldName = "";
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            fieldName = "FPeriodNumber".equals(field) ? field.substring(0, field.length() - 6) + "Name" : field.substring(0, field.length() - 2) + "Name";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemID")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProductID")) {
                whichTotal = ", FTotalProductRow = 1 ";
            }
            if (field.equals("FPeriodNumber")) {
                sql.append(" update " + tempTableNameSum + " set " + field + " = " + field + " || '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
                sql.append(whichTotal);
                sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sql.append("\n\n;");
                continue;
            }
            sql.append(" update " + tempTableNameSum + " set " + fieldName + " = " + "' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
            sql.append(whichTotal);
            sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sql.append("\n\n;");
        }
        sql.append(" DELETE " + tempTableNameSum + " WHERE FTOTALROW > 0 AND  (FCostCenterNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' " + "OR FCostObjectNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' OR FProductNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' OR FCostItemNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "') ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ") \n,FPriceDecimal= (SELECT MAX(FPriceDecimal) FROM " + tempTableNameSum + ") \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum).append(" as S SET (FCurUnitPrice)= (SELECT  ").append(" CASE WHEN FTotalRow = ").append(7).append(" or FTotalRow = ").append(8).append(" THEN 0 ").append(" WHEN FTotalRow >0 and FTotalRow <= ").append(6).append(" THEN  ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)sql, (String)"FCurAllAmount", (String)"FCurCompQty", (String)" ", (String)"FPriceDecimal");
        sql.append("  ELSE FCurUnitPrice END ").append(" ) ; \n ");
        return sql;
    }

    private String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException {
        String[] physicalTblNames = new String[3];
        try {
            physicalTblNames[0] = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynCostCalPrdDetailResult_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            physicalTblNames[1] = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynDataByProduct_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            physicalTblNames[2] = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynDataByCostObj_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return physicalTblNames;
    }

    private String createTmpTable() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append("FOrgName varchar(255) default(' ') ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) default(' ') ");
        createTable.append(",FCostCenterID varchar(44) default(' ') ");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FCostObjectID varchar(44)  default(' ') ");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FProductID varchar(44)  default(' ') ");
        createTable.append(",FProductNumber varchar(255) default(' ') ");
        createTable.append(",FProductName varchar(255) default(' ') ");
        createTable.append(",FModel nvarchar(255) default(' ') ");
        createTable.append(",FUnitName varchar(255) default(' ') ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCostItemID varchar(44) default(' ')");
        createTable.append(",FCostItemNumber varchar(255) default(' ')");
        createTable.append(",FCostItemName varchar(255) default(' ')");
        createTable.append(",FCurAllAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FTotalRow decimal(5,2) not null default(0) ");
        createTable.append(",FTotalRow2 decimal(5,2) not null default(0) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String getSQL(String companyName, RptParams filter, String[] physicalTblNames, String tmpTblName) {
        Context ctx = this.getContext();
        this.initData(filter);
        StringBuffer insert = new StringBuffer();
        insert.append(" Insert Into ").append(tmpTblName).append("(FOrgName,FPeriodNumber,FPeriodID,FPeriodName,FCostCenterID,FCostCenterNumber,FCostCenterName,FCostObjectID,FCostObjectNumber ").append(",FCostObjectName,FProductID,FProductNumber,FProductName,FModel,FUnitName,FCurCompQty,FCostItemID ").append(",FCostItemNumber,FCostItemName,FCurAllAmount,FCurUnitPrice,FQtyDecimal,FPriceDecimal,FIsTotalRow) \n").append(" SELECT '").append(companyName).append("',to_char(prd.FNumber),prd.FID,prd.FName_l2,cc.FID,cc.FNumber,cc.FName_l2,co.FID,co.FNumber").append(" ,co.FName_l2,mat.FID,mat.FNumber,mat.FName_l2,mat.FModel,mu.FName_l2,isnull(s.FFinishedQty,0)").append(" ,ci.FID,ci.FNumber,ci.FName_l2,isnull(cpr.FFinishedAmount,0) , ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)insert, (String)"cpr.FFinishedAmount", (String)"s.FFinishedQty", (String)"FCurUnitPrice", (String)"mat.FPricePrecision");
        insert.append(" , mmu.FQtyPrecision,mat.FPricePrecision,").append(" 0 AS FIsTotalRow").append(" FROM ").append(physicalTblNames[0]).append(" AS cpr ").append("INNER JOIN ").append(physicalTblNames[1]).append(" s \n").append(" ON S.FCompanyID = cpr.FCompanyID and S.FCalculatePeriodID = cpr.FCalculatePeriodID and S.FCostCenterID =cpr.FCostCenterID").append("  and S.FCostObjectID = cpr.FCostObjectID and S.FProductID =cpr.FProductID \n").append(" INNER JOIN T_NCM_Period prd on cpr.FCalculatePeriodID = prd.FID                                    \n ").append(" INNER JOIN T_ORG_CostCenter cc on cpr.FCostCenterID = cc.FID            \t\t\t\t\t\t    \n ").append(" INNER JOIN T_NCM_CostItem ci on cpr.FCostItemID=ci.FID \n\t").append(" INNER JOIN T_BD_CostObject co on (cpr.FCompanyID = co.FCompanyID and cpr.FCostObjectID = co.FID)   \n").append(" INNER JOIN T_BD_Material mat on cpr.FProductID = mat.FID                                          \n ").append(" INNER JOIN t_bd_multiMeasureUnit mmu on mat.fid = mmu.FMaterialID   \n ").append(" INNER JOIN T_BD_MeasureUnit mu on mmu.FMeasureUnitID = mu.FID    and mat.FBaseUnit=mu.fid          \n");
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append(" WHERE cpr.FCompanyID = ? \n").append(" \tAND co.FCalculateMode = ").append(3).append(" and prd.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(this.beginDate)).append("') \n").append(" and prd.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(this.endDate)).append("') \n");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)">=", (String)"prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)"<=", (String)"prmtCostCenterTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)">=", (String)"prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)"<=", (String)"prmtCostObjectTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"mat.FNumber", (String)">=", (String)"prmtProductFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"mat.FNumber", (String)"<=", (String)"prmtProductTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)">=", (String)"prmtCostItemFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)whereSQL, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)"<=", (String)"prmtCostItemTo");
        NCMReportHelper.AppendPredicateForOnePage((StringBuffer)whereSQL, (RptParams)filter, (String)"FCostObjectID", (String)"co.FID");
        String sql = insert.append(whereSQL).toString();
        return sql;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"4_DynByClassCostCalReport", (Locale)ctx.getLocale()) + this.periodFrom.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"5_DynByClassCostCalReport", (Locale)ctx.getLocale()) + this.periodTo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostCenterFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostCenterTo"))) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"7_DynByClassCostCalReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtCostCenterFrom") + "\u2014" + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtCostCenterTo"));
        } else {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"8_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostObjectFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostObjectTo"))) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"9_DynByClassCostCalReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtCostObjectFrom") + "\u2014" + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtCostObjectTo"));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"10_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostItemFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostItemTo"))) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"11_DynByClassCostCalReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtCostItemFrom") + "\u2014" + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtCostItemFromTo"));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"12_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtProductFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtProductTo"))) {
            titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"13_DynByClassCostCalReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtProductFrom") + "\u2014" + CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)"prmtProductTo"));
        } else {
            titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"14_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader header = super.getReportHeader(reportID, filter);
        ArrayList tblData = (ArrayList)filter.getObject("table");
        ArrayList childs = header.getChilds();
        HashMap<String, ReportHeader> headerMap = new HashMap<String, ReportHeader>();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            ReportHeader child = (ReportHeader)childs.get(i2);
            String fieldName = child.getFieldName().toLowerCase();
            headerMap.put(fieldName.toLowerCase(), child);
        }
        ArrayList temp = new ArrayList(childs.size());
        temp.addAll(childs);
        childs.clear();
        ArrayList<String> sortedCols = new ArrayList<String>();
        sortedCols.add("FOrgName");
        int qtyCounter = 0;
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodNumber".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FPeriodNumber");
                ++qtyCounter;
            }
            if ("FCostobjectID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostObjectNumber");
                sortedCols.add("FCostObjectName");
            }
            if ("FProductID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FProduct");
                sortedCols.add("FProductNumber");
                sortedCols.add("FProductName");
                sortedCols.add("FModel");
                sortedCols.add("FUnitName");
                sortedCols.add("FCurCompQty");
                ++qtyCounter;
            }
            if ("FCostcenterID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostCenterNumber");
                sortedCols.add("FCostCenterName");
                ++qtyCounter;
            }
            if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostItemNumber");
                sortedCols.add("FCostItemName");
            }
            if ("FMatID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FMatNumber");
                sortedCols.add("FMatName");
                sortedCols.add("FMatModel");
                sortedCols.add("FMatShortName");
                sortedCols.add("FMatUnitCommonName");
                sortedCols.add("FMatUnitName");
                sortedCols.add("FMatUnitAssistName");
                sortedCols.add("FMatLot");
            }
            if (qtyCounter != 3) continue;
            sortedCols.add("FObjQ");
            qtyCounter = 0;
        }
        for (i = 0; i < sortedCols.size(); ++i) {
            String field = (String)sortedCols.get(i);
            ReportHeader child = (ReportHeader)headerMap.get(field.toLowerCase());
            if (child == null) continue;
            childs.add(child);
            temp.remove(child);
        }
        childs.addAll(temp);
        return header;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        return super.buildReportFormatConditions(reportID);
    }

    public String getSortString(Context ctx, RptParams filter, String sortMode) {
        ArrayList tableList = (ArrayList)filter.getObject("table");
        if (tableList == null) {
            tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"83_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"84_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FProductID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"181_ByClassCostCalReportFilter2UI", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"85_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
        }
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < tableList.size(); ++i) {
            HashMap map = (HashMap)tableList.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (field.equalsIgnoreCase("FPeriodNumber")) {
                orderByWhichTotal = ", FTotalPeriodRow " + sortMode;
                fieldNumber = "FPeriodName";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumber")) {
                orderByWhichTotal = ", FTotalProductRow " + sortMode;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                sbChecked.append(fieldNumber);
                sbChecked.append(orderByWhichTotal);
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(fieldNumber);
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked.toString();
    }
}

