/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public class DynCCFeeTotalReport
extends ReportServerBase {
    private PeriodInfo periodFrom = null;
    private PeriodInfo periodTo = null;
    Date beginDate = null;
    Date endDate = null;
    SimpleDateFormat dateFormate = null;

    protected void initData(RptParams filter) {
        this.periodFrom = (PeriodInfo)filter.getObject("periodFrom");
        this.periodTo = (PeriodInfo)filter.getObject("periodTo");
        this.beginDate = new Date(this.periodFrom.getBeginDate().getTime());
        this.endDate = new Date(this.periodTo.getEndDate().getTime());
        this.dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private String buildFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("costcenterfrom") != null && !"".equals(filter.getString("costcenterfrom"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER >='").append(filter.getString("costcenterfrom")).append("'");
        }
        if (filter.getString("costcenterto") != null && !"".equals(filter.getString("costcenterto"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER <='").append(filter.getString("costcenterto")).append("'");
        }
        if (filter.getString("expensefrom") != null && !"".equals(filter.getString("expensefrom"))) {
            sb.append(" and T_NCM_EXPENSE.FNumber >='").append(filter.getString("expensefrom")).append("'");
        }
        if (filter.getString("expenseto") != null && !"".equals(filter.getString("expenseto"))) {
            sb.append(" and T_NCM_EXPENSE.FNumber <='").append(filter.getString("expenseto")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException, SQLException, EASBizException {
        String stempTableName;
        this.initData(filter);
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table t1( ");
        sb.append("fcostcenterid varchar(44),");
        sb.append("fexpenseid varchar(44),");
        sb.append("fexpensenumber nvarchar(80) default(''),");
        sb.append("fexpensename nvarchar(250)  default(''),");
        sb.append("fcostcenternumber nvarchar(80) default(''),");
        sb.append("fcostcentername nvarchar(250)  default(''),");
        sb.append("fperiod  varchar(80),");
        sb.append("famount decimal(28,10) default(0),");
        sb.append("FTotalRow int default(0),");
        sb.append("FsubRow int default(0),");
        sb.append("ftype int");
        sb.append(")");
        try {
            stempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(sb.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Context ctx = this.getContext();
        Connection cn = null;
        Statement st = null;
        try {
            IRowSet rs;
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            Locale locale = this.getContext().getLocale();
            String scompanyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
            String swhere = this.buildFilters(filter);
            String sbf = "fperiod,fcostcenternumber,fcostcentername,fexpensenumber,fexpensename,famount,FTotalRow";
            String number = " substring(to_char(T_NCM_OTHERFEEBILL.FBizDate,'yyyy-mm-dd'),0,4)||'Y.'||substring(to_char(T_NCM_OTHERFEEBILL.FBizDate,'yyyy-mm-dd'),6,2)||'M.'||substring(to_char(T_NCM_OTHERFEEBILL.FBizDate,'yyyy-mm-dd'),9,2)||'D'";
            sb = new StringBuffer();
            sb.append("insert into " + stempTableName + "(\n");
            sb.append("fexpenseid,fcostcenterid,fperiod,famount,ftype");
            sb.append(")\n");
            sb.append("select T_NCM_OTHERFEEBILL.FEXPENSEID as fexpenseid,T_NCM_OTHERFEEBILL.FCOSTCENTERID as fcostcenterid,");
            sb.append(number + " as fperiod,");
            sb.append("T_NCM_OTHERFEEBILLENTRY.FAMOUNT as famount,1 as ftype \n");
            sb.append(" FROM T_NCM_OTHERFEEBILL  JOIN T_NCM_OTHERFEEBILLENTRY ON \n");
            sb.append(" T_NCM_OTHERFEEBILLENTRY.FPARENTID=T_NCM_OTHERFEEBILL.FID \n");
            sb.append(" JOIN T_NCM_EXPENSE ON T_NCM_EXPENSE.FID=T_NCM_OTHERFEEBILL.FEXPENSEID \n");
            sb.append(" JOIN T_ORG_COSTCENTER ON T_ORG_COSTCENTER.FID=T_NCM_OTHERFEEBILL.FCOSTCENTERID \n");
            sb.append("where T_NCM_OTHERFEEBILL.FCompanyOrg='" + scompanyID + "'");
            sb.append(swhere + "\n");
            sb.append(" and T_NCM_OTHERFEEBILL.FBizDate >= TO_DATE('").append(this.dateFormate.format(this.beginDate)).append("') ").append("and T_NCM_OTHERFEEBILL.FBizDate <= TO_DATE('").append(this.dateFormate.format(this.endDate)).append("') ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            number = " substring(to_char(T_IM_MaterialReqBill.FBizDate,'yyyy-mm-dd'),0,4)||'Y.'||substring(to_char(T_IM_MaterialReqBill.FBizDate,'yyyy-mm-dd'),6,2)||'M.'||substring(to_char(T_IM_MaterialReqBill.FBizDate,'yyyy-mm-dd'),9,2)||'D'";
            sb.append("insert into " + stempTableName + "(\n");
            sb.append("fexpenseid,fcostcenterid,fperiod,famount,ftype");
            sb.append(")\n");
            sb.append("select T_NCM_EXPENSE.FID as fexpenseid,T_ORG_COSTCENTER.FID as fcostcenterid,");
            sb.append(number + " as fperiod,");
            sb.append("T_IM_MaterialReqBillEntry.FACTUALCOST as famount,1 as ftype \n");
            sb.append(" FROM T_IM_MaterialReqBill JOIN T_IM_MaterialReqBillEntry ON  T_IM_MaterialReqBillEntry.FPARENTID=T_IM_MaterialReqBill.FID \n");
            sb.append(" JOIN T_NCM_EXPENSE ON T_NCM_EXPENSE.FEXPENSEtype=1 \n");
            sb.append(" JOIN T_ORG_COSTCENTER ON T_ORG_COSTCENTER.FID=T_IM_MaterialReqBillEntry.FCostCenterOrgUnitID \n");
            sb.append("where T_IM_MaterialReqBillEntry.FCompanyOrgUnitID='" + scompanyID + "'");
            sb.append(swhere + "\n");
            sb.append(" and T_IM_MaterialReqBill.FBizDate >= TO_DATE('").append(this.dateFormate.format(this.beginDate)).append("') ").append("and T_IM_MaterialReqBill.FBizDate <= TO_DATE('").append(this.dateFormate.format(this.endDate)).append("') ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            number = " substring(to_char(bl.FBizDate,'yyyy-mm-dd'),0,4)||'Y.'||substring(to_char(bl.FBizDate,'yyyy-mm-dd'),6,2)||'M.'||substring(to_char(bl.FBizDate,'yyyy-mm-dd'),9,2)||'D'";
            sb.append("insert into " + stempTableName + "(\n");
            sb.append("fexpenseid,fcostcenterid,fperiod,famount,ftype");
            sb.append(")\n");
            sb.append("select T_NCM_EXPENSE.FID as fexpenseid,T_ORG_COSTCENTER.FID as fcostcenterid,");
            sb.append(number + " as fperiod,");
            sb.append("entry.FACTUALAmount as famount,1 as ftype \n");
            sb.append(" FROM T_NCM_InnerOverheadBill bl JOIN T_NCM_InnerOverheadBillEntry entry ON  entry.FPARENTID= bl.FID \n");
            sb.append("\tINNER JOIN T_NCM_AUXOverheadCompanyInfo Auxc ON Auxc.FAUXOverheadID=entry.FAUXOverheadID ").append('\n');
            sb.append("\t\t  AND bl.FCompanyOrg = Auxc.FCompanyID  ").append('\n');
            sb.append(" JOIN T_NCM_EXPENSE  ON T_NCM_EXPENSE.Fid = Auxc.FDefaultExpenseID \n");
            sb.append(" JOIN T_ORG_COSTCENTER  ON T_ORG_COSTCENTER.FID=entry.FConsumeCostCenterID \n");
            sb.append("where bl.FBillStatus = 4 and bl.FCompanyOrg = '" + scompanyID + "'");
            sb.append(swhere + "\n");
            sb.append(" and bl.FBizDate >= TO_DATE('").append(this.dateFormate.format(this.beginDate)).append("') ").append("and bl.FBizDate <= TO_DATE('").append(this.dateFormate.format(this.endDate)).append("') ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append("insert into " + stempTableName + "(\n");
            sb.append("fperiod,fcostcenterid,fexpenseid,famount,ftype");
            sb.append(")\n");
            sb.append("SELECT fperiod,fcostcenterid,fexpenseid,");
            sb.append("sum(FAMOUNT) as famount ,0 as ftype\n");
            sb.append(" from  " + stempTableName + " where ftype>0 ");
            sb.append(" group by fperiod,fcostcenterid,fexpenseid ");
            sb.append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" delete " + stempTableName + " where ftype>0 \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append("insert into " + stempTableName + "(\n");
            sb.append("fperiod,fcostcenterid,fexpensenumber,fexpensename,famount,FsubRow");
            sb.append(")\n");
            sb.append("SELECT fperiod,fcostcenterid,'','" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' as fexpensename,");
            sb.append("sum(FAMOUNT) as famount,10 \n");
            sb.append(" from  " + stempTableName);
            sb.append(" group by fperiod,fcostcenterid ");
            sb.append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append("insert into " + stempTableName + "(\n");
            sb.append("fexpensenumber,fexpensename,famount,FTotalRow");
            sb.append(")\n");
            sb.append("SELECT '','" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' as fexpensename,");
            sb.append("sum(FAMOUNT) as famount,20 \n");
            sb.append(" from  " + stempTableName);
            sb.append(" where fsubrow=10 \n");
            st.addBatch(sb.toString());
            st.executeBatch();
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, stempTableName);
            st.clearBatch();
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  set (FCostCenterNumber,FCostCenterName)  =(select  t2.FNumber, t2.FName_" + locale + " \n");
            sb.append(" from T_ORG_CostCenter t2 \n");
            sb.append(" where FCostCenterID = t2.FID) ");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  set (fexpensenumber,fexpensename)  =(select  t2.FNumber, t2.FName_" + locale + " \n");
            sb.append(" from T_NCM_EXPENSE t2 \n");
            sb.append(" where fexpenseid = t2.FID) ");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            st.executeBatch();
            IRowSet iRowSet = rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT " + sbf + " FROM " + stempTableName + " order by FTotalRow,fperiod,fcostcenternumber,fsubrow,fexpensenumber"));
            return iRowSet;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(stempTableName);
            SQLUtils.cleanup((Statement)st, (Connection)cn);
        }
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"15_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + this.periodFrom.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"16_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + this.periodTo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"17_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costcenterfrom"), (String)filter.getString("costcenterto")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"18_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("expensefrom"), (String)filter.getString("expenseto")));
        return titles;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("fexpensenumber", 1, (Object)"", a);
        return conditions;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldNameTemp = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldNameTemp = childHeader.getFieldName();
            if (fieldNameTemp.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"28_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("fexpensenumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynCCFeeTotalReport_ExpenseNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FPeriod")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostDetailReport_Period", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("fexpensename")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynCCFeeTotalReport_ExpenseName", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldNameTemp.equals("FCostCenterName")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"29_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
        }
        return header;
    }
}

