/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodCollection;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynCostCalTotalDetailReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.DynCostCalTotalDetailReport");
    private String tempTableNameSum = new String();
    private PeriodInfo periodFrom = null;
    private PeriodInfo periodTo = null;
    Date beginDate = null;
    Date endDate = null;
    SimpleDateFormat dateFormate = null;

    protected void initData(RptParams filter) {
        if (this.periodFrom == null) {
            this.periodFrom = (PeriodInfo)filter.getObject("periodFrom");
        }
        if (this.periodTo == null) {
            this.periodTo = (PeriodInfo)filter.getObject("periodTo");
        }
        this.beginDate = new Date(this.periodFrom.getBeginDate().getTime());
        this.endDate = new Date(this.periodTo.getEndDate().getTime());
        this.dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        String tempTableNameMain;
        this.initData(filter);
        StringBuffer sqlAll = new StringBuffer();
        Locale locale = this.getContext().getLocale();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName(locale).toString();
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
        String cuID = DefaultCU.getId().toString();
        StringBuffer filterContent = this.buildFilter(filter);
        StringBuffer filterIncludeCostItem = this.buildFilterIncludeCostItem(filter);
        String[] tableNames = this.getTableNames(companyID);
        HashMap objMap = (HashMap)filter.getObject("position");
        String filterObject = (String)objMap.get("costobjectid");
        StringBuffer createTableMain = this.getTempTableMain();
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer createTableSum = this.getTempTableSum();
        try {
            this.tempTableNameSum = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSum.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sqlAll.append(this.insertDataToTableMain(tempTableNameMain, companyName, companyID, cuID, filterContent, filterIncludeCostItem, tableNames, filterObject));
        sqlAll.append(this.insertDataToTableSum(tempTableNameMain, this.tempTableNameSum));
        StringBuffer sqlResult = this.getDataToResult(this.tempTableNameSum, companyName, filter, locale, companyID);
        sqlAll.append(sqlResult);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableNameMain);
        return this.tempTableNameSum;
    }

    private String[] getTableNames(String companyID) throws BOSException {
        String tableName;
        String[] tableNames = new String[2];
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynCostCalResult_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tableNames[0] = tableName;
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynDataByCostObj_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tableNames[1] = tableName;
        return tableNames;
    }

    protected StringBuffer getTempTableMain() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getMain ( ");
        createTable.append("FOrgName varchar(255) not null default(' ')");
        createTable.append(",FCostCenterID varchar(44) default(' ')");
        createTable.append(",FCostObjectID varchar(44) default(' ')");
        createTable.append(",FCostItemID varchar(44) default(' ')");
        createTable.append(",FBeginDate datetime ");
        createTable.append(",FEndDate datetime ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FBegProQty decimal(21,8) default(0) ");
        createTable.append(",FBegProAmount decimal(21,8) default(0) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCurAllAmount     decimal(21,8) default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearInFee   decimal(21,8) default(0) ");
        createTable.append(",FYearCompQty  decimal(21,8) default(0) ");
        createTable.append(",FYearCompAmount  decimal(21,8) default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected StringBuffer getTempTableSum() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append("FOrgName varchar(255) default(' ') ");
        createTable.append(",FCostCenterID varchar(44) default(' ') ");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FCostObjectID varchar(44)  default(' ') ");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FPeriodName varchar(50) default(' ') ");
        createTable.append(",FPeriodNumber varchar(255) default(' ') ");
        createTable.append(",FBatchNumber varchar(255) default(' ')");
        createTable.append(",FUnitName varchar(255) default(' ') ");
        createTable.append(",FModel nvarchar(255) default(' ') ");
        createTable.append(",FShortName nvarchar(80) default(' ') ");
        createTable.append(",FCostItemID varchar(44) default(' ')");
        createTable.append(",FCostItemNumber varchar(255) default(' ')");
        createTable.append(",FCostItemName varchar(255) default(' ')");
        createTable.append(",FCostItemType varchar(255) default(' ')");
        createTable.append(",FBegProQty decimal(21,8) default(0) ");
        createTable.append(",FBegProAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCurAllAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearInFee   decimal(21,8) default(0) ");
        createTable.append(",FYearCompQty  decimal(28,10) default(0) ");
        createTable.append(",FYearCompAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearCompPrice  decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FUnitPriceDecimal int default(0) ");
        createTable.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTable.append(",FTotalRow2 decimal(21,8) not null default(0) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected StringBuffer insertDataToTableMain(String tempTableNameMain, String companyName, String companyID, String cuID, StringBuffer filter, StringBuffer filterIncludeCostItem, String[] tableNames, String filterObject) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into " + tempTableNameMain + " (FOrgName,FBeginDate,FEndDate,FPeriodName,FPeriodNumber,FCostCenterID," + "FCostObjectID,FCostItemID,FCurAllAmount,FEndProAmount) \n");
        sql.append(" SELECT '" + companyName);
        sql.append("',t5.FBeginDate,t5.FEndDate,t5.FName_l2,t5.FNumber,T1.FCostCenterID,T1.FCostObjectID,T1.FCostItemID,T1.FFinishedAmount,T1.FEoPWIPAmount \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID and t1.FCompanyID = t4.FCompanyID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID,COSTITEM.FNUMBER FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID,COSTITEM.FNUMBER FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS T6 ON T6.FID = T1.FCostItemID \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' AND t4.FID in (" + filterObject + ") \n");
        sql.append(filterIncludeCostItem);
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " (FOrgName,FBeginDate,FEndDate,FPeriodName,FPeriodNumber,FCostCenterID," + "FCostObjectID,FCurCompQty) \n");
        sql.append(" SELECT '" + companyName);
        sql.append("',t5.FBeginDate,t5.FEndDate,t5.FName_l2,t5.FNumber,T1.FCostCenterID, \nT1.FCostObjectID,T1.FFinishedQty \n");
        sql.append(" FROM " + tableNames[1] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID and t1.FCompanyID = t4.FCompanyID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" where T1.FCompanyID = '" + companyID + "' AND t4.FID in (" + filterObject + ") \n");
        sql.append(filter);
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer insertDataToTableSum(String tempTableNameMain, String tempTableNameSum) {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO " + tempTableNameSum + "(");
        sql.append(" FOrgName,FPeriodName,FPeriodNumber,FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" FBegProAmount,FCurAllAmount,FEndProAmount,FYearCompAmount, \n");
        sql.append(" FYearCompQty,FYearInFee,FBegProQty,FCurInQty, \n");
        sql.append(" FCurCompQty,FEndProQty,FCurInAmount,FMakeSum,FTotalRow,FIsTotalRow) \n");
        sql.append(" SELECT FOrgName,FPeriodName,FPeriodNumber, \n");
        sql.append(" FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" Sum(FBegProAmount) as FBegProAmount, \n");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" Sum(FYearCompAmount) as FYearCompAmount, \n");
        sql.append(" Sum(FYearCompQty) as FYearCompQty, \n");
        sql.append(" Sum(FYearInFee) as FYearInFee, \n");
        sql.append(" Sum(FBegProQty) as FBegProQty, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount)-Sum(FBegProAmount) as FCurInAmount, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FMakeSum,0, \n");
        sql.append(" 0 AS FIsTotalRow \n");
        sql.append(" FROM " + tempTableNameMain);
        sql.append(" GROUP BY FOrgName,FPeriodName,FPeriodNumber,FCostCenterID,FCostObjectID,FCostItemID \n");
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer getDataToResult(String tempTableNameSum, String orgCompanyName, RptParams filter, Locale locale, String companyID) {
        Context ctx = this.getContext();
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (list.size() == 4 && i == 0) continue;
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("insertby");
            fields = fields.replaceAll("FPeriodName", "FPeriodNumber,FPeriodName");
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FTotalRow," + fields + ", \n");
            sql.append(" FBegProAmount,FCurAllAmount,FEndProAmount,FYearCompAmount, \n");
            sql.append(" FYearCompQty,FYearInFee,FBegProQty,FCurInQty, \n");
            sql.append(" FCurCompQty,FEndProQty,FCurInAmount, \n");
            sql.append(" FMakeSum) \n");
            sql.append(" SELECT " + map.get("totalrow").toString() + "," + fields + ",");
            sql.append(" Sum(FBegProAmount) as FBegProAmount, \n");
            sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
            sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
            sql.append(" Sum(FYearCompAmount) as FYearCompAmount, \n");
            sql.append(" Sum(FYearCompQty) as FYearCompQty, \n");
            sql.append(" Sum(FYearInFee) as FYearInFee, \n");
            sql.append(" Sum(FBegProQty) as FBegProQty, \n");
            sql.append(" Sum(FCurInQty) as FCurInQty, \n");
            sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
            sql.append(" Sum(FEndProQty) as FEndProQty, \n");
            sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount)-Sum(FBegProAmount) as FCurInAmount, \n");
            sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FMakeSum \n");
            sql.append(" FROM " + tempTableNameSum + "\n");
            sql.append(" WHERE FTotalRow = 0 \n");
            sql.append(" group by " + fields);
            sql.append("\n\n;");
        }
        sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
        sql.append(" FOrgName,FTotalRow2,FTotalRow, \n");
        sql.append(" FBegProAmount,FCurAllAmount,FEndProAmount,FYearCompAmount, \n");
        sql.append(" FYearCompQty,FYearInFee,FBegProQty,FCurInQty, \n");
        sql.append(" FCurCompQty,FEndProQty,FCurInAmount, \n");
        sql.append(" FMakeSum) \n");
        sql.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "',1,105,");
        sql.append(" Sum(FBegProAmount) as FBegProAmount, \n");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" Sum(FYearCompAmount) as FYearCompAmount, \n");
        sql.append(" Sum(FYearCompQty) as FYearCompQty, \n");
        sql.append(" Sum(FYearInFee) as FYearInFee, \n");
        sql.append(" Sum(FBegProQty) as FBegProQty, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount)-Sum(FBegProAmount) as FCurInAmount, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FMakeSum \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" where FTotalRow = 0  \n");
        sql.append("\n\n;");
        sql.append(" DELETE " + tempTableNameSum + " \n");
        sql.append(" WHERE FBegProAmount IS NULL \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n" + " SET (FBegProQty,FYearCompQty,FCurInQty,FCurCompQty,FEndProQty) ");
        sql.append(" = (SELECT T1.FBegProQty,T1.FYearCompQty,T1.FCurInQty,T1.FCurCompQty,T1.FEndProQty FROM \n(SELECT (CASE WHEN FPeriodName is null then ' ' else FPeriodName end) as FPeriodName, \n");
        sql.append(" (CASE WHEN FCostCenterID is null then ' ' else FCostCenterID end) as FCostCenterID, \n");
        sql.append(" (CASE WHEN FCostObjectID is null then ' ' else FCostObjectID end) as FCostObjectID, \n");
        sql.append(" SUM(FBegProQty) AS FBegProQty,SUM(FYearCompQty) AS FYearCompQty,SUM(FCurInQty) AS FCurInQty,SUM(FCurCompQty) AS FCurCompQty,SUM(FEndProQty) AS FEndProQty \n");
        sql.append(" FROM " + tempTableNameSum + "\n WHERE FTotalRow = 0 \n");
        sql.append(" GROUP BY FPeriodName,FCostCenterID,FCostObjectID with rollup ) T1 \n");
        sql.append(" WHERE T1.FPeriodName = " + tempTableNameSum + ".FPeriodName \n");
        sql.append(" AND T1.FCostCenterID = " + tempTableNameSum + ".FCostCenterID \n");
        sql.append(" AND T1.FCostObjectID = " + tempTableNameSum + ".FCostObjectID \n");
        sql.append(" )");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
        sql.append(" SET (FTOTALROW) = (SELECT 200 FROM ( \n");
        sql.append(" SELECT FPERIODNAME,FCostCenterID,FCostObjectID \n");
        sql.append(" FROM " + tempTableNameSum + " \n");
        sql.append(" WHERE FTotalRow=0 \n");
        sql.append(" GROUP BY FPERIODNAME,FCostCenterID,FCostObjectID \n");
        sql.append(" having count(1)>1) T2 \n");
        sql.append(" WHERE T2.FPERIODNAME=T1.FPERIODNAME AND T2.fcostcenterid=T1.FCostCenterID \n");
        sql.append(" AND T2.fcostobjectid = T1.FCostObjectID \n");
        sql.append(" AND T1.FCOSTITEMID= ' ' \n");
        sql.append(" AND T1.FTOTALROW= 0) \n");
        sql.append("\n\n;");
        sql.append(" DELETE " + tempTableNameSum + " WHERE FTOTALROW=200 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + locale + " \n");
        sql.append(" FROM T_ORG_CostCenter T2 WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + locale + "\n");
        sql.append(" FROM T_BD_CostObject T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID =T2.FID ) \n ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostItemNumber,FCostItemName,FCostItemType) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + locale + ",T2.FItemType \n");
        sql.append(" FROM T_NCM_CostItem T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostItemID =T2.FID ) \n ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET FOrgName= '" + orgCompanyName + "' where FTotalRow2 <> 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FBatchNumber,FUnitName,FModel,FShortName)= \n");
        sql.append(" (SELECT T2.FBatchNumber,T4.FName_" + locale + ",T3.FModel,T3.FShortName \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID \n");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FQtyDecimal= \n");
        sql.append(" (SELECT MAX(T4.FqtyPrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FUnitPriceDecimal= \n");
        sql.append(" (SELECT MAX(T3.FPricePrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append("UPDATE ").append(tempTableNameSum).append(" SET (FPriceDecimal)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sql.append("\n\n;");
        String field = "";
        String fieldName = "";
        String fieldNumber = "";
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemID")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (!field.equals("FPeriodName")) {
                fieldName = field.substring(0, field.length() - 2) + "Name";
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                sql.append(" update " + tempTableNameSum + " set " + fieldName + " = " + "' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "', \n");
                sql.append(fieldNumber + " = " + fieldNumber + "\n");
                sql.append(whichTotal);
                sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sql.append("\n\n;");
                continue;
            }
            fieldNumber = field;
            sql.append(" update " + tempTableNameSum + " set " + fieldNumber + " = " + fieldNumber + " || ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' \n");
            sql.append(" , FTotalPeriodRow = 1");
            sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sql.append("\n\n;");
        }
        sql.append(" DELETE " + tempTableNameSum + " WHERE FTOTALROW > 0 AND  (FCostCenterNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' " + "OR FCostObjectNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' OR FCostItemNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "') ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ") \n,FUnitPriceDecimal= (SELECT MAX(FUnitPriceDecimal) FROM " + tempTableNameSum + ") \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FYearInFee=FYearInFee+FEndProAmount+FCurAllAmount \n" + " ,FYearCompAmount=FYearCompAmount+FCurAllAmount," + "FYearCompQty=FYearCompQty+FCurCompQty \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FYearCompPrice= (CASE WHEN FYearCompQty<>0 THEN \n" + " to_decimal(FYearCompAmount,24,12)/to_decimal(FYearCompQty,24,12) ELSE 0 END), \n" + " FCurUnitPrice= (CASE WHEN FCurCompQty<>0 THEN \n" + " to_decimal(FCurAllAmount,24,12)/to_decimal(FCurCompQty,24,12) ELSE 0 END) \n");
        sql.append("\n\n;");
        sql.append(" DELETE " + tempTableNameSum + "\n");
        sql.append(" WHERE FBegProAmount=0 AND FCurInAmount=0 AND FCurAllAmount=0 AND FEndProAmount = 0 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + "\n");
        sql.append(" SET FBegProQty = NULL,FCurInQty = NULL,FCurCompQty = NULL, \n  FEndProQty=NULL,FYearCompQty=NULL \n");
        sql.append(" WHERE FTotalRow=0 \n");
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer buildFilter(RptParams filter) {
        this.initData(filter);
        StringBuffer sb = new StringBuffer();
        sb.append(" and t5.FBeginDate >= TO_DATE('");
        sb.append(this.dateFormate.format(this.beginDate));
        sb.append("') \n");
        sb.append(" and t5.FEndDate <= TO_DATE('");
        sb.append(this.dateFormate.format(this.endDate));
        sb.append("') \n");
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("' \n");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("' \n");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("' \n");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("' \n");
        }
        return sb;
    }

    private StringBuffer buildFilterIncludeCostItem(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildFilter(filter));
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t6.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t6.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
        return sb;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"25_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()) + this.periodFrom.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"5_DynByClassCostCalReport", (Locale)ctx.getLocale()) + this.periodTo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        if (filter.getString("costcenterFrom") != null || filter.getString("costcenterTo") != null) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"7_DynByClassCostCalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costcenterFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costcenterTo")));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"8_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("costobjectFrom") != null || filter.getString("costobjectTo") != null) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"9_DynByClassCostCalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costobjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costobjectTo")));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"10_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("costitemFrom") != null || filter.getString("costitemTo") != null) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"11_DynByClassCostCalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costitemFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costitemTo")));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"12_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FOrgName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"26_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(0);
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        boolean isItem = false;
        int index = 0;
        for (int i = 0; i < orderStrings.length; ++i) {
            index = isItem ? i + 4 : i + 1;
            if (orderStrings[i].equalsIgnoreCase("FPeriodName")) {
                reportHeader.addChild("FPeriodName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"27_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"28_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterName")) {
                reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"29_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectNumber")) {
                reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"30_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectName")) {
                reportHeader.addChild("FCostobjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"31_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostItemNumber")) {
                isItem = true;
                reportHeader.addChild("FModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"32_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
                reportHeader.addChild("FShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"33_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 1);
                reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"34_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 2);
                reportHeader.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"35_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 3);
                reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"36_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 4);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostItemName")) continue;
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"37_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
        }
        ReportHeader bandAmount3 = reportHeader.addChild("BQWG", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"38_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
        bandAmount3.addChild("FCurCompQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"39_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        bandAmount3.addChild("FCurAllAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"40_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        bandAmount3.addChild("FCurUnitPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"41_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
        return reportHeader;
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("insertby", sb.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    private StringBuffer getSortString(ArrayList list, String sortMode) {
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (field.equalsIgnoreCase("FPeriodName")) {
                orderByWhichTotal = ", FTotalPeriodRow " + sortMode;
                fieldNumber = "FPeriodNumber";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + sortMode;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                sbChecked.append(fieldNumber);
                sbChecked.append(orderByWhichTotal);
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(fieldNumber);
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        this.periodFrom = (PeriodInfo)filter.getObject("periodFrom");
        this.periodTo = (PeriodInfo)filter.getObject("periodTo");
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
        String cuID = DefaultCU.getId().toString();
        StringBuffer filterContent = this.buildFilter(filter);
        StringBuffer filterIncludeCostItem = this.buildFilterIncludeCostItem(filter);
        String[] tableNames = this.getTableNames(companyID);
        Integer nObjCountPerPage = new Integer(filter.getString("costobjectPerPage"));
        if (nObjCountPerPage <= 0 || nObjCountPerPage > 1000) {
            nObjCountPerPage = new Integer(20);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  distinct COTEMP.FCostObjectID,T_BD_CostObject.FNumber FROM \n( ");
        sql.append(" SELECT T2.FCostObjectID ");
        sql.append(" FROM T_NCM_InputQtyBill T1 ");
        sql.append(" INNER JOIN T_NCM_InputQtyBillEntry T2 ON T1.FID=T2.FParentID ");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterOrgUnitID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t2.FCostObjectID = t4.FID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriod = t5.FID \n ");
        sql.append(" where t1.FCompanyOrg = '" + companyID + "' \n");
        sql.append(filterContent);
        sql.append(" UNION \n");
        sql.append(" SELECT T1.FCostObjectID \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID,COSTITEM.FNUMBER FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID,COSTITEM.FNUMBER FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS T6 ON T6.FID = T1.FCostItemID \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filterIncludeCostItem);
        sql.append(" UNION \n");
        sql.append(" SELECT T1.FCostObjectID \n");
        sql.append(" FROM " + tableNames[1] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filterContent);
        sql.append(" UNION \n");
        sql.append(" SELECT T1.FCostObjectID \n");
        sql.append(" FROM T_NCM_WIPCountingBill T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriod = t5.FID \n ");
        sql.append(" where T1.FCompanyOrg = '" + companyID + "' \n");
        sql.append(filterContent);
        sql.append(" ) COTEMP \n");
        sql.append(" INNER JOIN T_BD_CostObject ON COTEMP.FCostObjectID=T_BD_CostObject.FID \n");
        sql.append(" ORDER BY T_BD_CostObject.FNumber \n");
        sql.append("\n\n;");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        DynamicRowSet drs = new DynamicRowSet(1);
        drs.setColInfo(1, "costobjectid", "constobjectid", 12, null);
        StringBuffer sb = new StringBuffer();
        rs.first();
        for (int i = 1; i <= rs.size(); ++i) {
            sb.append("'").append(rs.getString("FCostObjectID")).append("',");
            if (i == rs.size() || i % nObjCountPerPage == 0) {
                drs.moveToInsertRow();
                drs.updateString("costobjectid", sb.substring(0, sb.length() - 1).toString());
                drs.insertRow();
                sb = new StringBuffer();
            }
            rs.next();
        }
        if (drs.size() == 0) {
            drs.moveToInsertRow();
            drs.updateString("costobjectid", "'" + BOSUuid.create((String)"39734A77").toString() + "'");
            drs.insertRow();
        }
        return drs;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        Context ctx = this.getContext();
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow.compareTo(SysConstant.BIGZERO) == 0) {
            RptParams params = new RptParams();
            params.setObject("companyorg", totalFilter.getObject("companyorg"));
            ArrayList tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"27_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"42_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"43_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"44_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            params.setObject("table", tableList);
            params.setObject("costobjectPerPage", (Object)new String("100"));
            String sql = "select * where number = '" + rowData.get("FPERIODNUMBER") + "'";
            PeriodCollection periods = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(sql);
            this.periodFrom = periods.get(0);
            this.periodTo = periods.get(0);
            params.setObject("periodFrom", (Object)this.periodFrom);
            params.setObject("periodTo", (Object)this.periodTo);
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        ArrayList tableList;
        Context ctx = this.getContext();
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        if ((tableList = (ArrayList)filter.getObject("table")) == null) {
            tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"27_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"42_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"43_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"44_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
        }
        String orderBy = this.getSortString(tableList, orderByMode).toString();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " Order by  FTotalRow2 " + orderByMode + "," + orderBy + " ,FTotalRow"), (int)start, (int)rows);
        return rs;
    }
}

