/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynFinishedProductCostDetailReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)DynFinishedProductCostDetailReport.class.getName());
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();
    private static final double COSTITEMGROUP_MOVE = 500.0;
    private static final double COSTITEM_MOVE = 0.05;
    private static final double MATGROUP_MOVE = 0.001;
    private double globalSeq = 0.0;
    private String t_ExpenseFactor;
    private PeriodInfo periodFrom = null;
    private PeriodInfo periodTo = null;
    Date beginDate = null;
    Date endDate = null;

    protected void initData(RptParams filter) {
        this.periodFrom = (PeriodInfo)filter.getObject("prmtPeriodFrom");
        this.periodTo = (PeriodInfo)filter.getObject("prmtPeriodTo");
        this.beginDate = new Date(this.periodFrom.getBeginDate().getTime());
        this.endDate = new Date(this.periodTo.getEndDate().getTime());
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        this.globalSeq = 0.0;
        String sTableName = this.buildReportDataTableName(filter);
        StringBuffer select = new StringBuffer();
        select.append("SELECT * ").append(" FROM ").append(sTableName).append(filter.getBoolean("chkIsTotalCostItem") ? "" : " WHERE FMaterialgroupID is not null  ").append(this.getORDERBY());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)select.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        this.globalSeq = 0.0;
        String sTableName = this.buildReportDataTableName(filter);
        this.setTablename(sTableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuffer select = new StringBuffer();
        select.append("SELECT * ").append(" FROM ").append(tableName).append(filter.getBoolean("chkIsTotalCostItem") ? "" : " WHERE FMaterialgroupID is not null  ").append(this.getORDERBY());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)select.toString(), (int)start, (int)rows);
        return rs;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        String[] physicalTblNames;
        Context ctx = this.getContext();
        this.initData(filter);
        String companyID = null;
        if (filter.getObject("prmtCompanyOrg") != null) {
            companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        } else {
            return null;
        }
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct cpr.FCostCenterID ,cpr.FCostObjectID,cc.FNumber,co.FNumber FROM ").append(physicalTblNames[1]).append(" cpr ").append("INNER JOIN T_NCM_Period prd on cpr.FcalculatePeriodID = prd.FID\n").append("INNER JOIN T_ORG_CostCenter cc on cpr.FCostCenterID = cc.FID\n").append("INNER JOIN T_NCM_CostItem ci on cpr.FCostItemID = ci.FID ").append("INNER JOIN T_BD_CostObject co on (cpr.FCompanyID = co.FCompanyID and cpr.FCostObjectID = co.FID) \n").append(" WHERE cpr.FCompanyID = ? \n").append(" and prd.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(this.beginDate)).append("') \n").append(" and prd.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(this.endDate)).append("') \n");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)">=", (String)"prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)"<=", (String)"prmtCostCenterTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)">=", (String)"prmtCostItemFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)"<=", (String)"prmtCostItemTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)">=", (String)"prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)sbSQL, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)"<=", (String)"prmtCostObjectTo");
        sbSQL.append(" ORDER BY cc.FNumber,co.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new Object[]{companyID});
        if (rs.size() == 0) {
            DynamicRowSet drs = new DynamicRowSet(1);
            drs.setColInfo(1, "FCostCenterID_FCostObjectID", "constobjectid", 12, null);
            drs.moveToInsertRow();
            drs.updateString("FCostCenterID_FCostObjectID", "" + BOSUuid.create((String)"7FAFDF41").toString() + "_" + BOSUuid.create((String)"39734A77").toString() + "");
            drs.insertRow();
            return drs;
        }
        Integer nCountPerPage = new Integer(filter.getString("spCostObjectNum"));
        return NCMReportHelper.getListWithDynamicRowSet((Context)ctx, (Integer)nCountPerPage, (IRowSet)rs, (String)"FCostCenterID_FCostObjectID");
    }

    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        int amtPrecision = 2;
        if (companyID != null) {
            try {
                CompanyOrgUnitInfo comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                CurrencyInfo baseCurr = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(comOrg.getBaseCurrency().getId()));
                amtPrecision = baseCurr.getPrecision();
            }
            catch (EASBizException e) {
                throw new BOSException(e.getCause());
            }
        }
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        String mainTmpTblName = this.createTmpTableSQL();
        String sTmpTblName = this.createTmpTableSQL();
        String sTmpTblName2 = this.createTmpTableSQL2();
        String[] wheres = NCMReportHelper.ExtractForOnePage((RptParams)filter, (String)"FCostCenterID_FCostObjectID", (String)"cc.FID_co.FID");
        for (int i = 0; i < wheres.length; ++i) {
            this.buildDataOfReport(filter, companyID, amtPrecision, physicalTblNames, sTmpTblName, sTmpTblName2, wheres[i]);
            this.mergeToMainTmpTbl(mainTmpTblName, sTmpTblName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" update " + mainTmpTblName + " as t1  set FConsumeCommonQtyPrecision " + "  =(select  max(mmu.FqtyPrecision) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID");
        sb.append("  where t1.FMaterialID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + mainTmpTblName + " as t1  set FConsumeAssistQtyPrecision " + "  =(select  isnull(mmu.FqtyPrecision,4) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID and t2.FAssistUnit=mmu.FMeasureUnitID ");
        sb.append("  where t1.FMaterialID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
        super.setTablename(mainTmpTblName);
        return mainTmpTblName;
    }

    private void mergeToMainTmpTbl(String mainTmpTblName, String sTmpTblName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(mainTmpTblName).append(" SELECT * FROM ").append(sTmpTblName);
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        DbUtil.execute((Context)this.getContext(), (String)(" Truncate Table " + sTmpTblName));
    }

    private void buildDataOfReport(RptParams filter, String companyID, int amtPrecision, String[] physicalTblNames, String sTmpTblName, String sTmpTblName2, String wheres) throws BOSException {
        this.insertPartialData(sTmpTblName, physicalTblNames, filter, companyID, amtPrecision, wheres);
        this.innsertExpenseSQL(filter, physicalTblNames, sTmpTblName2, amtPrecision, companyID, wheres);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName);
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName2);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.updateExpenseSQL(sTmpTblName2);
        try {
            this.insertGroupTreeTotal(sTmpTblName, filter);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
        this.updateNumericFeilds(sTmpTblName);
        this.insertCostCenterTotalRow(filter);
    }

    private void insertPartialData(String tmpTblName, String[] physicalTblNames, RptParams filter, String companyID, int amtPrecision, String wheres) throws BOSException {
        String sql = this.getSQL(filter, physicalTblNames, tmpTblName, amtPrecision, wheres);
        DbUtil.execute((Context)this.getContext(), (String)sql, (Object[])new Object[]{companyID, companyID});
        StringBuffer sbSQL = new StringBuffer();
        String table = "T_IM_MaterialReqBillEntry";
        sbSQL.append(" update " + tmpTblName + " as t1  set FMatCommonUnitName " + "  = (select  top 1 t3.FName_L2 \n");
        sbSQL.append(" from  " + table + " t2  \n");
        sbSQL.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sbSQL.append(" where t2.FMaterialID=t1.FMaterialID group by t2.FMaterialID,t3.FName_L2 )");
        sbSQL.append("\n\n");
        sbSQL.append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
    }

    private void updateFinishedQty(String tmpTblName, String companyID) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("UPDATE " + tmpTblName + " as mar SET (FObjQty) = \n");
        sbSQL.append("(SELECT entry.FQty  \n");
        sbSQL.append(" from T_IM_ManufactureRecBill  parent \n");
        sbSQL.append(" INNER JOIN T_SCM_TransactionType TRANSTYPE  \n");
        sbSQL.append(" ON parent.FTransactionTypeID = TRANSTYPE.FID and TRANSTYPE.FIsManuCostCalculate = 1 \n");
        sbSQL.append(" inner join T_IM_ManufactureRecBillEntry entry on parent.fid=entry.fparentid \n ");
        sbSQL.append(" inner join T_ORG_CostCenter cc on entry.FCostCenterOrgUnitID = cc.FID \n ");
        sbSQL.append(" inner join T_BD_CostObject co on entry.FMaterialID =  co.FStdProductIDID AND ( isnull (entry.FLOT,'  ') = isnull(co.FBatchNumber,'  ')) ");
        sbSQL.append(" where parent.FBaseStatus=4 and entry.FCompanyOrgUnitID = ? ) \n");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new String[]{companyID});
    }

    private void updateNumericFeilds(String tmpTblName) throws BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" UPDATE ").append(tmpTblName).append(" as mar \n").append("    SET (FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,FUnitCostAmt)= \n").append(" (SELECT  \n");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)updateSQL, (String)"FTotalConsumeCommonQty", (String)"FObjQty", (String)"FUnitConsumeCommonQty", (String)"FQtyPrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)updateSQL, (String)"FTotalConsumeQty", (String)"FObjQty", (String)"FUnitConsumeQty", (String)"FQtyPrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)updateSQL, (String)"FTotalConsumeAssistQty", (String)"FObjQty", (String)"FUnitConsumeAssistQty", (String)"FQtyPrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)updateSQL, (String)"FTotalCostAmt", (String)"FTotalConsumeQty", (String)"FUnitCostPrice", (String)"FPricePrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)updateSQL, (String)"FTotalCostAmt", (String)"FObjQty", (String)"FUnitCostAmt", (String)"18");
        updateSQL.append(" ); \n");
        StringBuffer updateSQL2 = new StringBuffer();
        updateSQL2.append("UPDATE ").append(tmpTblName).append(" AS TMP SET (FTotalUnitCostAmt) =     \t\t ").append('\n').append(" ( SELECT T.V FROM (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ").append('\n').append("    select FCostCenterID , FCostObjectID ,sum( FUnitCostAmt) V ,FPeriodID                    ").append('\n').append("    from ").append(tmpTblName).append('\n').append("    where FTotalRow = 0                                                            ").append('\n').append("    group by FCostCenterID ,FCostObjectID,FPeriodID                                          ").append('\n').append("    ) AS T                                                                         ").append('\n').append("  WHERE Tmp.FCostCenterID = T.FCostCenterID AND TMP.FCostObjectID = T.FCostObjectID  and Tmp.FPeriodID = T.FPeriodID ").append('\n').append(" ) ;                                                                                ").append('\n');
        StringBuffer updateSQL3 = new StringBuffer();
        updateSQL3.append(" UPDATE ").append(tmpTblName).append(" as mar \n").append("    SET (FUnitPercent)= \n").append(" (SELECT  \n");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)updateSQL3, (String)"FUnitCostAmt *100", (String)"FTotalUnitCostAmt", (String)"FUnitPercent", (String)"FAmountPrecision");
        updateSQL3.append(" ) ");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)updateSQL.append(updateSQL2).append(updateSQL3).toString());
    }

    private void insertGroupTreeTotal(String tmpTblName, RptParams filter) throws BOSException, EASBizException, SQLException {
        this.insertTotalRowsForCostItemGroupTree(tmpTblName, filter);
        if (filter.getBoolean("chkIsTotalMaterial")) {
            this.insertTotalRowsForMaterialGroupTree(tmpTblName, filter);
        }
        if (filter.getBoolean("chkIsTotalExpense")) {
            this.insertTotalRowsForExpenseGroupTree(tmpTblName, filter);
        }
    }

    private void updateTempTableForInsertTotalRows(int groupLevel, Set databaseIDs, IDataBase iDataBase, int whichGroupTotal, StringBuffer updateSeqSQL, StringBuffer insertTotalSQL, StringBuffer sumSQL) throws BOSException, EASBizException {
        String groupTreeID2 = null;
        DataBaseInfo groupInfo = null;
        Set dbIDinGroup = null;
        Connection conn = null;
        PreparedStatement psInsertTotal = null;
        Map trees = null;
        HashSet allGroupSet = new HashSet();
        Iterator it = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            psInsertTotal = conn.prepareStatement(insertTotalSQL.toString());
            this.globalSeq += (double)(groupLevel * 2);
            int color = 0;
            for (int level = groupLevel; level >= 1; --level) {
                boolean isLowerGroup;
                boolean bl = isLowerGroup = level < groupLevel;
                if (whichGroupTotal == 0) {
                    ICostItem iCostItem = (ICostItem)iDataBase;
                    trees = iCostItem.transformToTree(databaseIDs, level);
                } else if (whichGroupTotal == -1) {
                    IMaterial iMaterail = (IMaterial)iDataBase;
                    trees = iMaterail.transformToTree(databaseIDs, level);
                    int startIndex = (level - 1) * 29;
                    sumSQL.append(" ,substring(FLongMaterialID," + startIndex + ",28) ");
                } else if (whichGroupTotal == 1) {
                    IExpense iExpense = (IExpense)iDataBase;
                    trees = iExpense.transformToTree(databaseIDs, level);
                }
                color = (color + 1) % NCMConst.reportColors20.length;
                trees.remove("RootID");
                Set groupSet = trees.keySet();
                groupSet.removeAll(allGroupSet);
                allGroupSet.addAll(groupSet);
                for (String groupTreeID2 : groupSet) {
                    groupInfo = (DataBaseInfo)BDCMUtils.getObjectValue((Context)this.getContext(), (String)groupTreeID2);
                    dbIDinGroup = (Set)trees.get(groupTreeID2);
                    double originalSeq = 0.0;
                    if (isLowerGroup && whichGroupTotal == 0) {
                        if (groupInfo.get("parent") != null) {
                            String parentID = ((DataBaseInfo)groupInfo.get("parent")).getId().toString();
                            originalSeq = this.getUpperGroupSeq(groupLevel, level, parentID);
                            this.globalSeq = originalSeq - 1.0 + 0.05;
                        }
                    } else {
                        this.globalSeq += 500.0;
                    }
                    if (whichGroupTotal == 0) {
                        psInsertTotal.setDouble(25, this.globalSeq += 1.0);
                        this.globalSeq = Math.ceil(this.globalSeq += 1.0);
                        NCMServerUtils.executeSQLByBatch((Context)this.getContext(), (String)updateSeqSQL.toString(), (Object[])new Object[]{isLowerGroup ? new BigDecimal("0.05") : new BigDecimal("" + this.globalSeq)}, (Collection)dbIDinGroup);
                    }
                    List rsList = NCMServerUtils.executeSQLByBatch((Context)this.getContext(), (String)sumSQL.toString(), (Object[])new Integer[]{new Integer(whichGroupTotal)}, (Collection)dbIDinGroup);
                    BigDecimal bd1 = SysConstant.BIGZERO;
                    BigDecimal bd2 = SysConstant.BIGZERO;
                    BigDecimal bd3 = SysConstant.BIGZERO;
                    BigDecimal bd4 = SysConstant.BIGZERO;
                    BigDecimal bd5 = SysConstant.BIGZERO;
                    BigDecimal bd6 = SysConstant.BIGZERO;
                    BigDecimal bd7 = SysConstant.BIGZERO;
                    BigDecimal bd8 = SysConstant.BIGZERO;
                    BigDecimal bd9 = SysConstant.BIGZERO;
                    ResultSet sumResult = null;
                    int rsSize = rsList.size();
                    for (int rsNum = 0; rsNum < rsSize; ++rsNum) {
                        sumResult = (ResultSet)rsList.get(rsNum);
                        while (sumResult.next()) {
                            bd6 = sumResult.getBigDecimal(13);
                            bd1 = sumResult.getBigDecimal(14);
                            bd7 = sumResult.getBigDecimal(15);
                            bd2 = sumResult.getBigDecimal(16);
                            bd8 = sumResult.getBigDecimal(17);
                            bd3 = sumResult.getBigDecimal(18);
                            bd9 = sumResult.getBigDecimal(19);
                            bd4 = sumResult.getBigDecimal(20);
                            bd5 = sumResult.getBigDecimal(21);
                            psInsertTotal.setString(1, sumResult.getString(1));
                            psInsertTotal.setString(2, sumResult.getString(2));
                            psInsertTotal.setString(3, sumResult.getString(3));
                            psInsertTotal.setString(4, sumResult.getString(4));
                            psInsertTotal.setString(5, sumResult.getString(5));
                            psInsertTotal.setString(6, sumResult.getString(6));
                            psInsertTotal.setString(7, sumResult.getString(7));
                            psInsertTotal.setString(8, sumResult.getString(8));
                            psInsertTotal.setString(9, sumResult.getString(9));
                            psInsertTotal.setString(10, sumResult.getString(10));
                            psInsertTotal.setString(11, sumResult.getString(11));
                            psInsertTotal.setBigDecimal(12, sumResult.getBigDecimal(12));
                            psInsertTotal.setString(13, groupInfo.getNumber());
                            psInsertTotal.setString(14, groupInfo.getName());
                            psInsertTotal.setBigDecimal(15, bd6);
                            psInsertTotal.setBigDecimal(16, bd1);
                            psInsertTotal.setBigDecimal(17, bd7);
                            psInsertTotal.setBigDecimal(18, bd2);
                            psInsertTotal.setBigDecimal(19, bd8);
                            psInsertTotal.setBigDecimal(20, bd3);
                            psInsertTotal.setBigDecimal(21, bd9);
                            psInsertTotal.setBigDecimal(22, bd4);
                            psInsertTotal.setBigDecimal(23, bd5);
                            psInsertTotal.setInt(24, color);
                            psInsertTotal.setString(26, groupTreeID2);
                            if (whichGroupTotal == -1) {
                                double matGroupSeq = this.adjustFSeqOfTotalMatGroup(sumResult.getString(22), groupTreeID2, level);
                                psInsertTotal.setDouble(25, matGroupSeq);
                                psInsertTotal.setString(27, sumResult.getString(23));
                                psInsertTotal.setString(28, sumResult.getString(24));
                            } else {
                                psInsertTotal.setString(27, groupTreeID2);
                            }
                            psInsertTotal.execute();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psInsertTotal, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psInsertTotal, (Connection)conn);
    }

    private double getUpperGroupSeq(int groupLevel, int level, String groupTreeID) throws BOSException, SQLException {
        IRowSet seqRS = DbUtil.executeQuery((Context)this.getContext(), (String)("select FSeq from " + this.getTablename() + " where fcostItemID = '" + groupTreeID + "'"));
        if (seqRS.next()) {
            return seqRS.getDouble(1);
        }
        return this.globalSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCIseqByGroup(Set groupSet, Set ciUnderRootID) throws BOSException, SQLException, EASBizException, UuidException {
        StringBuffer selectFSeqOfCostItem = new StringBuffer();
        selectFSeqOfCostItem.append("SELECT Fid From ").append(this.getTablename()).append(" where  FCostItemGroupID = ?  ").append(this.getORDERBY());
        StringBuffer updateFSeqOfCostItem = new StringBuffer();
        updateFSeqOfCostItem.append("UPDATE ").append(this.getTablename()).append(" SET FSeq = FSeq + ?  where  FID = ? ");
        Connection conn = EJBFactory.getConnection((Context)this.getContext());
        PreparedStatement psupdateFSeqOfCostItem = conn.prepareStatement(updateFSeqOfCostItem.toString());
        Iterator it = groupSet.iterator();
        while (it.hasNext()) {
            IRowSet ciByGroup = DbUtil.executeQuery((Context)this.getContext(), (String)selectFSeqOfCostItem.toString(), (Object[])new Object[]{it.next()});
            double ciSeqAdjust = 1.0;
            while (ciByGroup.next()) {
                psupdateFSeqOfCostItem.setBigDecimal(1, new BigDecimal("" + (ciSeqAdjust += 1.0)));
                psupdateFSeqOfCostItem.setObject(2, ciByGroup.getString(1));
                psupdateFSeqOfCostItem.addBatch();
            }
        }
        try {
            psupdateFSeqOfCostItem.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)psupdateFSeqOfCostItem);
        }
        if (ciUnderRootID != null) {
            updateFSeqOfCostItem.setLength(0);
            updateFSeqOfCostItem.append("UPDATE ").append(this.getTablename()).append(" SET FSeq = FSeq + ?  where  FCostItemID = ? and (FmaterialID = ' ' or fmaterialid is null )");
            psupdateFSeqOfCostItem = conn.prepareStatement(updateFSeqOfCostItem.toString());
            it = ciUnderRootID.iterator();
            double ciSeqAdjust = 1.0;
            while (it.hasNext()) {
                String ci = (String)it.next();
                psupdateFSeqOfCostItem.setBigDecimal(1, new BigDecimal(Double.toString(ciSeqAdjust += 1.0)));
                psupdateFSeqOfCostItem.setObject(2, ci);
                psupdateFSeqOfCostItem.addBatch();
            }
            try {
                psupdateFSeqOfCostItem.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)psupdateFSeqOfCostItem);
            }
        }
        StringBuffer updateLongMatID = new StringBuffer();
        updateLongMatID.append(" update ").append(this.getTablename()).append(" set FLongMaterialID = ? where Fid = ? ");
        PreparedStatement psUpdateLongMatID = conn.prepareStatement(updateLongMatID.toString());
        StringBuffer getMatRowsSQL = new StringBuffer();
        getMatRowsSQL.append("select FID , FMaterialGroupID from ").append(this.getTablename()).append(" where FTotalRow = -1  ").append(this.getORDERBY());
        IRowSet matRowsRS = DbUtil.executeQuery((Context)this.getContext(), (String)getMatRowsSQL.toString());
        IMaterialGroup img = MaterialGroupFactory.getLocalInstance((Context)this.getContext());
        StringBuffer longMaterialIDs = new StringBuffer();
        while (matRowsRS.next()) {
            MaterialGroupInfo matGroupInfo;
            String rowID = matRowsRS.getString(1);
            longMaterialIDs.setLength(0);
            String materialGroupID = matRowsRS.getString(2);
            String treeID = null;
            for (MaterialGroupInfo parentInfo = matGroupInfo = img.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)materialGroupID))); parentInfo != null; parentInfo = parentInfo.getParent()) {
                treeID = parentInfo.getId().toString();
                parentInfo = img.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)treeID)));
                longMaterialIDs.append(treeID).append("!");
            }
            psUpdateLongMatID.setString(1, longMaterialIDs.toString());
            psUpdateLongMatID.setString(2, rowID);
            psUpdateLongMatID.addBatch();
        }
        try {
            psUpdateLongMatID.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)psUpdateLongMatID, (Connection)conn);
        }
    }

    private double adjustFSeqOfTotalMatGroup(String ciid, String matGroupTotalRowID, int level) throws BOSException, SQLException, EASBizException, UuidException {
        double CIseq = 0.0;
        String ciRowID = null;
        StringBuffer getFSeqOfTotalCostItem = new StringBuffer();
        getFSeqOfTotalCostItem.append("select top 1 Fid,Fseq FROM ").append(this.getTablename()).append(" where  FcostItemID = ?  AND FlongMaterialID  LIKE  '%").append(matGroupTotalRowID).append("%'    ").append(this.getORDERBY());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)getFSeqOfTotalCostItem.toString(), (Object[])new String[]{ciid});
        if (!rs.next()) {
            return CIseq;
        }
        ciRowID = rs.getString(1);
        CIseq = rs.getDouble(2) + (double)level * 0.001;
        return CIseq;
    }

    private Set getAllCIid(String tmpTblName) throws BOSException, SQLException {
        IRowSet ciIDs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FCostItemID FROM " + tmpTblName + " WHERE FCostItemID is not null "));
        if (ciIDs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
        while (ciIDs.next()) {
            if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
            databaseIDs.add(ciIDs.getString(1));
        }
        return databaseIDs;
    }

    private void insertTotalRowsForCostItemGroupTree(String tmpTblName, RptParams filter) throws EASBizException, BOSException, SQLException {
        Set databaseIDs;
        int groupLevel = 1;
        if (filter.getString("spCostItemLevel") != null) {
            groupLevel = Integer.parseInt(filter.getString("spCostItemLevel"));
        }
        if ((databaseIDs = this.getAllCIid(tmpTblName)) == null) {
            return;
        }
        int maxLevel = 0;
        StringBuffer allDataIDs = BDCMUtils.splitPK((Collection)databaseIDs);
        IRowSet oneRow = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT Max(a.Flevel) FROM T_NCM_CostItemTypeTree a LEFT JOIN T_NCM_CostItem b  ON a.FID = b.FTypeTreeID WHERE b.FID IN (" + allDataIDs.toString() + ")"));
        if (oneRow.next()) {
            maxLevel = oneRow.getInt(1);
        }
        if (maxLevel < groupLevel) {
            groupLevel = maxLevel;
        }
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)this.getContext());
        StringBuffer updateSeqSQL = new StringBuffer();
        updateSeqSQL.append("UPDATE ").append(tmpTblName).append(" SET FSeq = FSeq + ?").append(" WHERE FCostItemID IN (?)");
        StringBuffer sumSQL = new StringBuffer();
        sumSQL.append("SELECT newbosid('12345678') as FID,").append(" FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty").append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),Sum(isnull(FUnitCostAmt,0)),Sum(isnull(FUnitPercent,0)) ,FCostItemGroupID \n ").append(" FROM ").append(tmpTblName).append(" WHERE FTotalRow = ? AND FCostItemID IN (?) \n ").append(" GROUP BY FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName ").append(" ,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,FCostItemGroupID");
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(tmpTblName).append(" (FID, FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,").append(" FCostItemNumber,FCostItemName,\n").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq,FCostItemGroupID,FCostItemID ) \n").append(" VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,   ?,?,   ?,?,   ?,?,?,?,?, ?,? ) ");
        this.updateTempTableForInsertTotalRows(groupLevel, databaseIDs, (IDataBase)iCostItem, 0, updateSeqSQL, insertTotalSQL, sumSQL);
    }

    private void insertTotalRowsForMaterialGroupTree(String tmpTblName, RptParams filter) throws BOSException, SQLException, EASBizException {
        IRowSet ciIDs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FMaterialID FROM " + tmpTblName + " WHERE FMaterialID <> ' ' AND  FMaterialID is not null  "));
        if (ciIDs.size() == 0) {
            return;
        }
        int groupLevel = Integer.parseInt(filter.getString("spMaterialLevel"));
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)this.getContext());
        Set allCostItemIDs = this.getAllCIid(tmpTblName);
        if (allCostItemIDs == null) {
            return;
        }
        Map trees = iCostItem.transformToTree(allCostItemIDs, 1);
        Set groupSet = trees.keySet();
        this.updateCIseqByGroup(groupSet, (Set)trees.get("RootID"));
        LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
        while (ciIDs.next()) {
            if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
            databaseIDs.add(ciIDs.getString(1));
        }
        int maxLevel = 0;
        StringBuffer allDataIDs = BDCMUtils.splitPK(databaseIDs);
        IRowSet oneRow = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT Max(a.Flevel) FROM T_BD_MaterialGroup a LEFT JOIN T_BD_material b  ON a.FID = b.FMaterialGroupID WHERE b.FID IN (" + allDataIDs.toString() + ")"));
        if (oneRow.next()) {
            maxLevel = oneRow.getInt(1);
        }
        if (maxLevel < groupLevel) {
            groupLevel = maxLevel;
        }
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)this.getContext());
        StringBuffer updateSeqSQL = new StringBuffer();
        updateSeqSQL.append("UPDATE ").append(tmpTblName).append(" SET FSeq = FSeq + ?").append(" where  (FMaterialID <> ' ' AND FMaterialID is not null) and FMaterialID IN (?)");
        StringBuffer sumSQL = new StringBuffer();
        sumSQL.append(" SELECT newbosid('12345678') as FID,").append(" FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty").append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),Sum(isnull(FUnitCostAmt,0)),Sum(isnull(FUnitPercent,0)) ,FCostItemID \n ").append(", FCostItemNumber,FCostItemName  \n").append(" FROM ").append(tmpTblName).append(" \n WHERE FTotalRow = ? AND FMaterialID IN (?)").append(" GROUP BY FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,").append(" FCostItemID ,FCostItemNumber,FCostItemName \n");
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(tmpTblName).append(" (FID, FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,").append(" FMatNumber,FMatName,\n").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq,FMaterialGroupID , \n").append(" FCostItemNumber,FCostItemName ) \n").append(" VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,   ?,?,   ?,?,   ?,?,?,?,?, ?,   ?,? )");
        this.updateTempTableForInsertTotalRows(groupLevel, databaseIDs, (IDataBase)iMaterial, -1, updateSeqSQL, insertTotalSQL, sumSQL);
    }

    private void insertTotalRowsForExpenseGroupTree(String tmpTblName, RptParams filter) throws BOSException, SQLException, EASBizException {
        int groupLevel = Integer.parseInt(filter.getString("spExpenseLevel"));
        IRowSet ciIDs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FExpenseID FROM " + tmpTblName + " WHERE FExpenseID is not null and FExpenseID <>' ' "));
        if (ciIDs.size() == 0) {
            return;
        }
        LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
        while (ciIDs.next()) {
            if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
            databaseIDs.add(ciIDs.getString(1));
        }
        int maxLevel = 0;
        StringBuffer allDataIDs = BDCMUtils.splitPK(databaseIDs);
        IRowSet oneRow = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT Max(a.Flevel) FROM T_NCM_ExpenseTree a LEFT JOIN T_NCM_Expense b  ON a.FID = b.FTreeID WHERE b.FID IN (" + allDataIDs.toString() + ")"));
        if (oneRow.next()) {
            maxLevel = oneRow.getInt(1);
        }
        if (maxLevel < groupLevel) {
            groupLevel = maxLevel;
        }
        IExpense iExpense = ExpenseFactory.getLocalInstance((Context)this.getContext());
        StringBuffer updateSeqSQL = new StringBuffer();
        updateSeqSQL.append("UPDATE ").append(tmpTblName).append(" SET FSeq = ?").append(" WHERE FExpenseID IN (?)");
        StringBuffer sumSQL = new StringBuffer();
        sumSQL.append("SELECT tree.FNumber,tree.FName_").append(locLan).append(",Sum(tmp.FTotalConsumeCommonQty),Sum(tmp.FTotalConsumeQty),Sum(tmp.FTotalConsumeAssistQty),Sum(tmp.FTotalCostAmt)").append(",Sum(tmp.FUnitConsumeCommonQty),Sum(tmp.FUnitConsumeQty),Sum(tmp.FUnitConsumeAssistQty),Sum(tmp.FUnitCostAmt),Sum(tmp.FUnitPercent) ,105,FSeq FROM ").append(tmpTblName).append(" tmp INNER JOIN T_NCM_ExpenseTree tree  ON tmp.FTreeID = tree.FID").append(" WHERE FTotalRow = ? AND FExpenseID IN (?)").append(" GROUP BY FSeq  ,tree.FNumber,tree.FName_").append(locLan);
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(tmpTblName).append(" ( FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,").append(" FExpenseNumber,FExpenseName,\n").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq,FMaterialGroupID,FID ) \n").append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,?,?,(newbosid('12345678')))");
        this.updateTempTableForInsertTotalRows(groupLevel, databaseIDs, (IDataBase)iExpense, 1, updateSeqSQL, insertTotalSQL, sumSQL);
    }

    private void insertCostCenterTotalRow(RptParams filter) throws BOSException {
        double seq = this.globalSeq += 1.0;
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(this.getTablename()).append(" ( FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq ) \n").append("SELECT ").append(" FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty").append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),Sum(isnull(FUnitCostAmt,0)),100 ,20, max(fseq)+1 ").append(" \n FROM ").append(this.getTablename()).append(" \n WHERE FTotalRow = 0 \n ").append(" GROUP BY ").append(" FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty");
        DbUtil.execute((Context)this.getContext(), (String)insertTotalSQL.toString());
        StringBuffer precision = new StringBuffer();
        precision.append(" UPDATE ").append(this.getTablename()).append("  SET (FQtyPrecision,FConsumeQtyPrecision,FPricePrecision) = ").append(" (SELECT a,b,c FROM ( (SELECT MAX(FQtyPrecision) a,MAX(FConsumeQtyPrecision) b ,MAX(FPricePrecision) c FROM  \n").append(this.getTablename()).append("   WHERE FTotalRow =-1 or FTotalRow =0) ) as T )\t\t\t\t\t                      \n").append(" WHERE FTotalRow >0                                            \t\t\t\t\t  \n");
        DbUtil.execute((Context)this.getContext(), (String)precision.toString());
        StringBuffer amtPrecision = new StringBuffer();
        amtPrecision.append(" Update ").append(this.getTablename()).append(" SET (FAmountPrecision)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID= ").append(this.getTablename()).append(".FCompanyOrg").append(" \n").append(")").append(" \n");
        DbUtil.execute((Context)this.getContext(), (String)amtPrecision.toString());
        StringBuffer difference = new StringBuffer();
        difference.append("    (select 100 - Sum(FUnitPercent), FCostCenterID,FCostObjectID,FPeriodID from  ").append(this.getTablename()).append("      where FTotalRow = 0 group by FCostCenterID,FCostObjectID,FPeriodID ) ");
        BigDecimal diff = SysConstant.BIGZERO;
        String costcenterID = "";
        String costObjectID = "";
        String preiodID = "";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)difference.toString());
        try {
            while (rs.next()) {
                diff = rs.getBigDecimal(1);
                costcenterID = rs.getString(2);
                costObjectID = rs.getString(3);
                preiodID = rs.getString(4);
                StringBuffer adjust = new StringBuffer();
                adjust.append(" UPDATE ").append(this.getTablename()).append(" SET FUnitPercent = FUnitPercent + ?  \n ").append(" WHERE FID =                                                                \n").append(" (select top 1 FID from ").append(this.getTablename()).append("                  \n").append(" where FTotalRow = 0 ").append("  and FCostCenterID = '").append(costcenterID).append("'").append("  and FCostObjectID = '").append(costObjectID).append("'").append("  and FPeriodID = '").append(preiodID).append("'").append(" order by FUnitPercent desc )                          \n");
                DbUtil.execute((Context)this.getContext(), (String)adjust.toString(), (Object[])new BigDecimal[]{diff});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    private String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException, EASBizException, SQLException {
        String[] physicalTblNames = new String[]{NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynCostCalMatDetailResult_History"), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynCostCalPrdDetailResult_History"), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynMatAllocResult")};
        return physicalTblNames;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FID varchar(44) ");
        createTable.append(",FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjNumber  varchar(80) not null default(' ')");
        createTable.append(",FCostObjName varchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(255) ");
        createTable.append(",FProductLot varchar(80) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FObjQty NUMERIC(21,8) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FCostItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostItemName varchar(255) ");
        createTable.append(",FMaterialID varchar(44) ");
        createTable.append(",FMatNumber varchar(80)  default(' ') ");
        createTable.append(",FMatName varchar(255) ");
        createTable.append(",FMatModel nvarchar(255) ");
        createTable.append(",FMatShortName nvarchar(255) ");
        createTable.append(",FMatLot varchar(80) ");
        createTable.append(",FMatCommonUnitName varchar(255) ");
        createTable.append(",FMatUnitName varchar(255) ");
        createTable.append(",FMatAssistUnitName varchar(255) ");
        createTable.append(",FExpenseID varchar(44) ");
        createTable.append(",FExpenseNumber varchar(80) not null default('\u007f') ");
        createTable.append(",FExpenseName varchar(255) ");
        createTable.append(",FTotalConsumeCommonQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalConsumeQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalConsumeAssistQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalCostAmt NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitConsumeCommonQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitConsumeQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitConsumeAssistQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitCostPrice NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitCostAmt NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalUnitCostAmt NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitPercent NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalRow decimal(5,3) DEFAULT 0 ");
        createTable.append(",FSeq NUMERIC(10,3) NOT NULL DEFAULT 0 ");
        createTable.append(",FCostItemGroupID varchar(44) ");
        createTable.append(",FMaterialGroupID varchar(44) ");
        createTable.append(",FQtyPrecision int default(4) ");
        createTable.append(",FConsumeCommonQtyPrecision int default(4) ");
        createTable.append(",FConsumeQtyPrecision int default(4) ");
        createTable.append(",FConsumeAssistQtyPrecision int default(4) ");
        createTable.append(",FPricePrecision int default(2) ");
        createTable.append(",FAmountPrecision int default(2) ");
        createTable.append(",FLongMaterialID varchar(440) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String createTmpTableSQL2() throws BOSException {
        if (this.t_ExpenseFactor != null) {
            DbUtil.execute((Context)this.getContext(), (String)(" Truncate Table " + this.t_ExpenseFactor));
            return this.t_ExpenseFactor;
        }
        StringBuffer createTable2 = new StringBuffer();
        createTable2.append("create table tmp_MatCostCalcReport( ");
        createTable2.append(" FID varchar(44) ");
        createTable2.append(",FCostCenterID varchar(44) ");
        createTable2.append(",FCostObjectID varchar(44) ");
        createTable2.append(",FCostItemID varchar(44) ");
        createTable2.append(",FExpenseID varchar(44) ");
        createTable2.append(",FExpenseNumber varchar(80) not null default(' ') ");
        createTable2.append(",FExpenseName varchar(255) ");
        createTable2.append(",FAmount NUMERIC(24,12) Default(0),FQty NUMERIC(24,12) Default(0) ");
        createTable2.append(",FRatio NUMERIC(24,12) Default(0),FRatioSum NUMERIC(24,12) Default(0) ) ");
        try {
            String sTmpTblName;
            this.t_ExpenseFactor = sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable2.toString());
            this.getContext().put((Object)"createTable2", (Object)sTmpTblName);
            return sTmpTblName;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void dropTempTable(String reportID, RptParams filter, String tableName) throws BaseException {
        super.dropTempTable(reportID, filter, tableName);
        Object sTmpTblName = this.getContext().get((Object)"createTable2");
        if (sTmpTblName instanceof String) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable((String)sTmpTblName);
        }
    }

    private void innsertExpenseSQL(RptParams filter, String[] physicalTblNames, String tmpTblName, int amtPrecision, String companyID, String wheres) throws BOSException {
        Context ctx = this.getContext();
        StringBuffer insert = new StringBuffer();
        insert.append(" INSERT INTO ").append(tmpTblName).append("\t(   FID,FCostCenterID, FCostObjectID,FCostItemID ").append("\t   ,FAmount,FQty,FExpenseID ,FExpenseNumber,FExpenseName )  ").append('\n').append(" SELECT newbosid('12345678'),FCostCenterID, FCostObjectID,FCostItemID ").append("\t   ,SUM(FAmount),SUM(FQty),FExpenseID ,FNumber,FName_L2   ").append('\n').append(" FROM ( ").append('\n').append("\tSELECT MAT.FCostCenterID, MAT.FCostObjectID, MAT.FCostItemID, FAmount, FQty, '").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("' FExpenseID,exp.FNumber,exp.FName_l2").append('\n').append("\tFROM ").append(physicalTblNames[2]).append(" MAT ").append('\n').append("   INNER JOIN T_NCM_EXPENSE EXP ON EXP.FID = '").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("'").append('\n').append("\tINNER JOIN T_NCM_Period prd on MAT.FCalculatePeriodID = prd.FID                                    \n ").append("   INNER JOIN T_ORG_CostCenter cc on MAT.FCostCenterID = cc.FID            \t\t\t\t\t\t    \n ").append("   INNER JOIN T_BD_CostObject co on (MAT.FCompanyID = co.FCompanyID and MAT.FCostObjectID = co.FID)   \n").append("   INNER JOIN T_NCM_CostItem ci on MAT.FCostItemID = ci.FID and ci.FItemType='").append("2").append("' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n").append("\tWHERE MAT.FCompanyID= ? ").append(" and prd.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(this.beginDate)).append("') \n").append(" and prd.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(this.endDate)).append("') \n");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)">=", (String)"prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)"<=", (String)"prmtCostCenterTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)">=", (String)"prmtCostItemFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)"<=", (String)"prmtCostItemTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)">=", (String)"prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)"<=", (String)"prmtCostObjectTo");
        insert.append(wheres);
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)">=", (String)"prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)"<=", (String)"prmtCostCenterTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)">=", (String)"prmtCostItemFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)"<=", (String)"prmtCostItemTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)">=", (String)"prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)insert, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)"<=", (String)"prmtCostObjectTo");
        insert.append(wheres);
        insert.append("\t ) AS U  ").append('\n').append("\t GROUP BY  FCostCenterID, FCostObjectID, FCostItemID,FExpenseID ,FNumber,FName_l2   ");
        DbUtil.execute((Context)this.getContext(), (String)insert.toString(), (Object[])new Object[]{companyID});
    }

    private void updateExpenseSQL(String sTmpTblName2) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(sTmpTblName2).append(" AS ADT ").append('\n').append(" \tSET  FRatioSum = ( ").append('\n').append("         SELECT Sum(FAmount) ").append('\n').append("         FROM   ").append(sTmpTblName2).append(" DT ").append('\n').append("         WHERE ADT.FCostCenterID = DT.FCostCenterID AND ADT.FCostObjectID = DT.FCostObjectID AND ADT.FCostItemID = DT.FCostItemID").append('\n').append("         GROUP BY FCostCenterID,FCostObjectID,FCostItemID ) ; ").append('\n');
        sb.append('\n').append(" UPDATE ").append(sTmpTblName2).append("    SET  FRatio = CASE FRatioSum WHEN 0 THEN 1 ELSE Round( FAmount / FRatioSum, 12) END; ").append('\n');
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
    }

    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        if (StringUtils.isEmpty((String)this.t_ExpenseFactor) || !StringUtils.isEmpty((String)((String)rowData.get("FEXPENSEID")))) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ");
        for (String fieldName : rowData.keySet()) {
            if ("FEXPENSEID".equalsIgnoreCase(fieldName) || "FEXPENSENUMBER".equalsIgnoreCase(fieldName) || "FEXPENSENAME".equalsIgnoreCase(fieldName)) {
                sb.append(fieldName).append(",");
                continue;
            }
            Object value = rowData.get(fieldName);
            if (value instanceof String) {
                sb.append("'" + value.toString() + "'");
            } else if (value instanceof BigDecimal) {
                sb.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)((BigDecimal)value)));
            } else {
                sb.append(StringUtils.cnulls(value, (String)"' '"));
            }
            if ("FTotalConsumeQty".equalsIgnoreCase(fieldName) || "FTotalCostAmt".equalsIgnoreCase(fieldName) || "FTotalUnitCostAmt".equalsIgnoreCase(fieldName)) {
                sb.append(" * FRatio ");
            }
            sb.append(" as ").append(fieldName).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append(" from  ").append(this.t_ExpenseFactor).append(" where FCostCenterID =? AND FCostObjectID = ? AND FCostItemID = ?  ");
        return DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString(), (Object[])new Object[]{rowData.get("FCOSTCENTERID"), rowData.get("FCOSTOBJECTID"), rowData.get("FCOSTITEMID")});
    }

    private String getSQL(RptParams filter, String[] physicalTblNames, String tmpTblName, int amtPrecision, String wheres) {
        Context ctx = this.getContext();
        this.initData(filter);
        StringBuffer insert = new StringBuffer();
        insert.append(" INSERT INTO ").append(tmpTblName).append(" \t  (FID, FCompanyOrg,FPeriodID,FPeriodNumber,\n").append("\t   FCostCenterID,FCostCenterNumber,FCostCenterName,\n").append("\t   FCostObjectID,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot,\n").append("\t   FUnitName,FObjQty,\n").append("\t   FCostItemID,FCostItemNumber,FCostItemName,\n").append("\t   FMaterialID,FMatNumber,FMatName,FMatLot,FMatModel,FMatShortName,FMatUnitName,FMatAssistUnitName,\n").append("\t   FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" \t   FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,FUnitCostAmt,FUnitPercent  \n").append("\t   ,FTotalRow,FSeq,FCostItemGroupID,FMaterialGroupID  ").append("\t   ,FQtyPrecision,FConsumeQtyPrecision,FPricePrecision ,FAmountPrecision ,FLongMaterialID) \n").append(" SELECT FID, FCompanyOrg,FPeriodID,FPeriodNumber,                            \n ").append(" \t     FCostCenterID,FCostCenterNumber,FCostCenterName,                     \n ").append(" \t     FCostObjectID,FCostObjNumber,FCostObjName,FProductModel,FProductShortName,FProductLot, \n ").append(" \t     FUnitName,FObjQty,                                                   \n ").append(" \t     FCostItemID,FCostItemNumber,FCostItemName,                           \n ").append(" \t     FMaterialID,FMatNumber,FMatName,FMatLot,FMatModel,FMatShortName,FMatUnitName, FMatAssistUnitName,     \n ").append(" \t     FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt,                                      \n ").append("   \t FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,FUnitCostAmt,FUnitPercent,            \n ").append(" \t     FTotalRow,FSeq,FCostItemGroupID,FMaterialGroupID, \t                  \n ").append(" \t     FQtyPrecision,FConsumeQtyPrecision,FPricePrecision ,FAmountPrecision ,FLongMaterialID \n ").append(" FROM (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t          \n ");
        StringBuffer calMaterialResult = new StringBuffer();
        calMaterialResult.append("UNION \n").append("( SELECT newbosid('12345678') FID, cpr.FCompanyID FCompanyOrg,cpr.FCalculatePeriodID FPeriodID \n").append("\t\t\t\t ,to_char(prd.FNumber)  FPeriodNumber,                       \n").append("       cc.FID FCostCenterID,cc.FNumber FCostCenterNumber,cc.FName_l2 FCostCenterName,        \n  ").append("       co.FID FCostObjectID,co.FNumber FCostObjNumber,co.FName_l2 FCostObjName,mat2.FModel FProductModel,mat2.FShortName FProductShortName,co.FBatchNumber FProductLot, \n  ").append("\t     mu2.FName_l2 FUnitName,isnull(cpr.FTotalFinishedQty,0) FObjQty,           \n").append("       ci.FID FCostItemID,ci.FNumber FCostItemNumber,ci.FName_l2 FCostItemName,                                     \n  ").append("       cmr.FMaterialID FMaterialID,mat.FNumber FMatNumber,mat.FName_l2 FMatName,                          \n  ").append("       cmr.FLot FMatLot,mat.FModel FMatModel,mat.FShortName FMatShortName,mu.FName_l2 FMatUnitName, mu3.FName_l2 FMatAssistUnitName,                                   \n  ").append("       isnull(cmr.FFinishedAddqty,0) FTotalConsumeCommonQty,                           \n  ").append("       isnull(cmr.FFinishedQty,0) FTotalConsumeQty,                           \n  ").append("       isnull(cmr.FFinishedAssistQty,0) FTotalConsumeAssistQty,                           \n  ").append("       isnull(cmr.FFinishedAmount,0) FTotalCostAmt,                     \n  ").append("       0 FUnitConsumeCommonQty,0 FUnitConsumeQty,0 FUnitConsumeAssistQty,0 FUnitCostPrice,0 FUnitCostAmt,0 FUnitPercent, -1 FTotalRow,0 FSeq,                                           \n ").append("\t\t\t ci.FTypeTreeID FCostItemGroupID,mat.FMaterialGroupID FMaterialGroupID,                        \n  ").append("\t\t\t mmu2.FQtyPrecision FQtyPrecision,mmu.FQtyPrecision FConsumeQtyPrecision,mat.FPricePrecision FPricePrecision, \t\t\t\t\t\t\t   ").append(amtPrecision).append(" FAmountPrecision , ' ' FLongMaterialID \n ").append(" FROM ").append(physicalTblNames[0]).append(" cmr \n");
        StringBuffer join1 = new StringBuffer();
        join1.append(" INNER JOIN ").append(physicalTblNames[1]).append(" cpr \n").append(" ON cmr.FCompanyID = cpr.FCompanyID and cmr.FCalculatePeriodID = cpr.FCalculatePeriodID and ").append(" cmr.FCostCenterID =cpr.FCostCenterID and cmr.FCostItemID = cpr.FCostItemID and cmr.FCostObjectID = cpr.FCostObjectID ").append(" INNER JOIN T_NCM_Period prd on cmr.FCalculatePeriodID = prd.FID                                    \n ").append(" INNER JOIN T_ORG_CostCenter cc on cmr.FCostCenterID = cc.FID            \t\t\t\t\t\t    \n ").append(" INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID=ci.FID and ci.FItemType='").append("1").append("' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n").append(" INNER JOIN T_BD_CostObject co on (cmr.FCompanyID = co.FCompanyID and cmr.FCostObjectID = co.FID)   \n").append(" INNER JOIN T_BD_Material mat on cmr.FMaterialID = mat.FID                                          \n ").append(" INNER JOIN t_bd_multiMeasureUnit mmu on mat.fid = mmu.FMaterialID   \n ").append(" INNER JOIN T_BD_MeasureUnit mu on mmu.FMeasureUnitID = mu.FID    and mat.FBaseUnit=mu.fid          \n").append(" left JOIN T_BD_MeasureUnit mu3 on mmu.FMeasureUnitID = mu3.FID   and mat.FAssistUnit=mu.fid     \n").append(" INNER JOIN T_BD_Material mat2 on cpr.FProductID = mat2.FID                                         \n ").append(" INNER JOIN t_bd_multiMeasureUnit mmu2 on mat2.fid = mmu2.FMaterialID   \n ").append(" INNER JOIN T_BD_MeasureUnit mu2 on mmu2.FMeasureUnitID = mu2.FID and mat2.FBaseUnit=mu2.fid        \n");
        StringBuffer Where = new StringBuffer();
        Where.append(" WHERE cmr.FCompanyID = ? ").append(" and prd.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(this.beginDate)).append("') \n").append(" and prd.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(this.endDate)).append("') \n");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)Where, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)">=", (String)"prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)Where, (RptParams)filter, (boolean)false, (String)"cc.FNumber", (String)"<=", (String)"prmtCostCenterTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)Where, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)">=", (String)"prmtCostItemFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)Where, (RptParams)filter, (boolean)false, (String)"ci.FNumber", (String)"<=", (String)"prmtCostItemTo");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)Where, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)">=", (String)"prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate((Context)ctx, (StringBuffer)Where, (RptParams)filter, (boolean)false, (String)"co.FNumber", (String)"<=", (String)"prmtCostObjectTo");
        Where.append(wheres);
        StringBuffer calProductResult = new StringBuffer();
        calProductResult.append("( SELECT newbosid('12345678')  FID, cmr.FCompanyID FCompanyOrg,cmr.FCalculatePeriodID FPeriodID  \n").append("\t\t\t\t ,to_char(prd.FNumber) FPeriodNumber,                          \n").append("       cc.FID FCostCenterID,cc.FNumber FCostCenterNumber,cc.FName_l2 FCostCenterName,          \n").append("       co.FID FCostObjectID,co.FNumber FCostObjNumber,co.FName_l2 FCostObjName,mat.FModel FProductModel,mat.FShortName FProductShortName,co.FBatchNumber FProductLot, mu2.FName_l2 FUnitName, \n").append("       isnull(cmr.FTotalFinishedQty,0) FObjQty,                          \n").append("       ci.FID FCostItemID,ci.FNumber FCostItemNumber,ci.FName_l2 FCostItemName,                               \n").append("      ' ' FMaterialID,N' ' FMatNumber,N' ' FMatName, N' ' FMatLot,N' ' FMatModel,N' ' FMatShortName,N' ' FMatUnitName, N' ' FMatAssistUnitName,                                                     \n").append("       0 FTotalConsumeCommonQty,                               \n").append("       isnull(cmr.FFinishedQty,0) FTotalConsumeQty,                               \n").append("       0 FTotalConsumeAssistQty,                               \n").append("       isnull(cmr.FFinishedAmount,0) FTotalCostAmt,                         \n").append("       0 FUnitConsumeCommonQty,0 FUnitConsumeQty,0 FUnitConsumeAssistQty,0 FUnitCostPrice,0 FUnitCostAmt,0 FUnitPercent,0 FTotalRow,0 FSeq,                                                              \n").append("\t\t\t ci.FTypeTreeID FCostItemGroupID ,mat.FMaterialGroupID FMaterialGroupID,                            \n").append("\t   mmu2.FQtyPrecision FQtyPrecision,CASE WHEN ci.FUnitID is null THEN mmu2.FQtyPrecision ELSE mu.FQtyPrecision END FConsumeQtyPrecision,").append("\t  CASE WHEN isnull(ci.FPricePrecision,0) =0 THEN mat.FPricePrecision ELSE ci.FPricePrecision END FPricePrecision,").append(amtPrecision).append(" FAmountPrecision  , ' ' FLongMaterialID \n ").append(" FROM ").append(physicalTblNames[1]).append(" cmr \n");
        StringBuffer join2 = new StringBuffer();
        join2.append(" INNER JOIN T_NCM_Period prd on cmr.FCalculatePeriodID = prd.FID                                   \n ").append(" INNER JOIN T_ORG_CostCenter cc on cmr.FCostCenterID = cc.FID            \t\t\t\t\t\t   \n ").append(" INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID=ci.FID ").append(" LEFT OUTER JOIN T_BD_MeasureUnit mu on ci.FUnitID = mu.FID                                       \n").append(" INNER JOIN T_BD_CostObject co on (cmr.FCompanyID = co.FCompanyID and cmr.FCostObjectID = co.FID) \n").append(" INNER JOIN T_BD_Material mat on cmr.FProductID = mat.FID                                         \n ").append(" INNER JOIN t_bd_multiMeasureUnit mmu2 on mat.fid = mmu2.FMaterialID   \t\t\t\t\t\t   \n ").append(" INNER JOIN T_BD_MeasureUnit mu2 on mmu2.FMeasureUnitID = mu2.FID   and mat.FBaseUnit=mu2.fid     \n");
        String sql = insert.append(calProductResult).append(join2).append(Where).append(" ) \n").append(calMaterialResult).append(join1).append(Where).append(" AND cmr.FMaterialID is not null ) \n").append(" ) AS Uinon  ORDER BY FPeriodNumber, FCostCenterNumber,FCostObjNumber,FCostItemNumber ,FMatNumber  ").toString();
        return sql;
    }

    protected String getORDERBY() {
        return " ORDER BY FPeriodNumber,FCostCenterNumber,FCostObjNumber,FSEQ,FCostItemNumber,FTotalRow,FMatNumber ";
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"52_DynFinishedProductCostDetailReport", (Locale)ctx.getLocale()) + this.periodFrom.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"53_DynFinishedProductCostDetailReport", (Locale)ctx.getLocale()) + this.periodTo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        return titles;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        return NCMUtils.formatConditions((String)"FTotalRow");
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList childList = header.getChilds();
        ArrayList childChildList = null;
        ReportHeader childHeader = null;
        ReportHeader childChildHeader = null;
        String fieldName = null;
        String childFieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            int j;
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"37_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"29_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"28_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FExpenseName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynCCFeeTotalReport_ExpenseName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Model", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FExpenseNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynCCFeeTotalReport_ExpenseNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"31_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FObjQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"39_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"30_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"36_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_MatNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_MatName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_MatShortName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_BaseUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductLot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"34_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"32_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynByClassCostCalReport_Period", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynFinishedProductCostDetailReport_ProductShortName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynFinishedProductCostDetailReport_ProductUnitName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatlot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"34_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FUnitCost")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"41_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FUnitPercent")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynFinishedProductCostDetailReport_UnitRatio", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitCostPrice")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Price", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitConsumeQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynFinishedProductCostDetailReport_UnitConsumeQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FUnitCostAmt")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (!fieldName.equals("FTotalCost")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"40_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            childChildList = childHeader.getChilds();
            for (j = 0; j < childChildList.size(); ++j) {
                childChildHeader = (ReportHeader)childChildList.get(j);
                childFieldName = childChildHeader.getFieldName();
                if (childFieldName.equals("FTotalConsumeQty")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynFinishedProductCostDetailReport_TotalConsumeQty", (Locale)ctx.getLocale()));
                    continue;
                }
                if (!childFieldName.equals("FTotalCostAmt")) continue;
                childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
            }
        }
        return header;
    }
}

