/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.cal.report.app.MAAllocTotalReport;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynMAAllocTotalReport
extends MAAllocTotalReport {
    private static Logger logger = Logger.getLogger((String)DynMAAllocTotalReport.class.getName());

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String sql = this.buildDataSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  * FROM ");
        sql.append(tempTableName);
        sql.append(where);
        sql.append(" Order by  FTotalRow2 ");
        sql.append(orderByMode);
        sql.append(", ");
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + orderByMode;
                fieldNumber = "FCostObjectID";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FitemNumber")) {
                orderByWhichTotal = ", FTotalMaterialRow " + orderByMode;
            }
            sql.append(fieldNumber);
            sql.append(orderByWhichTotal);
            sql.append(",");
        }
        sql.append("FTotalRow");
        return sql.toString();
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTableName(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        String tempTableName;
        String tableName;
        Context ctx = this.getContext();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReportNor((Context)ctx, (String)companyID, (String)"T_NCM_DynMatAllocResult");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table t1 ( ");
        createTable.append(" FPeriodNumber varchar(20) ");
        createTable.append(" ,FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FItemID varchar(44) ");
        createTable.append(",FItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FItemName varchar(255) ");
        createTable.append(",FItemModel nvarchar(255) ");
        createTable.append(",FItemShortName nvarchar(80) ");
        createTable.append(",FUnitCommonName varchar(255) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FUnitAssistName varchar(255) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjectNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostObjectName varchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FCostItemID varchar(80) ");
        createTable.append(",FCostItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostItemName varchar(255) ");
        createTable.append(",FCommonQty decimal(21,8) ");
        createTable.append(",FQty decimal(21,8) ");
        createTable.append(",FAssistQty decimal(21,8) ");
        createTable.append(",FCommonqtyPrecision int  default(4) ");
        createTable.append(",FqtyPrecision int not null default(4) ");
        createTable.append(",FAssistqtyPrecision int  default(4) ");
        createTable.append(",FPrice decimal(21,8) ");
        createTable.append(",FPricePrecision int not null default(2) ");
        createTable.append(",FAmount decimal(17,4) ");
        createTable.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTable.append(",FTotalRow2 decimal(21,8) not null default(0) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalMaterialRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FPeriodNumber,FCostCenterID,FItemID,FCostObjectID,FCostItemID,FUnitCommonName,FUnitAssistName,FCommonQty,FQty,FAssistQty,FPrice,FAmount,FIsTotalRow) \n");
        sb.append("(SELECT TO_CHAR(t2.FNumber), t1.FCostCenterID as FCostCenterID, t1.FMaterialID as FItemID, t1.FCostObjectID as FCostObjectID,");
        sb.append(" t1.FCostItemID as FCostItemID,unit.FName_L2,assistUnit.FName_L2,SUM(t1.FCommonQty) as FCommonQty, SUM(t1.FQty) as FQty,SUM(t1.FAssistQty) as FAssistQty, ");
        sb.append("case when SUM(t1.FQty) = 0 then 0 else to_decimal(SUM(t1.FAmount),24,12)/to_decimal(SUM(t1.FQty),24,12) end as FPrice,");
        sb.append(" SUM(t1.FAmount) as FAmount,0 AS FIsTotalRow \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join T_NCM_Period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sb.append(" join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sb.append(" join t_Ncm_Costitem t5 on t1.FCostItemID = t5.FID  \n");
        sb.append(" left join t_bd_material t6 on t1.FMaterialID = t6.FID  \n");
        sb.append(" left join t_bd_MeasureUnit t7 on t6.FBaseUnit = t7.FID  \n");
        sb.append(" left join T_BD_MeasureUnit unit on t1.FCommonUnitID = unit.FID \n");
        sb.append(" left join T_BD_MeasureUnit assistUnit on t1.FAssistUnitID = assistUnit.FID \n");
        sb.append(" left join T_BD_MaterialCompanyInfo t8 on t6.FID = t8.FMaterialID  \n");
        sb.append(" where t1.FCompanyID = ? and t1.FCompanyID=t8.FCompanyID and t8.FStatus=1 \n");
        this.buildFilter(filter, sb);
        sb.append(" GROUP BY TO_CHAR(t2.FNumber), FCostCenterID,t1.FMaterialID, FCostObjectID, FCostItemID ,unit.FName_L2,assistUnit.FName_L2 )\n");
        sb.append(";");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyID});
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tempTableName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + " as t1  set (FqtyPrecision,FPricePrecision) " + "  =(select  mmu.FqtyPrecision,t2.FPricePrecision \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID and t2.FBaseUnit=mmu.FMeasureUnitID ");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set FCommonqtyPrecision " + "  =(select  max(mmu.FqtyPrecision) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID ");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set FAssistqtyPrecision " + "  =(select  isnull(mmu.FqtyPrecision,4) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID and t2.FAssistUnit=mmu.FMeasureUnitID ");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        String[] fields = this.getGroupByFields((ArrayList)filter.getObject("table"));
        sb.append(" insert into " + tempTableName + "(FTotalRow,FTotalRow2," + fields[0] + ",FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPricePrecision,FCommonQty,FQty,FAssistQty,FPrice,FAmount) \n");
        sb.append(" SELECT " + fields[1] + ",case when grouping(" + fields[2] + ") = 1 then 1 else 0 end," + fields[0] + " ,isnull(max(FCommonqtyPrecision),4),isnull(max(FqtyPrecision),4),isnull(max(FAssistqtyPrecision),4)," + "isnull(max(FPricePrecision),0),SUM(FCommonQty),SUM(FQty),SUM(FAssistQty),CASE SUM(FQty) WHEN 0 THEN 0 ELSE  TO_Decimal(SUM(FAmount),21,8)/TO_Decimal(SUM(FQty),21,8) END ,SUM(FAmount) \n");
        sb.append(" FROM " + tempTableName + "\n");
        sb.append(" where FTotalRow = 0 \n");
        sb.append(" group by " + fields[0]);
        sb.append(" with rollup ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1 set (FCostCenterNumber,FCostCenterName)  =(select  t2.FNumber, t2.FName_L2 \n");
        sb.append(" from T_ORG_CostCenter t2 \n");
        sb.append(" where t1.FCostCenterID = t2.FID) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set (FItemNumber,FItemName,FUnitName,FItemModel,FItemShortName,FPricePrecision) " + "  =(select  t2.FNumber, t2.FName_L2, t3.FName_L2,t2.FModel,t2.FShortName,t2.FPricePrecision \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" inner join t_bd_MeasureUnit t3 on t2.FBaseUnit = t3.FID \n");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        String table = "T_IM_MaterialReqBillEntry";
        sb.append(" update " + tempTableName + " as t1  set FUnitCommonName " + "  = (select  top 1 t3.FName_L2 \n");
        sb.append(" from  " + table + " t2  \n");
        sb.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sb.append(" where t2.FMaterialID=t1.FItemID group by t2.FMaterialID,t3.FName_L2 )");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set FUnitAssistName " + "  =(select  t3.FName_L2 \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" left join t_bd_MeasureUnit t3 on t2.FAssistUnit = t3.FID \n");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1 set (FCostObjectNumber ,FCostObjectName,FProductModel,FProductShortName) = (select t2.FNumber,t2.FName_L2, t3.FModel,t3.FShortName \n");
        sb.append(" from  T_BD_CostObject t2 ");
        sb.append(" JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=t2.FStdProductIDID \n");
        sb.append(" JOIN T_BD_Material t3 ON t3.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
        sb.append(" where t1.FCostObjectID = t2.FID AND T_BD_MaterialCompanyInfo.FCompanyID='").append(companyID).append("'");
        sb.append(" AND T_BD_MaterialCompanyInfo.FStatus = 1 )");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n");
        sb.append(" from t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + "  set FItemModel = '', FItemShortName = '', FProductModel = '', FProductShortName = '', FUnitCommonName = '', FUnitName = '', FUnitAssistName = ''");
        sb.append(" where FTotalRow <> 0 \n");
        sb.append("\n\n");
        sb.append(";");
        StringBuffer orderBy = new StringBuffer();
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
                fieldNumber = "FCostObjectNumber";
                fieldName = "FCostObjectName";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FitemNumber")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
            }
            sb.append(" update " + tempTableName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
            sb.append(whichTotal);
            sb.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sb.append("\n\n");
            sb.append(";");
            orderBy.append(fieldNumber);
            orderBy.append(",");
        }
        String orderBySort = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBySort.split(",");
        String totalFieldNumber = orderStrings[0];
        sb.append("Update ");
        sb.append(tempTableName);
        sb.append(" set ");
        sb.append(totalFieldNumber);
        sb.append(" = '");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()));
        sb.append("'  where Ftotalrow2 = 1 \n");
        sb.append("\n\n");
        sb.append(";");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString());
        return tempTableName;
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        PeriodInfo periodInfo;
        if (filter.getObject("norStartPeriod") != null) {
            periodInfo = (PeriodInfo)filter.getObject("norStartPeriod");
            sb.append(" and t2.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(periodInfo.getBeginDate())).append("') \n");
        }
        if (filter.getObject("norEndPeriod") != null) {
            periodInfo = (PeriodInfo)filter.getObject("norEndPeriod");
            sb.append(" and t2.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(periodInfo.getEndDate())).append("') \n");
        }
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("itemFrom") != null && !"".equals(filter.getString("itemFrom"))) {
            sb.append(" and t6.FNumber >='").append(filter.getString("itemFrom")).append("'");
        }
        if (filter.getString("itemTo") != null && !"".equals(filter.getString("itemTo"))) {
            sb.append(" and t6.FNumber <='").append(filter.getString("itemTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t5.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t5.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
    }

    private String[] getGroupByFields(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sqlCase = new StringBuffer();
        String firstFields = null;
        sqlCase.append(" case ");
        int n = 105;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            sqlCase.append(" when grouping(" + fieldID + ") = 1 then " + n + " \n");
            if (firstFields == null) {
                firstFields = fieldID;
            }
            --n;
        }
        sqlCase.append(" else " + n + " end ");
        return new String[]{sb.toString(), sqlCase.toString(), firstFields};
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        String periodFrom = ((PeriodInfo)filter.getObject("norStartPeriod")).getName();
        String periodTo = ((PeriodInfo)filter.getObject("norEndPeriod")).getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"55_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + periodFrom + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"16_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + periodTo + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"17_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costcenterFrom"), (String)filter.getString("costcenterTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"57_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("itemFrom"), (String)filter.getString("itemTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"60_DynMAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costobjectFrom"), (String)filter.getString("costobjectTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"61_DynMAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costitemFrom"), (String)filter.getString("costitemTo")));
        return titles;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }
}

