/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodCollection;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynMaterialCostStatReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.MaterialCostStatReport");
    private PeriodInfo periodFrom = null;
    private PeriodInfo periodTo = null;
    Date beginDate = null;
    Date endDate = null;
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO);

    protected void initData(RptParams filter) {
        if (this.periodFrom == null) {
            this.periodFrom = (PeriodInfo)filter.getObject("periodFrom");
        }
        if (this.periodTo == null) {
            this.periodTo = (PeriodInfo)filter.getObject("periodTo");
        }
        this.beginDate = new Date(this.periodFrom.getBeginDate().getTime());
        this.endDate = new Date(this.periodTo.getEndDate().getTime());
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        this.initData(filter);
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String[] physicalTblNames = this.getPhysicalTableName(companyID);
        Integer nObjCountPerPage = new Integer(filter.getString("costobjectPerPage"));
        if (nObjCountPerPage <= 0) {
            nObjCountPerPage = new Integer(20);
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct t1.FCostObjectID,t5.FNumber FROM ").append(physicalTblNames[1]).append(" t1 ").append("INNER JOIN T_BD_CostObject t5 on t1.FCostObjectID=t5.FID\n").append("INNER JOIN T_ORG_CostCenter t6 on t1.FCostCenterID=t6.FID\n").append("INNER JOIN T_NCM_Period t7 on t1.FCalculatePeriodID=t7.FID\n").append("INNER JOIN T_NCM_CostItem t8 on t1.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append("INNER JOIN T_BD_Material t9 on t1.FMaterialID=t9.FID\n").append(" WHERE t1.FCompanyID=? \n").append(" and t7.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(this.beginDate)).append("') and t7.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(this.endDate)).append("') \n");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "costcenterFrom");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "costcenterTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "costobjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "costobjectTo");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "costitemFrom");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "costitemTo");
        sbSQL.append("\n ORDER BY t5.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new Object[]{companyID});
        DynamicRowSet drs = new DynamicRowSet(1);
        drs.setColInfo(1, "costobjectid", "constobjectid", 12, null);
        StringBuffer sb = new StringBuffer();
        rs.first();
        for (int i = 1; i <= rs.size(); ++i) {
            sb.append("'").append(rs.getString("FCostObjectID")).append("',");
            if (i == rs.size() || i % nObjCountPerPage == 0) {
                drs.moveToInsertRow();
                drs.updateString("costobjectid", sb.substring(0, sb.length() - 1).toString());
                drs.insertRow();
                sb = new StringBuffer();
            }
            rs.next();
        }
        return drs;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        int i;
        Context ctx = this.getContext();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        this.periodFrom = (PeriodInfo)filter.getObject("periodFrom");
        this.periodTo = (PeriodInfo)filter.getObject("periodTo");
        String[] physicalTblNames = this.getPhysicalTableName(companyID);
        String sTmpTblName = this.createTmpTableSQL();
        HashMap objMap = (HashMap)filter.getObject("position");
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" INSERT INTO ").append(sTmpTblName).append(" \t  (FTotalRow,FTotalRow2,FCompanyOrg,FPeriodID,FPeriodNumber,\n").append("\t   FCostObjID,FCostObjNumber,FCostObjName,FProductLot,\n").append("\t   FCostCenterID,FCostCenterNumber,FCostCenterName,\n").append("\t   FCostItemID,FCostItemNumber,FCostItemName,\n").append("\t   FMatID,FMatNumber,FMatName,FMatLot,FMatModel,FMatShortName,\n").append("\t   FObjQ,\n").append("\t   FWIPCommonQ,FWIPQ,FWIPAssistQ,FWIPA,\n").append("\t   FFinishedCommonQ,FFinishedQ,FFinishedAssistQ,FFinishedA,\n").append("\t   FCurInputCommonQ,FCurInputQ,FCurInputAssistQ,FCurInputA,\n").append("\t   FTotalInputCommonQ,FTotalInputQ,FTotalInputAssistQ,FTotalInputA,\n").append("      FYTDInputQ,FYTDInputA,\n").append("      FYTDFinishedQ,FYTDFinishedA,FIsTotalRow)\n").append("SELECT distinct 0,0,t4.FCompanyID,t4.FCalculatePeriodID,to_char(t7.FNumber),\n").append("       t4.FCostObjectID,t5.FNumber,t5.FName_l2,t5.FBatchNumber,\n").append("       t4.FCostCenterID,t6.FNumber,t6.FName_l2,\n").append("       t4.FCostItemID,t8.FNumber,t8.FName_l2,\n").append("       t4.FMaterialID,t9.FNumber,t9.FName_l2,\n").append("       t4.FLot,t9.FModel,t9.FShortName,\n").append("       0, \n").append("\t\tt4.FEoPWIPAddQty,t4.FEoPWIPQty,t4.FEoPWIPAssistQty,t4.FEoPWIPAmount,\n").append("       t4.FFinishedAddQty,t4.FFinishedQty,t4.FFinishedAssistQty,t4.FFinishedAmount,\n").append("       t4.FEoPWIPAddQty+t4.FFinishedAddQty,\t\tt4.FEoPWIPQty+t4.FFinishedQty,\t\tt4.FEoPWIPAssistQty+t4.FFinishedAssistQty,\t\tt4.FEoPWIPAmount+t4.FFinishedAmount,\n").append("       t4.FEoPWIPAddQty+t4.FFinishedAddQty,\t\tt4.FEoPWIPQty+t4.FFinishedQty,\t\tt4.FEoPWIPAssistQty+t4.FFinishedAssistQty,\t\tt4.FEoPWIPAmount+t4.FFinishedAmount,\n").append("       t4.FEoPWIPQty+t4.FFinishedQty,\n").append("\t    t4.FEoPWIPAmount+t4.FFinishedAmount,\n").append("       t4.FFinishedQty, t4.FFinishedAmount,\n").append("       0 AS FIsTotalRow \n").append("FROM ").append(physicalTblNames[0]).append(" t1\n").append("RIGHT JOIN ").append(physicalTblNames[1]).append(" t4\n").append("       on t4.FCostObjectID=t1.FCostObjectID\n").append("       AND t4.FCostCenterID=t1.FCostCenterID\n").append("       and isnull(t4.FLot,' ')=' ' \n").append("INNER JOIN T_BD_CostObject t5 on t4.FCostObjectID=t5.FID\n").append("INNER JOIN T_ORG_CostCenter t6 on t4.FCostCenterID=t6.FID\n").append("INNER JOIN T_NCM_Period t7 on t4.FCalculatePeriodID=t7.FID\n").append("INNER JOIN T_NCM_CostItem t8 on t4.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append("INNER JOIN T_BD_Material t9 on t4.FMaterialID=t9.FID\n").append(" WHERE t4.FCompanyID=? \n").append(" AND t4.FCostObjectID in (").append((String)objMap.get("costobjectid")).append(") \n").append(" and t7.FBeginDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(this.beginDate)).append("') and t7.FEndDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(this.endDate)).append("') \n");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "costcenterFrom");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "costcenterTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "costobjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "costobjectTo");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "costitemFrom");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "costitemTo");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new Object[]{companyID});
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FObjQ,FUnitCostCommonQ,FUnitCostQ,FUnitCostAssistQ,FUnitCostA)=\n").append("  (SELECT isnull(t2.FFinishedQty,0), \n");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedCommonQ", "isnull(t2.FFinishedQty,0)", ",");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedQ", "isnull(t2.FFinishedQty,0)", ",");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedAssistQ", "isnull(t2.FFinishedQty,0)", ",");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedA", "isnull(t2.FFinishedQty,0)", " ");
        sbSQL.append("      FROM ").append(physicalTblNames[2]).append(" t2\n").append("    WHERE t1.FCompanyOrg=t2.FCompanyID \n").append("      AND t1.FPeriodID=t2.FCalculatePeriodID\n").append("      AND t1.FCostObjID=t2.FCostObjectID\n").append("      AND t1.FCostCenterID=t2.FCostCenterID);\n\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FProductModel,FProductShortName,FUnitName)=\n").append("  (SELECT t3.FModel,t3.FShortName,t4.FName_L2 FObjUnit \n");
        sbSQL.append("      FROM T_BD_CostObject t2 \n").append("      INNER JOIN T_BD_Material t3 on t2.FStdProductIDID=t3.FID\n").append("      LEFT  JOIN T_BD_MeasureUnit t4 on t3.FBaseUnit=t4.FID\n").append("      WHERE t1.FCostObjID=t2.FID);\n\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FMatUnitName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID\n").append("      WHERE t1.FMatID=t2.FID);\n");
        String table = "T_IM_MaterialReqBillEntry";
        sbSQL.append(" update " + sTmpTblName + " as t1  set FMatUnitCommonName " + "  = (select  top 1 t3.FName_L2 \n");
        sbSQL.append(" from  " + table + " t2  \n");
        sbSQL.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sbSQL.append(" where t2.FMaterialID=t1.FMatID group by t2.FMaterialID,t3.FName_L2 )");
        sbSQL.append("\n\n");
        sbSQL.append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FMatUnitAssistName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      LEFT JOIN t_BD_MeasureUnit t3 on t2.FAssistUnit=t3.FID\n").append("      WHERE t1.FMatID=t2.FID);\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1 \n").append("    SET (FUnitCostRatio)= \n").append(" (SELECT FSum \n").append("    FROM (SELECT FPeriodNumber FP,FCostObjID FC,SUM(FFinishedA) FSum \n").append("            FROM  ").append(sTmpTblName).append("\n").append("            GROUP BY FPeriodNumber,FCostObjID) as t2\n").append("   WHERE t1.FCostObjID=t2.FC and t1.FPeriodNumber=t2.FP)");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        HashMap<String, Integer> totalrows = new HashMap<String, Integer>();
        int totalrow = 104;
        ArrayList tblData = (ArrayList)filter.getObject("table");
        sbSQL = new StringBuffer();
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer orderBy = new StringBuffer();
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            totalrows.put(fieldID, new Integer(totalrow--));
            if (!((Boolean)row.get("isTotal")).booleanValue()) continue;
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append(",FPeriodName,FTotalPeriodRow ").append(orderByMode);
            } else if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append(",FCostCenterNumber,FTotalCostCenterRow ").append(orderByMode);
            } else if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                orderBy.append(",FCostObjNumber,FTotalCostObjectRow ").append(orderByMode);
            } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append(",FCostItemNumber,FTotalCostItemRow ").append(orderByMode);
            } else if ("FMatID".equalsIgnoreCase(fieldID)) {
                orderBy.append(",FMatNumber,FTotalMatRow ").append(orderByMode);
            }
            StringBuffer fields = new StringBuffer();
            for (int k = 0; k <= i; ++k) {
                HashMap subrow = (HashMap)tblData.get(k);
                String subFieldID = (String)subrow.get("id");
                Boolean isTotal = (Boolean)subrow.get("isTotal");
                if ("FPeriodID".equalsIgnoreCase(subFieldID) && isTotal.booleanValue()) {
                    fields.append("FPeriodID,FPeriodNumber,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(subFieldID) && isTotal.booleanValue()) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if ("FCostObjID".equalsIgnoreCase(subFieldID) && isTotal.booleanValue()) {
                    fields.append("FCostObjID,FProductModel,FProductShortName,FProductLot,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(subFieldID) && isTotal.booleanValue()) {
                    fields.append("FCostItemID,");
                    continue;
                }
                if (!"FMatID".equalsIgnoreCase(subFieldID) || !isTotal.booleanValue()) continue;
                fields.append("FMatID,FMatNumber,FMatName,FMatModel,FMatShortName,FMatUnitCommonName,FMatUnitName,FMatUnitAssistName,FMatLot,");
            }
            fields.deleteCharAt(fields.length() - 1);
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("\n").append("  (FCompanyOrg,FTotalRow,FTotalRow2,\n").append("  " + fields + ",\n");
            sbSQL.append("  FUnitCostRatio,FUnitCostCommonQ,FUnitCostQ,FUnitCostAssistQ,FUnitCostA,\n");
            sbSQL.append("\tFBoPAmount,FWIPA,\n").append("\tFFinishedA,FTotalInputA,\n").append("   FYTDFinishedA,FYTDInputA,\n").append("   FCurInputA) \n").append(" SELECT '" + companyID + "', 0,").append(totalrows.get(fieldID)).append("\n").append("  ," + fields + ",\n");
            sbSQL.append("  MAX(FUnitCostRatio),");
            this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedCommonQ)", "MAX(FObjQ)", ",\n");
            this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedQ)", "MAX(FObjQ)", ",\n");
            this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedAssistQ)", "MAX(FObjQ)", ",\n");
            this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedA)", "MAX(FObjQ)", ",\n");
            sbSQL.append("  SUM(FBoPAmount),SUM(FWIPA),\n").append("  SUM(FFinishedA),SUM(FTotalInputA),\n").append("  SUM(FYTDFinishedA),SUM(FYTDInputA),\n").append("  SUM(FCurInputA) \n").append(" FROM " + sTmpTblName + "\n").append(" WHERE FTotalRow2 = 0 \n");
            sbSQL.append(" GROUP BY " + fields);
            sbSQL.append("\n\n").append(";");
        }
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FObjQ)=\n").append("  (SELECT isnull(t2.FFinishedQty,0)\n");
        sbSQL.append("      FROM ").append(physicalTblNames[2]).append(" t2\n").append("    WHERE t1.FCompanyOrg=t2.FCompanyID \n").append("      AND t1.FPeriodID=t2.FCalculatePeriodID\n").append("      AND t1.FCostObjID=t2.FCostObjectID\n").append("      AND t1.FCostCenterID=t2.FCostCenterID)").append("  where FTotalRow2 <> 0;\n\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FProductModel,FProductShortName,FUnitName)=\n").append("  (SELECT t3.FModel,t3.FShortName,t4.FName_L2 FObjUnit \n");
        sbSQL.append("      FROM T_BD_CostObject t2 \n").append("      INNER JOIN T_BD_Material t3 on t2.FStdProductIDID=t3.FID\n").append("      LEFT  JOIN T_BD_MeasureUnit t4 on t3.FBaseUnit=t4.FID\n").append("      WHERE t1.FCostObjID=t2.FID)").append("  where FTotalRow2 <> 0;\n\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" Update ").append(sTmpTblName).append("\n Set FUnitCostRatio= \n");
        this.AppendCaseSQLClause(sbSQL, "FFinishedA", "FUnitCostRatio", " \n\n;");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostCenterNumber,FCostCenterName) =(select  t2.FNumber, t2.FName_L2 \n").append(" FROM T_ORG_CostCenter t2 \n").append(" WHERE t1.FCostCenterID = t2.FID) ").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostObjNumber ,FCostObjName,FProductModel,FProductShortName) = (select t2.FNumber,t2.FName_L2, t3.FModel,t3.FShortName \n").append(" FROM T_BD_CostObject t2 ").append(" INNER JOIN t_bd_Material t3 on t2.FRelatedID = t3.FID  \n").append(" WHERE t1.FCostObjID = t2.FID )").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FMatNumber, FMatName, FMatModel, FMatShortName)= (select  t2.FNumber, t2.FName_L2, t2.FModel, t2.FShortName \n").append(" FROM t_bd_material t2 where  t1.FMatID = t2.FID ) ").append("\n\n").append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("  (FTotalRow,FTotalRow2,FCompanyOrg,").append("\t\t FBoPAmount,FWIPA,\n").append("\t\t FFinishedA,FTotalInputA,\n").append("        FYTDFinishedA,FYTDInputA,\n").append("        FCurInputA) ").append(" SELECT 1,105, '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "',").append("  SUM(FBoPAmount),SUM(FWIPA),\n").append("  SUM(FFinishedA),SUM(FTotalInputA),\n").append("  SUM(FYTDFinishedA),SUM(FYTDInputA),\n").append("  SUM(FCurInputA)\n").append(" FROM " + sTmpTblName + "\n").append(" where FTotalRow2 = 0 \n").append(";\n\n");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        for (i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if ("FPeriodID".equalsIgnoreCase(field)) {
                whichTotal = ",FTotalPeriodRow = 1";
                fieldName = "FPeriodNumber";
            } else if ("FCostCenterID".equalsIgnoreCase(field)) {
                whichTotal = ",FTotalCostCenterRow = 1";
            } else if ("FCostObjID".equalsIgnoreCase(field)) {
                whichTotal = ",FTotalCostObjectRow = 1";
            } else if ("FCostItemID".equalsIgnoreCase(field)) {
                whichTotal = ",FTotalCostItemRow = 1";
            } else if ("FMatID".equalsIgnoreCase(field)) {
                whichTotal = ",FTotalMatRow = 1";
            }
            sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET ").append(fieldName).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "'\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(map.get("totalrow")).append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        sbSQL = new StringBuffer();
        sbSQL.append(" Update ").append(sTmpTblName).append("\n Set FCompanyOrg= '").append(info.getName()).append("'").append(" WHERE FTotalRow2<105;\n\n");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FUNITCOSTCommonQ=null,FUNITCOSTQ=null,FUNITCOSTAssistQ=null where FTotalRow2>0; \n\n");
        sbSQL.append(" UPDATE " + sTmpTblName).append("  AS m SET FPeriodName = ").append("(SELECT FNumber From T_NCM_Period period WHERE period.FID = m.FPeriodID);\n\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FCoQtyPrecision= \n").append(" (SELECT T4.FqtyPrecision \n").append(" FROM T_BD_CostObject T2 \n").append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID \n").append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n").append(" WHERE " + sTmpTblName + ".FCostObjID=T2.FID ); \n\n");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FMatQtyPrecision= \n").append(" (SELECT mmu.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID  ").append(" INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FBaseUnit=T4.fid\n").append(" WHERE " + sTmpTblName + ".FMatID=T3.FID ) \n").append(" WHERE FTotalRow2=0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" \n").append(" SET FMatQtyPrecision= \n").append(" (SELECT MAX(mmu.FqtyPrecision) \n").append("  FROM " + sTmpTblName).append(" t2\n").append("  INNER JOIN t_bd_Material T3 ON t2.FMatID=t3.FID \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID ").append("  INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FBaseUnit=T4.fid) \n").append(" WHERE FTotalRow2>0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FMatAssistQtyPrecision= \n").append(" (SELECT mmu.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID  ").append(" INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FAssistUnit=T4.fid\n").append(" WHERE " + sTmpTblName + ".FMatID=T3.FID ) \n").append(" WHERE FTotalRow2=0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" \n").append(" SET FMatAssistQtyPrecision= \n").append(" (SELECT MAX(mmu.FqtyPrecision) \n").append("  FROM " + sTmpTblName).append(" t2\n").append("  INNER JOIN t_bd_Material T3 ON t2.FMatID=t3.FID \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID ").append("  INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FAssistUnit=T4.fid) \n").append(" WHERE FTotalRow2>0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FMatCommonQtyPrecision= \n").append(" (SELECT max(mmu.FqtyPrecision) \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID  ").append(" INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID \n").append(" WHERE " + sTmpTblName + ".FMatID=T3.FID ) \n").append(" WHERE FTotalRow2=0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" \n").append(" SET FMatCommonQtyPrecision= \n").append(" (SELECT MAX(mmu.FqtyPrecision) \n").append("  FROM " + sTmpTblName).append(" t2\n").append("  INNER JOIN t_bd_Material T3 ON t2.FMatID=t3.FID \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID ").append("  INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID ) \n").append(" WHERE FTotalRow2>0 \n\n;");
        sbSQL.append("UPDATE ").append(sTmpTblName).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT  * FROM " + sTmpTblName + where + " Order by  FTotalRow " + orderByMode + orderBy.toString() + " ,FTotalRow2 " + orderByMode));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTmpTblName);
        return rs;
    }

    private void AppendCaseSQLClause(StringBuffer sb, String sNumerator, String sDenominator, String sAlias) {
        sb.append("CASE ").append(sDenominator).append(" WHEN 0 THEN 0 ").append(" ELSE TO_Decimal(").append(sNumerator).append(",21,8)").append("     /TO_Decimal(").append(sDenominator).append(",21,8) END ").append(sAlias);
    }

    private void AppendPredicate(StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            this.AppendPredicateString(sb, false, sFieldName, ">=", this.beginDate);
            this.AppendPredicateString(sb, false, sFieldName, "<=", this.endDate);
        } else {
            String sFilterValue = filter.getString(sFilterName);
            if (sFilterValue != null && !"".equals(sFilterValue)) {
                this.AppendPredicateString(sb, true, sFieldName, sOP, sFilterValue);
            }
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, Date sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    private String[] getPhysicalTableName(String companyID) throws BOSException {
        String[] physicalTblNames = new String[3];
        String[] logicalTblNames = new String[]{"T_NCM_DynCostCalResult_History", "T_NCM_DynCostCalMatDetailResult_History", "T_NCM_DynDataByCostObj_History"};
        try {
            for (int i = 0; i < logicalTblNames.length; ++i) {
                physicalTblNames[i] = NCMDynamicTableManager.getPhysicalTblNameForReportNor((Context)this.getContext(), (String)companyID, (String)logicalTblNames[i]);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return physicalTblNames;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostObjID varchar(44) ");
        createTable.append(",FCostObjNumber  varchar(80) not null default(' ')");
        createTable.append(",FCostObjName varchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FProductLot varchar(80) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FObjQ NUMERIC(21,8) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FCostItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostItemName varchar(255) ");
        createTable.append(",FMatID varchar(44) ");
        createTable.append(",FMatNumber varchar(80) not null default(' ') ");
        createTable.append(",FMatName varchar(255) ");
        createTable.append(",FMatModel nvarchar(255) ");
        createTable.append(",FMatShortName nvarchar(80) ");
        createTable.append(",FMatUnitCommonName varchar(80) ");
        createTable.append(",FMatUnitName varchar(255) ");
        createTable.append(",FMatUnitAssistName varchar(80) ");
        createTable.append(",FMatLot varchar(80) ");
        createTable.append(",FBoPCommonQty NUMERIC(21,8) ");
        createTable.append(",FBoPQty NUMERIC(21,8) ");
        createTable.append(",FBoPAssistQty NUMERIC(21,8) ");
        createTable.append(",FBoPAmount NUMERIC(17,4) ");
        createTable.append(",FCurInputCommonQ NUMERIC(21,8) ");
        createTable.append(",FCurInputQ NUMERIC(21,8) ");
        createTable.append(",FCurInputAssistQ NUMERIC(21,8) ");
        createTable.append(",FCurInputA NUMERIC(17,4) ");
        createTable.append(",FTotalInputCommonQ NUMERIC(21,8) ");
        createTable.append(",FTotalInputQ NUMERIC(21,8) ");
        createTable.append(",FTotalInputAssistQ NUMERIC(21,8) ");
        createTable.append(",FTotalInputA NUMERIC(17,4) ");
        createTable.append(",FFinishedCommonQ NUMERIC(21,8) ");
        createTable.append(",FFinishedQ NUMERIC(21,8) ");
        createTable.append(",FFinishedAssistQ NUMERIC(21,8) ");
        createTable.append(",FFinishedA NUMERIC(17,4) ");
        createTable.append(",FWIPCommonQ NUMERIC(21,8) ");
        createTable.append(",FWIPQ NUMERIC(21,8) ");
        createTable.append(",FWIPAssistQ NUMERIC(21,8) ");
        createTable.append(",FWIPA NUMERIC(17,4) ");
        createTable.append(",FUnitCostCommonQ NUMERIC(21,8) ");
        createTable.append(",FUnitCostQ NUMERIC(21,8) ");
        createTable.append(",FUnitCostAssistQ NUMERIC(21,8) ");
        createTable.append(",FUnitCostA NUMERIC(17,4) ");
        createTable.append(",FUnitCostRatio NUMERIC(17,4) ");
        createTable.append(",FYTDInputQ NUMERIC(21,8) ");
        createTable.append(",FYTDInputA NUMERIC(17,4) ");
        createTable.append(",FYTDFinishedQ NUMERIC(21,8) ");
        createTable.append(",FYTDFinishedA NUMERIC(17,4) ");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FISTotalRow int default(1) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(",FTotalPeriodRow int default(0) ");
        createTable.append(",FTotalCostCenterRow int default(0) ");
        createTable.append(",FTotalCostObjectRow int default(0) ");
        createTable.append(",FTotalCostItemRow int default(0) ");
        createTable.append(",FTotalMatRow int default(0) ");
        createTable.append(",FCoQtyPrecision int default(0) ");
        createTable.append(",FMatCommonQtyPrecision int default(0) ");
        createTable.append(",FMatQtyPrecision int default(0) ");
        createTable.append(",FMatAssistQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"52_DynFinishedProductCostDetailReport", (Locale)ctx.getLocale()) + this.periodFrom.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"53_DynFinishedProductCostDetailReport", (Locale)ctx.getLocale()) + this.periodTo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"63_DynMaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costcenterFrom"), (String)filter.getString("costcenterTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"64_DynMaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costobjectFrom"), (String)filter.getString("costobjectTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"66_DynMaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costitemFrom"), (String)filter.getString("costitemTo")));
        return titles;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        Context ctx = this.getContext();
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        String costItemType = "";
        if (rowData.get("FCOSTITEMTYPE") != null) {
            costItemType = (String)rowData.get("FCOSTITEMTYPE");
        }
        if (totalRow.compareTo(ZERO) == 0 && costItemType.equalsIgnoreCase("1")) {
            RptParams params = new RptParams();
            Object companyOrg = totalFilter.getObject("companyorg");
            if (companyOrg == null) {
                companyOrg = ((RptParams)totalFilter.getObject("totalfilter")).getObject("companyorg");
            }
            params.setObject("companyorg", companyOrg);
            ArrayList tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"27_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostObjID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"43_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostCenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"42_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"44_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            params.setObject("table", tableList);
            params.setObject("costobjectPerPage", (Object)new String("1"));
            String periodName = (String)rowData.get("FPERIODNAME");
            String sql = "select * where name = '" + periodName + "'";
            PeriodCollection periods = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(sql);
            this.periodFrom = periods.get(0);
            this.periodTo = periods.get(0);
            params.setObject("periodFrom", (Object)this.periodFrom);
            params.setObject("periodTo", (Object)this.periodTo);
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costitemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costitemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    private PeriodInfo getPeriodInf(Context ctx, String periodName, String companyId) throws ReportException {
        String periodId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid from T_NCM_Period t1").append(" inner join T_NCM_PeriodStatus t2 on t2.FPeriodID = t1.fid").append(" where t1.fname_l2 ='" + periodName + "' and  t2.FCompanyID = '" + companyId + "'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                periodId = rs.getString("t1.fid");
            }
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(periodId));
            return periodInfo;
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
        catch (EASBizException e) {
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList childList = header.getChilds();
        ArrayList childChildList = null;
        ReportHeader childHeader = null;
        ReportHeader childChildHeader = null;
        String fieldNameTemp = null;
        String childFieldName = null;
        for (int i2 = 0; i2 < childList.size(); ++i2) {
            int j;
            childHeader = (ReportHeader)childList.get(i2);
            fieldNameTemp = childHeader.getFieldName();
            if (fieldNameTemp.equals("FTotalInput")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_TotalInput", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FTotalInputA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FTotalInputQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Qty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FUnitCost")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"41_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FUnitCostA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitCostQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Qty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FUnitCostRatio")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_Ratio", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FFinished")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_Finished", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FFinishedA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FFinishedQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Qty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FWIP")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_WIP", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FWIPA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FWIPQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Qty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FCurInput")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"49_DynCostCalTotalReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FCurInputA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FCurInputQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Qty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FBoPBalance")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_BOPBalance", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FBoPAmount")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FBoPQty")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Qty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldNameTemp.equals("FProductModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"32_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMatNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_MatNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_BaseUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FProductShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"33_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FObjQ")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"39_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCompanyOrg")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"26_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMatName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_MatName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"29_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"37_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMatModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_Model", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMatUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostTotalReport_BaseUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FProductLot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"34_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynByClassCostCalReport_Period", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostObjNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"30_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"36_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FMatlot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"34_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostObjName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"31_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldNameTemp.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"28_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldNameTemp.equals("FMatShortName")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"DynMaterialCostStatReport_MatShortName", (Locale)ctx.getLocale()));
        }
        ArrayList tblData = (ArrayList)filter.getObject("table");
        ArrayList childs = header.getChilds();
        HashMap<String, ReportHeader> headerMap = new HashMap<String, ReportHeader>();
        for (int i3 = 0; i3 < childs.size(); ++i3) {
            ReportHeader child = (ReportHeader)childs.get(i3);
            String fieldName = child.getFieldName().toLowerCase();
            headerMap.put(fieldName.toLowerCase(), child);
        }
        ArrayList temp = new ArrayList(childs.size());
        temp.addAll(childs);
        childs.clear();
        ArrayList<String> sortedCols = new ArrayList<String>();
        sortedCols.add("FCompanyOrg");
        int qtyCounter = 0;
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FPeriodNumber");
                ++qtyCounter;
            }
            if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostObjNumber");
                sortedCols.add("FCostObjName");
                sortedCols.add("FProductModel");
                sortedCols.add("FProductShortName");
                sortedCols.add("FUnitName");
                sortedCols.add("FProductLot");
                ++qtyCounter;
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostCenterNumber");
                sortedCols.add("FCostCenterName");
                ++qtyCounter;
            }
            if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostItemNumber");
                sortedCols.add("FCostItemName");
            }
            if ("FMatID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FMatNumber");
                sortedCols.add("FMatName");
                sortedCols.add("FMatModel");
                sortedCols.add("FMatShortName");
                sortedCols.add("FMatUnitCommonName");
                sortedCols.add("FMatUnitName");
                sortedCols.add("FMatUnitAssistName");
                sortedCols.add("FMatLot");
            }
            if (qtyCounter != 3) continue;
            sortedCols.add("FObjQ");
            qtyCounter = 0;
        }
        for (i = 0; i < sortedCols.size(); ++i) {
            String field = (String)sortedCols.get(i);
            ReportHeader child = (ReportHeader)headerMap.get(field.toLowerCase());
            if (child == null) continue;
            childs.add(child);
            temp.remove(child);
        }
        childs.addAll(temp);
        HashSet<String> removes = new HashSet<String>();
        if (filter.getString("showQty") != null && filter.getString("showQty").equalsIgnoreCase("false")) {
            removes.add("FBoPCommonQty".toLowerCase());
            removes.add("FCurInputCommonQ".toLowerCase());
            removes.add("FTotalInputCommonQ".toLowerCase());
            removes.add("FFinishedCommonQ".toLowerCase());
            removes.add("FWIPCommonQ".toLowerCase());
            removes.add("FUnitCostCommonQ".toLowerCase());
        }
        if (filter.getString("showAssistQty") != null && filter.getString("showAssistQty").equalsIgnoreCase("false")) {
            removes.add("FBoPAssistQty".toLowerCase());
            removes.add("FCurInputAssistQ".toLowerCase());
            removes.add("FTotalInputAssistQ".toLowerCase());
            removes.add("FFinishedAssistQ".toLowerCase());
            removes.add("FWIPAssistQ".toLowerCase());
            removes.add("FUnitCostAssistQ".toLowerCase());
        }
        if (removes.size() > 0) {
            this.removeChildHeaders(header, removes);
        }
        return header;
    }

    private void removeChildHeaders(ReportHeader header, Set removes) {
        ArrayList childs = header.getChilds();
        if (childs != null && childs.size() > 0) {
            for (int i = childs.size() - 1; i >= 0; --i) {
                ReportHeader child = (ReportHeader)childs.get(i);
                String fieldName = child.getFieldName().toLowerCase();
                if (removes.contains(fieldName)) {
                    childs.remove(child);
                    continue;
                }
                this.removeChildHeaders(child, removes);
            }
        }
    }
}

