/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.cal.report.app.OtherCostAllocDetailReport;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynOtherCostAllocDetailReport
extends OtherCostAllocDetailReport {
    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String tempTableName;
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.OtherCostAllocTotalReport");
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        if (filter == null) {
            return null;
        }
        this.dealFilter(filter, logger, ctx);
        if (filter.getObject("companyorg") == null || !(filter.getObject("companyorg") instanceof CompanyOrgUnitInfo)) {
            return null;
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName();
        String tableName = null;
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReportNor((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynOtherAllocResult");
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append(" create table t2 ( ");
        createTable.append(" FCompanyName varchar(255) ");
        createTable.append(" , FPeriodId varchar(44) ");
        createTable.append(" , FPeriodNumber varchar(80) ");
        createTable.append(" , FSourceBillId varchar(44) ");
        createTable.append(" , FSourceBillNumber varchar(80) ");
        createTable.append(" , FExpenseID varchar(44) ");
        createTable.append(" , FExpenseNumber varchar(80) ");
        createTable.append(" , FExpenseName varchar(255) ");
        createTable.append(" , FCostCenterID varchar(44) ");
        createTable.append(" , FCostCenterNumber varchar(80) ");
        createTable.append(" , FCostCenterName varchar(255) ");
        createTable.append(" , FCostObjectID varchar(44) ");
        createTable.append(" , FCostObjectNumber varchar(80) ");
        createTable.append(" , FCostObjectName varchar(255) ");
        createTable.append(" , FProductModel nvarchar(255) ");
        createTable.append(" , FProductShortName nvarchar(255) ");
        createTable.append(" , FCostItemID varchar(80) ");
        createTable.append(" , FCostItemNumber varchar(80) ");
        createTable.append(" , FCostItemName varchar(255) ");
        createTable.append(" , FQty decimal(19,4) ");
        createTable.append(" , FQtyPrecision int default(0) ");
        createTable.append(" , FPrice decimal(19,4) ");
        createTable.append(" , FPricePrecision int default(2) ");
        createTable.append(" , FAmount decimal(19,4) ");
        createTable.append(" , FDescription varchar(255) ");
        createTable.append(" , FAllocStdType varchar(255) ");
        createTable.append(" , FAllocStdData decimal(19,4) ");
        createTable.append(" , FTotalRow decimal(28,16) not null default(0) ");
        createTable.append(" , FTotalRow2 decimal(28,16) not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalExpenseRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + " ( FCompanyName , " + " FPeriodId , FPeriodNumber, " + " FSourceBillId , FSourceBillNumber, FDescription , " + " FExpenseID, FExpenseNumber, FExpenseName, " + " FCostCenterID, FCostCenterNumber, FCostCenterName, " + " FCostObjectID, FCostObjectNumber, FCostObjectName, " + " FProductModel, FProductShortName, " + " FCostItemID, FCostItemNumber, FCostItemName, " + " FQty , FPrice , FAmount, " + " FAllocStdType, FAllocStdData ) \n");
        sb.append(" SELECT '" + companyName + "' , " + " t2.FID, to_char(t2.fnumber) , " + " v.FID, v.FNumber, v.FDescription , " + " w.FID, w.FNumber, w.FName_" + locale + ", " + " t3.FID, t3.FNumber, t3.FName_" + locale + ", " + " t4.FID, t4.FNumber, t4.FName_" + locale + ", " + " t8.fmodel, t8.FShortName, " + " t5.FID, t5.FNumber, t5.FName_" + locale + ", " + " t1.FQty, case when ( t1.FQty=0 or t1.FQty is null ) then 0.00 else to_number(t1.FAmount)/to_number(t1.FQty) end ,t1.FAmount , " + " t6.FName_l2 , " + " t1.FAllocStdData \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join T_NCM_Period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" left outer join T_NCM_AllocStd t6 on t1.FAllocStdID = t6.FID \n ");
        sb.append(" inner join t_NCM_OtherFeeBill v on t1.FSourceBillID = v.FID \n");
        sb.append(" inner join T_NCM_Expense w on v.FExpenseID = w.FID \n");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sb.append(" left outer join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sb.append(" left outer join t_bd_material t8 on t4.FStdProductIDID = t8.FID  \n");
        sb.append(" left outer join t_Ncm_Costitem t5 on t1.FCostItemID = t5.FID  \n");
        sb.append(" where t1.FCompanyID = ? \n");
        this.buildFilter(filter, sb);
        this.buildSorter(sb);
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyID});
        sb = new StringBuffer(200);
        sb.append(" update " + tempTableName + " set FQtyPrecision = ( select isnull(unit.FQtyPrecision,0) " + " from T_NCM_Expense exp left outer join T_BD_MeasureUnit unit on exp.funitid = unit.fid " + " where " + tempTableName + ".FExpenseID = exp.fid  ) , " + " FPricePrecision = ( select isnull(exp.FPricePrecision,0) from T_NCM_Expense exp " + " where " + tempTableName + ".FExpenseID = exp.fid )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        Connection cn = null;
        Statement st = null;
        IRowSet rs = null;
        String[] fields = new String[]{"  FExpenseNumber ,FExpenseName,FPeriodNumber, FCostCenterNumber  ", "  FExpenseNumber,FExpenseName ,FPeriodNumber "};
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + "(FTotalRow," + fields[0] + ", FQty, FPrice, FAmount,FTotalExpenseRow,FTotalCostCenterRow) \n");
            sb.append(" SELECT 103, " + fields[0] + " , SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount), 0 as FTotalExpenseRow,1 as FTotalCostCenterRow \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append(" group by " + fields[0]);
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + "(FTotalRow," + fields[1] + ", FQty, FPrice, FAmount,FTotalExpenseRow,FTotalCostCenterRow) \n");
            sb.append(" SELECT 104, " + fields[1] + " , SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount), 1 as FTotalExpenseRow,0 as FTotalCostCenterRow \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append(" group by " + fields[1]);
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + " (FCostCenterName, FTotalRow2, FTotalRow, FQty, FPrice, FAmount) \n");
            sb.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "',1,105, SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount) \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FCostCenterName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "', FExpenseNumber = FExpenseNumber , ").append(" FCostCenterNumber = FCostCenterNumber ").append(" where FTotalRow = 103 ").append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FExpenseNumber = FExpenseNumber , ").append(" FExpenseName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' ").append(" where FTotalRow = 104 ").append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FCompanyName = '" + companyName + "'");
            st.addBatch(sb.toString());
            st.executeBatch();
            rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT * FROM " + tempTableName + " Order by  FTotalRow2 , FPeriodNumber, FExpenseNumber ,FTotalExpenseRow,FCostCenterNumber ,FTotalCostCenterRow,  FTotalRow "));
            if (rs.size() == 1) {
                rs = null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            SQLUtils.cleanup((Statement)st, (Connection)cn);
        }
        return rs;
    }

    private void dealFilter(RptParams filter, Logger logger, Context ctx) throws BOSException {
        if (filter.getString("prmtCompanyOrg") != null) {
            String comNumber = filter.getString("prmtCompanyOrg");
            CompanyOrgUnitInfo company = null;
            try {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(" select id,name,number where number = '" + comNumber + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            filter.setObject("companyorg", (Object)company);
            filter.remove("prmtCompanyOrg");
        }
        if (filter.getObject("prmtNorStartPeriod") != null) {
            filter.setObject("norStartPeriod", filter.getObject("prmtNorStartPeriod"));
            filter.remove("prmtNorStartPeriod");
        }
        if (filter.getObject("prmtNorEndPeriod") != null) {
            filter.setObject("norEndPeriod", filter.getObject("prmtNorEndPeriod"));
            filter.remove("prmtNorEndPeriod");
        }
        if (filter.getObject("prmtExpenseFrom") != null) {
            filter.setObject("expenseFrom", filter.getObject("prmtExpenseFrom"));
            filter.remove("prmtExpenseFrom");
        }
        if (filter.getObject("prmtExpenseTo") != null) {
            filter.setObject("expenseTo", filter.getObject("prmtExpenseTo"));
            filter.remove("prmtExpenseTo");
        }
        if (filter.getObject("prmtCostCenterFrom") != null) {
            filter.setObject("costcenterFrom", filter.getObject("prmtCostCenterFrom"));
            filter.remove("prmtCostCenterFrom");
        }
        if (filter.getObject("prmtCostCenterTo") != null) {
            filter.setObject("costcenterTo", filter.getObject("prmtCostCenterTo"));
            filter.remove("prmtCostCenterTo");
        }
        if (filter.getObject("prmtCostObjectFrom") != null) {
            filter.setObject("costobjectFrom", filter.getObject("prmtCostObjectFrom"));
            filter.remove("prmtCostObjectFrom");
        }
        if (filter.getObject("prmtCostObjectTo") != null) {
            filter.setObject("costobjectTo", filter.getObject("prmtCostObjectTo"));
            filter.remove("prmtCostObjectTo");
        }
        if (filter.getObject("prmtCostItemFrom") != null) {
            filter.setObject("costitemFrom", filter.getObject("prmtCostItemFrom"));
            filter.remove("prmtCostItemFrom");
        }
        if (filter.getObject("prmtCostItemTo") != null) {
            filter.setObject("costitemTo", filter.getObject("prmtCostItemTo"));
            filter.remove("prmtCostItemTo");
        }
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        sb.append(" and v.fbillStatus = 4");
        if (filter.getObject("norStartPeriod") != null) {
            PeriodInfo periodStartInfo = (PeriodInfo)filter.getObject("norStartPeriod");
            sb.append(" and t2.FBeginDate >= TO_DATE('");
            sb.append(Constants.FORMAT_TIME.format(periodStartInfo.getBeginDate()));
            sb.append("') \n");
        }
        if (filter.getObject("norEndPeriod") != null) {
            PeriodInfo periodEndInfo = (PeriodInfo)filter.getObject("norEndPeriod");
            sb.append(" and t2.FEndDate <= TO_DATE('");
            sb.append(Constants.FORMAT_TIME.format(periodEndInfo.getEndDate()));
            sb.append("') \n");
        }
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("expenseFrom") != null && !"".equals(filter.getString("expenseFrom").trim())) {
            sb.append(" and w.FNumber >='").append(filter.getString("expenseFrom")).append("'");
        }
        if (filter.getString("expenseTo") != null && !"".equals(filter.getString("expenseTo"))) {
            sb.append(" and w.FNumber <='").append(filter.getString("expenseTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t5.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t5.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        String periodFrom = ((PeriodInfo)filter.getObject("norStartPeriod")).getName();
        String periodTo = ((PeriodInfo)filter.getObject("norEndPeriod")).getName();
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"55_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + periodFrom + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"56_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + periodTo + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"17_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costcenterFrom"), (String)filter.getString("costcenterTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"18_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("expenseFrom"), (String)filter.getString("expenseTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"60_DynMAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costobjectFrom"), (String)filter.getString("costobjectTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"61_DynMAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costitemFrom"), (String)filter.getString("costitemTo")));
        return titles;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        BigDecimal ZERO = new BigDecimal(BigInteger.ZERO);
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow.compareTo(ZERO) == 0) {
            RptParams params = new RptParams();
            Object companyOrg = totalFilter.getObject("companyorg");
            if (companyOrg == null) {
                companyOrg = ContextUtil.getCurrentFIUnit((Context)this.getContext());
            }
            params.setObject("companyorg", companyOrg);
            String periodNumer = rowData.get("FPERIODNUMBER").toString();
            HashSet<String> numbers = new HashSet<String>();
            numbers.add(periodNumer);
            Map periods = CalPeriodUtils.getPeriods(this.getContext(), ((CompanyOrgUnitInfo)companyOrg).getId().toString(), numbers);
            if (periods.containsKey(periodNumer)) {
                params.setObject("norStartPeriod", periods.get(periodNumer));
                params.setObject("norEndPeriod", periods.get(periodNumer));
            }
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("expenseFrom", (String)rowData.get("FExpenseNumber".toUpperCase()));
            params.setString("expenseTo", (String)rowData.get("FExpenseNumber".toUpperCase()));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costitemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costitemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }
}

