/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TypedParamAdapterBase {
    private static Logger logger = Logger.getLogger((String)TypedParamAdapterBase.class.getName());
    public static final char CLF = '\n';
    protected static final String paramKey_ctx = "ctx";
    protected static final String paramKey_CU = "CU";
    protected static final String paramKey_userId = "userId";
    protected static final String paramKey_locale = "locale";
    protected static final String paramKey_companyId = "companyId";
    protected static final String paramKey_companyName = "companyName";
    protected static final String paramKey_currencyPrecision = "currencyPrecision";
    protected static final String paramKey_periodId = "periodId";
    protected static final String paramKey_periodDispNumber = "periodDispNumber";
    protected static final String paramKey_periodYear = "periodYear";
    protected static final String paramKey_periodNumber = "periodNumber";
    public Map _param = null;
    private Connection _conn = null;

    public TypedParamAdapterBase(Map param) throws BOSException, EASBizException {
        Assert.that((boolean)param.containsKey(paramKey_companyId));
        Assert.that((!StringUtils.isEmpty((String)((String)param.get(paramKey_companyId))) ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey(paramKey_periodId));
        Assert.that((!StringUtils.isEmpty((String)((String)param.get(paramKey_periodId))) ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey(paramKey_userId));
        Assert.that((!StringUtils.isEmpty((String)((String)param.get(paramKey_userId))) ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey(paramKey_ctx));
        Assert.that(((Context)param.get(paramKey_ctx) != null ? 1 : 0) != 0);
        this._param = param;
        this.InitAdditionalParam();
        if (this._conn == null) {
            try {
                this._conn = EJBFactory.getConnection((Context)this.getCtx());
            }
            catch (SQLException e) {
                throw new SQLDataException("getConnection exception", (Throwable)e);
            }
        }
        if (this._conn != null) {
            this.getCtx().put((Object)"ConnectionKey", (Object)this._conn);
        }
    }

    public void ReleaseResource() throws EASBizException, BOSException {
        if (this._conn != null) {
            SQLUtils.cleanup((Connection)this._conn);
        }
        if (this.getCtx().get((Object)"ConnectionKey") != null) {
            this.getCtx().remove((Object)"ConnectionKey");
        }
    }

    protected void InitAdditionalParam() throws BOSException {
        this.initCompanyInfo();
        this.initPeriodInfo();
        if (!this._param.containsKey(paramKey_CU) || StringUtils.isEmpty((String)((String)this._param.get(paramKey_CU)))) {
            this._param.put(paramKey_CU, ContextUtil.getCurrentCtrlUnit((Context)this.getCtx()).getId().toString());
        }
        if (!this._param.containsKey(paramKey_locale) || (Locale)this._param.get(paramKey_locale) == null) {
            this._param.put(paramKey_locale, this.getCtx().getLocale());
        }
        if (!this._param.containsKey("tempTablePool") || (TempTablePool)this._param.get("tempTablePool") == null) {
            this._param.put("tempTablePool", TempTablePool.getInstance((Context)this.getCtx()));
        }
    }

    public Map getParam() {
        return this._param;
    }

    public Context getCtx() {
        return (Context)this._param.get(paramKey_ctx);
    }

    public String getCU() {
        return (String)this._param.get(paramKey_CU);
    }

    public String getCompanyId() {
        return (String)this._param.get(paramKey_companyId);
    }

    public String getCompanyName() {
        return (String)this._param.get(paramKey_companyName);
    }

    public int getCurrencyPrecision() {
        return Integer.valueOf((String)this._param.get(paramKey_currencyPrecision));
    }

    public String getPeriodId() {
        return (String)this._param.get(paramKey_periodId);
    }

    public String getPeriodNumber() {
        return (String)this._param.get(paramKey_periodNumber);
    }

    public String getPeriodDispNumber() {
        return (String)this._param.get(paramKey_periodDispNumber);
    }

    public String getPeriodYear() {
        return (String)this._param.get(paramKey_periodYear);
    }

    public String getUserId() {
        return (String)this._param.get(paramKey_userId);
    }

    public Locale getLocale() {
        return (Locale)this._param.get(paramKey_locale);
    }

    public TempTablePool getTempTablePool() {
        return (TempTablePool)this._param.get("tempTablePool");
    }

    private void initPeriodInfo() throws BOSException {
        if (StringUtils.isEmpty((String)this.getPeriodId())) {
            return;
        }
        if (this._param.containsKey(paramKey_periodDispNumber) && !StringUtils.isEmpty((String)((String)this._param.get(paramKey_periodDispNumber))) && this._param.containsKey(paramKey_periodYear) && !StringUtils.isEmpty((String)((String)this._param.get(paramKey_periodYear))) && this._param.containsKey(paramKey_periodNumber) && !StringUtils.isEmpty((String)((String)this._param.get(paramKey_periodNumber)))) {
            return;
        }
        IPeriod period = null;
        PeriodInfo periodinfo = null;
        try {
            period = PeriodFactory.getLocalInstance((Context)this.getCtx());
            ObjectStringPK periodpk = new ObjectStringPK(this.getPeriodId());
            periodinfo = period.getPeriodInfo((IObjectPK)periodpk);
            this._param.put(paramKey_periodDispNumber, String.valueOf(periodinfo.getNumber()));
            this._param.put(paramKey_periodYear, String.valueOf(periodinfo.getPeriodYear()));
            this._param.put(paramKey_periodNumber, String.valueOf(periodinfo.getPeriodNumber()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initCompanyInfo() throws BOSException {
        if (StringUtils.isEmpty((String)this.getCompanyId())) {
            return;
        }
        if (this._param.containsKey(paramKey_companyName) && !StringUtils.isEmpty((String)((String)this._param.get(paramKey_companyName)))) {
            return;
        }
        ICompanyOrgUnit company = null;
        CompanyOrgUnitInfo companyInfo = null;
        try {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getCtx());
            ObjectStringPK companyPk = new ObjectStringPK(this.getCompanyId());
            companyInfo = company.getCompanyOrgUnitInfo((IObjectPK)companyPk);
            this._param.put(paramKey_companyName, companyInfo.getName());
            this._param.put(paramKey_currencyPrecision, String.valueOf(companyInfo.getBaseCurrency().getPrecision()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public Connection get_conn() {
        return this._conn;
    }
}

