/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.OCActivity2OrderData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.IFeeInfo;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.OCC2ActivityFeeInfoAdapter;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.AllocTable;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.OCActivity2OrderAllocTable;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.bill.CostDriverSetByActCollection;
import com.kingdee.eas.ncm.order.fact.bill.CostDriverSetByActFactory;
import com.kingdee.eas.ncm.order.fact.bill.ICostDriverSetByAct;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OCActivity2OrderAllocator
extends BaseAllocator {
    private static Logger logger = Logger.getLogger((String)OCActivity2OrderAllocator.class.getName());
    private CostDriverSetByActCollection costDriverSettingCache = null;
    private OCAllocExceptionLog _logger;

    public OCActivity2OrderAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (OCAllocExceptionLog)param.get("logger");
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(new OCActivity2OrderAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public FeeData getFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData(new OCActivity2OrderData(this._param));
        }
        return super.getFeeData();
    }

    @Override
    protected void insertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        String activityAllocTable = null;
        String billEntryIdTable = (String)this._param.get("toAllocBillEntryTable");
        try {
            activityAllocTable = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCCC2ActivityAlloc");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        StringBuffer sb = new StringBuffer(500);
        String sqlInsert = null;
        sb.append("INSERT INTO {0}(FID, FCompanyID, FCalculatePeriodID, FCC2ActivityID, ").append('\n').append("FCostCenterID, FExpenseID, FDepartmentID, FCostItemID, ").append('\n').append("FActivityID, FOrderID, ").append('\n').append("FOrderProdID, FOrderProdBatchNo, FOrderNumber, FStorageOrgUnitID,").append('\n').append("FOrderQty, FPrice, FAmount, ").append('\n').append("FCreatorID, FCreateTime, FAdjustUserID, FAdjustTime, FIsDirect)").append('\n').append(" SELECT newbosid(''474CFD96'') AS FID, ").append('\n').append("a.fcompanyid as FCompanyID, ").append('\n').append("a.fcalculateperiodid as FCalculatePeriodID, ").append('\n').append("a.fid as FCC2ActivityID,").append('\n').append("a.fcostcenterid as FCostCenterID, ").append('\n').append("a.FExpenseID as FExpenseID, ").append('\n').append("a.FDepartmentID as FDepartmentID, ").append('\n').append("a.FCostItemID as FCostItemID, ").append('\n').append("a.factivityid  as FActivityID,").append('\n').append("a.forderid  as FOrderID,").append('\n').append("b.fmaterialid  as FOrderProdID,").append('\n').append("b.flot  as FOrderProdBatchNo,").append('\n').append("b.fnumber  as FOrderNumber,").append('\n').append("b.fstorageorgunitid  as FStorageOrgUnitID,").append('\n').append("ISNULL(a.FACTIVITQTY, 0) as FOrderQty,").append('\n').append("ISNULL(a.FPrice, 0) as FPrice,").append('\n').append("ISNULL(a.FAmount, 0) as FAmount, ").append('\n').append("''{1}'' as FCreatorID, GetDate() as FCreateTime, ").append('\n').append("''{2}'' as FAdjustUserID, GetDate() as FAdjustTime, ").append('\n').append("''1'' as FIsDirect").append('\n').append(" FROM {3} a ").append('\n').append(" inner join  {4} c on a.FSourceBillEntryID = c.FSourceBillEntryID ").append('\n').append(" LEFT OUTER JOIN T_MM_ManufactureOrder b on a.forderid = b.fid ").append('\n').append(" where a.fcompanyid = ''{5}'' and a.fcalculateperiodid = ''{6}''").append('\n').append(" and a.forderid is not null ").append('\n');
        sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), userId, userId, activityAllocTable, billEntryIdTable, companyId, periodId);
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            log.error((Object)"insertDirectData", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }

    @Override
    protected String getSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer(500);
        OCC2ActivityFeeInfoAdapter _currFee = (OCC2ActivityFeeInfoAdapter)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(_currFee.GetQtyPrecision());
        String strQty = fm.format(_currFee.GetQty2());
        fm.setMaximumFractionDigits(_currFee.GetAmountPrecision());
        String strAmount = fm.format(_currFee.GetAmount2());
        fm.setMaximumFractionDigits(_currFee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (_currFee.GetQty2().compareTo(BigDecimal.valueOf(0L)) != 0) {
            strPrice = fm.format(_currFee.GetAmount2().divide(_currFee.GetQty2(), _currFee.GetPricePrecision(), 4));
        }
        sb.append("INSERT INTO {0}(FID, FCompanyID, FCalculatePeriodID, ").append('\n').append("FCC2ActivityID,").append('\n').append("FCostCenterID,").append('\n').append("FExpenseID,").append('\n').append("FDepartmentID,").append('\n').append("FCostItemID,").append('\n').append("FCostDriverID, FActivityID, FOrderID, ").append('\n').append("FOrderProdID, FOrderProdBatchNo, FOrderNumber, FStorageOrgUnitID, ").append('\n').append("FOrderQty, FPrice, FAmount, FCostDriverAmount,").append('\n').append("FCreatorID, FCreateTime, FAdjustUserID, FAdjustTime, ").append('\n').append("FIsDirect) ").append('\n').append(" SELECT newbosid(''474CFD96'') AS FID, ").append('\n').append("''{1}'' As FCompanyID, ").append('\n').append("''{2}'' As FCalculatePeriodID, ").append('\n').append("''{3}'' As FCC2ActivityID,").append('\n').append("''{4}'' As FCostCenterID,").append('\n').append("''{5}'' As FExpenseID,").append('\n').append("''{6}'' As FDepartmentID,").append('\n').append("''{7}'' As FCostItemID,").append('\n').append("''{8}'' As FCostDriverID,").append('\n').append("R.factivityid As FActivityID,").append('\n').append("R.forderid As FOrderID, ").append("b.fmaterialid  as FOrderProdID,").append('\n').append("b.flot  as FOrderProdBatchNo,").append('\n').append("b.fnumber  as FOrderNumber,").append('\n').append("b.fstorageorgunitid  as FStorageOrgUnitID,").append('\n').append("ROUND({9} * D.FRatio,{10}) As FOrderQty,").append(" {11} As FPrice, ").append("ROUND({12} * D.FRatio,{13}) As FAmount,").append('\n').append(" D.FQty as FCostDriverAmount,").append('\n').append("''{14}'' As FCreatorID, GetDate() As FCreateTime, ''{15}'' as FAdjustUserID, ").append("GetDate() as FAdjustTime, ''0'' As FIsDirect").append('\n').append("FROM {16} R ").append('\n').append("INNER JOIN {17} D ON D.FID=R.FID ").append('\n').append(" LEFT OUTER JOIN T_MM_ManufactureOrder b on R.forderid = b.fid ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costCenterId = _currFee.GetCostCenterId2();
        String expenseId = _currFee.GetExpenseId2();
        String departmentId = _currFee.GetDepartmentId2();
        if (departmentId == null) {
            departmentId = "";
        }
        String costItemId = _currFee.GetCostItemId2();
        String cc2ActivityID = _currFee.GetCC2ActivityID();
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, cc2ActivityID, costCenterId, expenseId, departmentId, costItemId, this.getCostDriver().getId().toString(), strQty, String.valueOf(_currFee.GetQtyPrecision()), strPrice, strAmount, String.valueOf(_currFee.GetAmountPrecision()), userId, userId, this.getTblAllocObjectRange(), this.getTblAllocData());
        return sqlInsert;
    }

    @Override
    protected String getSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        OCC2ActivityFeeInfoAdapter _currFee = (OCC2ActivityFeeInfoAdapter)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(_currFee.GetQtyPrecision());
        String strQty = fm.format(_currFee.GetQty2());
        fm.setMaximumFractionDigits(_currFee.GetAmountPrecision());
        String strAmount = fm.format(_currFee.GetAmount2());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FOrderQty =(FOrderQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FOrderQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FCC2ActivityID = ''{3}'' )").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {4} ").append('\n').append("\tWHERE FCC2ActivityID = ''{5}''").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), _currFee.GetCC2ActivityID(), this.getTblResult(), _currFee.GetCC2ActivityID());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FCC2ActivityID=''{3}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {4} ").append('\n').append("\tWHERE FCC2ActivityID = ''{5}'' ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), _currFee.GetCC2ActivityID(), this.getTblResult(), _currFee.GetCC2ActivityID());
        sb.delete(0, sb.length());
        String sqlUpdatePrice = MessageFormat.format("UPDATE {0} SET FPrice=ROUND(to_decimal(FAmount,24,12)/to_decimal(FOrderQty,24,12),{1}) WHERE FCC2ActivityID = ''{2}'' AND FOrderQty<>0 ;", this.getTblResult(), String.valueOf(_currFee.GetPricePrecision()), _currFee.GetCC2ActivityID());
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FCC2ActivityID=''{1}'' AND FOrderQty=0 ;", this.getTblResult(), _currFee.GetCC2ActivityID());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + sqlUpdatePrice + '\n' + sqlUpdatePrice_Zero;
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    protected boolean IsOnlyNotZero_AllcoStdData() {
        return false;
    }

    @Override
    public Map processResult() throws AllocateException {
        return null;
    }

    @Override
    public void preProcess() throws AllocateException {
        AllocTable tables = this.getAllocTable();
        FeeData feeData = this.getFeeData();
        String allocResultTable = tables.GetResultTable();
        feeData.clearPreAllocResult(allocResultTable, null);
        this.fillObjectRange();
        tables.CreateTempTableIndexs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        if (StringUtils.isEmpty((String)tblObjRange)) {
            return;
        }
        Connection conn = null;
        try {
            DbUtil.execute((Context)ctx, (String)("truncate table " + tblObjRange));
            StringBuffer kSql = new StringBuffer(200);
            kSql.append("INSERT INTO ").append(tblObjRange).append(" (FID, FCOSTCENTERID, FActivityID, FOrderID, FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, fcostcenterid, factivityid, fmanufacturerorderid, 1 ").append('\n').append("FROM (").append('\n').append(" select distinct b.fcostcenterid, b.factivityid, a.fmanufacturerorderid ").append('\n').append(" from T_NCM_OrderReportBill a inner join  ").append('\n').append(" (select hour.FParentid as FParentid, hour.FCostCenterID as FCostCenterID, hour.FActivityID as FActivityID from t_Ncm_OrderreportbillHourentry hour ").append('\n').append("  UNION select qty.FParentid as FParentid, qty.FCostCenterID as FCostCenterID, qty.FActivityID as FActivityID from t_ncm_orderReportBillQtyEntry qty ) b on a.fid = b.fparentid  ").append(" inner join t_mm_manufactureorder c on a.fmanufacturerorderid = c.fid ").append('\n').append(" where a.fbillstatus = 4 and a.FCOMPANYORG = ? ").append('\n').append(" and c.fbasestatus in (5, 7, 8) and c.factureBeginDate <= ").append('\n').append(" (select fenddate from T_BD_Period  where fid = '").append(periodId).append("')").append('\n').append(") As c ");
            DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId});
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    @Override
    public void allocDirect() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        this.insertDirectData(ctx, companyId, periodId, userId);
        this.updateDefaultCostItem(ctx, companyId, periodId);
        this.removeNoCostItem(ctx, companyId, periodId);
        this.removeInvalidCostObject(ctx, companyId, periodId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        Context ctx;
        block13: {
            boolean cancelAlloc;
            block12: {
                boolean allocStdChanged;
                boolean isDirectMatQtyStrategy;
                block11: {
                    CostDriverInfo std;
                    block10: {
                        block9: {
                            block8: {
                                cancelAlloc = false;
                                ctx = (Context)this._param.get("ctx");
                                try {
                                    log.info((Object)"--OCActivity2OrderAllocator, begin allocIndirect");
                                    cancelAlloc = this.crossCostObjectSuiteRange(currFee);
                                    if (!cancelAlloc) break block8;
                                }
                                catch (Throwable throwable) {
                                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                    log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
                                    this.commitAllocResult((position & 2) > 0);
                                    throw throwable;
                                }
                                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
                                this.commitAllocResult((position & 2) > 0);
                                return;
                            }
                            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"15_BaseAllocator", (Locale)ctx.getLocale()));
                            cancelAlloc = this.filterAllocTempDataRange(currFee);
                            if (!cancelAlloc) break block9;
                            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                            log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
                            this.commitAllocResult((position & 2) > 0);
                            return;
                        }
                        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"16_BaseAllocator", (Locale)ctx.getLocale()));
                        std = this.getAllocStdSetting(currFee);
                        if (std != null) break block10;
                        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                        log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
                        this.commitAllocResult((position & 2) > 0);
                        return;
                    }
                    isDirectMatQtyStrategy = !StringUtils.isEmpty((String)std.getFormulaForParse()) && std.getFormulaForParse().indexOf("wSCGfwEgEADgABg2wKgSMp3UGuM=") != -1 && this._param.containsKey("currFeeMaterialId");
                    boolean bl = allocStdChanged = this._costDriver == null || std == null || !this._costDriver.getId().toString().equals(std.getId().toString());
                    if (allocStdChanged) {
                        this.setCostDriver(std);
                    }
                    if (!allocStdChanged && !this.bRangeChanged) break block11;
                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"17_BaseAllocator", (Locale)ctx.getLocale()));
                    cancelAlloc = this.initAllocDataTable();
                    if (!cancelAlloc) break block11;
                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                    log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
                    this.commitAllocResult((position & 2) > 0);
                    return;
                }
                if (!allocStdChanged && !this.bRangeChanged && !this.bMaterialChanged && !isDirectMatQtyStrategy) break block12;
                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"18_BaseAllocator", (Locale)ctx.getLocale()));
                cancelAlloc = this.updateAllocDataTable();
                if (!cancelAlloc) break block12;
                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
                this.commitAllocResult((position & 2) > 0);
                return;
            }
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"19_BaseAllocator", (Locale)ctx.getLocale()));
            this.checkNoAllocStdData(currFee);
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"20_BaseAllocator", (Locale)ctx.getLocale()));
            cancelAlloc = this.saveAllocResult(currFee);
            if (!cancelAlloc) break block13;
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
            log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
            this.commitAllocResult((position & 2) > 0);
            return;
        }
        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
        log.info((Object)"--OCActivity2OrderAllocator, end allocIndirect");
        this.commitAllocResult((position & 2) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void checkNoAllocStdData(IFeeInfo currFee) throws AllocateException {
        IRowSet rs;
        block7: {
            Context ctx = (Context)this._param.get("ctx");
            OCC2ActivityFeeInfoAdapter _currFee = (OCC2ActivityFeeInfoAdapter)currFee;
            StringBuffer sb = new StringBuffer(100);
            sb.append("Select top 1 FQty ").append("FROM ").append(this.getTblAllocData()).append(" ").append("WHERE FQty <> 0 ");
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next()) break block7;
                String[] hint = this._ausCtx.GetNoAllocStdDataHint();
                if (!this._param.containsKey("allocStdID")) {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_ACTIVITYDATA, new Object[]{_currFee.GetSourceBillNumber2(), _currFee.GetSourceBillEntryNumber2(), _currFee.GetCostCenterNumber2(), _currFee.GetActivityNumber2(), this.getCostDriver().getName()}), hint[0], hint[1]);
                    break block7;
                }
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_ACTIVITYDATA, new Object[]{_currFee.GetCostCenterNumber2(), _currFee.GetActivityNumber2(), this.getCostDriver().getName()}), this.getCostDriver().getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"22_BaseAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"23_BaseAllocator", (Locale)ctx.getLocale()));
            }
            catch (BOSException e) {
                log.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (SQLException e2) {
                log.error((Object)"", (Throwable)e2);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e2), null, null);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.addLog(e);
        } else {
            this._logger.addLog(e, possibleReason, adviceHandle);
        }
    }

    @Override
    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        OCC2ActivityFeeInfoAdapter _currFee = (OCC2ActivityFeeInfoAdapter)currFee;
        String costCenterId = _currFee.GetCostCenterId2();
        String activityId = _currFee.GetActivityId2();
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        String sqlInit = "UPDATE " + tblObjRange + " SET FIsValid = 0 ";
        StringBuffer sb = new StringBuffer(500);
        StringBuffer sbQty = new StringBuffer(500);
        boolean cancelAlloc = true;
        this.bRangeChanged = false;
        if (activityId != null) {
            sb.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)= ").append(" (SELECT top 1 1 FROM T_NCM_OrderReportBill a inner JOIN T_NCM_OrderReportBillHourEntry b ON a.FID = b.FParentID ").append(" WHERE a.fcompanyorg = '").append(companyId).append("' and a.fcalculateperiod = '").append(periodId).append("' and a.fmanufacturerorderid = ").append(tblObjRange).append(".Forderid ").append(" AND b.factivityid = ").append(tblObjRange).append(".FACTIVITYID and (b.FPrepareTime > 0 or FProcessTime >0) )").append(" where ").append(tblObjRange).append(".Fcostcenterid = '").append(costCenterId).append("' and ").append(tblObjRange).append(".Factivityid = '").append(activityId).append("'");
            sbQty.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)= ").append(" (SELECT top 1 1 FROM T_NCM_OrderReportBill a inner JOIN T_NCM_OrderReportBillQtyEntry b ON a.FID = b.FParentID ").append(" WHERE a.fcompanyorg = '").append(companyId).append("' and a.fcalculateperiod = '").append(periodId).append("' and a.fmanufacturerorderid = ").append(tblObjRange).append(".Forderid ").append(" AND b.factivityid = ").append(tblObjRange).append(".FACTIVITYID and \n").append("  (b.FReportQty > 0 or b.FDetectQty > 0 or b.FQualifiedQty > 0 or b.FYieldQty > 0 or b.FScrapQty > 0 \n").append("   or b.FWorkerScrapQty > 0 or b.FSteelScrapQty > 0 or b.FRepairQty > 0))").append(" where ").append(tblObjRange).append(".Fcostcenterid = '").append(costCenterId).append("' and ").append(tblObjRange).append(".Factivityid = '").append(activityId).append("'");
            try {
                DbUtil.execute((Context)ctx, (String)sqlInit);
                DbUtil.execute((Context)ctx, (String)sb.toString());
                DbUtil.execute((Context)ctx, (String)sbQty.toString());
                cancelAlloc = false;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            this.bRangeChanged = true;
        }
        cancelAlloc = false;
        if (activityId != null && !activityId.equals("")) {
            sb.delete(0, sb.length());
            sb.append("Select top 1 FID ").append("FROM ").append(tblObjRange).append(" ").append("WHERE FIsValid = 1 ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) {
                    cancelAlloc = true;
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_ORDER, new Object[]{_currFee.GetSourceBillNumber2(), _currFee.GetSourceBillEntryNumber2(), _currFee.GetCostCenterNumber2(), _currFee.GetActivityNumber2()}), null, null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
            }
        }
        return cancelAlloc;
    }

    @Override
    protected boolean dataIsVouchered(IFeeInfo currFee) throws AllocateException {
        boolean isVouchered = true;
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 fid From T_NCM_OrderCCFeeBill ").append(" Where FSourceBillID = ?  And Fivouchered = 1");
        Object[] params = new Object[]{currFee.GetEntryId()};
        try {
            IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
            if (voucheredRS.size() > 0) {
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq()}), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"25_CCOAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"26_CCOAllocator", (Locale)ctx.getLocale()));
            } else {
                isVouchered = false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isVouchered;
    }

    @Override
    protected boolean updateAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer(150);
        String tblAllocData = this.getTblAllocData();
        try {
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            if (sb.length() <= 1) {
                return false;
            }
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append('\n');
            sb.append(" UPDATE ").append(tblAllocData).append(" SET FQty = 0 WHERE FQty < 0 ;").append('\n');
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(tblAllocData).append(" SET FRatio = FQty/").append("\t(").append("\tSelect ISNULL(SUM(S.FQty),1)As FQty").append("\tFROM ").append(tblAllocData).append(" S ").append("\tWHERE S.FQty > 0 ").append("\tGROUP BY S.FRatio ").append("\tHAVING SUM(S.FQty) <> 0 ").append("\t);");
            sb.append(" delete from ").append(tblAllocData).append(" WHERE FRatio is null or FRatio = 0 ;");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean initAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        String tblAllocData = this.getTblAllocData();
        if (StringUtils.isEmpty((String)tblAllocData)) {
            return cancelAlloc;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(tblAllocData).append(";").append('\n');
        fieldList = fieldList + "FActivityID, FOrderID, ";
        fldAstList = fldAstList + "FActivityID, FOrderID, ";
        sb.append("INSERT INTO ").append(tblAllocData).append("(FID,").append(fieldList).append("FCC2ActivityID,").append('\n').append("FCostCenterID,").append('\n').append("FQty,FRatio)").append('\n').append("Select FID,").append(fldAstList).append("FCC2ActivityID, FCostCenterID,").append("0 As FQty, 0 As FRatio ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ;");
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean isOnlyNotZero_AllcoStdData() {
        return false;
    }

    @Override
    public CostDriverInfo getAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        CostDriverInfo setting;
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        OCC2ActivityFeeInfoAdapter _currFee = (OCC2ActivityFeeInfoAdapter)currFee;
        if (this.costDriverSettingCache == null) {
            StringBuffer sb = new StringBuffer(150);
            try {
                ICostDriverSetByAct fact = CostDriverSetByActFactory.getLocalInstance(ctx);
                sb.append("Select costDriver.*,activity.*,costCenter.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND costDriver.id is not null ");
                this.costDriverSettingCache = fact.getCostDriverSetByActCollection(sb.toString());
            }
            catch (BOSException e) {
                this._logger.addLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((setting = this.getAllocStdFromCache(_currFee)) == null) {
            this._logger.addLog(new AllocateException(AllocateException.ITEM_ALLOC_DRIVER2NOTSET, new Object[]{_currFee.GetSourceBillNumber2(), _currFee.GetSourceBillEntryNumber2(), _currFee.GetCostCenterNumber2(), _currFee.GetActivityNumber2()}));
        }
        return setting;
    }

    private CostDriverInfo getAllocStdFromCache(OCC2ActivityFeeInfoAdapter _currFee) {
        String activityId = null;
        String costCenterId = null;
        for (int i = 0; i < this.costDriverSettingCache.size(); ++i) {
            activityId = this.costDriverSettingCache.get(i).getActivity().getId().toString();
            costCenterId = this.costDriverSettingCache.get(i).getCostCenter().getId().toString();
            if (!_currFee.GetActivityId2().equals(activityId) || !_currFee.GetCostCenterId2().equals(costCenterId)) continue;
            return this.costDriverSettingCache.get(i).getCostDriver();
        }
        return null;
    }
}

