/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee.table;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.AllocTable;
import com.kingdee.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OCActivity2OrderAllocTable
extends AllocTable {
    private static Logger logger = Logger.getLogger((String)OCActivity2OrderAllocTable.class.getName());
    protected String _tblResult = null;
    protected String _tempTblObjectRange = null;
    protected String _tblCostCalPrdDetailResult = null;
    protected String _tempTblBillEntryID = null;
    protected Map tblAllocDataCache = null;
    protected static final char CLF = '\n';
    protected TempTablePool pool;

    public OCActivity2OrderAllocTable(Map param) {
        super(param);
        Assert.that((boolean)param.containsKey("pool"));
        this.pool = (TempTablePool)param.get("pool");
    }

    @Override
    public String GetResultTable() throws AllocateException {
        if (this._tblResult != null) {
            return this._tblResult;
        }
        Context ctx = (Context)this.param.get("ctx");
        String companyId = this.param.get("companyId").toString();
        String periodId = this.param.get("periodId").toString();
        try {
            this._tblResult = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCActivity2OrderAlloc");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tblResult;
    }

    @Override
    public String GetObjectRangeTable() throws AllocateException {
        if (this._tempTblObjectRange != null) {
            return this._tempTblObjectRange;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("create table t_ncm_ObjectRange (").append("FID varchar(44),").append("FCC2ActivityID VARCHAR(44),").append("FCostCenterID varchar(44),").append("FActivityID varchar(44),").append("FOrderID varchar(44),").append("FIsValid INT)");
        try {
            this._tempTblObjectRange = this.pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this._tempTblObjectRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String GetAllocDataTable(String factorFldCreateList) throws AllocateException {
        if (this.tblAllocDataCache == null) {
            Class<OCActivity2OrderAllocTable> clazz = OCActivity2OrderAllocTable.class;
            // MONITORENTER : com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.OCActivity2OrderAllocTable.class
            this.tblAllocDataCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this.tblAllocDataCache.containsKey(factorFldCreateList)) {
            return (String)this.tblAllocDataCache.get(factorFldCreateList);
        }
        StringBuffer createSqlTempTblAllocDataTable = new StringBuffer(200);
        createSqlTempTblAllocDataTable.append("create table t_ncm_AllocData (").append("FID varchar(44),").append(factorFldCreateList).append("FCC2ActivityID VARCHAR(44),").append("FCostCenterID varchar(44),").append("FActivityID varchar(44),FOrderID varchar(44),").append("FQty NUMERIC(24,12) Default(0), FRatio NUMERIC(24,12) Default(0))");
        String tblname = null;
        try {
            tblname = this.pool.createTempTable(createSqlTempTblAllocDataTable.toString());
            this.pool.createIndex(tblname, "FID", false, false);
            this.tblAllocDataCache.put(factorFldCreateList, tblname);
            return tblname;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tblname;
    }

    @Override
    public String GetCalPrdDetailResultTable() throws AllocateException {
        return null;
    }

    @Override
    public void CreateTempTableIndexs() throws AllocateException {
        try {
            String tbl_range = this.GetObjectRangeTable();
            this.pool.createIndex(tbl_range, "FID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void releaseTempTable() {
        if (this._tblResult != null) {
            this.pool.releaseTable(this._tblResult);
        }
        if (this._tempTblObjectRange != null) {
            this.pool.releaseTable(this._tempTblObjectRange);
        }
        if (this._tempTblBillEntryID != null) {
            this.pool.releaseTable(this._tempTblBillEntryID);
        }
        if (this.tblAllocDataCache != null) {
            for (Map.Entry entry : this.tblAllocDataCache.entrySet()) {
                String tblname = (String)entry.getValue();
                this.pool.releaseTable(tblname);
            }
        }
    }

    @Override
    public String GetToAllocBillEntryIDTable() throws AllocateException {
        return null;
    }
}

