/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.ncm.CostDriverTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.OCCC2ActivityData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.Allocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.AutoOCCC2ActicityAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.OCActivity2OrderAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCCC2ActivityAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.task.OCBaseAllocTask;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.AutoOCCC2ActivityBatchAllocIterator;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.IBatchAllocIterator;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.OCActivity2OrderBatchAllocIterator;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OCCC2ActivityAllocTask
extends OCBaseAllocTask {
    private int directDataCount = 0;
    private int indirectDataCount = 0;
    protected FeeData feeData = null;
    protected OCAllocExceptionLog exclog = null;
    private Map _param;
    private Allocator allocator;
    private OCCC2ActivityAllocExceptionLog _logger;
    private String companyId;
    private String periodId;
    private String userId;
    private AllocTypeEnum allocType;
    private FilterInfo filterInfo;
    private AllocSourceBillEnum allocSourceBill;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatchLog");
    private String tblAllocResult = null;

    @Override
    public void init(Map param) {
        super.init(param);
        this._param = param;
        if (!param.containsKey("ctx")) {
            param.put("ctx", this.getContext());
        }
        this.companyId = param.get("companyId").toString();
        this.periodId = param.get("periodId").toString();
        this.userId = param.get("userId") != null ? param.get("userId").toString() : ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId().toString();
        this.allocType = (AllocTypeEnum)param.get("allocType");
        if (this.allocType == null) {
            this.allocType = AllocTypeEnum.AUTO;
        }
        this.filterInfo = (FilterInfo)param.get("filterInfo");
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.companyId));
            this.filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.periodId));
            this.filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4), CompareType.EQUALS));
        }
        this.allocSourceBill = (AllocSourceBillEnum)param.get("allocSourceBill");
        if (this.allocSourceBill == null) {
            this.allocSourceBill = AllocSourceBillEnum.OrderCCFeeBill;
        }
        this._param.put("companyId", this.companyId);
        this._param.put("periodId", this.periodId);
        this._param.put("userId", this.userId);
        this._param.put("allocType", this.allocType);
        this._param.put("filterInfo", this.filterInfo);
        this._param.put("allocSourceBill", AllocSourceBillEnum.OrderCCFeeBill);
    }

    protected FeeData getOCCCActivityData() throws Throwable {
        if (this.feeData == null) {
            this.feeData = new OCCC2ActivityData(this.getParam());
        }
        return this.feeData;
    }

    @Override
    public int calculateStepAmount() throws Throwable {
        this.setStepName("\u6b63\u5728\u8fdb\u884c\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d...");
        this.info("\u6b63\u5728\u8fdb\u884c\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u4efb\u52a1\u91cf\u8ba1\u7b97...");
        int stepAmount = 0;
        ++stepAmount;
        ++stepAmount;
        stepAmount += 5;
        stepAmount += 13;
        String sql = ((OCCC2ActivityData)this.getFeeData()).getCountIndirectFeeDataSql();
        IRowSet rowset = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (rowset.next()) {
            this.indirectDataCount = rowset.getInt(1);
        }
        if (this.isDebugEnabled()) {
            this.debug("\u5171\u6709" + this.indirectDataCount + "\u7b14\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u3002");
        }
        stepAmount = this.indirectDataCount > 80 ? (stepAmount += 80) : (stepAmount += this.indirectDataCount);
        this.info("\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u4efb\u52a1\u91cf\u8ba1\u7b97\u5b8c\u6210\u3002");
        return stepAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map DoAllocate() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"27_AllocDispatch", (Locale)ctx.getLocale()));
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"28_AllocDispatch", (Locale)ctx.getLocale()));
        AUSContext ausCtx = new AUSContext(this._param);
        this.allocator = this.CreateAllocator(ausCtx);
        IBatchAllocIterator iterator = this.CreateBatchAllocIterator(this.allocator);
        Map ret = null;
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"29_AllocDispatch", (Locale)ctx.getLocale()));
        this.allocator.preCheck();
        try {
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"30_AllocDispatch", (Locale)ctx.getLocale()));
            this.info("\u6e05\u9664\u5386\u53f2\u6570\u636e\u5f00\u59cb...");
            this.allocator.preProcess();
            this.info("\u6e05\u9664\u5386\u53f2\u6570\u636e\u7ed3\u675f\u3002");
            this.allocator.allocDirect();
            int i = 1;
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"32_AllocDispatch", (Locale)ctx.getLocale()));
            iterator.FirstBatch();
            while (!iterator.IsDone()) {
                this.info("\u5f00\u59cb\u5206\u914d\u7b2c" + i + "\u7b14\u8d39\u7528...");
                iterator.AllocateCurrBatch();
                this.info("\u7b2c" + i + "\u7b14\u8d39\u7528\u5206\u914d\u5b8c\u6210\u3002");
                ++i;
                if (this.indirectDataCount + this.directDataCount < 80) {
                    this.progress(1);
                } else if (i % this.getNumberProgress() == 0) {
                    this.progress(1);
                }
                iterator.NextBatch();
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"33_AllocDispatch", (Locale)ctx.getLocale()));
            this.info("\u5f00\u59cb\u5904\u7406\u5206\u914d\u7ed3\u679c...");
            ret = this.allocator.processResult();
            this.progress(13);
            this.info("\u5f00\u59cb\u5206\u914d\u4f5c\u4e1a\u8d39\u7528...");
            this.allocActivity2Order(ausCtx);
            this.info("\u5206\u914d\u7ed3\u679c\u5904\u7406\u5b8c\u6210\u3002");
        }
        finally {
            this.allocator.endProcess();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            boolean isSuccessed = false;
            if (this._logger == null || this._logger.getLogCount() == 0) {
                isSuccessed = true;
            }
            NCMUtils.addEASLogForAlloc((Context)ctx, (String)"DoAllocate", (String)(company.getNumber() + ' ' + company.getName()), (AllocSourceBillEnum)this.allocSourceBill, (AllocTypeEnum)this.allocType, (String)this.companyId, (boolean)isSuccessed);
        }
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"34_AllocDispatch", (Locale)ctx.getLocale()));
        return ret;
    }

    private Map allocActivity2Order(AUSContext ausCtx) throws AllocateException {
        ausCtx.set_allocStdType(CostDriverTypeEnum.ACTIVITY__DRIVER);
        this._param.put("allocStdType", CostDriverTypeEnum.ACTIVITY__DRIVER);
        OCActivity2OrderAllocator allocator = new OCActivity2OrderAllocator(this._param, ausCtx);
        OCActivity2OrderBatchAllocIterator iterator = new OCActivity2OrderBatchAllocIterator(this._param, allocator);
        ((Allocator)allocator).preProcess();
        ((Allocator)allocator).allocDirect();
        int i = 0;
        iterator.FirstBatch();
        while (!iterator.IsDone()) {
            this.info("\u5f00\u59cb\u5206\u914d\u7b2c" + i + "\u7b14\u8d39\u7528...");
            iterator.AllocateCurrBatch();
            this.info("\u7b2c" + i + "\u7b14\u8d39\u7528\u5206\u914d\u5b8c\u6210\u3002");
            ++i;
            if (this.indirectDataCount + this.directDataCount < 80) {
                this.progress(1);
            } else if (i % this.getNumberProgress() == 0) {
                this.progress(1);
            }
            iterator.NextBatch();
        }
        return null;
    }

    private Allocator CreateAllocator(AUSContext ausCtx) {
        AutoOCCC2ActicityAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._logger = new OCCC2ActivityAllocExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoOCCC2ActicityAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                break;
            }
        }
        return alloc;
    }

    private IBatchAllocIterator CreateBatchAllocIterator(Allocator allocatorAdapter) throws AllocateException {
        AutoOCCC2ActivityBatchAllocIterator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                alloc = new AutoOCCC2ActivityBatchAllocIterator(this._param, allocatorAdapter);
                break;
            }
            case 1: {
                break;
            }
        }
        return alloc;
    }

    public AllocTypeEnum getAllocType() {
        return this.allocType;
    }

    @Override
    public String getCompanyId() {
        return this.companyId;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public String getPeriodId() {
        return this.periodId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void allocDirect() throws Throwable {
    }

    @Override
    public void allocIndirect() throws Throwable {
        this.DoAllocate();
    }

    public String getTblAllocResult() throws Throwable {
        if (this.tblAllocResult != null) {
            return this.tblAllocResult;
        }
        this.checkInterruptAndPause();
        this.info("\u53d6\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u7ed3\u679c\u8868...");
        try {
            this.tblAllocResult = DynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)this.getCompanyId(), (String)this.getPeriodId(), (String)"T_NCM_OCActivity2OrderAlloc");
            if (this.isDebugEnabled()) {
                this.debug("\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u7ed3\u679c\u8868\uff1a" + this.tblAllocResult);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        this.info("\u53d6\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u7ed3\u679c\u8868\u5b8c\u6210\u3002");
        this.progress(1);
        return this.tblAllocResult;
    }

    @Override
    public void endProcess() throws Throwable {
        String companyId = this.getCompanyId();
        String periodId = this.getPeriodId();
        StringBuffer ksql = new StringBuffer();
        String allocResultTable = this.getTblAllocResult();
        this.info("\u6b63\u5728\u66f4\u65b0\u7269\u6599\u6279\u6b21\u4fe1\u606f...");
        ksql.append("update " + allocResultTable + " r set \n");
        ksql.append("forderprodbatchno = N' ' \n");
        ksql.append("where FCompanyID = '" + companyId + "' and FCalculatePeriodID = '" + periodId + "' \n");
        ksql.append("and not exists ( \n");
        ksql.append("    select 1 from T_BD_MaterialCompanyInfo mc \n");
        ksql.append("    where mc.FCompanyID = r.FCompanyID and mc.FMaterialID = r.FORDERPRODID \n");
        ksql.append("    and mc.FAccountType = 5 \n");
        ksql.append(") \n");
        if (this.isDebugEnabled()) {
            this.debug(ksql.toString());
        }
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        this.progress(1);
        this.info("\u66f4\u65b0\u7269\u6599\u6279\u6b21\u4fe1\u606f\u5b8c\u6210\u3002");
        this.info("\u6b63\u5728\u8fdb\u884c\u590d\u5236\u8ba2\u5355\u76f8\u5173\u4fe1\u606f...");
        ksql.setLength(0);
        ksql.append("update " + allocResultTable + " r set \n");
        ksql.append("(FOrderNumber, FOrderProdID, FOrderProdBatchNo) = ( \n");
        ksql.append("    select \n");
        ksql.append("    o.FNumber FOrderNumber, \n");
        ksql.append("    o.FMaterialID FOrderProdID, \n");
        ksql.append("    case when mc.FAccountType = 5 \n");
        ksql.append("    then (case when o.FLot is null then N' ' else (o.FLot||N'') end) \n");
        ksql.append("    else N' ' end FOrderProdBatchNo \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    left join T_BD_MaterialCompanyInfo mc on \n");
        ksql.append("    mc.FCompanyID = '" + companyId + "' and mc.FMaterialID = o.FMaterialID \n");
        ksql.append("    where o.FID = r.FOrderID \n");
        ksql.append(") \n");
        ksql.append("where r.FCompanyID = '" + companyId + "' and r.FCalculatePeriodID = '" + periodId + "' \n");
        if (this.isDebugEnabled()) {
            this.debug(ksql.toString());
        }
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        this.progress(1);
        this.info("\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\u590d\u5236\u5b8c\u6210\u3002");
        if (this._logger == null || this._logger.getLogCount() == 0) {
            this.setStepName("\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u6210\u529f\u3002");
            this.info("\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u6210\u529f");
            this.addUserObject("activityAlloc_success");
        } else {
            this.setStepName("\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u5b8c\u6210\uff0c\u90e8\u5206\u5355\u636e\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002");
            this.warn("\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d\u5b8c\u6210\uff0c\u90e8\u5206\u5355\u636e\u51fa\u73b0\u9519\u8bef");
            this.addUserObject("activityAlloc_error");
        }
    }

    @Override
    public OCAllocExceptionLog getExceptionLog() throws Throwable {
        if (this.exclog == null) {
            this.exclog = new OCCC2ActivityAllocExceptionLog(this.getParam());
            this.exclog.clearPreLogData();
        }
        this.progress(1);
        return this.exclog;
    }

    @Override
    public FeeData getFeeData() throws Throwable {
        if (this.feeData == null) {
            this.feeData = new OCCC2ActivityData(this.getParam());
        }
        this.progress(1);
        return this.feeData;
    }

    @Override
    public void preCheck() throws Throwable {
        this.checkCCFeeBillCodingRule();
        this.getExceptionLog();
    }

    @Override
    public void preProcess() throws Throwable {
        this._param.put("allocStdType", CostDriverTypeEnum.INNERCC_DRIVER);
    }

    @Override
    public void release() throws Throwable {
    }

    private void checkCCFeeBillCodingRule() throws AllocateException {
    }

    private int getNumberProgress() {
        return (this.indirectDataCount + this.directDataCount) / 80;
    }
}

