/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.MatFeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCMaterialAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.task.OCBaseAllocTask;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class OCMaterialAllocTask
extends OCBaseAllocTask {
    private static Logger logger = Logger.getLogger((String)OCMaterialAllocTask.class.getName());
    public static final String SysExpense = "ml7t5QEaEADgAAwawKgRe0olWCc=";
    private int directDataCount = 0;
    private int indirectDataCount = 0;
    protected MatFeeData feeData = null;
    protected OCAllocExceptionLog exclog = null;
    private String costItemId = null;
    private int totalProgress = -1;
    private int directProgress;
    private int finishedDirectProgress;
    private int indirectProgress;
    private int clearProgress;
    private int updateLotProgress;
    private int copyOrderProgress;
    private int calStepProgress;

    @Override
    public int calculateStepAmount() throws Throwable {
        if (this.totalProgress > 0) {
            return this.totalProgress;
        }
        IObjectPK logPk = LogUtil.beginLog((Context)this.getContext(), (String)"alloc", (BOSObjectType)this.getBOSType(), null, (String)"", (String)"OC_MaterialAlloc_Auto");
        this.getParam().put("logPk_materialAlloc", logPk);
        this.info("\u6b63\u5728\u8fdb\u884c\u6750\u6599\u8d39\u7528\u5206\u914d\u4efb\u52a1\u91cf\u8ba1\u7b97...");
        int stepAmount = 0;
        this.getFeeData();
        this.checkInterruptAndPause();
        String sql = this.feeData.getCountDirectFeeDataSql();
        if (this.isDebugEnabled()) {
            this.debug("\u6750\u6599\u8d39\u7528\u76f4\u63a5\u8d39\u7528\u8bb0\u5f55\u8ba1\u6570SQL\uff1a" + sql);
        }
        this.checkInterruptAndPause();
        IRowSet rowset = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (rowset.next()) {
            this.directDataCount = rowset.getInt(1);
        }
        if (this.isDebugEnabled()) {
            this.debug("\u5171\u6709" + this.directDataCount + "\u7b14\u6750\u6599\u8d39\u7528\u76f4\u63a5\u8d39\u7528\u3002");
        }
        this.directProgress = (int)Math.sqrt(this.directDataCount);
        if (this.directProgress < 4) {
            this.directProgress = 4;
        }
        stepAmount += this.directProgress;
        this.checkInterruptAndPause();
        this.indirectProgress = (int)Math.sqrt(this.indirectDataCount);
        stepAmount += this.indirectProgress;
        this.clearProgress = (this.directProgress + this.indirectProgress) / 4;
        if (this.clearProgress <= 0) {
            this.clearProgress = 1;
        }
        stepAmount += this.clearProgress;
        this.calStepProgress = (this.directProgress + this.indirectProgress) / 10;
        if (this.calStepProgress <= 0) {
            this.calStepProgress = 1;
        }
        stepAmount += this.calStepProgress;
        this.updateLotProgress = (this.directProgress + this.indirectProgress) / 10;
        if (this.updateLotProgress <= 0) {
            this.updateLotProgress = 1;
        }
        stepAmount += this.updateLotProgress;
        this.copyOrderProgress = (this.directProgress + this.indirectProgress) / 10;
        if (this.copyOrderProgress <= 0) {
            this.copyOrderProgress = 1;
        }
        this.info("\u6750\u6599\u8d39\u7528\u5206\u914d\u4efb\u52a1\u91cf\u8ba1\u7b97\u5b8c\u6210\u3002");
        this.totalProgress = stepAmount += this.copyOrderProgress;
        return stepAmount;
    }

    public int estimateStepAmount() throws Throwable {
        return this.calculateStepAmount();
    }

    @Override
    public FeeData getFeeData() throws Throwable {
        if (this.feeData == null) {
            this.feeData = new MatFeeData(this);
        }
        return this.feeData;
    }

    @Override
    public OCAllocExceptionLog getExceptionLog() throws Throwable {
        if (this.exclog == null) {
            this.checkInterruptAndPause();
            this.exclog = new OCMaterialAllocExceptionLog(this.getParam());
            this.exclog.clearPreLogData();
        }
        return this.exclog;
    }

    @Override
    public void preProcess() throws Throwable {
        this.setStepName("\u6b63\u5728\u8fdb\u884c\u6750\u6599\u8d39\u7528\u5206\u914d...");
        this.checkInterruptAndPause();
        this.progress(this.calStepProgress);
        this.getExceptionLog();
        this.checkInterruptAndPause();
        this.info("\u6e05\u9664\u4e0a\u6b21\u8d39\u7528\u5206\u914d\u7ed3\u679c...");
        this.feeData.clearPreAllocResult(null, null);
        this.progress(this.clearProgress);
        this.info("\u6e05\u9664\u4e0a\u6b21\u8d39\u7528\u5206\u914d\u7ed3\u679c\u5b8c\u6210");
    }

    @Override
    public void preCheck() throws Throwable {
        this.checkInterruptAndPause();
        Context ctx = this.getContext();
        String companyId = this.getCompanyId();
        IExpense iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo dFilter = iExpense.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "id", "CU.id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysExpense));
        filter.mergeFilter(dFilter, "and");
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        ExpenseCollection eColl = iExpense.getExpenseCollection(view);
        if (eColl != null && eColl.size() > 0) {
            CostItemInfo costItem;
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)SysExpense));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("costItem.id");
            view.setSelector(sic);
            ExpenseCompanyInfoCollection ecColl = ExpenseCompanyInfoFactory.getLocalInstance((Context)ctx).getExpenseCompanyInfoCollection(view);
            if (ecColl != null && ecColl.size() > 0 && (costItem = ecColl.get(0).getCostItem()) != null && costItem.getId() != null) {
                this.costItemId = costItem.getId().toString();
            }
        }
        if (this.costItemId == null) {
            String sql = this.feeData.getCheckCostItemDataSql();
            IRowSet rowset = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
            String possibleReason = "\u5355\u636e\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee\u6216\u7269\u6599\u6210\u672c\u9875\u7b7e\u672a\u8bbe\u7f6e\u5bf9\u5e94\u6210\u672c\u9879\u76ee\u6216\u5bf9\u5e94\u8981\u7d20\u8d39\u7528\u65e0\u9ed8\u8ba4\u6210\u672c\u9879\u76ee\u3002";
            String adviceHandle = "\u5355\u636e\u5f55\u5165\u6210\u672c\u9879\u76ee\u6216\u7ef4\u62a4\u7269\u6599\u6210\u672c\u9875\u7b7e\u5bf9\u5e94\u6210\u672c\u9879\u76ee\u6216\u5bf9\u5e94\u8981\u7d20\u8d39\u7528\u7ef4\u62a4\u9ed8\u8ba4\u6210\u672c\u9879\u76ee\u3002";
            String error = "\u5355\u636e\u7f16\u53f7[{0}]\u7b2c[{1}]\u7684\u5206\u5f55\u65e0\u6cd5\u53d6\u5230\u5bf9\u5e94\u7684\u6210\u672c\u9879\u76ee\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u3002";
            while (rowset.next()) {
                this.processAllocateError(MessageFormat.format(error, rowset.getString("FNumber"), rowset.getString("FSeq")), possibleReason, adviceHandle);
            }
        }
        int progress = this.directProgress / 3;
        this.finishedDirectProgress += progress;
        this.progress(progress);
    }

    @Override
    public void allocDirect() throws Throwable {
        if (this.directDataCount <= 0) {
            return;
        }
        this.checkInterruptAndPause();
        this.info("\u6b63\u5728\u8fdb\u884c\u6750\u6599\u8d39\u7528\u76f4\u63a5\u8d39\u7528\u5206\u914d...");
        String companyId = this.getCompanyId();
        String periodId = this.getPeriodId();
        String creatorId = ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId().toString();
        String sql = this.getFeeData().getDirectFeeDataSql();
        StringBuffer ksql = new StringBuffer();
        ksql.append("insert into " + this.feeData.getTblAllocResult() + " ( \n");
        ksql.append("    FID, \n");
        ksql.append("    FCompanyID, \n");
        ksql.append("    FCalculatePeriodID, \n");
        ksql.append("    FCostCenterID, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillEntryID, \n");
        ksql.append("    FMatReqBillNumber, \n");
        ksql.append("    FSeq, \n");
        ksql.append("    FMaterialID, \n");
        ksql.append("    FLot, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FAllocStdID, \n");
        ksql.append("    FAllocStdData, \n");
        ksql.append("    FOrderID, \n");
        ksql.append("    FOperationID, \n");
        ksql.append("    FBaseUnitID, \n");
        ksql.append("    FUnitID, \n");
        ksql.append("    FAssistUnitID, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FAssistQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FAllocBillType, \n");
        ksql.append("    FIsRework, \n");
        ksql.append("    FIsDirect, \n");
        ksql.append("    FCreatorID, \n");
        ksql.append("    FCreateTime, \n");
        ksql.append("    FAdjustUserID, \n");
        ksql.append("    FAdjustTime \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    newbosid('500AB75E') FID, \n");
        ksql.append("    '" + companyId + "' FCompanyID, \n");
        ksql.append("    '" + periodId + "' FCalculatePeriodID, \n");
        ksql.append("    \"COSTCENTERORGUNIT.ID\" FCostCenterID, \n");
        ksql.append("    \"ID\" FSourceBillID, \n");
        ksql.append("    \"ENTRY.ID\" FSourceBillEntryID, \n");
        ksql.append("    \"NUMBER\" FMatReqBillNumber, \n");
        ksql.append("    \"ENTRY.SEQ\" FSeq, \n");
        ksql.append("    \"MATERIAL.ID\" FMaterialID, \n");
        ksql.append("    isnull(\"ENTRY.LOT\", N' ') FLot, \n");
        ksql.append("    \"COSTITEM.id\" FCostItemID, \n");
        ksql.append("    null FAllocStdID, \n");
        ksql.append("    1 FAllocStdData, \n");
        ksql.append("    \"ENTRY.SOURCEBILLID\" FOrderID, \n");
        ksql.append("    \"OPERATION.ID\" FOperationID, \n");
        ksql.append("    null FBaseUnitID, \n");
        ksql.append("    \"UNIT.ID\" FUnitID, \n");
        ksql.append("    null FAssistUnitID, \n");
        ksql.append("    \"entry.baseQty\" FBaseQty, \n");
        ksql.append("    \"ENTRY.QTY\" FQty, \n");
        ksql.append("    \"ENTRY.ASSISTQTY\" FAssistQty, \n");
        ksql.append("    ROUND( \n");
        ksql.append("        to_decimal(\"entry.actualCost\",24,12) / to_decimal(\"entry.baseQty\",24,12) \n");
        ksql.append("        , \"material.pricePrecision\" \n");
        ksql.append("    ) FPrice, \n");
        ksql.append("    \"entry.actualCost\" FAmount, \n");
        ksql.append("    null FAllocBillType, \n");
        ksql.append("    0 FIsRework, \n");
        ksql.append("    1 FIsDirect, \n");
        ksql.append("    '" + creatorId + "' FCreatorID, \n");
        ksql.append("    GetDate() FCreateTime, \n");
        ksql.append("    null FAdjustUserID, \n");
        ksql.append("    GetDate() FAdjustTime \n");
        ksql.append("from ( \n");
        ksql.append("    " + sql + " \n");
        ksql.append(") T \n");
        ksql.append("where \"entry.baseQty\" <> 0 ");
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        int progress = this.directProgress / 3;
        this.progress(progress);
        this.finishedDirectProgress += progress;
        this.checkInterruptAndPause();
        ksql.setLength(0);
        String FCostItemID = "null";
        if (this.costItemId != null) {
            FCostItemID = "'" + this.costItemId + "'";
        }
        ksql.append("update " + this.feeData.getTblAllocResult() + " r set \n");
        ksql.append("FCostItemID = isnull(( \n");
        ksql.append("    select mc.FDefaultCostItemID from T_BD_MaterialCost mc \n");
        ksql.append("    where mc.FMaterialID = r.FMaterialID and FOrgUnit = '" + companyId + "' \n");
        ksql.append("), " + FCostItemID + ") \n");
        ksql.append("where FCostItemID is null \n");
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        progress = (this.directProgress - this.finishedDirectProgress) * 2 / 3;
        this.progress(progress);
        this.finishedDirectProgress += progress;
        this.checkInterruptAndPause();
        ksql.setLength(0);
        ksql.append("delete from " + this.feeData.getTblAllocResult() + " where FCostItemID is null \n");
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        this.progress(this.directProgress - this.finishedDirectProgress);
        this.info("\u6750\u6599\u8d39\u7528\u76f4\u63a5\u8d39\u7528\u5206\u914d\u5b8c\u6210\u3002");
    }

    @Override
    public void allocIndirect() throws Throwable {
    }

    @Override
    public void endProcess() throws Throwable {
        String companyId = this.getCompanyId();
        String periodId = this.getPeriodId();
        StringBuffer ksql = new StringBuffer();
        this.info("\u6b63\u5728\u66f4\u65b0\u7269\u6599\u6279\u6b21\u4fe1\u606f...");
        ksql.append("update " + this.feeData.getTblAllocResult() + " r set \n");
        ksql.append("FLot = N' ' \n");
        ksql.append("where FCompanyID = '" + companyId + "' and FCalculatePeriodID = '" + periodId + "' \n");
        ksql.append("and not exists ( \n");
        ksql.append("    select 1 from T_BD_MaterialCompanyInfo mc \n");
        ksql.append("    where mc.FCompanyID = r.FCompanyID and mc.FMaterialID = r.FMaterialID \n");
        ksql.append("    and mc.FAccountType = 5 \n");
        ksql.append(") \n");
        if (this.isDebugEnabled()) {
            this.debug(ksql.toString());
        }
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        this.progress(this.updateLotProgress);
        this.info("\u66f4\u65b0\u7269\u6599\u6279\u6b21\u4fe1\u606f\u5b8c\u6210\u3002");
        this.info("\u6b63\u5728\u8fdb\u884c\u590d\u5236\u8ba2\u5355\u76f8\u5173\u4fe1\u606f...");
        ksql.setLength(0);
        ksql.append("update " + this.feeData.getTblAllocResult() + " r set \n");
        ksql.append("(FOrderNumber, FOrderProdID, FOrderProdBatchNo) = ( \n");
        ksql.append("    select \n");
        ksql.append("    o.FNumber FOrderNumber, \n");
        ksql.append("    o.FMaterialID FOrderProdID, \n");
        ksql.append("    case when mc.FAccountType = 5 \n");
        ksql.append("    then (case when o.FLot is null then N' ' else (o.FLot||N'') end) \n");
        ksql.append("    else N' ' end FOrderProdBatchNo \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    left join T_BD_MaterialCompanyInfo mc on \n");
        ksql.append("    mc.FCompanyID = '" + companyId + "' and mc.FMaterialID = o.FMaterialID \n");
        ksql.append("    where o.FID = r.FOrderID \n");
        ksql.append(") \n");
        ksql.append("where r.FCompanyID = '" + companyId + "' and FCalculatePeriodID = '" + periodId + "' \n");
        if (this.isDebugEnabled()) {
            this.debug(ksql.toString());
        }
        try {
            DbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        this.progress(this.copyOrderProgress);
        this.info("\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\u590d\u5236\u5b8c\u6210\u3002");
        if (this.getExceptionLog().getLogCount() > 0) {
            this.setStepName("\u6750\u6599\u8d39\u7528\u5206\u914d\u5b8c\u6210\uff0c\u90e8\u5206\u5355\u636e\u51fa\u73b0\u9519\u8bef");
            this.warn("\u6750\u6599\u8d39\u7528\u5206\u914d\u5b8c\u6210\uff0c\u90e8\u5206\u5355\u636e\u51fa\u73b0\u9519\u8bef");
            this.addUserObject("materialAlloc_error");
        } else {
            this.setStepName("\u6750\u6599\u8d39\u7528\u5206\u914d\u6210\u529f");
            this.info("\u6750\u6599\u8d39\u7528\u5206\u914d\u6210\u529f");
            this.addUserObject("materialAlloc_success");
        }
        LogUtil.afterLog((Context)this.getContext(), (IObjectPK)((IObjectPK)this.getParam().get("logPk_materialAlloc")));
    }

    @Override
    public void release() throws Throwable {
        this.feeData.release();
    }

    public String getTaskName() {
        return "\u8ba2\u5355\u6210\u672c_\u6750\u6599\u8d39\u7528\u5206\u914d";
    }

    @Override
    public int getConcurrentSeq() {
        return 10;
    }
}

