/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator;

import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.Allocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.CCOFeeInfoAdapter;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.IBatchAllocIterator;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class CCOBatchAllocIterator
implements IBatchAllocIterator {
    private static Logger logger = Logger.getLogger((String)CCOBatchAllocIterator.class.getName());
    protected Map _param;
    protected Allocator _allocatorAdapter;
    protected IRowSet _data;
    protected CCOFeeInfoAdapter _dataAdapter;

    public CCOBatchAllocIterator(Map param, Allocator allocatorAdapter) throws AllocateException {
        this._param = param;
        this._allocatorAdapter = allocatorAdapter;
        this.initData();
    }

    @Override
    public void FirstBatch() throws AllocateException {
        try {
            this._data.first();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public void NextBatch() throws AllocateException {
        try {
            this._data.next();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public boolean IsDone() throws AllocateException {
        try {
            return this._data.getRow() == 0 || this._data.isAfterLast();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public void AllocateCurrBatch() throws AllocateException {
        try {
            int position = -1;
            if (this._data.isFirst()) {
                position = 1;
            }
            if (this._data.isLast()) {
                position = 2;
            }
            if (this._data.isFirst() || this._data.isLast()) {
                position = 3;
            }
            if (!this._data.isFirst() && !this._data.isLast()) {
                position = 4;
            }
            this._allocatorAdapter.allocIndirect(this._dataAdapter, position);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    protected void initData() throws AllocateException {
        FeeData ifee = this._allocatorAdapter.getFeeDataControl();
        this._data = ifee.getIndirectFeeData();
        this._dataAdapter = new CCOFeeInfoAdapter(this._data);
    }
}

