/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.dispatch;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Allocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoCostAdjustAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoOtherInWHAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuCostAdjustAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.ManuOtherInWHAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.WizMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.WizOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.AutoMatBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.AutoOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.IBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.ManuMatBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.ManuOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.WizMatBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.WizOtherBatchAllocIterator;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxAUSContext;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxAllocator;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocDispatch {
    protected Map _param;
    private Allocator allocator;
    private AllocateExceptionLog _logger;
    private String companyId;
    private String periodId;
    private String userId;
    protected AllocTypeEnum allocType;
    private AllocSourceBillEnum allocSourceBill;
    protected FilterInfo filterInfo;
    private boolean isMat = false;
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatchLog");

    public AllocDispatch(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocType"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        Assert.that((boolean)param.containsKey("isMat"));
        this._param = param;
        this.companyId = param.get("companyId").toString();
        this.periodId = param.get("periodId").toString();
        this.userId = param.get("userId").toString();
        this.allocType = (AllocTypeEnum)param.get("allocType");
        this.filterInfo = (FilterInfo)param.get("filterInfo");
        if (String.valueOf(true).equals(param.get("isMat"))) {
            this.isMat = true;
        }
        this._param.put("allocStdType", AllocStdTypeEnum.INNERPRD);
        this.allocSourceBill = (AllocSourceBillEnum)param.get("allocSourceBill");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map DoAllocate() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"27_AllocDispatch", (Locale)ctx.getLocale()));
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"28_AllocDispatch", (Locale)ctx.getLocale()));
        AUSContext ausCtx = new AUSContext(this._param);
        this.allocator = this.CreateAllocator(ausCtx);
        IBatchAllocIterator iterator = this.CreateBatchAllocIterator(this.allocator);
        Map ret = null;
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"29_AllocDispatch", (Locale)ctx.getLocale()));
        try {
            try {
                this.allocator.preCheck();
            }
            catch (Exception e) {
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"30_AllocDispatch", (Locale)ctx.getLocale()));
            try {
                this.allocator.preProcess();
            }
            catch (Exception e) {
                AllocateException ae = new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e);
                this._logger.AddLog(ae);
                log.error((Object)"", (Throwable)e);
                throw ae;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"31_AllocDispatch", (Locale)ctx.getLocale()));
            this.allocator.allocDirect();
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"32_AllocDispatch", (Locale)ctx.getLocale()));
            iterator.FirstBatch();
            while (!iterator.IsDone()) {
                iterator.AllocateCurrBatch();
                iterator.NextBatch();
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"33_AllocDispatch", (Locale)ctx.getLocale()));
            ret = this.allocator.processResult();
        }
        finally {
            this.allocator.endProcess();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            boolean isSuccessed = false;
            if (this._logger == null || this._logger.getLogCount() == 0) {
                isSuccessed = true;
            }
            NCMUtils.addEASLogForAlloc((Context)ctx, (String)"DoAllocate", (String)(company.getNumber() + ' ' + company.getName()), (AllocSourceBillEnum)this.allocSourceBill, (AllocTypeEnum)this.allocType, (String)this.companyId, (boolean)isSuccessed);
        }
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"34_AllocDispatch", (Locale)ctx.getLocale()));
        return ret;
    }

    private Allocator CreateAllocator(AUSContext ausCtx) {
        Allocator alloc = null;
        if (this.isMat) {
            alloc = "OtherInWarehs".equals(this._param.get("matType")) ? this.createOtherInWarehsAllocator(ausCtx) : ("CostAdjust".equals(this._param.get("matType")) ? this.createCostAdjustAllocator(ausCtx) : this.createManufactureRecAllocator(ausCtx));
        } else {
            switch (this.allocType.getValue()) {
                case 2: {
                    this._param.put("logTblName", "T_NCM_LOG_Other");
                    if (this._logger == null || this._logger.getLogCount() <= 0) {
                        this._logger = new AllocateExceptionLog(this._param);
                        this._param.put("logger", this._logger);
                    }
                    alloc = new AutoOtherAllocator(this._param, ausCtx);
                    break;
                }
                case 1: {
                    alloc = new ManuOtherAllocator(this._param, ausCtx);
                    break;
                }
                case 3: {
                    this._param.put("logTblName", "T_NCM_LOG_Other");
                    if (this._logger == null || this._logger.getLogCount() <= 0) {
                        this._logger = new AllocateExceptionLog(this._param);
                        this._param.put("logger", this._logger);
                    }
                    alloc = new WizOtherAllocator(this._param, ausCtx);
                }
            }
        }
        if (this.allocSourceBill != null && 5 == this.allocSourceBill.getValue()) {
            alloc = new AuxAllocator(this._param, (AUSContext)new AuxAUSContext(this._param));
        }
        return alloc;
    }

    private Allocator createOtherInWarehsAllocator(AUSContext ausCtx) {
        ManuOtherInWHAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_OtherInWH");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoOtherInWHAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuOtherInWHAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_OtherInWH");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new WizMatAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private Allocator createCostAdjustAllocator(AUSContext ausCtx) {
        ManuCostAdjustAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_CostAdjust");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoCostAdjustAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuCostAdjustAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_CostAdjust");
                this._logger = new AllocateExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new WizMatAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private Allocator createManufactureRecAllocator(AUSContext ausCtx) {
        ManuMatAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._param.put("logTblName", "T_NCM_LOG_Mat");
                if (this._logger == null || this._logger.getLogCount() <= 0) {
                    this._logger = new AllocateExceptionLog(this._param);
                    this._param.put("logger", this._logger);
                }
                alloc = new AutoMatAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                alloc = new ManuMatAllocator(this._param, ausCtx);
                break;
            }
            case 3: {
                this._param.put("logTblName", "T_NCM_LOG_Mat");
                if (this._logger == null || this._logger.getLogCount() <= 0) {
                    this._logger = new AllocateExceptionLog(this._param);
                    this._param.put("logger", this._logger);
                }
                alloc = new WizMatAllocator(this._param, ausCtx);
            }
        }
        return alloc;
    }

    private IBatchAllocIterator CreateBatchAllocIterator(Allocator allocatorAdapter) throws AllocateException {
        AutoMatBatchAllocIterator alloc = null;
        if (this.isMat) {
            switch (this.allocType.getValue()) {
                case 2: {
                    alloc = new AutoMatBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 1: {
                    alloc = new ManuMatBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 3: {
                    alloc = new WizMatBatchAllocIterator(this._param, allocatorAdapter);
                }
            }
        } else {
            switch (this.allocType.getValue()) {
                case 2: {
                    alloc = new AutoOtherBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 1: {
                    alloc = new ManuOtherBatchAllocIterator(this._param, allocatorAdapter);
                    break;
                }
                case 3: {
                    alloc = new WizOtherBatchAllocIterator(this._param, allocatorAdapter);
                }
            }
        }
        return alloc;
    }

    public AllocTypeEnum getAllocType() {
        return this.allocType;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }
}

