/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.rpt.FunctionWebserviceFacadeFactory;
import com.kingdee.eas.fi.rpt.IFunctionWebserviceFacade;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.FetchDataToOrderDirectionEnum;
import com.kingdee.eas.ncm.order.fact.bill.GLFetchDataToOrderEntryCollection;
import com.kingdee.eas.ncm.order.fact.bill.GLFetchDataToOrderEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.GLFetchDataToOrderException;
import com.kingdee.eas.ncm.order.fact.bill.GLFetchDataToOrderInfo;
import com.kingdee.eas.ncm.order.fact.bill.IOrderCCFeeBill;
import com.kingdee.eas.ncm.order.fact.bill.IOrderCCOFeeBill;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillEntryCollection;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCOFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCOFeeBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCOFeeEntryBillCollection;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCOFeeEntryBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.app.AbstractGLFetchDataToOrderControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class GLFetchDataToOrderControllerBean
extends AbstractGLFetchDataToOrderControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.bill.app.GLFetchDataToOrderControllerBean");
    private static final String RESOURCE_PATH = "com.kingdee.eas.ncm.order.fact.bill.GLFetchDataToOrderResource";
    private Map glEntryFeildsMap = new LinkedHashMap();
    private Map costCenter = new HashMap();
    private Map costCenterGroup = new HashMap();
    private Map expense = new HashMap();
    private Map costItem = new HashMap();
    private Map activity = new HashMap();
    private Map order = new HashMap();
    private Map department = new HashMap();
    private Map asstAcctMap = new HashMap();

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_GLDataToOrder";
    }

    @Override
    protected IObjectValue _checkFetchDataDup(Context ctx, String orgId, String periodId, IObjectValue value) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _checkBizDul(Context ctx, IObjectPK orgPk, IObjectPK periodPk, String costCenter, String fid) throws BOSException {
        return false;
    }

    @Override
    protected List _fetchData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof GLFetchDataToOrderInfo)) {
            return null;
        }
        GLFetchDataToOrderInfo glFetchDataInfo = (GLFetchDataToOrderInfo)model;
        GLFetchDataToOrderEntryCollection entrys = glFetchDataInfo.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            return null;
        }
        this.checkAccount(ctx, entrys);
        return super._submit(ctx, model);
    }

    @Override
    protected synchronized String _fetchData(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.initForFetchData();
        ArrayList orderCCFeeNumberList = new ArrayList();
        ArrayList orderCCOFeeNumberList = new ArrayList();
        for (int i = 0; i < ids.length; ++i) {
            List[] numbers;
            GLFetchDataToOrderInfo ov = (GLFetchDataToOrderInfo)BDCMUtils.getObjectValue((Context)ctx, (String)ids[i]);
            if (!BillBaseStatusEnum.AUDITED.equals((Object)ov.getBillStatus()) || (numbers = this.fetchDataNew(ctx, ov)) == null) continue;
            if (numbers[0] != null) {
                orderCCFeeNumberList.addAll(numbers[0]);
            }
            if (numbers[1] == null) continue;
            orderCCOFeeNumberList.addAll(numbers[1]);
        }
        return this.getGetchDataResult(ctx, orderCCFeeNumberList, orderCCOFeeNumberList);
    }

    private String getGetchDataResult(Context ctx, List otherNumberList, List ccoNumberList) throws EASBizException, BOSException {
        if (otherNumberList.size() == 0 && ccoNumberList.size() == 0) {
            return EASResource.getString((String)RESOURCE_PATH, (String)"NO_BILL");
        }
        String message_Output = "";
        if (otherNumberList.size() > 0) {
            String[] numbers_OtherFeeBill = new String[otherNumberList.size()];
            otherNumberList.toArray(numbers_OtherFeeBill);
            if (numbers_OtherFeeBill.length > 0) {
                message_Output = this.getMessage(numbers_OtherFeeBill, "OTHER_FEE");
            }
        }
        if (ccoNumberList.size() > 0) {
            String[] numbers_ccoFeeBill = new String[ccoNumberList.size()];
            ccoNumberList.toArray(numbers_ccoFeeBill);
            if (numbers_ccoFeeBill.length > 0) {
                message_Output = message_Output + " , ";
                message_Output = message_Output + this.getMessage(numbers_ccoFeeBill, "CCO_FEE");
            }
        }
        return EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA1") + message_Output + EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA4");
    }

    private List[] fetchDataNew(Context ctx, GLFetchDataToOrderInfo info) throws BOSException, EASBizException {
        if (info.getCompanyOrg() == null || info.getCalculatePeriod() == null) {
            return null;
        }
        BigDecimal[] result = this.getAcctBatchFetchData(ctx, info);
        this.clearPreviousData(ctx, info);
        List[] numbers = this.fetchDataByOverride(ctx, info, result);
        return numbers;
    }

    private void clearPreviousData(Context ctx, GLFetchDataToOrderInfo info) throws BOSException, EASBizException {
        Object[] params = new Object[]{info.getId().toString(), info.getCompanyOrg().getId().toString(), info.getCalculatePeriod().getId().toString()};
        this.clearDataInOtherFee(ctx, params, info);
        this.clearDataInCCOFee(ctx, params, info);
    }

    private List[] fetchDataByOverride(Context ctx, GLFetchDataToOrderInfo editData, BigDecimal[] result) throws BOSException, EASBizException {
        List[] diffdatas = this.diffData(editData, result);
        List numberList_OtherFee = this.fetchDataToOtherFee(ctx, editData, diffdatas[0], diffdatas[1]);
        List numberList_CCOFee = this.fetchDataToCCOFee(ctx, editData, diffdatas[2], diffdatas[3]);
        return new List[]{numberList_OtherFee, numberList_CCOFee};
    }

    private BigDecimal[] getAcctBatchFetchData(Context ctx, GLFetchDataToOrderInfo info) throws EASBizException, BOSException {
        PeriodInfo period = OrderCMUtils.getCurrentPeriod(ctx, info.getCompanyOrg().getId().toString());
        if (period != null) {
            info.setCalculatePeriod(period);
        }
        String[][] params_jf = this.getParams(ctx, info, "JF");
        String[][] params_df = this.getParams(ctx, info, "DF");
        IFunctionWebserviceFacade facade = FunctionWebserviceFacadeFactory.getLocalInstance((Context)ctx);
        String[] result_jf = facade.fetchData("acct", params_jf);
        String[] result_df = facade.fetchData("acct", params_df);
        return this.computeResult(info, result_jf, result_df);
    }

    private List fetchDataToOtherFee(Context ctx, GLFetchDataToOrderInfo editData, List entryCollection, List result) throws BOSException, EASBizException {
        if (entryCollection.size() <= 0 || result.size() <= 0) {
            return null;
        }
        this.putOtherFetchDataToMap(entryCollection, result);
        List numberList_OtherFee = this.getOtherFeeBillNumber(ctx, editData, entryCollection);
        this.glEntryFeildsMap.clear();
        if (numberList_OtherFee.size() > 0) {
            return numberList_OtherFee;
        }
        return null;
    }

    private List fetchDataToCCOFee(Context ctx, GLFetchDataToOrderInfo editData, List entryCollection, List result) throws BOSException, EASBizException {
        if (entryCollection.size() <= 0 || result.size() <= 0) {
            return null;
        }
        this.putCCOFetchDataToMap(entryCollection, result);
        List numberList_CCOFee = this.getCCOFeeBillNumber(ctx, editData, entryCollection);
        this.glEntryFeildsMap.clear();
        if (numberList_CCOFee.size() > 0) {
            return numberList_CCOFee;
        }
        return null;
    }

    private void putOtherFetchDataToMap(List entryCollection, List result) {
        String key = null;
        String costCenterID = null;
        String expenseID = null;
        String costItemID = null;
        String activityID = null;
        String orderID = null;
        String departmentID = null;
        ActivityInfo activityInfo = null;
        ManufactureOrderInfo orderInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        GLFetchDataToOrderEntryInfo entry = null;
        int count = entryCollection.size();
        for (int i = 0; i < count; ++i) {
            BigDecimal dataResult;
            if (result.get(i) == null || SysConstant.BIGZERO.compareTo(dataResult = (BigDecimal)result.get(i)) == 0) continue;
            entry = (GLFetchDataToOrderEntryInfo)entryCollection.get(i);
            costCenterID = entry.getCostCenter().getId().toString();
            expenseID = entry.getExpense().getId().toString();
            costItemID = entry.getCostItem().getId().toString();
            activityInfo = entry.getActivity();
            activityID = activityInfo != null ? activityInfo.getId().toString() : "";
            orderInfo = entry.getOrder();
            orderID = orderInfo != null ? orderInfo.getId().toString() : "";
            departmentInfo = entry.getDepartment();
            departmentID = departmentInfo != null ? departmentInfo.getId().toString() : "";
            key = costCenterID + ";" + expenseID + ";" + costItemID + ";" + activityID + ";" + orderID + ";" + departmentID;
            if (this.glEntryFeildsMap.containsKey(key)) {
                BigDecimal resultInMap = (BigDecimal)this.glEntryFeildsMap.get(key);
                this.glEntryFeildsMap.put(key, dataResult.add(resultInMap));
                continue;
            }
            this.glEntryFeildsMap.put(key, dataResult);
            this.costCenter.put(costCenterID, entry.getCostCenter());
            this.expense.put(expenseID, entry.getExpense());
            this.costItem.put(costItemID, entry.getCostItem());
            if (activityID.length() > 0) {
                this.activity.put(activityID, activityInfo);
            }
            if (orderID.length() > 0) {
                this.order.put(orderID, orderInfo);
            }
            if (departmentID.length() <= 0) continue;
            this.department.put(departmentID, departmentInfo);
        }
    }

    private void clearDataInOtherFee(Context ctx, Object[] params, GLFetchDataToOrderInfo info) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 fid From T_NCM_OrderCCFeeBill ").append(" Where FSourceBillID = ? And FCompanyOrg = ? And FCalculatePeriod = ? And Fivouchered = 1");
        IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
        boolean i = false;
        if (voucheredRS.size() > 0) {
            throw new GLFetchDataToOrderException(GLFetchDataToOrderException.OTHERFEEVOUCHERED, new String[]{info.getNumber()});
        }
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_OrderCCFeeBillEntry Where FId In ").append("(Select entry.FId ").append("From T_NCM_OrderCCFeeBill parent ").append("Left outer join T_NCM_OrderCCFeeBillEntry entry ").append("On parent.FId = entry.FParentID ").append("Where parent.FSourceBillID = ? And parent.FCompanyOrg = ? And parent.FCalculatePeriod = ? )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_OrderCCFeeBill ").append(" Where FSourceBillID = ? And FCompanyOrg = ? And FCalculatePeriod = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    private List getCCOFeeBillNumber(Context ctx, GLFetchDataToOrderInfo editData, List entryCollection) throws EASBizException, BOSException {
        String key = null;
        String expenseID = null;
        String costItemID = null;
        String costCenterGroupID = null;
        String departmentID = null;
        CostCenterOrgUnitGroupInfo costCenterGroupInfo = null;
        ExpenseInfo expenseInfo = null;
        CostItemInfo costItemInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        ArrayList<String> numberList_CCOFee = new ArrayList<String>();
        BigDecimal itemValue = SysConstant.BIGZERO;
        Iterator iterator = this.glEntryFeildsMap.keySet().iterator();
        int index1 = 0;
        int index2 = 0;
        int index3 = 0;
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            index1 = key.indexOf(";");
            costCenterGroupID = key.substring(0, index1);
            index2 = key.indexOf(";", index1 + 1);
            expenseID = key.substring(index1 + 1, index2);
            index3 = key.indexOf(";", index2 + 1);
            costItemID = key.substring(index2 + 1, index3);
            departmentID = key.substring(index3 + 1);
            costCenterGroupInfo = (CostCenterOrgUnitGroupInfo)this.costCenterGroup.get(costCenterGroupID);
            expenseInfo = (ExpenseInfo)this.expense.get(expenseID);
            costItemInfo = (CostItemInfo)this.costItem.get(costItemID);
            departmentInfo = departmentID != null && departmentID.length() > 0 ? (AdminOrgUnitInfo)this.department.get(departmentID) : null;
            itemValue = BDCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.glEntryFeildsMap.get(key)));
            String preNumber = this.getCCOPreNumber(ctx, editData);
            numberList_CCOFee.add(this.fetchDataToCCOFeeBill(ctx, editData, expenseInfo, costItemInfo, costCenterGroupInfo, departmentInfo, itemValue, preNumber));
        }
        return numberList_CCOFee;
    }

    private void clearDataInCCOFee(Context ctx, Object[] params, GLFetchDataToOrderInfo info) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 bill.fid ").append("From T_NCM_OrderCCOFeeBill bill, T_NCM_OrderCCOFeeEntryBill entry, T_NCM_OrderCCFeeBill otherFee ").append(" Where bill.fid = entry.FParentID and entry.fid = otherFee.FSourceBillID ").append("   and bill.FSourceBillID = ? And bill.FCompanyOrg = ? And bill.FCalculatePeriod = ? ");
        IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
        if (voucheredRS.size() > 0) {
            throw new GLFetchDataToOrderException(GLFetchDataToOrderException.CCOFEEALLOCATED, new String[]{info.getNumber()});
        }
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_OrderCCOFeeEntryBill Where FId In ").append("(Select entry.FId ").append("From T_NCM_OrderCCOFeeBill parent Left outer join T_NCM_OrderCCOFeeEntryBill entry ").append("On parent.FId = entry.FParentID ").append("Where parent.FSourceBillID = ? And parent.FCompanyOrg = ? And parent.FCalculatePeriod = ? )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_OrderCCOFeeBill ").append(" Where FSourceBillID = ? And FCompanyOrg = ? And FCalculatePeriod = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    private List[] diffData(GLFetchDataToOrderInfo editData, BigDecimal[] result) {
        ArrayList<GLFetchDataToOrderEntryInfo> dataToOther = new ArrayList<GLFetchDataToOrderEntryInfo>();
        ArrayList<BigDecimal> resultToOther = new ArrayList<BigDecimal>();
        ArrayList<GLFetchDataToOrderEntryInfo> dataToCCO = new ArrayList<GLFetchDataToOrderEntryInfo>();
        ArrayList<BigDecimal> resultToCCO = new ArrayList<BigDecimal>();
        GLFetchDataToOrderEntryCollection entryCollection = editData.getEntrys();
        int count = entryCollection.size();
        for (int i = 0; i < count; ++i) {
            GLFetchDataToOrderEntryInfo entry = entryCollection.get(i);
            if (entry.getCostCenter() != null) {
                dataToOther.add(entry);
                resultToOther.add(result[i]);
                continue;
            }
            if (entry.getCostCenterGroup() == null) continue;
            dataToCCO.add(entry);
            resultToCCO.add(result[i]);
        }
        return new List[]{dataToOther, resultToOther, dataToCCO, resultToCCO};
    }

    private String[][] getParams(Context ctx, GLFetchDataToOrderInfo editData, String fetchDataDirection) throws EASBizException, BOSException {
        String companyNumber = null;
        String accountItem = null;
        String year = "0";
        String period = "0";
        String currencyNumber = null;
        String accountNumber = null;
        ObjectUuidPK pk = new ObjectUuidPK(editData.getCompanyOrg().getId());
        CompanyOrgUnitInfo comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        companyNumber = comOrg.getNumber();
        PeriodInfo periodInfo = editData.getCalculatePeriod();
        year = Integer.toString(periodInfo.getPeriodYear());
        period = Integer.toString(periodInfo.getPeriodNumber());
        CurrencyInfo currencyInfo = comOrg.getBaseCurrency();
        if (currencyInfo == null) {
            throw new GLFetchDataToOrderException(GLFetchDataToOrderException.NULL_CURRENCY);
        }
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        currencyNumber = iCurrency.getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyInfo.getId().toString())).getNumber().toString();
        GLFetchDataToOrderEntryCollection entryCollection = editData.getEntrys();
        int count = entryCollection.size();
        String[][] params = new String[count][];
        GLFetchDataToOrderEntryInfo entryInfo = null;
        ObjectUuidPK accpk = null;
        AccountViewInfo accInfo = null;
        for (int i = 0; i < count; ++i) {
            entryInfo = entryCollection.get(i);
            accpk = new ObjectUuidPK(entryInfo.getAccount().getId());
            accInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)accpk);
            accountNumber = accInfo.getNumber();
            accountItem = accountNumber + ":" + accountNumber;
            if (entryInfo.getAsstAccount() != null) {
                accountItem = accountItem + entryInfo.getAsstAccount();
            }
            String[] params_row = new String[]{companyNumber, accountItem, fetchDataDirection, year, period, year, period, currencyNumber};
            params[i] = params_row;
        }
        return params;
    }

    private BigDecimal[] computeResult(GLFetchDataToOrderInfo editData, String[] result_jf, String[] result_df) throws EASBizException {
        GLFetchDataToOrderEntryCollection entryCollection = editData.getEntrys();
        int count = entryCollection.size();
        GLFetchDataToOrderEntryInfo entryInfo = null;
        BigDecimal[] result = new BigDecimal[count];
        BigDecimal jf = SysConstant.BIGZERO;
        BigDecimal df = SysConstant.BIGZERO;
        for (int i = 0; i < count; ++i) {
            entryInfo = entryCollection.get(i);
            FetchDataToOrderDirectionEnum fetchDataDirection = entryInfo.getFetchDataDirect();
            try {
                jf = new BigDecimal(result_jf[i]);
            }
            catch (Exception e) {
                this.showTheException(result_jf[i]);
            }
            try {
                df = new BigDecimal(result_df[i]);
            }
            catch (Exception e) {
                this.showTheException(result_df[i]);
            }
            result[i] = fetchDataDirection == FetchDataToOrderDirectionEnum.DEBIT ? jf : (fetchDataDirection == FetchDataToOrderDirectionEnum.CREDIT ? df : (fetchDataDirection == FetchDataToOrderDirectionEnum.DEBIT_CREDIT ? jf.subtract(df) : (fetchDataDirection == FetchDataToOrderDirectionEnum.CREDIT_DEBIT ? df.subtract(jf) : SysConstant.BIGZERO)));
        }
        return result;
    }

    private List getOtherFeeBillNumber(Context ctx, GLFetchDataToOrderInfo editData, List entryCollection) throws EASBizException, BOSException {
        String key = null;
        String costCenterID = null;
        String expenseID = null;
        String costItemID = null;
        String activityID = null;
        String orderID = null;
        String departmentID = null;
        CostCenterOrgUnitInfo costCenterInfo = null;
        ExpenseInfo expenseInfo = null;
        CostItemInfo costItemInfo = null;
        ActivityInfo activityInfo = null;
        ManufactureOrderInfo orderInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        ArrayList<String> numberList_OtherFee = new ArrayList<String>();
        BigDecimal itemValue = SysConstant.BIGZERO;
        Iterator iterator = this.glEntryFeildsMap.keySet().iterator();
        int index1 = 0;
        int index2 = 0;
        int index3 = 0;
        int index4 = 0;
        int index5 = 0;
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            index1 = key.indexOf(";");
            costCenterID = key.substring(0, index1);
            index2 = key.indexOf(";", index1 + 1);
            expenseID = key.substring(index1 + 1, index2);
            index3 = key.indexOf(";", index2 + 1);
            costItemID = key.substring(index2 + 1, index3);
            index4 = key.indexOf(";", index3 + 1);
            activityID = key.substring(index3 + 1, index4);
            index5 = key.indexOf(";", index4 + 1);
            orderID = key.substring(index4 + 1, index5);
            departmentID = key.substring(index5 + 1);
            costCenterInfo = (CostCenterOrgUnitInfo)this.costCenter.get(costCenterID);
            expenseInfo = (ExpenseInfo)this.expense.get(expenseID);
            costItemInfo = (CostItemInfo)this.costItem.get(costItemID);
            activityInfo = activityID != null && activityID.length() > 0 ? (ActivityInfo)this.activity.get(activityID) : null;
            orderInfo = orderID != null && orderID.length() > 0 ? (ManufactureOrderInfo)this.order.get(orderID) : null;
            departmentInfo = departmentID != null && departmentID.length() > 0 ? (AdminOrgUnitInfo)this.department.get(departmentID) : null;
            itemValue = BDCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.glEntryFeildsMap.get(key)));
            String preNumber = this.getOtherPreNumber(ctx, editData);
            numberList_OtherFee.add(this.fetchDataToOtherFeeBill(ctx, editData, costCenterInfo, expenseInfo, costItemInfo, activityInfo, orderInfo, departmentInfo, itemValue, preNumber));
        }
        return numberList_OtherFee;
    }

    private void putCCOFetchDataToMap(List entryCollection, List result) {
        String key = null;
        String expenseID = null;
        String costItemID = null;
        String costCenterGroupID = null;
        String departmentID = null;
        AdminOrgUnitInfo departmentInfo = null;
        BigDecimal resultData = null;
        GLFetchDataToOrderEntryInfo entry = null;
        BigDecimal resultInMap = null;
        int count = entryCollection.size();
        for (int i = 0; i < count; ++i) {
            if (result.get(i) == null || SysConstant.BIGZERO.compareTo(resultData = (BigDecimal)result.get(i)) == 0) continue;
            entry = (GLFetchDataToOrderEntryInfo)entryCollection.get(i);
            expenseID = entry.getExpense().getId().toString();
            costItemID = entry.getCostItem().getId().toString();
            costCenterGroupID = entry.getCostCenterGroup().getId().toString();
            departmentInfo = entry.getDepartment();
            departmentID = departmentInfo != null ? departmentInfo.getId().toString() : "";
            key = costCenterGroupID + ";" + expenseID + ";" + costItemID + ";" + departmentID;
            if (this.glEntryFeildsMap.containsKey(key)) {
                resultInMap = (BigDecimal)this.glEntryFeildsMap.get(key);
                this.glEntryFeildsMap.put(key, resultData.add(resultInMap));
                continue;
            }
            this.glEntryFeildsMap.put(key, resultData);
            this.costCenterGroup.put(costCenterGroupID, entry.getCostCenterGroup());
            this.expense.put(expenseID, entry.getExpense());
            this.costItem.put(costItemID, entry.getCostItem());
            if (departmentID.length() <= 0) continue;
            this.department.put(departmentID, departmentInfo);
        }
    }

    private String fetchDataToCCOFeeBill(Context ctx, GLFetchDataToOrderInfo editData, ExpenseInfo expenseInfo, CostItemInfo costItemInfo, CostCenterOrgUnitGroupInfo costCenterGroupInfo, AdminOrgUnitInfo departmentInfo, BigDecimal result, String newNumber) throws EASBizException, BOSException {
        OrderCCOFeeBillInfo newCCOFeeInfo = new OrderCCOFeeBillInfo();
        newCCOFeeInfo.setIsAuto(true);
        newCCOFeeInfo.setCU(editData.getCU());
        newCCOFeeInfo.setNumber(newNumber);
        newCCOFeeInfo.setCompanyOrg(editData.getCompanyOrg());
        newCCOFeeInfo.setCostCenterGroup(costCenterGroupInfo);
        newCCOFeeInfo.setExpense(expenseInfo);
        newCCOFeeInfo.setSourceBillId(editData.getId().toString());
        newCCOFeeInfo.setSourceFunction(editData.getNumber() + "-" + editData.getDescription());
        newCCOFeeInfo.setDepartment(departmentInfo);
        PeriodInfo p = this.fullPeriod(ctx, editData.getCalculatePeriod());
        newCCOFeeInfo.setBizDate(p.getEndDate());
        newCCOFeeInfo.setCalculatePeriod(editData.getCalculatePeriod());
        newCCOFeeInfo.setBillStatus(BillBaseStatusEnum.AUDITED);
        newCCOFeeInfo.setAuditor(editData.getCreator());
        newCCOFeeInfo.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
        OrderCCOFeeEntryBillInfo entryInfo = new OrderCCOFeeEntryBillInfo();
        entryInfo.setCostItem(costItemInfo);
        entryInfo.setAmount(result);
        OrderCCOFeeEntryBillCollection collections = newCCOFeeInfo.getEntries();
        collections.add(entryInfo);
        IOrderCCOFeeBill iCCOFeeBill = OrderCCOFeeBillFactory.getLocalInstance(ctx);
        IObjectPK pk = iCCOFeeBill.addnew(newCCOFeeInfo);
        String number = iCCOFeeBill.getOrderCCOFeeBillInfo(pk).getNumber().toString();
        return number;
    }

    private String fetchDataToOtherFeeBill(Context ctx, GLFetchDataToOrderInfo editData, CostCenterOrgUnitInfo costCenterInfo, ExpenseInfo expenseInfo, CostItemInfo costItemInfo, ActivityInfo activityInfo, ManufactureOrderInfo orderInfo, AdminOrgUnitInfo departmentInfo, BigDecimal result, String newNumber) throws EASBizException, BOSException {
        boolean isExist = false;
        String number = null;
        OrderCCFeeBillInfo newOtherFeeInfo = null;
        OrderCCFeeBillEntryInfo entryInfo = null;
        OrderCCFeeBillEntryCollection collection = null;
        OrderCCFeeBillInfo OtherFeeBillInfo = null;
        if (OtherFeeBillInfo == null) {
            newOtherFeeInfo = new OrderCCFeeBillInfo();
            newOtherFeeInfo.setIsAuto(true);
            newOtherFeeInfo.setCU(editData.getCU());
            newOtherFeeInfo.setNumber(newNumber);
            newOtherFeeInfo.setCompanyOrg(editData.getCompanyOrg());
            newOtherFeeInfo.setCostCenter(costCenterInfo);
            newOtherFeeInfo.setExpense(expenseInfo);
            newOtherFeeInfo.setSourceBillId(editData.getId().toString());
            newOtherFeeInfo.setSourceFunction(editData.getNumber() + "-" + editData.getDescription());
            newOtherFeeInfo.setDepartment(departmentInfo);
            PeriodInfo p = this.fullPeriod(ctx, editData.getCalculatePeriod());
            newOtherFeeInfo.setBizDate(p.getEndDate());
            newOtherFeeInfo.setCalculatePeriod(editData.getCalculatePeriod());
            newOtherFeeInfo.setFivouchered(false);
            newOtherFeeInfo.setBillStatus(BillBaseStatusEnum.AUDITED);
            newOtherFeeInfo.setAuditor(editData.getCreator());
            newOtherFeeInfo.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
            isExist = false;
        } else {
            newOtherFeeInfo = OtherFeeBillInfo;
            isExist = true;
        }
        entryInfo = new OrderCCFeeBillEntryInfo();
        entryInfo.setCostItem(costItemInfo);
        entryInfo.setAmount(result);
        entryInfo.setActivity(activityInfo);
        entryInfo.setManufactureOrder(orderInfo);
        if (newOtherFeeInfo != null) {
            collection = newOtherFeeInfo.getEntries();
            int count = collection.size();
            if (count > 0) {
                for (int i = count - 1; i >= 0; --i) {
                    OrderCCFeeBillEntryInfo temp_entryInfo = collection.get(i);
                    if (!temp_entryInfo.getCostItem().getId().toString().equals(costItemInfo.getId().toString())) continue;
                    collection.removeObject(i);
                }
            }
            collection.add(entryInfo);
            newOtherFeeInfo.put("entrys", (Object)collection);
        }
        IOrderCCFeeBill iOtherFeeBill = OrderCCFeeBillFactory.getLocalInstance(ctx);
        if (!isExist) {
            IObjectPK pk = iOtherFeeBill.addnew(newOtherFeeInfo);
            number = iOtherFeeBill.getOrderCCFeeBillInfo(pk).getNumber().toString();
        } else {
            iOtherFeeBill.update((IObjectPK)new ObjectStringPK(newOtherFeeInfo.getId().toString()), newOtherFeeInfo);
            number = newOtherFeeInfo.getNumber();
        }
        return number;
    }

    private String getCCOPreNumber(Context ctx, GLFetchDataToOrderInfo editData) throws EASBizException, BOSException {
        return this.getPreNumber("OrderCCOFee", ctx, editData, new OrderCCOFeeBillInfo());
    }

    private void showTheException(String errorMsg) throws CMBillException {
        String mesg = "error exsit!";
        if (errorMsg != null) {
            mesg = errorMsg.replaceAll("#BAD FUNCTION ", "");
        }
        throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{mesg});
    }

    private String getOtherPreNumber(Context ctx, GLFetchDataToOrderInfo editData) throws EASBizException, BOSException {
        return this.getPreNumber("CCFee", ctx, editData, new OrderCCFeeBillInfo());
    }

    private PeriodInfo fullPeriod(Context ctx, PeriodInfo period) throws EASBizException, BOSException {
        PeriodInfo p = period;
        if (period != null && period.getId() != null && period.getEndDate() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("startDate"));
            selector.add(new SelectorItemInfo("endDate"));
            p = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(period.getId().toString()), selector);
        }
        return p;
    }

    private boolean checkCodingRule(Context ctx, String strCompanyID, IObjectValue aCMBillBaseInfo) throws BOSException, EASBizException {
        ICodingRuleManager icrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus rStatus = icrm.getRuleStatus(aCMBillBaseInfo, strCompanyID);
        if (rStatus.isExist()) {
            // empty if block
        }
        return rStatus.isExist();
    }

    private String getPreNumber(String preNumber, Context ctx, GLFetchDataToOrderInfo editData, CMBillBaseInfo info) throws EASBizException, BOSException {
        boolean hasCodingRule = this.checkCodingRule(ctx, editData.getCompanyOrg().getId().toString(), (IObjectValue)info);
        if (!hasCodingRule) {
            SecureRandom secureRandom = new SecureRandom();
            Timestamp now = BDCMUtils.DateToTime((Date)BDCMUtils.now());
            preNumber = preNumber + now.getYear() + now.getMonth() + now.getDay() + now.getHours() + now.getMinutes() + now.getSeconds() + secureRandom.nextInt(100);
        } else {
            info.setCompanyOrg(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(editData.getCompanyOrg().getId().toString())));
            ICodingRuleManager icrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            preNumber = icrm.getNumber((IObjectValue)info, editData.getCompanyOrg().getId().toString());
        }
        return preNumber;
    }

    private void initForFetchData() {
        this.glEntryFeildsMap.clear();
        this.costCenter.clear();
        this.costCenterGroup.clear();
        this.expense.clear();
        this.costItem.clear();
        this.activity.clear();
        this.order.clear();
        this.department.clear();
        this.asstAcctMap.clear();
    }

    private String getMessage(String[] numbers, String resourceType) {
        return EASResource.getString((String)RESOURCE_PATH, (String)resourceType) + EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA2") + numbers[0] + EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA3") + numbers[numbers.length - 1];
    }

    private void checkAccount(Context ctx, GLFetchDataToOrderEntryCollection entrys) throws GLFetchDataToOrderException, BOSException {
        String accountID1 = null;
        String accountID2 = null;
        String accountNumber1 = null;
        String accountNumber2 = null;
        String asstAccount1 = null;
        String asstAccount2 = null;
        String asstAccountId1 = null;
        String asstAccountId2 = null;
        AccountViewInfo acctView1 = null;
        AccountViewInfo acctView2 = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            acctView1 = entrys.get(i).getAccount();
            accountID1 = acctView1.getId().toString();
            accountNumber1 = acctView1.getNumber();
            asstAccount1 = entrys.get(i).getAsstAccount();
            asstAccountId1 = entrys.get(i).getAsstAccountID();
            int size2 = entrys.size();
            for (int j = i + 1; j < size2; ++j) {
                acctView2 = entrys.get(j).getAccount();
                accountID2 = acctView2.getId().toString();
                accountNumber2 = acctView2.getNumber();
                asstAccount2 = entrys.get(j).getAsstAccount();
                asstAccountId2 = entrys.get(j).getAsstAccountID();
                if (!accountID1.equals(accountID2) && !accountNumber1.startsWith(accountNumber2) && !accountNumber2.startsWith(accountNumber1) || !this.isOverlap(ctx, asstAccount1, asstAccount2, asstAccountId1, asstAccountId2)) continue;
                throw new GLFetchDataToOrderException(GLFetchDataToOrderException.OVERLAP_ASSTACCOUNT, new Object[]{new Integer(i + 1), new Integer(j + 1)});
            }
        }
    }

    private boolean isOverlap(Context ctx, String asstAccount1, String asstAccount2, String asstAccountId1, String asstAccountId2) throws BOSException {
        if (asstAccount1 == null || asstAccount2 == null) {
            return true;
        }
        if (asstAccount1.length() == 0 || asstAccount2.length() == 0) {
            return true;
        }
        ArrayList<String> asstActTypeList = new ArrayList<String>();
        HashMap<String, String> asstActNumbers1 = new HashMap<String, String>();
        if (asstAccount1 != null) {
            String[] temp = this.splitString(asstAccount1);
            String[] tempId = this.splitString(asstAccountId1);
            Object asstAcctId = null;
            Object asstAcctInfo = null;
            int count = temp.length;
            for (int i = 0; i < count; i += 2) {
                asstActNumbers1.put(temp[i], tempId[i + 1]);
                asstActTypeList.add(temp[i]);
            }
        }
        HashMap<String, String> asstActNumbers2 = new HashMap<String, String>();
        if (asstAccount2 != null) {
            String[] temp = this.splitString(asstAccount2);
            String[] tempId = this.splitString(asstAccountId2);
            Object asstAcctId = null;
            Object asstAcctInfo = null;
            int count = temp.length;
            for (int i = 0; i < count; i += 2) {
                asstActNumbers2.put(temp[i], tempId[i + 1]);
            }
        }
        String asstActNumber1 = null;
        String asstActNumber2 = null;
        String asstActNumber11 = null;
        String asstActNumber12 = null;
        String asstActNumber21 = null;
        String asstActNumber22 = null;
        String asstAcctId = null;
        IObjectValue asstAcctInfo = null;
        int index = 0;
        String asstActKey = null;
        Object o = null;
        int count = asstActTypeList.size();
        for (int i = 0; i < count; ++i) {
            asstActKey = asstActTypeList.get(i).toString();
            o = asstActNumbers1.get(asstActKey);
            asstActNumber1 = o == null ? ":" : asstActNumbers1.get(asstActKey).toString();
            o = asstActNumbers2.get(asstActKey);
            asstActNumber2 = o == null ? ":" : asstActNumbers2.get(asstActKey).toString();
            index = asstActNumber1.indexOf(":");
            asstAcctId = asstActNumber1.substring(0, index);
            asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId);
            asstActNumber11 = asstAcctInfo.getString("longNumber");
            if (asstActNumber11 == null) {
                asstActNumber11 = asstAcctInfo.getString("number");
            }
            if ((asstActNumber12 = (asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId = asstActNumber1.substring(index + 1)) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId)).getString("longNumber")) == null) {
                asstActNumber12 = asstAcctInfo.getString("number");
            }
            if ((asstActNumber21 = (asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId = asstActNumber2.substring(0, index = asstActNumber2.indexOf(":"))) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId)).getString("longNumber")) == null) {
                asstActNumber21 = asstAcctInfo.getString("number");
            }
            if ((asstActNumber22 = (asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId = asstActNumber2.substring(index + 1)) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId)).getString("longNumber")) == null) {
                asstActNumber22 = asstAcctInfo.getString("number");
            }
            int compare1 = 0;
            int compare2 = 0;
            compare1 = asstActNumber12.equals("") ? 1 : asstActNumber12.compareTo(asstActNumber21);
            compare2 = asstActNumber22.equals("") ? -1 : asstActNumber11.compareTo(asstActNumber22);
            if (compare1 >= 0 && compare2 <= 0) continue;
            return false;
        }
        return true;
    }

    private IObjectValue getDynamicObject(Context ctx, String bosId) throws BOSException {
        IObjectValue objectValue = null;
        if (bosId != null && bosId.trim().length() != 0) {
            BOSUuid uuid = BOSUuid.read((String)bosId);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
        }
        return objectValue;
    }

    private String[] splitString(String str) {
        ArrayList<String> stringList = new ArrayList<String>();
        Pattern pt = Pattern.compile("([^\\|]{1,})");
        Matcher matcher = pt.matcher(str);
        String v = null;
        while (matcher.find()) {
            v = matcher.group(1).trim().toString();
            stringList.add(v);
        }
        String[] result = new String[stringList.size()];
        stringList.toArray(result);
        return result;
    }

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    protected void _checkStart(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
    }
}

