/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.order.fact.bill.DataInputModeEnum;
import com.kingdee.eas.ncm.order.fact.bill.OrderBillException;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillHourEntryCollection;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillHourEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillQtyEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.app.AbstractOrderReportBillControllerBean;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrderReportBillControllerBean
extends AbstractOrderReportBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderReportBillControllerBean");

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_OrderReportBill";
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof OrderReportBillInfo)) {
            return null;
        }
        OrderReportBillInfo orderReportBillInfo = (OrderReportBillInfo)model;
        if (orderReportBillInfo.getHourEntries() == null || orderReportBillInfo.getHourEntries().size() == 0) {
            return null;
        }
        OrderReportBillHourEntryCollection entry = orderReportBillInfo.getHourEntries();
        Iterator iter = entry.iterator();
        while (iter.hasNext()) {
            OrderReportBillHourEntryInfo entryInfo = (OrderReportBillHourEntryInfo)iter.next();
            String unit = entryInfo.getUnit().getValue();
            int factor = 1;
            if ("1".equals(unit)) {
                factor = 3600;
            }
            if ("2".equals(unit)) {
                factor = 60;
            }
            BigDecimal prepareTime = entryInfo.getPrepareTime();
            BigDecimal poressTime = entryInfo.getProcessTime();
            if (prepareTime == null) {
                prepareTime = new BigDecimal(0);
            }
            if (poressTime == null) {
                poressTime = new BigDecimal(0);
            }
            prepareTime = prepareTime.multiply(new BigDecimal(factor));
            poressTime = poressTime.multiply(new BigDecimal(factor));
            entryInfo.setPrepareTime(prepareTime);
            entryInfo.setProcessTime(poressTime);
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrderReportBillInfo orderReportBillInfo = (OrderReportBillInfo)model;
        orderReportBillInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        OrderReportBillHourEntryCollection entry = orderReportBillInfo.getHourEntries();
        Iterator iter = entry.iterator();
        while (iter.hasNext()) {
            OrderReportBillHourEntryInfo entryInfo = (OrderReportBillHourEntryInfo)iter.next();
            String unit = entryInfo.getUnit().getValue();
            int factor = 1;
            if ("1".equals(unit)) {
                factor = 3600;
            }
            if ("2".equals(unit)) {
                factor = 60;
            }
            BigDecimal prepareTime = entryInfo.getPrepareTime();
            BigDecimal poressTime = entryInfo.getProcessTime();
            if (prepareTime == null) {
                prepareTime = new BigDecimal(0);
            }
            if (poressTime == null) {
                poressTime = new BigDecimal(0);
            }
            prepareTime = prepareTime.multiply(new BigDecimal(factor));
            poressTime = poressTime.multiply(new BigDecimal(factor));
            entryInfo.setPrepareTime(prepareTime);
            entryInfo.setProcessTime(poressTime);
        }
        return super._save(ctx, model);
    }

    protected Map bizCheckForSubmit(Context ctx, List ids) throws BOSException, EASBizException {
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsParam.add(new Object[]{ids.get(i)});
        }
        final String manufacturerIsNull = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"OrderReportBillContr_NO_ManufactutreOrder");
        final String bizDateIsNull = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"CCFeeBillContrl_NO_BizDate");
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID,FManuFacturerOrderID,FBizDate \n");
        kSql.append("   from T_NCM_OrderReportBill \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FManuFacturerOrderID is null or FBizDate is null) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                String manufacturerID = rs.getString("FManuFacturerOrderID");
                Date date = rs.getDate("FBizDate");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (manufacturerID == null || manufacturerID.length() == 0) {
                    detail.add(manufacturerIsNull);
                }
                if (date == null) {
                    detail.add(bizDateIsNull);
                }
                report.put(id, detail);
            }
        });
        final String noEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"CCFeeBillContrl_NO_Entry");
        kSql.setLength(0);
        kSql.append(" select FID \n");
        kSql.append("   from T_NCM_OrderReportBill \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and FID not in (select FParentID from T_NCM_OrderReportBillHourEntry  \n");
        kSql.append("                    UNION ALL \n");
        kSql.append("                    select FParentID From T_NCM_OrderReportBillQtyEntry) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add(noEntry);
                report.put(id, detail);
            }
        });
        final String message = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"Bill_Entry");
        final String noCostCenterEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"CCFeeBillContrl_NO_CostCenter");
        final String noActivitynEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"OrderReportBill_NO_Activity");
        final String noUnitEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"OrderReportBill_NO_Unit");
        kSql.setLength(0);
        kSql.append(" select FParentID, FCostCenterID, FActivityID, FUnit, FPrepareTime, FProcessTime \n");
        kSql.append("   from T_NCM_OrderReportBillHourEntry \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostCenterID is null  \n");
        kSql.append("    or FActivityID is null \n");
        kSql.append("    or FUnit is null) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FParentID");
                String costCenterID = rs.getString("FCostCenterID");
                String activityID = rs.getString("FActivityID");
                String unit = rs.getString("FUnit");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costCenterID == null || costCenterID.length() == 0) {
                    detail.add(message + noCostCenterEntry);
                }
                if (activityID == null || activityID.length() == 0) {
                    detail.add(message + noActivitynEntry);
                }
                if (unit == null || unit.length() == 0) {
                    detail.add(message + noUnitEntry);
                }
                report.put(id, detail);
            }
        });
        final String messageQty = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"Bill_Entry");
        final String noCostCenterQtyEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"CCFeeBillContrl_NO_CostCenter");
        final String noActivitynQtyEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"OrderReportBill_NO_Activity");
        final String noUnitQtyEntry = EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"OrderReportBill_NO_Unit");
        kSql.setLength(0);
        kSql.append(" select Fseq,FParentID, FCostCenterID, FActivityID, FUnit, \n");
        kSql.append(" FReportQty, FDetectQty, FQualifiedQty, FYieldQty, FScrapQty, FWorkerScrapQty, FSteelScrapQty, FRepairQty \n");
        kSql.append("   from T_NCM_OrderReportBillQtyEntry \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostCenterID is null  \n");
        kSql.append("    or FActivityID is null \n");
        kSql.append("    or FUnit is null) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FParentID");
                String seq = rs.getString("Feq");
                String costCenterID = rs.getString("FCostCenterID");
                String activityID = rs.getString("FActivityID");
                String unit = rs.getString("FUnit");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costCenterID == null || costCenterID.length() == 0) {
                    detail.add(messageQty + seq + noCostCenterQtyEntry);
                }
                if (activityID == null || activityID.length() == 0) {
                    detail.add(messageQty + seq + noActivitynQtyEntry);
                }
                if (unit == null || unit.length() == 0) {
                    detail.add(messageQty + seq + noUnitQtyEntry);
                }
                report.put(id, detail);
            }
        });
        return report;
    }

    @Override
    protected String _importFromMM(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        String dealReuslt = "Failure";
        boolean isExistCodingRule = this.isExistCodingRule(ctx, new OrderReportBillInfo(), companyInfo.getId().toString());
        if (!isExistCodingRule) {
            throw new CMBillException(CMBillException.NOCORDRULE, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.app.OrderBillAppResource", (String)"OrderReportBill_Title")});
        }
        Set conditions = new HashSet();
        conditions = this.getStorageCondition_Hour(ctx, companyInfo);
        String stempTableName_Hour = this.createInductHourDataTable(ctx);
        Set StorageIDSet = null;
        StorageIDSet = this.getStorageCondition_Qty(ctx, companyInfo);
        String stempTableName_Qty = this.createInductQtyDataTable(ctx);
        String stmepName = this.createInductQtyDataTempTable(ctx);
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = null;
        try {
            this.deleteLastImportData(ctx, companyInfo.getId().toString());
            periodInfo = ibiz.getCacheCurrentPeriod(1010, companyInfo.getId().toString());
            dealReuslt = ManufactureOrderFacadeFactory.getLocalInstance((Context)ctx).getFetchHourDataByBill(periodInfo, conditions, stempTableName_Hour);
            this.chekProcess(ctx, stempTableName_Hour);
            this.insertIntoHourData(ctx, companyInfo.getId().toString(), stempTableName_Hour);
            ManufactureOrderFacadeFactory.getLocalInstance((Context)ctx).getOCOrderQtyDataByBill(periodInfo, StorageIDSet, stempTableName_Qty);
            this.chekProcess(ctx, stempTableName_Qty);
            this.insertIntoQtyData(ctx, companyInfo.getId().toString(), stempTableName_Qty, stmepName, stempTableName_Hour);
            this.checkImportData(ctx, companyInfo.getId().toString());
            dealReuslt = "Success";
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(stempTableName_Hour);
        }
        return dealReuslt;
    }

    private String createInductHourDataTable(Context ctx) throws BOSException {
        String stempTableName;
        StringBuffer createSql = new StringBuffer();
        createSql.append(" CREATE TABLE t1(");
        createSql.append("FStorageID varchar(44),");
        createSql.append(" FProcessID varchar(44),");
        createSql.append("FManufactureOrderID varchar(44),");
        createSql.append("FCostCenterID varchar(44),");
        createSql.append("FCostObjectID varchar(44),");
        createSql.append("FActivity varchar(44),");
        createSql.append("FHourType int ,");
        createSql.append("FTimeUnit int ,");
        createSql.append("FIsTotoal int default(0),");
        createSql.append("FHourSecond decimal(28,13) not null default(0))");
        try {
            stempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return stempTableName;
    }

    private String createInductQtyDataTable(Context ctx) throws BOSException {
        String stempTableName;
        StringBuffer createSql = new StringBuffer();
        createSql.append(" CREATE TABLE t1(");
        createSql.append("FID varchar(44),");
        createSql.append("FManufactureOrderID varchar(44),");
        createSql.append("FStorageID varchar(44),");
        createSql.append(" FProcessID varchar(44),");
        createSql.append("FIsEndProcess int ,");
        createSql.append("FIsFirstProcess int ,");
        createSql.append("FCostCenterID varchar(44),");
        createSql.append("FReportQty decimal(28,10) ,");
        createSql.append("FDetectQty decimal(28,10),");
        createSql.append("FQualifiedQty decimal(28,10),");
        createSql.append("FYieldQty decimal(28,10),");
        createSql.append("FScrapQty decimal(28,10),");
        createSql.append("FWorkerScrapQty decimal(28,10),");
        createSql.append("FSteelScrapQty decimal(28,10),");
        createSql.append("FRepairQty decimal(28,10),");
        createSql.append("FUnitID VARCHAR(44),");
        createSql.append("FPrepareTime decimal(28,10),");
        createSql.append("FProcessTime decimal(28,10),");
        createSql.append("FTimeUnit VARCHAR(44))");
        try {
            stempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return stempTableName;
    }

    private String createInductQtyDataTempTable(Context ctx) throws BOSException {
        String stempName;
        StringBuffer createSql = new StringBuffer();
        createSql.append(" CREATE TABLE t1(");
        createSql.append("FID varchar(44),");
        createSql.append("FManufactureOrderID varchar(44),");
        createSql.append("FManufactureOrderNumber nvarchar(80),");
        createSql.append("FLot nvarchar(80),");
        createSql.append("FStorageUnit varchar(44),");
        createSql.append("Fproject varchar(255),");
        createSql.append("FTrankNUmber varchar(255),");
        createSql.append("FProductNumber varchar(255),");
        createSql.append("FProductName varchar(255),");
        createSql.append("FActivity varchar(44),");
        createSql.append("FCostCenterID varchar(44),");
        createSql.append("FHourType int,");
        createSql.append("FUnit VARCHAR(255),");
        createSql.append("FUnitID varchar(44),");
        createSql.append("FReportQty decimal(28,10),");
        createSql.append("FDetectQty decimal(28,10),");
        createSql.append("FQualifiedQty decimal(28,10),");
        createSql.append("FYieldQty decimal(28,10),");
        createSql.append("FScrapQty decimal(28,10),");
        createSql.append("FWorkerScrapQty decimal(28,10),");
        createSql.append("FSteelScrapQty decimal(28,10),");
        createSql.append("FRepairQty decimal(28,10),");
        createSql.append("FOperationNo VARCHAR(255),");
        createSql.append("FPrepareTime decimal(28,10),");
        createSql.append("FProcessTime decimal(28,10),");
        createSql.append("FTimeUnit VARCHAR(44))");
        try {
            stempName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return stempName;
    }

    private Set getStorageCondition_Hour(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashSet storageCondition = new HashSet();
        Set storageSet = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyInfo.getId().toString());
        if (storageSet != null && storageSet.size() > 0) {
            Iterator iter = storageSet.iterator();
            while (iter.hasNext()) {
                HashMap<String, String> condition = new HashMap<String, String>();
                String storageInfoID = iter.next().toString();
                if (storageInfoID == null) continue;
                condition.put("_storage", storageInfoID);
                storageCondition.add(condition);
            }
        }
        return storageCondition;
    }

    private Set getStorageCondition_Qty(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashSet<String> storageCondition = new HashSet<String>();
        Set storageSet = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyInfo.getId().toString());
        if (storageSet != null && storageSet.size() > 0) {
            Iterator iter = storageSet.iterator();
            while (iter.hasNext()) {
                String storageInfoID = iter.next().toString();
                storageCondition.add(storageInfoID);
            }
        }
        return storageCondition;
    }

    private boolean insertIntoHourData(Context ctx, String companyID, String stempTableName) throws EASBizException, BOSException, SQLException {
        StringBuffer getData = new StringBuffer();
        getData.append(" insert into " + stempTableName + " (FStorageID,FManufactureOrderID,FActivity,FHourType,FTimeUnit,FIsTotoal,FHourSecond)").append(" Select company.FID as FStorageUnit,data.FManufactureOrderID as FManufactureOrderID,activityEntry.FParentID,  \n").append("        FHourType, max(data.FTimeUnit),1, sum(FHourSecond) as FQty \n").append(" From " + stempTableName + " AS data \n").append("        Inner Join T_MM_ManufactureOrder AS order1 \n").append("        on data.FManufactureOrderID = order1.Fid \n").append("        Left Outer Join T_MM_Project project \n").append("        on order1.FProjectid = project.Fid \n").append("        Left Outer Join T_MM_TrackNumber trankNumber \n").append("        on order1.FTrackID = trankNumber.Fid \n").append("        Left Outer Join T_BD_Material material\n").append("        on order1.FMaterialID = material.Fid \n").append("        Inner Join T_NCM_ActivityOperation activityEntry \n").append("        on data.FProcessID = activityEntry.FOperationID \n").append("        Inner Join T_NCM_Activity activity \n").append("        on activityEntry.FParentID = activity.Fid \n").append("        Inner Join T_ORG_Storage company \n").append("        on company.FID = data.FStorageID \n").append("    Where FHourSecond <> 0 and (FHourType = 7 or FHourType = 8)\n").append(" group by FManufactureOrderID, company.FID, project.FID, trankNumber.FID \n").append("          , material.FID,material.FName_l2, activityEntry.FParentID, activity.FCostCenterID, FHourType, order1.FNumber,order1.FLot \n").append("  order by data.FManufactureOrderID, activityEntry.FParentID \n");
        DBUtil.execute((Context)ctx, (String)getData.toString());
        return true;
    }

    private boolean insertIntoQtyData(Context ctx, String companyID, String stempTableName, String stempName, String stempTableName_Hour) throws EASBizException, BOSException, SQLException {
        boolean result = false;
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1010, companyID);
        StringBuffer getData = new StringBuffer();
        getData.append(" insert Into  " + stempName).append(" (Fid,FManufactureOrderID,FManufactureOrderNumber,FLot,FStorageUnit,Fproject,FTrankNUmber,FProductNumber,FProductName,FActivity, \n").append("  FCostCenterID,FHourType,FUnit,FUnitID,FReportQty, FDetectQty, FQualifiedQty, FYieldQty, FScrapQty, FWorkerScrapQty, FSteelScrapQty, FRepairQty,FOperationNo) \n").append("  Select NEWBOSID('6F79A4B6') as fid,data.FManufactureOrderID as FManufactureOrderID,order1.FNumber as FManufactureOrderNumber, order1.FLot as FLot, \n").append("  company.FID as FStorageUnit, project.FID as Fproject, trankNumber.FID as FTrankNUmber, material.FID as FProductNumber, \n").append("        material.FName_l2 as FProductName, activityEntry.FParentID as FActivity, activity.FCostCenterID as FCostCenterID,\n").append("        0 as FHourType, unit.FName_l2 as FUnit, unit.FID as FUnitID, sum(isnull(data.FReportQty,0)), sum(isnull(data.FDetectQty,0)), sum(isnull(data.FQualifiedQty,0)), \n").append("        sum(isnull(data.FYieldQty,0)), sum(isnull(data.FScrapQty,0)), sum(isnull(data.FWorkerScrapQty,0)), sum(isnull(data.FSteelScrapQty,0)), sum(isnull(data.FRepairQty,0)),TO_Char(tech.FOperationNo) as FOperationNo ").append(" From " + stempTableName + "\n").append("  AS data \n").append("        Inner Join T_MM_ManufactureOrder AS order1 \n").append("        on data.FManufactureOrderID = order1.Fid \n").append("        Left Outer Join T_MM_Project project \n").append("        on order1.FProjectid = project.Fid \n").append("        Left Outer Join T_MM_TrackNumber trankNumber \n").append("        on order1.FTrackID = trankNumber.Fid \n").append("        Left Outer Join T_BD_Material material\n").append("        on order1.FMaterialID = material.Fid \n").append("        Inner Join T_NCM_ActivityOperation activityEntry \n").append("        on data.FProcessID = activityEntry.FOperationID \n").append("        Inner Join T_NCM_Activity activity \n").append("        on activityEntry.FParentID = activity.Fid \n").append("        Inner Join T_BD_MeasureUnit unit \n").append("        on unit.FID = data.FUnitID \n").append("        Inner Join T_ORG_Storage company on company.FID = data.FStorageID  \n").append("        inner Join T_MM_MFTOrderTechnics tech \n").append("        on tech.FParentID = data.FManufactureOrderID AND tech.FOperationID = data.FProcessID \n").append("        group by data.FManufactureOrderID,order1.FNumber,order1.FLot,company.FID,project.FID,trankNumber.FID,material.FID,material.FName_l2, \n").append("                 activityEntry.FParentID,activity.FCostCenterID,unit.FName_l2,unit.FID,tech.FOperationNo \n");
        DBUtil.execute((Context)ctx, (String)getData.toString());
        getData.delete(0, getData.length());
        getData.append(" update " + stempName).append("  qty set FPrepareTime = (select FHourSecond from " + stempTableName_Hour).append("  hour where qty.FStorageUnit = hour.FStorageID and qty.FManufactureOrderID = hour.FManufactureOrderID and qty.FActivity = hour.FActivity and hour.FHourType = 7 and hour.FIsTotoal = 1)");
        DBUtil.execute((Context)ctx, (String)getData.toString());
        getData.delete(0, getData.length());
        getData.append(" update " + stempName).append("  qty set FProcessTime = (select sum(FHourSecond) from " + stempTableName_Hour).append("  hour where qty.FStorageUnit = hour.FStorageID and qty.FManufactureOrderID = hour.FManufactureOrderID and qty.FActivity = hour.FActivity  and hour.FHourType = 8 and hour.FIsTotoal = 1)");
        DBUtil.execute((Context)ctx, (String)getData.toString());
        getData.delete(0, getData.length());
        getData.append(" update " + stempName).append("  qty set FTimeUnit = (select TO_Char(max(FTimeUnit)) from " + stempTableName_Hour).append("  hour where qty.FStorageUnit = hour.FStorageID and qty.FManufactureOrderID = hour.FManufactureOrderID and hour.FIsTotoal = 1)");
        DBUtil.execute((Context)ctx, (String)getData.toString());
        getData.delete(0, getData.length());
        getData.append("  Select FManufactureOrderID,FStorageUnit,Fproject,FTrankNUmber,FProductNumber,FProductName,FActivity,FCostCenterID,FHourType,FUnit,FUnitID, \n").append("         FReportQty, FDetectQty, FQualifiedQty, FYieldQty, FScrapQty, FWorkerScrapQty, FSteelScrapQty, FRepairQty,FPrepareTime,FProcessTime,FTimeUnit,FOperationNo,FManufactureOrderNumber,FLot \n").append("    From " + stempName + " \n").append("  order by FManufactureOrderID,FActivity,FOperationNo \n");
        IRowSet querySet = DBUtil.executeQuery((Context)ctx, (String)getData.toString());
        OrderReportBillInfo orderReportBillInfo = new OrderReportBillInfo();
        OrderReportBillQtyEntryInfo orderReportBillQtyEntryInfo = new OrderReportBillQtyEntryInfo();
        OrderReportBillHourEntryInfo orderReportBillHourEntryInfo = new OrderReportBillHourEntryInfo();
        String manufactureOrderID = "";
        String foreManufactureOrderID = "";
        String activityID = "";
        String operationNumber = "";
        if (querySet.size() == 0) {
            return true;
        }
        while (querySet.next()) {
            if (!foreManufactureOrderID.equals(querySet.getString(1))) {
                if (manufactureOrderID.length() > 0) {
                    this._addnew(ctx, (IObjectValue)orderReportBillInfo);
                }
                orderReportBillInfo = new OrderReportBillInfo();
                activityID = "";
                manufactureOrderID = querySet.getString(1);
            }
            orderReportBillInfo.setCalculatePeriod(periodInfo);
            ManufactureOrderInfo mf = new ManufactureOrderInfo();
            if (querySet.getString(1) != null && !"".equals(querySet.getString(1))) {
                mf.setId(BOSUuid.read((String)querySet.getString(1)));
            }
            orderReportBillInfo.setManuFacturerOrder(mf);
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)companyID));
            orderReportBillInfo.setCompanyOrg(companyInfo);
            StorageOrgUnitInfo storage = new StorageOrgUnitInfo();
            if (querySet.getString(2) != null && !"".equals(querySet.getString(2))) {
                storage.setId(BOSUuid.read((String)querySet.getString(2)));
                orderReportBillInfo.setStorage(storage);
            }
            ProjectInfo porject = new ProjectInfo();
            if (querySet.getString(3) != null && !"".equals(querySet.getString(3))) {
                porject.setId(BOSUuid.read((String)querySet.getString(3)));
                orderReportBillInfo.setProject(porject);
            }
            TrackNumberInfo tranckNumber = new TrackNumberInfo();
            if (querySet.getString(4) != null && !"".equals(querySet.getString(4))) {
                tranckNumber.setId(BOSUuid.read((String)querySet.getString(4)));
                orderReportBillInfo.setTrackNumber(tranckNumber);
            }
            MaterialInfo materil = new MaterialInfo();
            if (querySet.getString(5) != null && !"".equals(querySet.getString(5))) {
                materil.setId(BOSUuid.read((String)querySet.getString(5)));
                orderReportBillInfo.setProductNumber(materil);
            }
            if (querySet.getString(24) != null && !"".equals(querySet.getString(24))) {
                orderReportBillInfo.setOrderNumber(querySet.getString(24));
            }
            if (querySet.getString(25) != null) {
                orderReportBillInfo.setLot(querySet.getString(25));
            }
            orderReportBillInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            Date bizData = this.getBizData(periodInfo);
            orderReportBillInfo.setBizDate(bizData);
            BOSUuid id = BOSUuid.create((BOSObjectType)orderReportBillInfo.getBOSType());
            orderReportBillInfo.setId(id);
            if (!foreManufactureOrderID.equals(querySet.getString(1)) || "".equals(activityID) || !activityID.equals(querySet.getString(7))) {
                orderReportBillQtyEntryInfo = new OrderReportBillQtyEntryInfo();
                orderReportBillHourEntryInfo = new OrderReportBillHourEntryInfo();
            }
            ActivityInfo activity = new ActivityInfo();
            if (querySet.getString(7) != null && !"".equals(querySet.getString(7))) {
                activity.setId(BOSUuid.read((String)querySet.getString(7)));
            }
            orderReportBillQtyEntryInfo.setActivity(activity);
            orderReportBillHourEntryInfo.setActivity(activity);
            CostCenterOrgUnitInfo cc = new CostCenterOrgUnitInfo();
            if (querySet.getString(8) != null && !"".equals(querySet.getString(8))) {
                cc.setId(BOSUuid.read((String)querySet.getString(8)));
            }
            orderReportBillQtyEntryInfo.setCostCenter(cc);
            orderReportBillHourEntryInfo.setCostCenter(cc);
            if (querySet.getString(10) != null) {
                orderReportBillQtyEntryInfo.setUnit(querySet.getString(10));
            }
            if (querySet.getString(10) != null) {
                orderReportBillQtyEntryInfo.setUnitID(querySet.getString(11));
            }
            if (querySet.getInt(22) == 2 || querySet.getInt(22) == 0) {
                orderReportBillHourEntryInfo.setUnit(TimeUnitEnum.HOUR);
            }
            if (querySet.getInt(22) == 3) {
                orderReportBillHourEntryInfo.setUnit(TimeUnitEnum.MINUTES);
            }
            if (querySet.getInt(22) == 4) {
                orderReportBillHourEntryInfo.setUnit(TimeUnitEnum.SCEOND);
            }
            if (querySet.getBigDecimal(20) != null) {
                orderReportBillHourEntryInfo.setPrepareTime(querySet.getBigDecimal(20));
            }
            if (querySet.getBigDecimal(21) != null) {
                orderReportBillHourEntryInfo.setProcessTime(querySet.getBigDecimal(21));
            }
            if (querySet.getBigDecimal(12) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(12)) != 0)) {
                orderReportBillQtyEntryInfo.setReportQty(querySet.getBigDecimal(12));
            }
            if (querySet.getBigDecimal(13) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(13)) != 0)) {
                orderReportBillQtyEntryInfo.setDetectQty(querySet.getBigDecimal(13));
            }
            if (querySet.getBigDecimal(14) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(14)) != 0)) {
                orderReportBillQtyEntryInfo.setQualifiedQty(querySet.getBigDecimal(14));
            }
            if (querySet.getBigDecimal(15) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(15)) != 0)) {
                orderReportBillQtyEntryInfo.setYieldQty(querySet.getBigDecimal(15));
            }
            if (querySet.getBigDecimal(16) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(16)) != 0)) {
                orderReportBillQtyEntryInfo.setScrapQty(querySet.getBigDecimal(16));
            }
            if (querySet.getBigDecimal(17) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(17)) != 0)) {
                orderReportBillQtyEntryInfo.setWorkerScrapQty(querySet.getBigDecimal(17));
            }
            if (querySet.getBigDecimal(18) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(18)) != 0)) {
                orderReportBillQtyEntryInfo.setSteelScrapQty(querySet.getBigDecimal(18));
            }
            if (querySet.getBigDecimal(19) != null && ("".equals(activityID) || !activityID.equals(querySet.getString(7)) || "".equals(operationNumber) || operationNumber.compareTo(querySet.getString(23)) == -1 && NCMConst.ZERO.compareTo(querySet.getBigDecimal(19)) != 0)) {
                orderReportBillQtyEntryInfo.setRepairQty(querySet.getBigDecimal(19));
            }
            operationNumber = querySet.getString(23);
            BOSUuid hourEntryID = BOSUuid.create((BOSObjectType)orderReportBillQtyEntryInfo.getBOSType());
            orderReportBillQtyEntryInfo.setId(hourEntryID);
            BOSUuid qtyEntryID = BOSUuid.create((BOSObjectType)orderReportBillHourEntryInfo.getBOSType());
            orderReportBillHourEntryInfo.setId(qtyEntryID);
            orderReportBillQtyEntryInfo.setInputMode(DataInputModeEnum.INDUCT);
            orderReportBillHourEntryInfo.setInputMode(DataInputModeEnum.INDUCT);
            if (foreManufactureOrderID.equals(querySet.getString(1)) && !"".equals(activityID) && activityID.equals(querySet.getString(7))) continue;
            orderReportBillInfo.getQtyEntries().add(orderReportBillQtyEntryInfo);
            orderReportBillInfo.getHourEntries().add(orderReportBillHourEntryInfo);
            activityID = querySet.getString(7);
            foreManufactureOrderID = querySet.getString(1);
        }
        if (orderReportBillInfo != null) {
            this._addnew(ctx, (IObjectValue)orderReportBillInfo);
        }
        result = true;
        return result;
    }

    private boolean isExistCodingRule(Context ctx, CMBillBaseInfo info, String companyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.isExist((IObjectValue)info, companyID);
    }

    private Date getBizData(PeriodInfo periodInfo) {
        Date bizDate = null;
        Timestamp time = periodInfo.getEndDate();
        if (time != null) {
            bizDate = new Date(time.getYear(), time.getMonth(), time.getDay());
        }
        return bizDate;
    }

    private void chekProcess(Context ctx, String stempTableName) throws BOSException, OrderBillException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select distinct pr.FNumber as number,pr.FName_l2 as name From \n").append(stempTableName + " data \n").append("  Inner JOin T_MM_Operation pr on pr.FID = data.FProcessID \n").append("  where NOT EXISTS (select oper.FOperationID From T_NCM_ActivityOperation oper where oper.FOperationID = data.FProcessID)  \n").append("  order by pr.FNumber \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer message = new StringBuffer();
            boolean flag = false;
            message.append("\n");
            while (rs.next()) {
                flag = true;
                message.append(rs.getString("number")).append("   ").append(rs.getString("name") + "\n");
            }
            Object[] messages = new String[]{message.toString()};
            if (flag) {
                throw new OrderBillException(OrderBillException.OPERATION_NO_ACTIVITY, messages);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void deleteLastImportData(Context ctx, String companyID) throws BOSException, EASBizException {
        StringBuffer delete = new StringBuffer();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1010, companyID);
        delete.append("DELETE FROM T_NCM_OrderReportBill WHERE FCompanyOrg = '" + companyID + "' \n");
        delete.append("    AND FCalculatePeriod = '" + periodInfo.getId().toString() + "' \n");
        delete.append("    AND EXISTS (SELECT T_NCM_OrderReportBillHourENTRY.FID FROM T_NCM_OrderReportBillHourENTRY \n");
        delete.append("    WHERE T_NCM_OrderReportBillHourENTRY.FParentID = T_NCM_OrderReportBill.FID AND FInputMode = '3'); \n\n ");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        delete.setLength(0);
        delete.append("DELETE FROM T_NCM_OrderReportBillHourENTRY WHERE FInputMode = '3' \n");
        delete.append("    AND NOT EXISTS (SELECT T_NCM_OrderReportBill.FID FROM T_NCM_OrderReportBill \n");
        delete.append("    WHERE T_NCM_OrderReportBill.FID = T_NCM_OrderReportBillHourENTRY.FParentID); \n\n");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        delete.setLength(0);
        delete.append("DELETE FROM T_NCM_OrderReportBill WHERE FCompanyOrg = '" + companyID + "' \n");
        delete.append("    AND FCalculatePeriod = '" + periodInfo.getId().toString() + "' \n");
        delete.append("    AND EXISTS (SELECT T_NCM_OrderReportBillQtyENTRY.FID FROM T_NCM_OrderReportBillQtyENTRY \n");
        delete.append("    WHERE T_NCM_OrderReportBillQtyENTRY.FParentID = T_NCM_OrderReportBill.FID AND FInputMode = '3'); \n\n ");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        delete.setLength(0);
        delete.append("DELETE FROM T_NCM_OrderReportBillQtyENTRY WHERE FInputMode = '3' \n");
        delete.append("    AND NOT EXISTS (SELECT T_NCM_OrderReportBill.FID FROM T_NCM_OrderReportBill \n");
        delete.append("    WHERE T_NCM_OrderReportBill.FID = T_NCM_OrderReportBillQtyENTRY.FParentID); \n\n");
        DbUtil.execute((Context)ctx, (String)delete.toString());
    }

    private void checkImportData(Context ctx, String companyID) throws BOSException, EASBizException {
        StringBuffer checkSql = new StringBuffer();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1010, companyID);
        checkSql.append("select count(1) From T_NCM_OrderReportBill m \n").append("  left join T_NCM_OrderReportBillHourEntry e on e.FParentID = m.FID \n").append("  left join T_NCM_OrderReportBillQtyEntry e1 on e1.FParentID = m.FID \n").append("  where m.FCompanyOrg = '" + companyID + "' \n").append("  AND m.FCalculatePeriod = '" + periodInfo.getId().toString() + "' \n").append("  AND (e.FInputMode = '3' or e1.FInputMode = '3')\n");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            while (rs.next()) {
                if (rs.getInt(1) != 0) continue;
                throw new OrderBillException(OrderBillException.IMPORT_NO_DATA);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

