/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.ncm.order.fact.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckInterfaceCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckInterfaceInfo;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckItemCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckItemInfo;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.AbstractOrderCheckItemControllerBean;
import com.kingdee.eas.ncm.order.fact.cal.app.IOrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.OrderCalProcess;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import javax.ejb.EJBException;
import org.apache.log4j.Logger;

public class OrderCheckItemControllerBean
extends AbstractOrderCheckItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.cal.app.OrderCheckItemControllerBean");

    @Override
    protected IObjectCollection _check(Context ctx, String companyOrgID, String periodID, boolean isStep, IObjectCollection OrderCheckItemCollection2) throws BOSException, EASBizException {
        OrderCalProcess proc = new OrderCalProcess(ctx, companyOrgID);
        OrderCheckItemCollection aOrderCheckItemCollection = (OrderCheckItemCollection)OrderCheckItemCollection2;
        try {
            int cItem;
            if (aOrderCheckItemCollection == null || !isStep) {
                String oql = "WHERE (checkStatus = 'unchecke' or checkStatus = 'unchecked') ORDER BY seq ASC";
                aOrderCheckItemCollection = this.getOrderCheckItemCollection(ctx, oql);
            }
            OrderCheckItemInfo[] aOrderCheckItemInfoArr = new OrderCheckItemInfo[aOrderCheckItemCollection.size()];
            int cIitemSize = aOrderCheckItemCollection.size();
            for (cItem = 0; cItem < cIitemSize; ++cItem) {
                aOrderCheckItemCollection.get(cItem).getCheckResult().clear();
                aOrderCheckItemInfoArr[cItem] = aOrderCheckItemCollection.get(cItem);
            }
            aOrderCheckItemInfoArr = OrderCheckItemControllerBean.sortDataBySeq(aOrderCheckItemInfoArr, true);
            aOrderCheckItemCollection = new OrderCheckItemCollection();
            cIitemSize = aOrderCheckItemInfoArr.length;
            for (cItem = 0; cItem < cIitemSize; ++cItem) {
                aOrderCheckItemCollection.add(aOrderCheckItemInfoArr[cItem]);
            }
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        if (companyOrgID == null || periodID == null) {
            return aOrderCheckItemCollection;
        }
        OrderCheckInterfaceCollection aCheckInterface = null;
        OrderCheckResultCollection aCheckResult = null;
        OrderCheckItemInfo aCalCostCheckItemInfo = null;
        LowTimer st = new LowTimer();
        String getcalcHMSString = "";
        long endTime = 0L;
        this.delete(ctx, "WHERE companyID = '" + companyOrgID + "' ");
        proc.clearProcess();
        int cIitemSize = aOrderCheckItemCollection.size();
        for (int cItem = 0; cItem < cIitemSize; ++cItem) {
            aCalCostCheckItemInfo = aOrderCheckItemCollection.get(cItem);
            aCalCostCheckItemInfo.setCompanyID(companyOrgID);
            if (aCalCostCheckItemInfo.getNumber() != null && isStep) continue;
            aCheckInterface = aCalCostCheckItemInfo.getCheckInterface();
            aCalCostCheckItemInfo.setNumber("isCheck");
            proc.setProcess("OrderChecking", new Integer(cItem + 1), new Integer(0), new Integer(0), aCalCostCheckItemInfo.getDescription());
            proc.CommitCacheSetProcessSql();
            int cInterfaceSize = aCheckInterface.size();
            for (int cInterface = 0; cInterface < cInterfaceSize; ++cInterface) {
                OrderCheckResultInfo aCalCostCheckItemCheckResultInfo;
                try {
                    if (aCheckInterface.get(cInterface) == null || aCheckInterface.get(cInterface).getInterfaceName() == null) continue;
                    aCalCostCheckItemInfo.setStartDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    st = new LowTimer();
                    getcalcHMSString = "";
                    endTime = 0L;
                    Class<?> checkerClass = Class.forName(aCheckInterface.get(cInterface).getInterfaceName());
                    IOrderCalChecker checker = (IOrderCalChecker)checkerClass.newInstance();
                    if (checker != null) {
                        aCheckResult = checker.calChecker(ctx, companyOrgID, periodID);
                        if (aCheckResult != null) {
                            aCalCostCheckItemInfo.getCheckResult().addCollection(aCheckResult);
                        }
                        if (aCheckResult != null && aCheckResult.size() > 0) {
                            aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                            if (isStep) {
                                aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                                endTime = st.msValue();
                                getcalcHMSString = CalcAppUntil.getcalcHMSString(ctx, (int)endTime);
                                aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                                return aOrderCheckItemCollection;
                            }
                        } else {
                            aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.succeed);
                            aCalCostCheckItemInfo.setSimpleName("cost");
                        }
                    }
                    endTime = st.msValue();
                    getcalcHMSString = CalcAppUntil.getcalcHMSString(ctx, (int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription("ClassNotFoundException");
                    aCalCostCheckItemCheckResultInfo.setReason(e.toString().length() > 200 ? e.toString().substring(0, 199) : e.toString());
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    if (!isStep || !aCalCostCheckItemInfo.isIsNeed()) continue;
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    endTime = st.msValue();
                    getcalcHMSString = CalcAppUntil.getcalcHMSString(ctx, (int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    return aOrderCheckItemCollection;
                }
                catch (EJBException e) {
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription("EJBException");
                    aCalCostCheckItemCheckResultInfo.setReason(e.toString().length() > 200 ? e.toString().substring(0, 199) : e.toString());
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    continue;
                }
                catch (ClassCastException e) {
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription("ClassCastException");
                    aCalCostCheckItemCheckResultInfo.setReason(e.toString().length() > 200 ? e.toString().substring(0, 199) : e.toString());
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    continue;
                }
                catch (InstantiationException e) {
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription("InstantiationException");
                    aCalCostCheckItemCheckResultInfo.setReason(e.toString().length() > 200 ? e.toString().substring(0, 199) : e.toString());
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    continue;
                }
                catch (IllegalAccessException e) {
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription("IllegalAccessException");
                    aCalCostCheckItemCheckResultInfo.setReason(e.toString().length() > 200 ? e.toString().substring(0, 199) : e.toString());
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrDescription"));
                    aCalCostCheckItemCheckResultInfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrReason"));
                    aCalCostCheckItemCheckResultInfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrSuggestOperation"));
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    endTime = st.msValue();
                    getcalcHMSString = CalcAppUntil.getcalcHMSString(ctx, (int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    if (!isStep) continue;
                    return aOrderCheckItemCollection;
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrDescription"));
                    aCalCostCheckItemCheckResultInfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrReason"));
                    aCalCostCheckItemCheckResultInfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrSuggestOperation"));
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    endTime = st.msValue();
                    getcalcHMSString = CalcAppUntil.getcalcHMSString(ctx, (int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    if (!isStep) continue;
                    return aOrderCheckItemCollection;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    aCalCostCheckItemCheckResultInfo = new OrderCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrDescription"));
                    aCalCostCheckItemCheckResultInfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrReason"));
                    aCalCostCheckItemCheckResultInfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CostCheckErrSuggestOperation"));
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    endTime = st.msValue();
                    getcalcHMSString = CalcAppUntil.getcalcHMSString(ctx, (int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    if (!isStep) continue;
                    return aOrderCheckItemCollection;
                }
            }
            this._saveCheckResultToDB(ctx, companyOrgID, aCalCostCheckItemInfo);
            aCalCostCheckItemInfo.getCheckResult().clear();
        }
        return aOrderCheckItemCollection;
    }

    public static OrderCheckItemInfo[] sortDataBySeq(OrderCheckItemInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Comparator {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int compare(Object arg0, Object arg1) {
                return this.isAsc ? new Integer(((OrderCheckItemInfo)arg0).getSeq()).compareTo(new Integer(((OrderCheckItemInfo)arg1).getSeq())) : new Integer(((OrderCheckItemInfo)arg1).getSeq()).compareTo(new Integer(((OrderCheckItemInfo)arg0).getSeq()));
            }
        }
        Arrays.sort(datas, new DataCompare(isAsc));
        return datas;
    }

    @Override
    protected void _saveCheckResultToDB(Context ctx, String companyOrgID, IObjectCollection OrderCheckItemCollection2) throws BOSException, EASBizException {
        OrderCheckItemCollection newBillColls = new OrderCheckItemCollection();
        int cIitemSize = OrderCheckItemCollection2.size();
        for (int cItem = 0; cItem < cIitemSize; ++cItem) {
            OrderCheckItemInfo info = ((OrderCheckItemCollection)OrderCheckItemCollection2).get(cItem);
            info.setNumber(null);
            info.setSimpleName(null);
            info.setId(null);
            int interfaces = info.getCheckInterface().size();
            for (int j = 0; j < interfaces; ++j) {
                OrderCheckInterfaceInfo interfaceEntry = info.getCheckInterface().get(j);
                interfaceEntry.setId(null);
            }
            interfaces = info.getCheckResult().size();
            for (int k = 0; k < interfaces; ++k) {
                OrderCheckResultInfo checkResultEntry = info.getCheckResult().get(k);
                checkResultEntry.setId(null);
            }
            newBillColls.add(info);
        }
        Result result = this.addnew(ctx, (CoreBaseCollection)newBillColls.cast(CoreBaseCollection.class));
        if (result != null) {
            logger.debug((Object)(CalcAppUntil.getOrderCheckResource(ctx, "SaveCheckResultToDB") + result.getResult() + result.toString()));
        }
    }

    protected void _saveCheckResultToDB(Context ctx, String companyOrgID, OrderCheckItemInfo info) throws BOSException, EASBizException {
        info.setNumber(null);
        info.setSimpleName(null);
        info.setId(null);
        int interfaces = info.getCheckInterface().size();
        for (int j = 0; j < interfaces; ++j) {
            OrderCheckInterfaceInfo interfaceEntry = info.getCheckInterface().get(j);
            interfaceEntry.setId(null);
        }
        interfaces = info.getCheckResult().size();
        for (int k = 0; k < interfaces; ++k) {
            OrderCheckResultInfo checkResultEntry = info.getCheckResult().get(k);
            checkResultEntry.setId(null);
        }
        this.addnew(ctx, (CoreBaseInfo)info);
    }

    @Override
    protected IObjectCollection _dynamicCheck(Context ctx, String companyOrgID, String currPeriod, String periodID, boolean isStep, IObjectCollection OrderCheckItemCollection2) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected int _getNormalCheckItemNum(Context ctx) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(*) from T_NCM_OrderCheckItem \n").append("\twhere (isnull(FCompanyId,'#')='#' or FCompanyId is null) \n").append("   and (FcheckStatus = 'unchecke' or FcheckStatus = 'unchecked')\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int itemNum = 0;
        try {
            rs.first();
            itemNum = rs.getInt(1);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return itemNum;
    }

    @Override
    protected Object[] _getNormalCheckProcess(Context ctx, String companyID) throws BOSException, EASBizException {
        OrderCalProcess proc = new OrderCalProcess(ctx, companyID);
        Object[] currentProcess = proc.getProcess("OrderChecking");
        return currentProcess;
    }

    @Override
    protected IObjectValue _getCalCostCheckItemByCount(Context ctx, String checkItemPk, int count) throws BOSException {
        OrderCheckItemInfo OrderCheckItemInfo2 = new OrderCheckItemInfo();
        OrderCheckResultCollection collect = new OrderCheckResultCollection();
        StringBuffer getCheckItem = new StringBuffer();
        getCheckItem.append("    SELECT top 100 FstartDateTime,FendDateTime,FcalcHMSString, \n");
        getCheckItem.append("    checkResult.Fdescription,checkResult.Freason,checkResult.FsuggestOperation \n");
        getCheckItem.append("    From T_NCM_OrderCheckItem main \n");
        getCheckItem.append("    INNER JOIN T_NCM_OrderCheckResult checkResult ON checkResult.FParentID = main.fid \n");
        getCheckItem.append("    Where FParentID = '" + checkItemPk + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCheckItem.toString());
        try {
            while (rs.next()) {
                OrderCheckItemInfo2.setStartDateTime(rs.getTimestamp(1));
                OrderCheckItemInfo2.setEndDateTime(rs.getTimestamp(2));
                OrderCheckItemInfo2.setCalcHMSString(rs.getString(3));
                OrderCheckResultInfo checkResult = new OrderCheckResultInfo();
                checkResult.setDescription(rs.getString(4));
                checkResult.setReason(rs.getString(5));
                checkResult.setSuggestOperation(rs.getString(6));
                collect.add(checkResult);
            }
            OrderCheckItemInfo2.put("checkResult", (Object)collect);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return OrderCheckItemInfo2;
    }
}

