/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.CostDriverFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.IStrategy;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.Wip.BaseStrategy;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.Wip.NotCalcWIPStrategy;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.Wip.activity.AsFinishedQtyStrategy;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.helper.CalcParamAdapter;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AUSContext {
    private static Logger logger = Logger.getLogger((String)AUSContext.class.getName());
    private CalcParamAdapter _calcParam;
    protected String _formula = null;
    protected Map _strategyCache = null;
    protected String tblAllocData = null;
    public boolean isCallFromActivity = false;

    public AUSContext(CalcParamAdapter calcParam) {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        this._calcParam = calcParam;
    }

    public void setStrategyContext(String formula, String currentTable, int rank) throws AllocateException {
        Assert.that((formula != null ? 1 : 0) != 0);
        Assert.that((currentTable != null ? 1 : 0) != 0);
        this._formula = formula;
        this._calcParam.SetAllocRangeTable(currentTable);
        this._calcParam.SetAllocResultTable(currentTable);
        String createFieldList = this.GetFieldListForCreateTbl();
        this.setTblAllocData(this._calcParam.GetAllocDataTable(createFieldList));
        this._calcParam.set_tmpTbl_CurrentContextAllocDataTable(this.getTblAllocData());
        this._calcParam.setRank(rank);
    }

    public String getTblAllocData() {
        return this.tblAllocData;
    }

    public void setTblAllocData(String tblAllocData) {
        this.tblAllocData = tblAllocData;
    }

    public String GetAllocStdUnitDataSql() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        String[] factors = this.SplitFormula(this._formula);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < factors.length; ++i) {
            IStrategy s = this.getStrategyByFactor(factors[i]);
            b.append(s.getCostDriverDataSql()).append(";");
        }
        return b.toString();
    }

    public String GetAllocStdFormulaUpdateSql() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        String formula = this.parseFormula(this._formula);
        String sql = "UPDATE " + this.tblAllocData + " SET FRatio = (" + formula + "); ";
        return sql;
    }

    public String[] getColumns() throws AllocateException {
        String[] factors = this.SplitFormula(this._formula);
        String[] columns = new String[factors.length];
        for (int i = 0; i < factors.length; ++i) {
            columns[i] = this.GetFldFlag(factors[i]);
        }
        return columns;
    }

    public String[] GetNoAllocStdDataHint() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        String[] retHint = new String[]{AllocUtils.getAllocResource((Context)this._calcParam.getCtx(), (String)"NoData_Hint_0"), "\u8bf7\u5728"};
        String[] factors = this.SplitFormula(this._formula);
        for (int i = 0; i < factors.length; ++i) {
            IStrategy s = this.getStrategyByFactor(factors[i]);
            String[] unitHint = s.getNoAllocCostDriverDataHint();
            String sep = i == 0 ? "" : "\u3001";
            retHint[0] = retHint[0] + sep + unitHint[0];
            retHint[1] = retHint[1] + sep + unitHint[1];
        }
        return retHint;
    }

    public String GetFieldListForCreateTbl() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        return this.GetMergeFormatStr("{0} NUMERIC(28,10) Default(0)", ",");
    }

    public String GetFieldListForQuery() throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        return this.GetMergeFormatStr("{0}", ",");
    }

    public String GetMergeFormatStr(String format, String separator) throws AllocateException {
        Assert.that((this._formula != null ? 1 : 0) != 0);
        if (separator == null) {
            separator = ",";
        }
        String[] factors = this.SplitFormula(this._formula);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < factors.length; ++i) {
            String fildFlag = this.GetFldFlag(factors[i]);
            String item = MessageFormat.format(format, fildFlag);
            b.append(item).append(separator);
        }
        return b.toString();
    }

    private String GetFldFlag(String factor) throws AllocateException {
        IStrategy s = this.getStrategyByFactor(factor);
        if (s != null) {
            return s.getFieldFlag();
        }
        return null;
    }

    public Map GetFactor_FldFlagMapping(String formula) throws AllocateException {
        String[] list = this.SplitFormula(formula);
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < list.length; ++i) {
            String factor = list[i].toString();
            ret.put(factor, this.GetFldFlag(factor));
        }
        return ret;
    }

    private String parseFormula(String formula) throws AllocateException {
        String retFormula = formula;
        String[] factors = this.SplitFormula(formula);
        for (int i = 0; i < factors.length; ++i) {
            String factor = factors[i].toString();
            String factorReg = "~#" + factor + "~@";
            factorReg = factorReg.replaceAll("\\+", "\\\\+");
            retFormula = retFormula.replaceAll(factorReg, this.GetFldFlag(factor));
        }
        return this.dealWithDivisor(retFormula);
    }

    private String dealWithDivisor(String originalStr) {
        StringBuffer finalSb = new StringBuffer();
        if (originalStr.indexOf("/") != -1) {
            originalStr = this.delThePlace(originalStr);
            int division = originalStr.indexOf("/");
            int next = division + 1;
            finalSb.append(originalStr.substring(0, next));
            int subEnd = 0;
            String divisoinStr = null;
            if (originalStr.substring(next, next + 1).equals("(")) {
                subEnd = this.getSubEnd(originalStr, next + 1);
                divisoinStr = this.dealWithDivisor(originalStr.substring(next, subEnd));
            } else {
                subEnd = this.getSignExsitNo(originalStr, next);
                divisoinStr = subEnd == -1 ? originalStr.substring(next) : originalStr.substring(next, subEnd);
            }
            finalSb.append("TO_DECIMAL(" + divisoinStr + ",21,8)");
            if (subEnd > 0) {
                String restStr = this.dealWithDivisor(originalStr.substring(subEnd));
                finalSb.append(restStr);
            }
        } else if (originalStr.length() > 0) {
            return originalStr;
        }
        return finalSb.toString();
    }

    private String delThePlace(String originalStr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < originalStr.length(); ++i) {
            if (" ".equals(originalStr.substring(i, i + 1))) continue;
            sb.append(originalStr.substring(i, i + 1));
        }
        return sb.toString();
    }

    private int getSubEnd(String originalStr, int subStart) {
        int subEnd = subStart;
        int loss = 1;
        for (int i = subStart; i < originalStr.length(); ++i) {
            if (originalStr.substring(i, i + 1).equals(")")) {
                --loss;
            }
            if (originalStr.substring(i, i + 1).equals("(")) {
                ++loss;
            }
            if (loss != 0) continue;
            subEnd = i + 1;
            break;
        }
        return subEnd;
    }

    private int getSignExsitNo(String finalFormula, int next) {
        int signNo = -1;
        for (int i = next; i < finalFormula.length(); ++i) {
            if (!finalFormula.substring(i, i + 1).equals("+") && !finalFormula.substring(i, i + 1).equals("-") && !finalFormula.substring(i, i + 1).equals("*") && !finalFormula.substring(i, i + 1).equals("/")) continue;
            signNo = i;
            break;
        }
        return signNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected IStrategy getStrategyByFactor(String factor) throws AllocateException {
        Assert.that((this._calcParam != null ? 1 : 0) != 0);
        Assert.that((this._calcParam.GetAllocResultTable() != null ? 1 : 0) != 0);
        if (this._strategyCache == null) {
            Class<AUSContext> clazz = AUSContext.class;
            // MONITORENTER : com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.AUSContext.class
            this._strategyCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this.isCallFromActivity) {
            if (this._strategyCache.containsKey(factor + "1")) {
                return (IStrategy)this._strategyCache.get(factor + "1");
            }
        } else if (this._strategyCache.containsKey(factor)) {
            return (IStrategy)this._strategyCache.get(factor);
        }
        BaseStrategy ret = null;
        if ("d2T+lgEaEADgAAobwKgRj53UGuM=".equals(factor)) {
            ret = this.isCallFromActivity ? new AsFinishedQtyStrategy(this._calcParam) : new com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.Wip.order.AsFinishedQtyStrategy(this._calcParam);
        } else if ("d2T+lgEaEADgAAoawKgRj53UGuM=".equals(factor)) {
            ret = new NotCalcWIPStrategy(this._calcParam);
        }
        if (this.isCallFromActivity) {
            this._strategyCache.put(factor + "1", ret);
            return ret;
        }
        this._strategyCache.put(factor, ret);
        return ret;
    }

    private String[] SplitFormula(String formula) {
        if (formula == null) {
            return null;
        }
        String delim = "~#";
        String[] list = formula.split(delim);
        int count = list.length;
        String[] retArr = new String[count];
        int index = 0;
        int pos = -1;
        boolean hasRec = false;
        for (int i = 0; i < count; ++i) {
            String item = list[i];
            pos = item.indexOf("~@");
            if (pos == -1) continue;
            item = item.substring(0, pos);
            hasRec = false;
            for (int j = 0; j < count; ++j) {
                if (item == null || !item.equals(retArr[j])) continue;
                hasRec = true;
                break;
            }
            if (hasRec) continue;
            retArr[index++] = item;
        }
        if (index < count) {
            String[] retNewArr = new String[index];
            System.arraycopy(retArr, 0, retNewArr, 0, index);
            return retNewArr;
        }
        return retArr;
    }

    protected boolean isByCU_UserDefined(String factor) throws AllocateException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)factor, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isByCU", (Object)"1", CompareType.EQUALS));
        try {
            return AllocStdUnitFactory.getLocalInstance((Context)this._calcParam.getCtx()).exists(filter);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    protected CostDriverInfo getAllocStdUnitByFactor(String factor) throws AllocateException {
        try {
            return CostDriverFactory.getLocalInstance((Context)this._calcParam.getCtx()).getCostDriverInfo((IObjectPK)new ObjectUuidPK(factor), this.getSelectors());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("resCostItem.*"));
        return sic;
    }

    public static boolean isDataBaseDPermission(Context ctx, String thisCUId, String compareCUId, String bosType, String checkDataId) throws BOSException {
        return AUSContext.isAdminData(thisCUId, compareCUId) || AUSContext.isAssignedDataBaseDId(ctx, bosType, thisCUId, checkDataId);
    }

    public static boolean isAdminData(String thisCUId, String compareCUId) {
        return thisCUId.equals(compareCUId);
    }

    public static boolean isAssignedDataBaseDId(Context ctx, String bosObjectType, String assignCUId, String dataBaseDID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosObjectType", (Object)bosObjectType));
        filter.getFilterItems().add(new FilterItemInfo("assignCU", (Object)assignCUId));
        filter.getFilterItems().add(new FilterItemInfo("dataBaseDID", (Object)dataBaseDID));
        view.setFilter(filter);
        DataBaseDAssignCollection coll = DataBaseDAssignFactory.getLocalInstance((Context)ctx).getDataBaseDAssignCollection(view);
        return coll != null && coll.size() > 0;
    }
}

