/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.calc.allocwip;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.Strategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.allocwip.IAllocWIP;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.allocwip.data.CostDriverSet;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.helper.CalcParamAdapter;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AllocWIP
implements IAllocWIP {
    protected CalcParamAdapter _calcParam;
    private AUSContext _ausCtx = null;
    protected int _rank = -1;
    protected static Logger logger = Logger.getLogger((String)IAllocWIP.class.getName());

    public AllocWIP(CalcParamAdapter calcParam) {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        this._calcParam = calcParam;
        this._ausCtx = new AUSContext(this._calcParam);
    }

    @Override
    public void setCalcRank(int rank) {
        this._rank = rank;
    }

    @Override
    public boolean DoAllocWIP() throws BOSException {
        boolean isCalcSuccess = true;
        try {
            isCalcSuccess = this.allocWIPandFinished();
            if (!this.checkInvalidMatCost()) {
                isCalcSuccess = false;
            }
            if (!this.checkInvalidFinishedUnitCost()) {
                isCalcSuccess = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (AllocateException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        return isCalcSuccess;
    }

    protected boolean allocWIPandFinished() throws BOSException, AllocateException, SQLException {
        boolean isCalcSuccess = true;
        StringBuffer sb = new StringBuffer();
        this.initDataSql_CostCalMatDetailResult(sb);
        this.initDataSql_CostCalActivityDetailResult(sb);
        this.initDataSql_CostCalActivityResult(sb);
        this.initDataSql_OrderCostCalResult(sb);
        sb.delete(0, sb.length());
        CostDriverSet costDriverList_Mat = new CostDriverSet(this.getCostDriverSetting_Material());
        costDriverList_Mat.First();
        while (!costDriverList_Mat.IsDone()) {
            String formulaForParse = costDriverList_Mat.getFormulaForParse();
            this._ausCtx.isCallFromActivity = false;
            this._ausCtx.setStrategyContext(formulaForParse, this._calcParam.get_tbl_OrderCostCalMatDetailResult(), this._rank);
            this.initAllocDataTable(sb, costDriverList_Mat.getCostDriverId());
            this.updateAllocDataTable(sb);
            try {
                NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            sb.delete(0, sb.length());
            if (!this.checkInvalidAllocStdData()) {
                isCalcSuccess = false;
            }
            this.adjustInvalidAllocStdData(sb);
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
            costDriverList_Mat.Next();
        }
        CostDriverSet costDriverList_Act = new CostDriverSet(this.getCostDriverSetting_Activity());
        costDriverList_Act.First();
        while (!costDriverList_Act.IsDone()) {
            String formulaForParse = costDriverList_Act.getFormulaForParse();
            this._ausCtx.isCallFromActivity = true;
            this._ausCtx.setStrategyContext(formulaForParse, this._calcParam.get_tbl_OrderCostCalActivityDetailResult(), this._rank);
            this.initAllocDataTable(sb, costDriverList_Act.getCostDriverId());
            this.updateAllocDataTable(sb);
            try {
                NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.delete(0, sb.length());
            if (!this.checkInvalidAllocStdData()) {
                isCalcSuccess = false;
            }
            this.adjustInvalidAllocStdData(sb);
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
            costDriverList_Act.Next();
        }
        this.updateCostDriverData_MatDetail2CalResult(sb);
        this.updateCostDriverData_ActivityDetail2CalResult(sb);
        this.innerAllocWIPandFinished_CalcResult(sb);
        this.innerAllocWIPandFinished_MatDetail(sb);
        this.innerAllocWIPandFinished_ActivityDetail(sb);
        this.innerAllocWIPandFinished_Activity(sb);
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        this.adjustDiff_Mat();
        this.adjustDiff_Activity();
        return isCalcSuccess;
    }

    protected void separateAllocWIPCounting(StringBuffer sb) throws BOSException {
    }

    public void releasePrivateTempTbl() throws BOSException {
    }

    @Override
    public void CommitAllocResult() throws BOSException {
    }

    protected void initDataSql_OrderCostCalResult(StringBuffer sb) throws BOSException {
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("( ").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,FOrderID,FProductID,FProdBatchNo,FOrderNumber,FCostItemID,FAmount,FQty,FCalcLevel,FIsMatType) ").append('\n').append("SELECT newbosid('C819BF74') AS FID, R.FCompanyOrg As FCompanyID, R.FCalculatePeriod As FCalculatePeriodID, ").append('\n').append("\tFEE.FCostCenterID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber, FEE.FCostItemID, ").append('\n').append("\tSUM(FEE.FAmount)As FAmount, SUM(FEE.FQty)As FQty, ").append(this._rank).append(" As FCalcLevel, FEE.FIsMatType ").append('\n').append("FROM (").append('\n').append("\tSELECT BM.FCostCenterID, B.FOrderID, B.FOrderProductID As FProductID,  Isnull(B.FOrderProductLot,N' ') As FProdBatchNo, B.FOrderNumber, BM.FCostItemID, ").append('\n').append("\t\tBM.FBopAmount As FAmount, 0.00 As FQty, 1 As FIsMatType ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderBalance()).append(" B ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceMaterial()).append(" BM ON BM.FParentID=B.FID").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT BM.FCostCenterID, B.FOrderID, B.FOrderProductID As FProductID, Isnull(B.FOrderProductLot,N' ') As FProdBatchNo, B.FOrderNumber,  BME.FCostItemID, ").append('\n').append("\t\tBME.FBopAmount As FAmount, isnull(BME.FBopQty,0) As FQty, 0 As FIsMatType ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderBalance()).append(" B ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceActivity()).append(" BM ON BM.FParentID=B.FID").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceActivityEntry()).append(" BME ON BME.FParentID=BM.FID ").append('\n').append("\tUNION ALL  ").append('\n').append("\tSELECT FCostCenterID, FOrderID, FOrderProdID As FProductID, FOrderProdBatchNo As FProdBatchNo, FOrderNumber, FCostItemID, FAmount, FQty, 1 As FIsMatType ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OCMatAllocResult()).append(" MAT ").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT FCostCenterID, FOrderID, FOrderProdID As FProductID, FOrderProdBatchNo As FProdBatchNo, FOrderNumber, FCostItemID, FAmount, FOrderQty As FQty, 0 As FIsMatType ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OCActivity2OrderAllocResult()).append(" ACT ").append('\n').append(") FEE ").append('\n').append("INNER JOIN T_NCM_OrderRankEntry RE ON RE.FMaterialID=FEE.FProductID AND RE.FMatBatchNo=FEE.FProdBatchNo ").append('\n').append("INNER JOIN T_NCM_OrderRank R ON RE.FParentID= R.FID ").append('\n').append("WHERE R.FCompanyOrg = ? AND R.FCalculatePeriod = ? AND RE.FRank = ? ").append('\n').append("GROUP BY  R.FCompanyOrg, R.FCalculatePeriod,FEE.FCostCenterID, FEE.FOrderID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,FEE.FCostItemID,FEE.FIsMatType").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{this._calcParam.getCompanyId(), this._calcParam.getPeriodId(), String.valueOf(this._rank)});
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FCostDriverID)=(").append('\n').append("\tSELECT top 1 ST.FCostDriverID").append('\n').append("\tFROM T_NCM_CostDriverSetByWIP ST ").append('\n').append("\tWHERE ST.FCompanyID = '").append(this._calcParam.getCompanyId()).append("' AND ST.FCalculatePeriodID = '").append(this._calcParam.getPeriodId()).append("' ").append('\n').append("\t\tAND ST.FCostCenterID=D.FCostCenterID AND ST.FCostItemID=D.FCostItemID ").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE " + this._calcParam.get_tbl_OrderCostCalResult() + " AS D \n");
        sb.append("   SET (FTotalFinishedQty)=( \n");
        sb.append("                           select S.maxQty  \n");
        sb.append("                             from (SELECT Max(FFinishedQty) as maxQty, \n");
        sb.append("                                          FOrderID \n");
        sb.append("                                     FROM " + this._calcParam.get_Tbl_DataByOrder() + "  \n");
        sb.append("                                    WHERE FCompanyID = '" + this._calcParam.getCompanyId() + "'  \n");
        sb.append("                                      AND FCalculatePeriodID = '" + this._calcParam.getPeriodId() + "' \n");
        sb.append("                                     group by FOrderID \n");
        sb.append("                                    ) S  \n");
        sb.append("                             where S.FOrderID=D.FOrderID \n");
        sb.append("                             ) \n");
        sb.append("WHERE D.FCalcLevel = " + this._rank + "  \n");
        sb.append(";");
        sb.append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FTotalEoPWIPQty)=(").append('\n').append("\tSELECT BILL.FEUntoCntQty As FTotalEoPWIPQty ").append('\n').append("\tFROM T_NCM_OCWIPCountingBill BILL ").append('\n').append("\tWHERE BILL.FCompanyOrg = '").append(this._calcParam.getCompanyId()).append("' AND BILL.FCalculatePeriod = '").append(this._calcParam.getPeriodId()).append("' ").append('\n').append("\t\tAND D.FOrderID=BILL.FOrderID AND BILL.FActivityID is null ").append('\n').append(") ").append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FAmountPrecision)=(").append('\n').append("\tSELECT CY.FPrecision As FAmountPrecision ").append('\n').append("\tFROM T_BD_Currency CY ").append('\n').append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append('\n').append("\tWHERE CP.FID = '").append(this._calcParam.getCompanyId()).append("' ").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FPricePrecision)=(").append('\n').append("\tSELECT M.FPricePrecision AS FPricePrecison ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tWHERE M.FID=D.FProductID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tINNER JOIN T_BD_MeasureUnit MU ON M.FBaseUnit=MU.FID").append('\n').append("\tWHERE M.FID=D.FProductID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    protected void initDataSql_CostCalMatDetailResult(StringBuffer sb) throws BOSException {
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append("( ").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,").append('\n').append("\tFCostCenterID, FOrderID,FProductID,FProdBatchNo,FOrderNumber,").append('\n').append("\tFCostItemID,FMaterialID,FMatBatchNo,FAmount,FQty,FCalcLevel )").append('\n').append("SELECT newbosid('C819BF74') AS FID, R.FCompanyOrg As FCompanyID, R.FCalculatePeriod As FCalculatePeriodID, ").append('\n').append("\tFEE.FCostCenterID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,").append('\n').append("\tFEE.FCostItemID, FEE.FMaterialID, FEE.FMatBatchNo,SUM(FEE.FAmount)As FAmount,SUM(FEE.FQty)As FQty, ").append(this._rank).append(" As FCalcLevel ").append('\n').append("FROM (").append('\n').append("\tSELECT BM.FCostCenterID, B.FOrderID, B.FOrderProductID As FProductID, Isnull(B.FOrderProductLot,N' ') As FProdBatchNo, B.FOrderNumber, BM.FCostItemID, BME.FMaterialID, BME.FMatLot As FMatBatchNo,").append('\n').append("\t\tBME.FAmount, BME.FQty ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderBalance()).append(" B ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceMaterial()).append(" BM ON BM.FParentID=B.FID").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceMaterialEntry()).append(" BME ON BME.FParentID=BM.FID ").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT FCostCenterID, FOrderID, FOrderProdID As FProductID, FOrderProdBatchNo As FProdBatchNo, FOrderNumber, FCostItemID, FMaterialID, FLot As FMatBatchNo, FAmount, FQty ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OCMatAllocResult()).append(" MAT ").append('\n').append(") FEE ").append('\n').append("INNER JOIN T_NCM_OrderRankEntry RE ON RE.FMaterialID=FEE.FProductID AND RE.FMatBatchNo=FEE.FProdBatchNo ").append('\n').append("INNER JOIN T_NCM_OrderRank R ON RE.FParentID= R.FID ").append('\n').append("WHERE R.FCompanyOrg = ? AND R.FCalculatePeriod = ? AND RE.FRank = ? ").append('\n').append("GROUP BY R.FCompanyOrg,R.FCalculatePeriod,FEE.FCostCenterID, FEE.FOrderID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,FEE.FCostItemID,FEE.FMaterialID,FEE.FMatBatchNo").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{this._calcParam.getCompanyId(), this._calcParam.getPeriodId(), String.valueOf(this._rank)});
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FCostDriverID)=(").append('\n').append("\tSELECT top 1 ST.FCostDriverID").append('\n').append("\tFROM T_NCM_CostDriverSetByWIP ST ").append('\n').append("\tWHERE ST.FCompanyID = '").append(this._calcParam.getCompanyId()).append("' AND ST.FCalculatePeriodID = '").append(this._calcParam.getPeriodId()).append("' ").append('\n').append("\t\tAND ST.FCostCenterID=D.FCostCenterID AND ST.FCostItemID=D.FCostItemID ").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FIsSelfManufacture)=(").append('\n').append("\tSELECT  1 ").append('\n').append("\tFROM T_BD_MaterialCompanyInfo AS  CI ").append('\n').append("\tWHERE CI.FMaterialID=D.FMaterialID AND CI.FStatus=1 AND CI.FCalculateType=2 ").append('\n').append("\t\tAND CI.FCompanyID = '").append(this._calcParam.getCompanyId()).append("'").append('\n').append(")").append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FAmountPrecision)=(").append('\n').append("\tSELECT CY.FPrecision As FAmountPrecision ").append('\n').append("\tFROM T_BD_Currency CY ").append('\n').append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append('\n').append("\tWHERE CP.FID = '").append(this._calcParam.getCompanyId()).append("' ").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FPricePrecision)=(").append('\n').append("\tSELECT M.FPricePrecision AS FPricePrecison ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tWHERE M.FID=D.FMaterialID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tINNER JOIN T_BD_MeasureUnit MU ON M.FBaseUnit=MU.FID").append('\n').append("\tWHERE M.FID=D.FMaterialID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    protected void initDataSql_CostCalActivityResult(StringBuffer sb) throws BOSException {
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.get_tbl_OrderCostCalActivityResult()).append("( ").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,").append('\n').append("\tFCostCenterID, FOrderID,FProductID,FProdBatchNo,FOrderNumber,").append('\n').append("\tFActivityID,FQty,FCalcLevel )").append('\n').append("SELECT newbosid('C819BF74') AS FID, R.FCompanyOrg As FCompanyID, R.FCalculatePeriod As FCalculatePeriodID, ").append('\n').append("\tFEE.FCostCenterID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,").append('\n').append("\tFEE.FActivityID, SUM(FEE.FQty)As FQty, ").append(this._rank).append(" As FCalcLevel ").append('\n').append("FROM (").append('\n').append("\tSELECT BM.FCostCenterID, B.FOrderID, B.FOrderProductID As FProductID, Isnull(B.FOrderProductLot,N' ') As FProdBatchNo, B.FOrderNumber, BM.FActivityID, ").append('\n').append("\t\tisnull(BM.FBopWipQty,0) As FQty ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderBalance()).append(" B ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceActivity()).append(" BM ON BM.FParentID=B.FID").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT E.FCostCenterID, B.FManuFacturerOrderID As FOrderID, B.FProductNumberID As FProductID, Isnull(B.FLot, N' ') As FProdBatchNo, Isnull(B.FOrderNumber, N' ')As FOrderNumber, E.FActivityID, E.FPrepareTime + E.FProcessTime as Fqty ").append('\n').append("\tFROM T_NCM_OrderReportBill B ").append('\n').append("\tINNER JOIN T_NCM_OrderReportBillHourEntry E ON E.FParentID = B.FID ").append('\n').append("\tWHERE B.FCompanyOrg = ? AND B.FCalculatePeriod = ? AND B.FBillStatus = 4 ").append('\n').append(") FEE ").append('\n').append("INNER JOIN T_NCM_OrderRankEntry RE ON RE.FMaterialID=FEE.FProductID AND RE.FMatBatchNo=FEE.FProdBatchNo ").append('\n').append("INNER JOIN T_NCM_OrderRank R ON RE.FParentID= R.FID ").append('\n').append("WHERE R.FCompanyOrg = ? AND R.FCalculatePeriod = ? AND RE.FRank = ? ").append('\n').append("GROUP BY R.FCompanyOrg, R.FCalculatePeriod, FEE.FCostCenterID, FEE.FOrderID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,FEE.FActivityID ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{this._calcParam.getCompanyId(), this._calcParam.getPeriodId(), this._calcParam.getCompanyId(), this._calcParam.getPeriodId(), String.valueOf(this._rank)});
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityResult()).append(" AS D SET (FQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_NCM_Activity A ").append('\n').append("\tINNER JOIN T_BD_MeasureUnit MU ON A.FBaseUnitID=MU.FID").append('\n').append("\tWHERE A.FID=D.FActivityID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank);
        NCMDbUtil.execute((Context)this._calcParam.getCtx(), (String)sb.toString());
        sb.setLength(0);
    }

    protected void initDataSql_CostCalActivityDetailResult(StringBuffer sb) throws BOSException {
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append("( ").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,").append('\n').append("\tFCostCenterID, FOrderID,FProductID,FProdBatchNo,FOrderNumber,").append('\n').append("\tFActivityID,FCostItemID,FAmount,FQty,FCalcLevel )").append('\n').append("SELECT newbosid('C819BF74') AS FID, R.FCompanyOrg As FCompanyID, R.FCalculatePeriod As FCalculatePeriodID, ").append('\n').append("\tFEE.FCostCenterID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,").append('\n').append("\tFEE.FActivityID, FEE.FCostItemID, SUM(FEE.FAmount)As FAmount,SUM(FEE.FQty)As FQty, ").append(this._rank).append(" As FCalcLevel ").append('\n').append("FROM (").append('\n').append("\tSELECT BM.FCostCenterID, B.FOrderID, B.FOrderProductID As FProductID, Isnull(B.FOrderProductLot,N' ') As FProdBatchNo, B.FOrderNumber, BM.FActivityID, BME.FCostItemID, ").append('\n').append("\t\tBME.FBopAmount As FAmount, BME.FBopQty As FQty ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderBalance()).append(" B ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceActivity()).append(" BM ON BM.FParentID=B.FID").append('\n').append("\tLEFT JOIN ").append(this._calcParam.get_tbl_OrderBalanceActivityEntry()).append(" BME ON BME.FParentID=BM.FID ").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT FCostCenterID, FOrderID, FOrderProdID As FProductID, FOrderProdBatchNo As FProdBatchNo, FOrderNumber, FActivityID, FCostItemID, FAmount, FOrderQty As FQty ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OCActivity2OrderAllocResult()).append(" ACT ").append('\n').append(") FEE ").append('\n').append("INNER JOIN T_NCM_OrderRankEntry RE ON RE.FMaterialID=FEE.FProductID AND RE.FMatBatchNo=FEE.FProdBatchNo ").append('\n').append("INNER JOIN T_NCM_OrderRank R ON RE.FParentID= R.FID ").append('\n').append("WHERE R.FCompanyOrg = ? AND R.FCalculatePeriod = ? AND RE.FRank = ? ").append('\n').append("GROUP BY R.FCompanyOrg,R.FCalculatePeriod,FEE.FCostCenterID, FEE.FOrderID, FEE.FOrderID, FEE.FProductID, FEE.FProdBatchNo, FEE.FOrderNumber,FEE.FActivityID, FEE.FCostItemID").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{this._calcParam.getCompanyId(), this._calcParam.getPeriodId(), String.valueOf(this._rank)});
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FCostDriverID)=(").append('\n').append("\tSELECT top 1 ST.FCostDriverID").append('\n').append("\tFROM T_NCM_CostDriverSetByWIP ST ").append('\n').append("\tWHERE ST.FCompanyID = '").append(this._calcParam.getCompanyId()).append("' AND ST.FCalculatePeriodID = '").append(this._calcParam.getPeriodId()).append("' ").append('\n').append("\t\tAND ST.FCostCenterID=D.FCostCenterID AND ST.FCostItemID=D.FCostItemID ").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FAmountPrecision)=(").append('\n').append("\tSELECT CY.FPrecision As FAmountPrecision ").append('\n').append("\tFROM T_BD_Currency CY ").append('\n').append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append('\n').append("\tWHERE CP.FID = '").append(this._calcParam.getCompanyId()).append("' ").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FPricePrecision)=(").append('\n').append("\tSELECT AP.FPrecision AS FPricePrecison ").append('\n').append("\tFROM T_NCM_ActivityPrecision AP ").append('\n').append("\tWHERE AP.FCompanyID = D.FCompanyID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_NCM_Activity A ").append('\n').append("\tINNER JOIN T_BD_MeasureUnit MU ON A.FBaseUnitID=MU.FID").append('\n').append("\tWHERE A.FID=D.FActivityID").append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    private IRowSet getCostDriverSetting_Material() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Select distinct STD.FormulaForParse, STD.FID As FCostDriverID ").append("FROM T_NCM_CostDriver STD ").append("INNER JOIN ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" R ON R.FCostDriverID=STD.FID ").append("WHERE R.FCalcLevel = ").append(this._rank);
        return NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString());
    }

    private IRowSet getCostDriverSetting_Activity() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Select distinct STD.FormulaForParse, STD.FID As FCostDriverID ").append("FROM T_NCM_CostDriver STD ").append("INNER JOIN ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" R ON R.FCostDriverID=STD.FID ").append("WHERE R.FCalcLevel = ").append(this._rank);
        return NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString());
    }

    private void initAllocDataTable(StringBuffer sb, String costDriverId) throws AllocateException {
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        String tblAllocData = this._ausCtx.getTblAllocData();
        sb.append("truncate table  ").append(tblAllocData).append(";");
        sb.append("INSERT INTO ").append(tblAllocData).append("(FID,").append(fieldList).append("FRatio)").append('\n').append("Select FID,").append(fldAstList).append(" 0 As FRatio ").append('\n').append("from ").append(this._calcParam.GetAllocRangeTable()).append('\n').append("Where FCostDriverId='").append(costDriverId).append("' AND FCalcLevel = ").append(this._rank).append(";");
    }

    private void updateAllocDataTable(StringBuffer sb) throws AllocateException {
        sb.append(this._ausCtx.GetAllocStdUnitDataSql());
        sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql());
    }

    protected boolean checkInvalidMatCost() throws BOSException, SQLException {
        boolean isSuccess = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT Distinct MAT.FOrderProdID As FProductID,MAT.FOrderID,bill.FNumber, entry.FSeq,").append('\n').append("\tM.FName_" + this._calcParam.getLocale() + " || '(' || M.FNumber || ')' As FMaterialDisp ").append('\n').append("FROM T_IM_MaterialReqBillEntry entry ").append('\n').append("INNER JOIN ").append(this._calcParam.get_tbl_OCMatAllocResult()).append(" MAT ON MAT.FSourceBillEntryID=entry.FID ").append('\n').append("INNER JOIN ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" CR ON CR.FOrderID=MAT.FOrderID ").append('\n').append("LEFT JOIN T_IM_MaterialReqBill bill ON bill.FID=entry.FParentID ").append('\n').append("LEFT JOIN T_BD_Material M ON M.FID=entry.FMaterialID ").append('\n').append("WHERE MAT.FCompanyID= ? AND MAT.FCalculatePeriodID= ? ").append('\n').append("\tAND entry.FActualCost=0 AND CR.FCalcLevel=").append(this._rank).append('\n').append("Order by bill.FNumber, entry.FSeq ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{this._calcParam.getCompanyId(), this._calcParam.getPeriodId()});
        sb.delete(0, sb.length());
        String possibleReason = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_WIPAlloc_No_Amount_Reason");
        String adviceHandle = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_WIPAlloc_No_Amount_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            String allocErrorInfo = MessageFormat.format(CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_WIPAlloc_No_Amount"), rs.getString("FNumber"), rs.getString("FSeq"), rs.getString("FMaterialDisp"));
            this._calcParam.getCalcLog().AddCalcDetailLog(rs.getString("FProductID"), rs.getString("FOrderID"), allocErrorInfo, possibleReason, adviceHandle);
            rs.next();
        }
        return isSuccess;
    }

    private boolean checkInvalidAllocStdData() throws AllocateException, BOSException, SQLException {
        return true;
    }

    private void adjustInvalidAllocStdData(StringBuffer sb) throws AllocateException {
        String tblAllocData = this._ausCtx.getTblAllocData();
        sb.append("UPDATE ").append(tblAllocData).append(" AS D SET (FRatio)=(").append('\n').append("\tSELECT 0 as FRatio ").append('\n').append("\tFROM ").append(tblAllocData).append(" AD ").append('\n').append("\tWHERE AD.FID=D.FID AND AD.FRatio < 0 ").append('\n').append(");").append('\n');
        sb.append("UPDATE ").append(tblAllocData).append(" AS D SET (FRatio)=(").append('\n').append("\tSELECT 1 as FRatio ").append('\n').append("\tFROM ").append(tblAllocData).append(" AD ").append('\n').append("\tWHERE AD.FID=D.FID AND AD.FRatio > 1 ").append('\n').append(");").append('\n');
        sb.append("UPDATE ").append(this._calcParam.GetAllocResultTable()).append(" AS D SET (FAllocCostDriverData)=(").append('\n').append("\tSELECT AD.FRatio ").append('\n').append("\tFROM ").append(tblAllocData).append(" AD ").append('\n').append("\tWHERE AD.FID=D.FID ").append('\n').append(")Where D.FCalcLevel = ").append(this._rank).append(";").append('\n');
    }

    private void updateCostDriverData_MatDetail2CalResult(StringBuffer sb) throws AllocateException {
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FRatio) = (").append('\n').append("\tSELECT Round(D.FAmount /S.FSumAmount ,12) ").append('\n').append("\tFROM ( ").append('\n').append("\t\tSELECT FCalcLevel,FCostCenterID,FOrderID,FCostItemID,sum(FAmount )As FSumAmount ").append('\n').append("\t\tFROM ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append('\n').append("\t  \tGROUP By FCalcLevel,FCostCenterID,FOrderID,FCostItemID").append('\n').append("\t  \tHaving sum(FAmount ) <> 0 ").append('\n').append("\t)S ").append('\n').append("\tWHERE S.FCalcLevel=D.FCalcLevel AND S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append(")WHERE D.FCalcLevel = ").append(this._rank).append(" ;").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FAllocCostDriverData)=(").append('\n').append("\tSELECT S.FAllocCostDriverData ").append('\n').append("\tFROM ( ").append('\n').append("\t\tSELECT FCalcLevel,FCostCenterID,FOrderID,FCostItemID,Round(sum(FallocCostDriverData * FRatio),12)As FAllocCostDriverData ").append('\n').append("\t\tFROM ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append('\n').append("\t  \tGROUP By FCalcLevel,FCostCenterID,FOrderID,FCostItemID").append('\n').append("\t)S ").append('\n').append("\tWHERE S.FCalcLevel=D.FCalcLevel AND S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append(")WHERE D.FCalcLevel = ").append(this._rank).append(" AND D.FIsMatType = 1 ;").append('\n');
    }

    private void updateCostDriverData_ActivityDetail2CalResult(StringBuffer sb) throws AllocateException {
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FRatio) = (").append('\n').append("\tSELECT Round(D.FAmount /S.FSumAmount ,12) ").append('\n').append("\tFROM ( ").append('\n').append("\t\tSELECT FCalcLevel,FCostCenterID,FOrderID,FCostItemID,sum(FAmount )As FSumAmount ").append('\n').append("\t\tFROM ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append('\n').append("\t  \tGROUP By FCalcLevel,FCostCenterID,FOrderID,FCostItemID").append('\n').append("\t  \tHaving sum(FAmount ) <> 0 ").append('\n').append("\t)S ").append('\n').append("\tWHERE S.FCalcLevel=D.FCalcLevel AND S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append(")WHERE D.FCalcLevel = ").append(this._rank).append(" ;").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" AS D SET (FAllocCostDriverData)=(").append('\n').append("\tSELECT S.FAllocCostDriverData ").append('\n').append("\tFROM ( ").append('\n').append("\t\tSELECT FCalcLevel,FCostCenterID,FOrderID,FCostItemID,Round(sum(FallocCostDriverData * FRatio),12)As FAllocCostDriverData ").append('\n').append("\t\tFROM ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append('\n').append("\t  \tGROUP By FCalcLevel,FCostCenterID,FOrderID,FCostItemID").append('\n').append("\t)S ").append('\n').append("\tWHERE S.FCalcLevel=D.FCalcLevel AND S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append(")WHERE D.FCalcLevel = ").append(this._rank).append(" AND D.FIsMatType = 0;").append('\n');
    }

    private void innerAllocWIPandFinished_CalcResult(StringBuffer sb) throws AllocateException {
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FEoPWIPAmount = Round(FAmount * FAllocCostDriverData, FAmountPrecision), ").append('\n').append("\t      FFinishedAmount = (FAmount-Round(FAmount*FAllocCostDriverData,FAmountPrecision)) ").append('\n').append("WHERE FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FEoPWIPAmount=FAmount, ").append('\n').append("\t      FFinishedAmount=0 ").append('\n').append(" WHERE FTotalEoPWIPQty>0 AND FTotalFinishedQty<=0 ").append('\n').append("\t\tAND FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FEoPWIPAmount=0, ").append('\n').append("\t      FFinishedAmount=FAmount ").append('\n').append(" WHERE FTotalEoPWIPQty<=0 AND FTotalFinishedQty>0 ").append('\n').append("\t\tAND FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FEoPWIPQty=Round(FQty*FAllocCostDriverData,FQtyPrecision), ").append('\n').append("   \t  FFinishedQty=(FQty-Round(FQty*FAllocCostDriverData,FQtyPrecision)) ").append('\n').append("WHERE FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FEoPWIPQty=FQty, ").append('\n').append("\t      FFinishedQty=0 ").append('\n').append(" WHERE FTotalEoPWIPQty>0 AND FTotalFinishedQty<=0 ").append('\n').append("\t\tAND FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FEoPWIPQty=0, ").append('\n').append("\t      FFinishedQty=FQty ").append('\n').append(" WHERE FTotalEoPWIPQty<=0 AND FTotalFinishedQty>0 ").append('\n').append("\t\tAND FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalResult()).append("  ").append('\n').append("\t  Set FFinishedPrice = Round(FFinishedAmount/FFinishedQty,FPricePrecision) ").append('\n').append("WHERE FFinishedQty <> 0 AND FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
    }

    private void innerAllocWIPandFinished_MatDetail(StringBuffer sb) throws AllocateException {
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" ").append('\n').append("\tSet FEoPWIPAmount=Round(FAmount*FAllocCostDriverData,FAmountPrecision), ").append('\n').append("\tFFinishedAmount=(FAmount-Round(FAmount*FAllocCostDriverData,FAmountPrecision)), ").append('\n').append("\tFEoPWIPQty=Round(FQty*FAllocCostDriverData,FQtyPrecision),").append('\n').append("\tFFinishedQty=(FQty-Round(FQty*FAllocCostDriverData,FQtyPrecision))").append('\n').append("WHERE FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FEoPWIPAmount,FFinishedAmount,FEoPWIPQty,FFinishedQty)=(").append('\n').append("\tSELECT D.FAmount As FEoPWIPAmount, 0 As FFinishedAmount ,D.FQty as FEoPWIPQty,0 As FFinishedQty").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" S ").append('\n').append("\tWHERE S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append("     AND S.FTotalEoPWIPQty>0 AND S.FTotalFinishedQty<=0 AND S.FIsMatType=1 ").append("\t  AND S.FCalcLevel = ").append(this._rank).append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalMatDetailResult()).append(" AS D SET (FEoPWIPAmount,FFinishedAmount,FEoPWIPQty,FFinishedQty)=(").append('\n').append("\tSELECT 0 As FEoPWIPAmount, D.FAmount As FFinishedAmount ,0 as FEoPWIPQty,D.FQty As FFinishedQty").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" S ").append('\n').append("\tWHERE S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append("\t  AND S.FTotalEoPWIPQty<=0 AND S.FTotalFinishedQty>0 AND S.FIsMatType=1 ").append("\t  AND S.FCalcLevel = ").append(this._rank).append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
    }

    private void innerAllocWIPandFinished_ActivityDetail(StringBuffer sb) throws AllocateException {
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" ").append('\n').append("\tSet FEoPWIPAmount=Round(FAmount*FAllocCostDriverData,FAmountPrecision), ").append('\n').append("\tFFinishedAmount=(FAmount-Round(FAmount*FAllocCostDriverData,FAmountPrecision)), ").append('\n').append("\tFEoPWIPQty=Round(FQty*FAllocCostDriverData,FQtyPrecision),").append('\n').append("\tFFinishedQty=(FQty-Round(FQty*FAllocCostDriverData,FQtyPrecision))").append('\n').append("WHERE FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FEoPWIPAmount,FFinishedAmount,FEoPWIPQty,FFinishedQty)=(").append('\n').append("\tSELECT D.FAmount As FEoPWIPAmount, 0 As FFinishedAmount ,D.FQty as FEoPWIPQty,0 As FFinishedQty").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" S ").append('\n').append("\tWHERE S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append("     AND S.FTotalEoPWIPQty>0 AND S.FTotalFinishedQty<=0 AND S.FIsMatType=0 ").append("\t  AND S.FCalcLevel = ").append(this._rank).append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityDetailResult()).append(" AS D SET (FEoPWIPAmount,FFinishedAmount,FEoPWIPQty,FFinishedQty)=(").append('\n').append("\tSELECT 0 As FEoPWIPAmount, D.FAmount As FFinishedAmount ,0 as FEoPWIPQty,D.FQty As FFinishedQty").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" S ").append('\n').append("\tWHERE S.FCostCenterID=D.FCostCenterID AND S.FOrderID=D.FOrderID AND S.FCostItemID=D.FCostItemID ").append('\n').append("\t  AND S.FTotalEoPWIPQty<=0 AND S.FTotalFinishedQty>0 AND S.FIsMatType=0 ").append("\t  AND S.FCalcLevel = ").append(this._rank).append('\n').append(")").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
    }

    private void innerAllocWIPandFinished_Activity(StringBuffer sb) throws AllocateException {
        sb.append("UPDATE ").append(this._calcParam.get_tbl_OrderCostCalActivityResult()).append(" SET ").append('\n').append("\tFAllocCostDriverData = 0, FFinishedQty = FQty, FEoPWIPQty = 0  ").append('\n').append("WHERE FCalcLevel = ").append(this._rank).append('\n').append(";").append('\n');
    }

    protected void adjustDiff_Mat() throws BOSException {
        String tblSrc = this._calcParam.get_tbl_OrderCostCalResult();
        String tblDest = this._calcParam.get_tbl_OrderCostCalMatDetailResult();
        StringBuffer sb = new StringBuffer();
        sb.append("Select D.FCostCenterID,D.FOrderID,D.FCostItemID, ").append('\n').append("\t(S.FSrcFinishedAmount-D.FDestFinishedAmount) As FFinishedAmountDiff,(S.FSrcEoPWIPAmount-D.FDestEoPWIPAmount) As FEoPWIPAmountDiff ").append('\n').append("FROM (").append('\n').append("\tSelect FCostCenterID,FOrderID,FCostItemID,Sum(FFinishedAmount)As FDestFinishedAmount,Sum(FEoPWIPAmount)As FDestEoPWIPAmount ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FCalcLevel = ").append(this._rank).append('\n').append("\tGroup by FCostCenterID,FOrderID,FCostItemID ").append('\n').append(")D").append('\n').append("Inner join (").append('\n').append("\tSelect FCostCenterID,FOrderID, FCostItemID,Sum(FFinishedAmount)As FSrcFinishedAmount,Sum(FEoPWIPAmount)As FSrcEoPWIPAmount ").append('\n').append("\tFrom ").append(tblSrc).append('\n').append("\tWHERE FCalcLevel = ").append(this._rank).append('\n').append("\tGroup by FCostCenterID,FOrderID,FCostItemID ").append('\n').append(")S On D.FCostCenterID=S.FCostCenterID AND D.FOrderID=S.FOrderID AND D.FCostItemID=S.FCostItemID ").append('\n').append("Where (S.FSrcFinishedAmount<>D.FDestFinishedAmount OR S.FSrcEoPWIPAmount<>D.FDestEoPWIPAmount) ").append('\n').append("\tAnd (S.FSrcFinishedAmount+S.FSrcEoPWIPAmount=D.FDestFinishedAmount + D.FDestEoPWIPAmount) ").append('\n').append("").append('\n');
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString());
        try {
            sb.delete(0, sb.length());
            sb.append("UPDATE ").append(tblDest).append(" SET FFinishedAmount=(FFinishedAmount + ? ), FEoPWIPAmount=(FEoPWIPAmount + ? ) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FCostCenterID=? AND FOrderID=? AND FCostItemID=? ").append('\n').append("\t\tAND FCalcLevel = ? ").append('\n').append("\tORDER BY FFinishedAmount+FEoPWIPAmount DESC ").append('\n').append(")");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                paramList.add(new Object[]{rs.getBigDecimal("FFinishedAmountDiff"), rs.getBigDecimal("FEoPWIPAmountDiff"), rs.getString("FCostCenterID"), rs.getString("FOrderID"), rs.getString("FCostItemID"), String.valueOf(this._rank)});
                rs.next();
            }
            NCMDbUtil.executeBatch((Context)this._calcParam.getCtx(), (String)sb.toString(), paramList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void adjustDiff_Activity() throws BOSException {
        String tblSrc = this._calcParam.get_tbl_OrderCostCalResult();
        String tblDest = this._calcParam.get_tbl_OrderCostCalActivityDetailResult();
        StringBuffer sb = new StringBuffer();
        sb.append("Select D.FCostCenterID,D.FOrderID,D.FCostItemID, ").append('\n').append("\t(S.FSrcFinishedAmount-D.FDestFinishedAmount) As FFinishedAmountDiff,(S.FSrcEoPWIPAmount-D.FDestEoPWIPAmount) As FEoPWIPAmountDiff ").append('\n').append("FROM (").append('\n').append("\tSelect FCostCenterID,FOrderID,FCostItemID,Sum(FFinishedAmount)As FDestFinishedAmount,Sum(FEoPWIPAmount)As FDestEoPWIPAmount ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FCalcLevel = ").append(this._rank).append('\n').append("\tGroup by FCostCenterID,FOrderID,FCostItemID ").append('\n').append(")D").append('\n').append("Inner join (").append('\n').append("\tSelect FCostCenterID,FOrderID, FCostItemID,Sum(FFinishedAmount)As FSrcFinishedAmount,Sum(FEoPWIPAmount)As FSrcEoPWIPAmount ").append('\n').append("\tFrom ").append(tblSrc).append('\n').append("\tWHERE FCalcLevel = ").append(this._rank).append('\n').append("\tGroup by FCostCenterID,FOrderID,FCostItemID ").append('\n').append(")S On D.FCostCenterID=S.FCostCenterID AND D.FOrderID=S.FOrderID AND D.FCostItemID=S.FCostItemID ").append('\n').append("Where (S.FSrcFinishedAmount<>D.FDestFinishedAmount OR S.FSrcEoPWIPAmount<>D.FDestEoPWIPAmount) ").append('\n').append("\tAnd (S.FSrcFinishedAmount+S.FSrcEoPWIPAmount=D.FDestFinishedAmount + D.FDestEoPWIPAmount) ").append('\n').append("").append('\n');
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString());
        try {
            sb.delete(0, sb.length());
            sb.append("UPDATE ").append(tblDest).append(" SET FFinishedAmount=(FFinishedAmount + ? ), FEoPWIPAmount=(FEoPWIPAmount + ? ) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FCostCenterID=? AND FOrderID=? AND FCostItemID=? ").append('\n').append("\t\tAND FCalcLevel = ? ").append('\n').append("\tORDER BY FFinishedAmount+FEoPWIPAmount DESC ").append('\n').append(")");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                paramList.add(new Object[]{rs.getBigDecimal("FFinishedAmountDiff"), rs.getBigDecimal("FEoPWIPAmountDiff"), rs.getString("FCostCenterID"), rs.getString("FOrderID"), rs.getString("FCostItemID"), String.valueOf(this._rank)});
                rs.next();
            }
            NCMDbUtil.executeBatch((Context)this._calcParam.getCtx(), (String)sb.toString(), paramList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean checkInvalidFinishedUnitCost() throws BOSException, SQLException {
        boolean isSuccess = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FOrderID,D.FProductID,D.FOrderNumber,").append('\n').append("\tMax(Mat.FName_" + this._calcParam.getLocale() + ") || '(' || Max(Mat.FNumber) || ')' As FProductDisp,D.FProdBatchNo, ").append('\n').append("\tSUM(D.FFinishedAmount)As FAmount, MAX(D.FTotalFinishedQty) As FQty ").append('\n').append("FROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" D ").append('\n').append("LEFT JOIN T_BD_Material Mat ON Mat.FID=D.FProductID ").append('\n').append("WHERE D.FCalcLevel = ").append(this._rank).append('\n').append("GROUP BY D.FCostCenterID, D.FOrderID,D.FOrderNumber,D.FProductID,FProdBatchNo ").append('\n').append("HAVING (MAX(D.FTotalFinishedQty)>0 AND SUM(D.FFinishedAmount) <=0) or (MAX(D.FTotalFinishedQty)<0 AND SUM(D.FFinishedAmount) >=0)");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString());
        sb.delete(0, sb.length());
        String possibleReason = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_WIPAlloc_InValid_UnitCost_Reason");
        String adviceHandle = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_WIPAlloc_InValid_UnitCost_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            String allocErrorInfo = MessageFormat.format(CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_WIPAlloc_InValid_UnitCost"), rs.getString("FOrderNumber"), rs.getString("FProductDisp"), rs.getString("FProdBatchNo"), rs.getString("FAmount"), rs.getString("FQty"));
            this._calcParam.getCalcLog().AddCalcDetailLog(rs.getString("FProductID"), rs.getString("FOrderID"), allocErrorInfo, possibleReason, adviceHandle);
            rs.next();
        }
        return isSuccess;
    }
}

