/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class BillAuditChecker
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)BillAuditChecker.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        String descrip = null;
        try {
            OrderCheckResultInfo rinfo;
            sql.append("SELECT DISTINCT Top 100 B.FNumber ").append('\n').append("FROM T_NCM_OrderCCOFeeBill B").append('\n').append("WHERE B.FBillStatus = ? AND B.FCalculatePeriod= ? AND B.FCompanyOrg = ? ").append('\n');
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{String.valueOf(3), periodId, companyId});
            descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_BillAuditChecker_CCOFee");
            while (rs.next()) {
                rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_BillAuditChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_BillAuditChecker_CCOFee"));
                this.rc.add(rinfo);
            }
            sql.delete(0, sql.length());
            sql.append("SELECT DISTINCT Top 100 B.FNumber ").append('\n').append("FROM T_NCM_OrderCCFeeBill B").append('\n').append("WHERE B.FBillStatus=? AND B.FCalculatePeriod= ? AND B.FCompanyOrg=? ").append('\n');
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{String.valueOf(3), periodId, companyId});
            descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_BillAuditChecker_CCFee");
            while (rs.next()) {
                rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_BillAuditChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_BillAuditChecker_CCFee"));
                this.rc.add(rinfo);
            }
            sql.delete(0, sql.length());
            sql.append("SELECT DISTINCT Top 100 B.FNumber ").append('\n').append("FROM T_NCM_OrderReportBill B").append('\n').append("WHERE B.FBillStatus=? AND B.FCalculatePeriod= ? AND B.FCompanyOrg=? ").append('\n');
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{String.valueOf(3), periodId, companyId});
            descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_BillAuditChecker_Rep");
            while (rs.next()) {
                rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_BillAuditChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_BillAuditChecker_Rep"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

