/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostDriverSetByWIPChecker
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)CostDriverSetByWIPChecker.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String PeriodId) throws BOSException {
        CtrlUnitInfo CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT Top 100 C.FNumber As FCostCenterNumber, C.FName_" + locale + " As FCostCenterName, ").append('\n').append("\tI.FNumber As FCostItemNumber, I.FName_" + locale + " As FCostItemName ").append('\n').append(" FROM (T_NCM_OCWIPCountingBill AS D  ").append('\n').append(" INNER JOIN T_NCM_Activity AS A ON D.FCompanyOrg = A.FCompanyID AND D.FActivityID = A.FID ").append('\n').append(" INNER JOIN T_ORG_CostCenter C ON C.FID = A.FCostCenterID )").append('\n').append(" CROSS JOIN T_NCM_CostItem I ").append(" WHERE D.FCompanyOrg = ? AND D.FCalculatePeriod = ? ").append("\tAND (I.FAdminCUID = ? ").append('\n').append("\t\tOR I.FID IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '548C5A91' AND FAssignCUID = ? ))").append('\n').append("\tand not exists( ").append('\n').append("\t\tSelect 1 ").append('\n').append("\t\tFROM T_NCM_CostDriverSetByWIP W ").append('\n').append("\t\tWHERE W.FCompanyID=D.FCompanyOrg AND W.FCalculatePeriodID=D.FCalculatePeriod ").append('\n').append("\t\t\tAND W.FCostCenterID=C.FID AND W.FCostItemID=I.FID AND W.FCostDriverID Is not null ").append('\n').append("\t) ").append('\n');
        Object[] params = new Object[]{companyId, PeriodId, CU.getId().toString(), CU.getId().toString()};
        IRowSet rs = null;
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_CostDriverSetByWIPChecker");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FCostCenterName") + "(" + rs.getString("FCostCenterNumber") + ")", rs.getString("FCostItemName") + "(" + rs.getString("FCostItemNumber") + ")"));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_CostDriverSetByWIPChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_CostDriverSetByWIPChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

