/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ManufactureRecHasOrderChecker
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)ManufactureRecHasOrderChecker.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct Top 100 PARENT.FNUMBER ").append('\n').append(" FROM T_IM_ManufactureRecBill AS  PARENT ").append('\n').append(" INNER JOIN T_SCM_TransactionType AS TRANS ON PARENT.FTransactionTypeID = TRANS.FID AND TRANS.FIsManuCostCalculate=1 ").append('\n').append(" INNER JOIN T_IM_ManufactureRecBillEntry AS ENTRY ON PARENT.FID = ENTRY.FParentID ").append('\n').append(" INNER JOIN T_IM_InvUpdateType ut on ENTRY.FINVUPDATETYPEID = ut.fid ").append('\n').append(" INNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append(" LEFT OUTER JOIN T_BD_Period AS  YEARPERIOD ON (PARENT.FYear = YEARPERIOD.FPeriodYear AND PARENT.FPeriod = YEARPERIOD.FPeriodNumber) ").append('\n').append(" WHERE (PARENT.FBASESTATUS = ? AND ENTRY.FManuBillID is null AND ").append(" \tENTRY.FCompanyOrgUnitID = ? AND YEARPERIOD.FID = ?)");
        Object[] params = new Object[]{String.valueOf(4), companyId, periodId};
        IRowSet rs = null;
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_ManufactureRecHasOrderChecker");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNUMBER")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_ManufactureRecHasOrderChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_ManufactureRecHasOrderChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

