/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class MaterialFeeUnAssignedChecher
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)MaterialFeeUnAssignedChecher.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        String tblAllocResult = null;
        try {
            tblAllocResult = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCMatAllocResult");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        PeriodInfo period = null;
        try {
            period = (PeriodInfo)PeriodFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(periodId));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT Top 100 B.FNumber,E.FSeq").append('\n').append("FROM T_IM_MaterialReqBill B").append('\n').append("LEFT OUTER JOIN T_IM_MaterialReqBillEntry E ON B.FID = E.FParentID").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter C ON E.FCostCenterOrgUnitID = C.FID").append('\n').append("LEFT OUTER JOIN T_SCM_TransactionType TT ON B.FTransactionTypeID = TT.FID").append('\n').append("INNER JOIN T_IM_InvUpdateType ut on E.FINVUPDATETYPEID = ut.fid ").append('\n').append("INNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid ").append('\n').append("WHERE B.FBaseStatus=? AND B.FYear = ? AND B.FPeriod= ? AND E.FCompanyOrgUnitID=? AND C.FCostCenterType=? AND TT.FIsManuCostCalculate=? AND FOrderNumber is not null ").append('\n').append("AND st.FISFORWARDAMT = 1 ").append('\n').append("\tAND NOT EXISTS(").append('\n').append("  \t\tSELECT 1").append('\n').append("\t\tFROM ").append(tblAllocResult).append(" S").append('\n').append("\t\tWHERE S.FSourceBillID=B.FID AND S.FSourceBillEntryID=E.FID AND S.FCompanyID=? AND S.FCalculatePeriodID=?").append('\n').append("\t)").append('\n');
        Object[] params = new Object[]{String.valueOf(4), String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber()), companyId, String.valueOf(0), String.valueOf(1), companyId, periodId};
        IRowSet rs = null;
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_MaterialFeeUnAssignedChecher");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber"), rs.getString("FSeq")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_MaterialFeeUnAssignedChecher"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_MaterialFeeUnAssignedChecher"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

