/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.order.fact.cal.IOrderRank;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.OrderRankFactory;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RankCodeCycleChecker
extends OrderCalChecker {
    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        OrderCheckResultCollection results = new OrderCheckResultCollection();
        this.checking(ctx, CompanyOrgID, PeriodId, results);
        return results;
    }

    private void checking(Context ctx, String CompanyOrgID, String PeriodId, OrderCheckResultCollection results) throws BOSException, EASBizException {
        OrderCheckResultInfo result = null;
        IOrderRank iRank = OrderRankFactory.getLocalInstance(ctx);
        Map co_billNumbers = null;
        try {
            co_billNumbers = iRank.checkAndMakeBill(CompanyOrgID, PeriodId);
        }
        catch (EASBizException e) {
            if (EASBizException.CHECKBLANK.getCode().equals(e.getSubCode()) || EASBizException.CHECKDUPLICATED.getCode().equals(e.getSubCode())) {
                result = new OrderCheckResultInfo();
                result.setDescription(CalcAppUntil.getOrderCheckResource(ctx, "RankCodeCycleChecker_description2"));
                result.setReason(CalcAppUntil.getOrderCheckResource(ctx, "RankCodeCycleChecker_reason2"));
                result.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "RankCodeCycleChecker_SO2"));
                results.add(result);
                return;
            }
            throw e;
        }
        if (co_billNumbers == null || co_billNumbers.size() == 0) {
            return;
        }
        Set cos = co_billNumbers.keySet();
        Iterator coItr = cos.iterator();
        Iterator numberItr = null;
        String coNumber = null;
        String billNumber2 = null;
        Set billNumbers = null;
        StringBuffer tips = new StringBuffer();
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_RankCodeCycleChecker");
        boolean hasBal = false;
        while (coItr.hasNext()) {
            coNumber = (String)coItr.next();
            billNumbers = (Set)co_billNumbers.get(coNumber);
            for (String billNumber2 : billNumbers) {
                if (billNumber2 == null) {
                    hasBal = true;
                    continue;
                }
                tips.append(" ").append(billNumber2);
            }
            if (hasBal) {
                // empty if block
            }
            tips.append("\n");
            result = new OrderCheckResultInfo();
            result.setDescription(MessageFormat.format(descrip, coNumber, tips.toString()));
            tips.delete(0, tips.length());
            result.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_RankCodeCycleChecker"));
            result.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_RankCodeCycleChecker"));
            results.add(result);
        }
    }
}

