/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ValidOrderChecker
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)OrderCalChecker.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String PeriodId) throws BOSException {
        try {
            CalcAppUntil.prepareOrderData(ctx, companyId, PeriodId, false);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        String tbl_DataByOrder = null;
        try {
            tbl_DataByOrder = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)PeriodId, (String)"T_NCM_DataByOrder");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Top 1 1 ").append('\n').append("FROM ").append(tbl_DataByOrder).append(" D ").append('\n');
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_ValidOrderChecker"));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_ValidOrderChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_ValidOrderChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

