/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WIPCountingNegativeChecker
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)WIPCountingNegativeChecker.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct Top 100 D.FOrderNumber, A.FNumber As FActivityNumber, A.FName_" + locale + " As FActivityName ").append('\n').append(" FROM T_NCM_OCWIPCountingBill AS D  ").append('\n').append(" LEFT JOIN T_NCM_Activity AS A ON D.FCompanyOrg = A.FCompanyID AND D.FActivityID = A.FID ").append('\n').append(" WHERE D.FCompanyOrg = ? AND D.FCalculatePeriod = ? ").append("\tAND (D.FEUntoCntQty < 0 Or D.FEUntoQty < 0 )");
        IRowSet rs = null;
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_WIPCountingNegativeChecker");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
            while (rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FOrderNumber"), rs.getString("FActivityName") + "(" + rs.getString("FActivityNumber") + ")"));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_WIPCountingNegativeChecker"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_WIPCountingNegativeChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

