/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;

public class CalcAppUntil {
    public static final char CLF = '\n';

    public static String getSrvCalcResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.cal.OrderCalcResource", (String)key, (Locale)ctx.getLocale());
    }

    public static String getOrderCheckResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.cal.OrderCheckResource", (String)key, (Locale)ctx.getLocale());
    }

    public static String getSrvReportResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)key, (Locale)ctx.getLocale());
    }

    public static String getcalcHMSString(Context ctx, int timeSecond) {
        int timeInSecond;
        String resHour = ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.cal.OrderCalcResource", (String)"COST_HOUR", (Locale)ctx.getLocale());
        String resMinute = ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.cal.OrderCalcResource", (String)"COST_MINUTE", (Locale)ctx.getLocale());
        String resSecond = ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.cal.OrderCalcResource", (String)"COST_SECOND", (Locale)ctx.getLocale());
        int es = timeSecond / 1000;
        int hour = es / 3600;
        int timeInminute = es - hour * 3600;
        int minute = timeInminute / 60;
        int second = timeInSecond = timeInminute - minute * 60;
        return hour + " " + resHour + " " + minute + " " + resMinute + " " + second + " " + resSecond;
    }

    public static void prepareOrderData(Context ctx, String companyId, String periodId, boolean orderRangeOnly) throws EASBizException, BOSException {
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        String strStorageOrgUnitIds = null;
        if (storageOrgUnitIds.size() <= 0) {
            return;
        }
        try {
            strStorageOrgUnitIds = BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds);
            IPeriod period = null;
            PeriodInfo periodinfo = null;
            try {
                period = PeriodFactory.getLocalInstance((Context)ctx);
                ObjectStringPK periodpk = new ObjectStringPK(periodId);
                periodinfo = period.getPeriodInfo((IObjectPK)periodpk);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            String tbl_DataByOrder = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_DataByOrder");
            String tblOrderBalance = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OrderBalance");
            DynamicTableManager.TruncateTables((Context)ctx, (String[])new String[]{tbl_DataByOrder});
            StringBuffer ksql = new StringBuffer();
            ksql.append("insert into " + tbl_DataByOrder).append('\n').append("    ( ").append('\n').append("    FID,FCompanyID,FCalculatePeriodID,FOrderID,FOrderNumber,FProductID,FProdBatchNo, ").append("    FPlanQty,FTotalFinishedQty ").append('\n').append("    ) ").append('\n').append("select newbosid('B5688415') As FID, '").append(companyId).append("' As FCompanyID, '").append(periodId).append("' As FCalculatePeriodID, ").append("\tZ.FOrderID, Z.FOrderNumber, Z.FProductID, Z.FProdBatchNo, Max(Z.FPlanQty)As FPlanQty, Max(Z.FTotalFinishedQty)As FTotalFinishedQty ").append('\n').append("from ( ").append('\n').append("\tSelect o.FID As FOrderID, o.FNumber As FOrderNumber, o.FMaterialID As FProductID, TO_CHAR(Isnull(o.FLot,N' ')) As FProdBatchNo, ").append('\n').append("     \tcase when o.FActureBeginDate >= ? and o.FActureBeginDate <= ? then o.FBaseQty else 0 end As FPlanQty, o.FToStoreBaseQty As FTotalFinishedQty ").append('\n').append("\tfrom T_MM_ManufactureOrder o ").append('\n').append("\twhere o.FBaseStatus in ( ").append("    5, ").append("    7, ").append("    8").append("\t) ").append('\n').append("\tand o.FStorageOrgUnitID in " + strStorageOrgUnitIds).append('\n').append("\tand o.FActureBeginDate <= ? ").append('\n');
            ksql.append("\tUNION ").append('\n').append("\tSELECT B.FOrderID, B.FOrderNumber, B.FOrderProductID as FProductID, TO_CHAR(B.FOrderProductLot) as FProdBatchNo,").append('\n').append("\t\t0.00 As FPlanQty, Sum(FFinishedQty) As FTotalFinishedQty ").append('\n').append("\tFROM ").append(tblOrderBalance).append(" B ").append('\n').append("\tGROUP BY B.FOrderID, B.FOrderNumber, B.FOrderProductID, B.FOrderProductLot ").append('\n').append("\tHAVING SUM(B.FBopWIPQty) <>0 ").append('\n').append(") Z ").append("Group by Z.FOrderID, Z.FOrderNumber, Z.FProductID, Z.FProdBatchNo ");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString(), (Object[])new Object[]{periodinfo.getBeginDate(), periodinfo.getEndDate(), periodinfo.getEndDate()});
            if (!orderRangeOnly) {
                CalcAppUntil.prepareOrderDetailData(ctx, companyId, periodId, tbl_DataByOrder, strStorageOrgUnitIds, periodinfo.getPeriodYear(), periodinfo.getPeriodNumber());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void prepareOrderDetailData(Context ctx, String companyId, String periodId, String tbl_DataByOrder, String strStorageOrgUnitIds, int periodYear, int periodNumber) throws EASBizException, BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("Update ").append(tbl_DataByOrder).append(" d set ").append(" FFinishedQty = isnull(( \n").append('\n').append("    select sum(e.FBaseQty) from T_IM_ManufactureRecBill b ").append('\n').append("    join T_IM_ManufactureRecBillEntry e on e.FParentID = b.FID ").append('\n').append("    and b.FBaseStatus = 4 ").append('\n').append("    and b.FStorageOrgUnitID in " + strStorageOrgUnitIds + " ").append('\n').append("    join T_SCM_TransactionType tt on tt.FID = b.FTransactionTypeID ").append('\n').append("    and tt.FIsManuCostCalculate = 1 ").append('\n').append("\tinner join T_IM_InvUpdateType ut on e.FINVUPDATETYPEID = ut.fid ").append('\n').append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append("    where e.FManuBillID = d.FOrderID ").append('\n').append("    and b.FYear = " + periodYear + " ").append('\n').append("    and b.FPeriod = " + periodNumber + " ").append('\n').append("), 0), ").append('\n').append(" FEoPWIPQty = isnull(( ").append('\n').append("    select B.FEUntoCntQty  ").append('\n').append("    from T_NCM_OCWIPCountingBill B ").append('\n').append("    where B.FCompanyOrg=D.FCompanyID AND B.FCalculatePeriod=D.FCalculatePeriodID AND B.FOrderID = D.FOrderID AND B.FActivityID is null ").append('\n').append("), 0) ").append('\n');
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
    }
}

