/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.TimeUnitTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCActivityCostStatReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.report.app.OCActivityCostStatReport");

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(99), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    private int getPeriodNumber(String companyId, String periodYear, String periodNumber) throws EASBizException, BOSException {
        int number = 0;
        if (periodYear == null || periodNumber == null || periodYear.length() != 4 || periodNumber.length() != 1 && periodNumber.length() != 2) {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            number = currPeriod.getNumber();
            return number;
        }
        if (periodNumber.length() == 1) {
            periodNumber = "0" + periodNumber;
        }
        String temp = periodYear + periodNumber;
        number = new Integer(temp);
        return number;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        Set periodIds;
        IRowSet rs = null;
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        Integer fromPeriod = this.getFromPeriod(filter);
        Integer toPeriod = this.getToPeriod(filter);
        String periodId2 = null;
        try {
            periodIds = OrderCMUtils.getPeriodIds(this.getContext(), company, fromPeriod, toPeriod);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (periodIds.size() <= 0) {
            return rs;
        }
        String T_NCM_OrderBalance = null;
        Map T_NCM_OrderBalances = null;
        String T_NCM_OrderBalanceActivity = null;
        Map T_NCM_OrderBalanceActivitys = null;
        String T_NCM_OrderBalanceActivityEntry = null;
        Map T_NCM_OrderBalanceActivityEntrys = null;
        String T_NCM_OrderCostCalActivityDetailResult = null;
        Map T_NCM_OrderCostCalActivityDetailResults = null;
        String T_NCM_OrderCostCalActivityResult = null;
        Map T_NCM_OrderCostCalActivityResults = null;
        String T_NCM_DataByOrder = null;
        Map T_NCM_DataByOrders = null;
        try {
            T_NCM_OrderBalances = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderBalance");
            T_NCM_OrderBalanceActivitys = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderBalanceActivity");
            T_NCM_OrderBalanceActivityEntrys = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderBalanceActivityEntry");
            T_NCM_OrderCostCalActivityDetailResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderCostCalActivityDetailResult");
            T_NCM_OrderCostCalActivityResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderCostCalActivityResult");
            T_NCM_DataByOrders = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_DataByOrder");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String sTmpTblName = this.createTmpTableSQL();
        StringBuffer sbSQL = new StringBuffer();
        for (String periodId2 : periodIds) {
            T_NCM_OrderBalance = (String)T_NCM_OrderBalances.get(periodId2);
            T_NCM_OrderBalanceActivity = (String)T_NCM_OrderBalanceActivitys.get(periodId2);
            T_NCM_OrderBalanceActivityEntry = (String)T_NCM_OrderBalanceActivityEntrys.get(periodId2);
            T_NCM_OrderCostCalActivityDetailResult = (String)T_NCM_OrderCostCalActivityDetailResults.get(periodId2);
            T_NCM_OrderCostCalActivityResult = (String)T_NCM_OrderCostCalActivityResults.get(periodId2);
            T_NCM_DataByOrder = (String)T_NCM_DataByOrders.get(periodId2);
            if (T_NCM_OrderBalance == null || T_NCM_OrderBalanceActivity == null || T_NCM_OrderBalanceActivityEntry == null || T_NCM_OrderCostCalActivityDetailResult == null || T_NCM_OrderCostCalActivityResult == null || T_NCM_DataByOrder == null) continue;
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append(" \t  (FTotalRow,FTotalRow2,FCompanyOrg,\n").append("      FPeriodID,FPeriodName,FPeriodNumber,\n").append("\t   FManufactureOrderID,FManufactureOrderName,FManufactureOrderNumber,\n").append("\t   FProductID,FProductName,FProductNumber,FProductModel,FLot,\n").append("      FBaseUnitName,FPlanQty,FFinishedProductQty, \n").append("\t   FCostCenterID,FCostCenterName,FCostCenterNumber,\n").append("\t   FCostItemID,FCostItemName,FCostItemNumber,\n").append("\t   FActivityID,FActivityName,FActivityNumber,FActivityUnitName,\n").append("\t   FActivityQty,FActivityTotalQty, \n").append("\t   FBcToUnewhQty,FBUntoQty,FBopAmount,\n").append("\t   FCurInputQty,FCurInputAmount,FTotalInputAmount,\n").append("\t   FEcToUnewhQty,FEUntoCntQty,FWIPAmount,\n").append("\t   FCurFinishedQty,FCurFinishedAmount,FCurFinishedPrice,\n").append("\t   FTotalFinishedQty,FTotalFinishedAmount,\n").append("      FIsTotalRow,\n").append("      FTotalManufactureRow,FTotalProductRow,FTotalCostCenterRow,FTotalCostItemRow,FTotalActivityRow, \n").append("      FProductQtyPrecision,FMatQtyPrecision,FAmountPrecision) \n").append("SELECT 0,0,t4.FCompanyID,\n").append("       t4.FCalculatePeriodID,TO_Char(t9.FNumber) as FPeriodName, TO_Char(t9.FNumber) as FPeriodNumber,\n").append("\t    t4.FOrderID,t7.FNumber as FManufactureOrderName, t7.FNumber as FManufactureOrderNumber,\n").append("\t    t4.FProductID,t13.FName_l2 as FProductName, t13.FNumber as FProductNumber,t13.FModel as FProductModel,t7.FLot as FLot,\n").append("       '' as FBaseUnitName,t7.FQty as FPlanQty, t6.FFinishedQty as FFinishedProductQty, \n").append("\t    t4.FCostCenterID,t8.FName_l2 as FCostCenterName,t8.FNumber as FCostCenterNumber,\n").append("\t    t4.FCostItemID,t10.FName_l2 as FCostItemName,t10.FNumber as FCostItemNumber,\n").append("\t    t4.FActivityID,t11.FName_l2 as FActivityName,t11.FNumber as FActivityNumber,'' as FActivityUnitName, \n").append("\t    isnull(t5.FEoPWIPQty,0) + isnull(t5.FFinishedQty,0) as FActivityQty, \n").append("       isnull(t5.FFinishedQty,0) as FActivityTotalQty, \n").append("\t    t2.FBcToUnewhQty as FBcToUnewhQty, t2.FBUntoQty as FBUntoQty,t3.FBopAmount as FBopAmount, \n").append("       t12.FCTiQty as FCurInputQty, isnull(t4.FFinishedAmount,0) + isnull(t4.FEoPWIPAmount,0)-isnull(t3.FBopAmount,0) as FCurInputAmount, \n").append("       isnull(t4.FFinishedAmount,0) + isnull(t4.FEoPWIPAmount,0) as FTotalInputAmount, \n").append("       t12.FEcToUnewhQty as FEcToUnewhQty, t12.FEUntoCntQty as FEUntoCntQty, t4.FEoPWIPAmount as FWIPAmount,").append("\t    t6.FFinishedQty as FCurFinishedQty, t4.FFinishedAmount as FCurFinishedAmount, \n").append("       case when t6.FFinishedQty = 0 then 0 else FFinishedAmount/t6.FFinishedQty end as FCurFinishedPrice, \n").append("\t    isnull(t1.FFinishedQty,0) + t6.FFinishedQty as FTotalFinishedQty, \n").append("       isnull(t3.FcumFinishedAmount,0) + isnull(t4.FFinishedAmount,0) as FTotalFinishedAmount, \n").append("      0 as FIsTotalRow,\n").append("      0 FTotalManufactureRow,0 FTotalProductRow,0 FTotalCostCenterRow,0 FTotalCostItemRow,0 FTotalActivityRow, \n").append("      0 FProductQtyPrecision,0 FMatQtyPrecision,0 FAmountPrecision \n").append("FROM ").append(T_NCM_OrderBalance).append(" t1\n").append("INNER JOIN ").append(T_NCM_OrderBalanceActivity).append(" t2 on t2.FParentID=t1.FID\n").append("INNER JOIN ").append(T_NCM_OrderBalanceActivityEntry).append(" t3 on t3.FParentID=t2.FID\n").append("full JOIN ").append(T_NCM_OrderCostCalActivityDetailResult).append(" t4 on t1.FCompanyOrg=t4.FCompanyID\n").append("       AND t1.FCalculatePeriod=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t1.FOrderID\n").append("       AND t4.FCostCenterID=t2.FCostCenterID\n").append("       AND t4.FCostItemID=t3.FCostItemID\n").append("       AND t4.FActivityID=t2.FActivityID \n").append("       AND t4.FProductID=t1.FOrderProductID and isnull(t4.FProdBatchNo,' ')=isnull(t1.FOrderProductLot, ' ') \n").append("full JOIN ").append(T_NCM_OrderCostCalActivityResult).append(" t5 on t5.FCompanyID=t4.FCompanyID\n").append("       AND t5.FCalculatePeriodID=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t5.FOrderID\n").append("       AND t4.FCostCenterID=t5.FCostCenterID\n").append("       AND t4.FActivityID=t5.FActivityID\n").append("       AND t4.FProductID=t5.FProductID and isnull(t4.FProdBatchNo,' ')=isnull(t5.FProdBatchNo, ' ') \n").append("full JOIN ").append(T_NCM_DataByOrder).append(" t6 on t6.FCompanyID=t4.FCompanyID\n").append("       AND t6.FCalculatePeriodID=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t6.FOrderID\n").append("INNER JOIN T_MM_ManufactureOrder t7 on t4.FOrderID=t7.FID\n").append("INNER JOIN T_ORG_CostCenter t8 on t4.FCostCenterID=t8.FID\n").append("INNER JOIN T_BD_Period t9 on t4.FCalculatePeriodID=t9.FID\n").append("INNER JOIN T_NCM_CostItem t10 on t4.FCostItemID=t10.FID \n").append("INNER JOIN T_NCM_Activity t11 on t4.FActivityID=t11.FID\n").append("left JOIN T_NCM_OCWIPCountingBill t12 on t12.FCalculatePeriod = t4.FCalculatePeriodID and t12.FOrderID = t4.FOrderID and t12.FOrderProductID = t4.FProductID and t12.FActivityID =  t11.FID \n").append("INNER JOIN T_BD_Material t13 on t4.FProductID=t13.FID\n").append(" WHERE 1 = 1 \n");
            this.AppendPredicate(sbSQL, filter, true, "t9.FNumber", "", "");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "costcenterFrom");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "costcenterTo");
            this.AppendPredicate(sbSQL, filter, false, "t7.FNumber", ">=", "manufacturerOrderFrom");
            this.AppendPredicate(sbSQL, filter, false, "t7.FNumber", "<=", "manufacturerOrderTo");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", ">=", "costitemFrom");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", "<=", "costitemTo");
            this.AppendPredicate(sbSQL, filter, false, "t11.FNumber", ">=", "activityFrom");
            this.AppendPredicate(sbSQL, filter, false, "t11.FNumber", "<=", "activityTo");
            this.AppendPredicate(sbSQL, filter, false, "t13.FNumber", ">=", "productFrom");
            this.AppendPredicate(sbSQL, filter, false, "t13.FNumber", "<=", "productTo");
            DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
            sbSQL.delete(0, sbSQL.length() - 1);
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append(" \t  (FTotalRow,FTotalRow2,FCompanyOrg,\n").append("      FPeriodID,FPeriodName,FPeriodNumber,\n").append("\t   FManufactureOrderID,FManufactureOrderName,FManufactureOrderNumber,\n").append("\t   FProductID,FProductName,FProductNumber,FProductModel,FLot,\n").append("      FBaseUnitName,FPlanQty,FFinishedProductQty, \n").append("\t   FCostCenterID,FCostCenterName,FCostCenterNumber,\n").append("\t   FCostItemID,FCostItemName,FCostItemNumber,\n").append("\t   FActivityID,FActivityName,FActivityNumber,FActivityUnitName,\n").append("\t   FActivityQty,FActivityTotalQty, \n").append("\t   FBcToUnewhQty,FBUntoQty,FBopAmount,\n").append("\t   FCurInputQty,FCurInputAmount,FTotalInputAmount,\n").append("\t   FEcToUnewhQty,FEUntoCntQty,FWIPAmount,\n").append("\t   FCurFinishedQty,FCurFinishedAmount,FCurFinishedPrice,\n").append("\t   FTotalFinishedQty,FTotalFinishedAmount,\n").append("      FIsTotalRow,\n").append("      FTotalManufactureRow,FTotalProductRow,FTotalCostCenterRow,FTotalCostItemRow,FTotalActivityRow, \n").append("      FProductQtyPrecision,FMatQtyPrecision,FAmountPrecision) \n").append("SELECT 0,0,t1.FCompanyOrg,\n").append("       t1.FCalculatePeriod,TO_Char(t9.FNumber) as FPeriodName, TO_Char(t9.FNumber) as FPeriodNumber,\n").append("\t    t1.FOrderID,t7.FNumber as FManufactureOrderName, t7.FNumber as FManufactureOrderNumber,\n").append("\t    t1.FOrderProductID,t13.FName_l2 as FProductName, t13.FNumber as FProductNumber,t13.FModel as FProductModel,t7.FLot as FLot,\n").append("       '' as FBaseUnitName,t7.FQty as FPlanQty, t6.FFinishedQty as FFinishedProductQty, \n").append("\t    t2.FCostCenterID,t8.FName_l2 as FCostCenterName,t8.FNumber as FCostCenterNumber,\n").append("\t    t3.FCostItemID,t10.FName_l2 as FCostItemName,t10.FNumber as FCostItemNumber,\n").append("\t    t2.FActivityID,t11.FName_l2 as FActivityName,t11.FNumber as FActivityNumber,'' as FActivityUnitName, \n").append("\t    isnull(t5.FEoPWIPQty,0) + isnull(t5.FFinishedQty,0) as FActivityQty, \n").append("       isnull(t5.FEoPWIPQty,0) + isnull(t5.FFinishedQty,0) + isnull(t2.FBopQty,0) as FActivityTotalQty, \n").append("\t    t2.FBcToUnewhQty as FBcToUnewhQty, t2.FBUntoQty as FBUntoQty,t3.FBopAmount as FBopAmount, \n").append("       t12.FCTiQty as FCurInputQty, 0 as FCurInputAmount, \n").append("       isnull(t4.FFinishedAmount,0) + isnull(t4.FEoPWIPAmount,0) as FTotalInputAmount, \n").append("       t12.FEcToUnewhQty as FEcToUnewhQty, t12.FEUntoCntQty as FEUntoCntQty, t4.FEoPWIPAmount as FWIPAmount,").append("\t    t6.FFinishedQty as FCurFinishedQty, t4.FFinishedAmount as FCurFinishedAmount, \n").append("       case when t6.FFinishedQty = 0 then 0 else FFinishedAmount/t6.FFinishedQty end as FCurFinishedPrice, \n").append("\t    isnull(t1.FFinishedQty,0) + t6.FFinishedQty as FTotalFinishedQty, \n").append("       isnull(t3.FcumFinishedAmount,0) + isnull(t4.FFinishedAmount,0) as FTotalFinishedAmount, \n").append("      0 as FIsTotalRow,\n").append("      0 FTotalManufactureRow,0 FTotalProductRow,0 FTotalCostCenterRow,0 FTotalCostItemRow,0 FTotalActivityRow, \n").append("      0 FProductQtyPrecision,0 FMatQtyPrecision,0 FAmountPrecision \n").append("FROM ").append(T_NCM_OrderBalance).append(" t1\n").append("INNER JOIN ").append(T_NCM_OrderBalanceActivity).append(" t2 on t2.FParentID=t1.FID\n").append("INNER JOIN ").append(T_NCM_OrderBalanceActivityEntry).append(" t3 on t3.FParentID=t2.FID\n").append("full JOIN ").append(T_NCM_OrderCostCalActivityDetailResult).append(" t4 on t1.FCompanyOrg=t4.FCompanyID\n").append("       AND t1.FCalculatePeriod=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t1.FOrderID\n").append("       AND t4.FCostCenterID=t2.FCostCenterID\n").append("       AND t4.FCostItemID=t3.FCostItemID\n").append("       AND t4.FActivityID=t2.FActivityID \n").append("       AND t4.FProductID=t1.FOrderProductID and isnull(t4.FProdBatchNo,' ')=isnull(t1.FOrderProductLot, ' ') \n").append("full JOIN ").append(T_NCM_OrderCostCalActivityResult).append(" t5 on t5.FCompanyID=t4.FCompanyID\n").append("       AND t5.FCalculatePeriodID=t1.FCalculatePeriod\n").append("       AND t1.FOrderID=t5.FOrderID\n").append("       AND t2.FCostCenterID=t5.FCostCenterID\n").append("       AND t2.FActivityID=t5.FActivityID\n").append("       AND t1.FOrderProductID=t5.FProductID and isnull(t1.FOrderProductLot,' ')=isnull(t5.FProdBatchNo, ' ') \n").append("full JOIN ").append(T_NCM_DataByOrder).append(" t6 on t6.FCompanyID=t4.FCompanyID\n").append("       AND t6.FCalculatePeriodID=t1.FCalculatePeriod\n").append("       AND t1.FOrderID=t6.FOrderID\n").append("INNER JOIN T_MM_ManufactureOrder t7 on t1.FOrderID=t7.FID\n").append("INNER JOIN T_ORG_CostCenter t8 on t2.FCostCenterID=t8.FID\n").append("INNER JOIN T_BD_Period t9 on t1.FCalculatePeriod=t9.FID\n").append("INNER JOIN T_NCM_CostItem t10 on t3.FCostItemID=t10.FID \n").append("INNER JOIN T_NCM_Activity t11 on t2.FActivityID=t11.FID\n").append("left JOIN T_NCM_OCWIPCountingBill t12 on t12.FCalculatePeriod = t1.FCalculatePeriod and t12.FOrderID = t1.FOrderID and t12.FOrderProductID = t1.FOrderProductID and t12.FActivityID =  t11.FID \n").append("INNER JOIN T_BD_Material t13 on t1.FOrderProductID=t13.FID\n").append(" WHERE 1 = 1 and t6.FFinishedQty is null and t12.FEUntoCntQty is null \n");
            this.AppendPredicate(sbSQL, filter, true, "t9.FNumber", "", "");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "costcenterFrom");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "costcenterTo");
            this.AppendPredicate(sbSQL, filter, false, "t7.FNumber", ">=", "manufacturerOrderFrom");
            this.AppendPredicate(sbSQL, filter, false, "t7.FNumber", "<=", "manufacturerOrderTo");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", ">=", "costitemFrom");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", "<=", "costitemTo");
            this.AppendPredicate(sbSQL, filter, false, "t11.FNumber", ">=", "activityFrom");
            this.AppendPredicate(sbSQL, filter, false, "t11.FNumber", "<=", "activityTo");
            this.AppendPredicate(sbSQL, filter, false, "t13.FNumber", ">=", "productFrom");
            this.AppendPredicate(sbSQL, filter, false, "t13.FNumber", "<=", "productTo");
            DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
            sbSQL.delete(0, sbSQL.length() - 1);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FBaseUnitName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID\n").append("      WHERE t1.FProductID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FActivityUnitName)=\n").append("  (SELECT \n").append("\tcase when t2.FTimeUnit = 10 then '" + TimeUnitTypeEnum.hour.getAlias() + "' \n").append("\t     when t2.FTimeUnit = 20 then '" + TimeUnitTypeEnum.minute.getAlias() + "' \n").append("\t     when t2.FTimeUnit = 30 then '" + TimeUnitTypeEnum.second.getAlias() + "' \n").append("\t     else ' ' \n").append("\tend  as FTimeUnitName \n").append("      FROM T_NCM_Activity t2\n").append("      WHERE t1.FActivityID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FProductQtyPrecision)=\n").append("  (SELECT t3.FQtyPrecision \n").append("      FROM T_MM_ManuFactureOrder t2\n").append("      LEFT JOIN t_BD_MeasureUnit t3 on t2.FBaseUnitID=t3.FID\n").append("      WHERE t1.FManufactureOrderID=t2.FID);\n");
        sbSQL.append("UPDATE ").append(sTmpTblName).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        HashMap<String, Integer> totalrows = new HashMap<String, Integer>();
        int totalrow = 104;
        ArrayList tblData = (ArrayList)filter.getObject("table");
        sbSQL = new StringBuffer();
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodNumberOrder,FTotalPeriodRow " + orderByMode + ",");
            }
            if ("FManufactureOrderID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FManufactureOrderNumberOrder,FTotalManufactureRow " + orderByMode + ",");
            } else if ("FProductID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProductNumberOrder,FTotalProductRow " + orderByMode + ",");
            } else if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumberOrder,FTotalCostCenterRow " + orderByMode + ",");
            } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostItemNumberOrder,FTotalCostItemRow " + orderByMode + ",");
            } else if ("FActivityID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FActivityNumberOrder,FTotalActivityRow " + orderByMode + ",");
            }
            if (!((Boolean)row.get("isTotal")).booleanValue()) continue;
            totalrows.put(fieldID, new Integer(totalrow--));
            StringBuffer fields = new StringBuffer();
            for (int k = 0; k <= i; ++k) {
                HashMap subrow = (HashMap)tblData.get(k);
                String subFieldID = (String)subrow.get("id");
                if ("FPeriodID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FPeriodID,");
                }
                if ("FManufactureOrderID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FManufactureOrderID,");
                    continue;
                }
                if ("FProductID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FProductID,FPlanQty,FFinishedProductQty,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostItemID,");
                    continue;
                }
                if (!"FActivityID".equalsIgnoreCase(subFieldID)) continue;
                fields.append("FActivityID,FActivityQty,FActivityTotalQty,");
            }
            fields.deleteCharAt(fields.length() - 1);
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("\n").append("  (FCompanyOrg,FTotalRow,FTotalRow2,\n").append("  " + fields + ",\n");
            if (fields.toString().endsWith("FActivityID,FActivityQty,FActivityTotalQty")) {
                sbSQL.append(" FBcToUnewhQty,FBUntoQty,\n");
                sbSQL.append(" FCurInputQty,\n");
                sbSQL.append(" FEcToUnewhQty,FEUntoCntQty, \n");
            }
            if (fields.toString().endsWith("FManufactureOrderID")) {
                sbSQL.append(" FCurFinishedQty, \n");
                sbSQL.append(" FTotalFinishedQty, \n");
            }
            sbSQL.append("FBopAmount, \n");
            sbSQL.append("FCurInputAmount,FTotalInputAmount, \n");
            sbSQL.append("FWIPAmount, \n");
            sbSQL.append("FCurFinishedAmount,FCurFinishedPrice, \n");
            sbSQL.append("FTotalFinishedAmount, \n");
            sbSQL.append(" FProductQtyPrecision, FAmountPrecision)");
            sbSQL.append(" SELECT FCompanyOrg, 0,").append(totalrows.get(fieldID)).append("\n").append("  ," + fields + ",\n");
            if (fields.toString().endsWith("FActivityID,FActivityQty,FActivityTotalQty")) {
                sbSQL.append(" max(FBcToUnewhQty),max(FBUntoQty), \n");
                sbSQL.append(" max(FCurInputQty), \n");
                sbSQL.append(" max(FEcToUnewhQty),max(FEUntoCntQty), \n");
            }
            if (fields.toString().endsWith("FManufactureOrderID")) {
                sbSQL.append(" max(FCurFinishedQty), \n");
                sbSQL.append(" max(FTotalFinishedQty), \n");
            }
            sbSQL.append("sum(FBopAmount),\n");
            sbSQL.append("sum(FCurInputAmount),sum(FTotalInputAmount), \n");
            sbSQL.append("sum(FWIPAmount), \n");
            sbSQL.append("sum(FCurFinishedAmount),sum(FCurFinishedPrice), \n");
            sbSQL.append("sum(FTotalFinishedAmount), \n");
            sbSQL.append("  max(FProductQtyPrecision),max(FAmountPrecision)\n").append(" FROM " + sTmpTblName + "\n").append(" WHERE FTotalRow2 = 0 \n");
            sbSQL.append(" GROUP BY FCompanyOrg, " + fields);
            sbSQL.append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        String fieldID = "";
        String totalFieldName = "";
        if (tblData.size() > 0) {
            HashMap row = (HashMap)tblData.get(0);
            fieldID = (String)row.get("id");
        }
        if ("FPeriodID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FPeriodNumber";
        } else if ("FManufactureOrderID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FManufactureOrderNumber";
        } else if ("FProductID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FProductNumber";
        } else if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FCostCenterName";
        } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FCostItemName";
        } else if ("FActivityID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FActivityNumber";
        }
        sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("  (FTotalRow,FTotalRow2," + totalFieldName + ",");
        sbSQL.append(" FBopAmount,\n");
        sbSQL.append(" FCurInputAmount,FTotalInputAmount, \n");
        sbSQL.append(" FWIPAmount, \n");
        sbSQL.append(" FCurFinishedAmount,FCurFinishedPrice, \n");
        sbSQL.append(" FTotalFinishedAmount, \n");
        sbSQL.append("        FProductQtyPrecision, FAmountPrecision)").append(" SELECT 1,105, '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',");
        sbSQL.append(" sum(FBopAmount),\n");
        sbSQL.append(" sum(FCurInputAmount),sum(FTotalInputAmount), \n");
        sbSQL.append(" sum(FWIPAmount), \n");
        sbSQL.append(" sum(FCurFinishedAmount),sum(FCurFinishedPrice), \n");
        sbSQL.append(" sum(FTotalFinishedAmount), \n");
        sbSQL.append("  max(FProductQtyPrecision), max(FAmountPrecision)").append(" FROM " + sTmpTblName + "\n").append(" where FTotalRow2 = 0 \n").append(";\n\n");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
                fieldName = fieldNumber;
            }
            if (fieldNumber.equalsIgnoreCase("FManufactureOrderNumber")) {
                whichTotal = ", FTotalManufactureRow = 1 ";
                fieldName = fieldNumber;
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumber")) {
                whichTotal = ", FTotalProductRow = 1 ";
                fieldName = fieldNumber;
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FActivityNumber")) {
                whichTotal = ", FTotalActivityRow = 1 ";
            }
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET ").append(fieldName).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostCenterNumber,FCostCenterName) =(select  t2.FNumber, t2.FName_L2 \n").append(" FROM T_ORG_CostCenter t2 \n").append(" WHERE t1.FCostCenterID = t2.FID) ").append(" Where FTotalCostCenterRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FPeriodNumber) = (select TO_Char(t2.FNumber)\n").append(" FROM T_BD_Period t2 ").append(" WHERE t1.FPeriodID = t2.FID )").append(" Where FTotalPeriodRow <> 1 \n\n").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append(" where FTotalCostItemRow <> 1\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FManufactureOrderNumber, FLot )= (select  t2.FNumber,t2.FLot \n").append(" FROM t_MM_ManufactureOrder t2 where  t1.FManufactureOrderID = t2.FID ) ").append(" where FTotalManufactureRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FActivityNumber, FActivityName )= (select  t2.FNumber,t2.FName_l2\n").append(" FROM T_NCM_Activity t2  \n").append(" INNER JOIN  t_BD_MeasureUnit t3 on t2.FBaseUnitID=t3.FID \n").append(" where  t1.FActivityID = t2.FID )").append(" where FTotalActivityRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FProductName, FProductNumber,FProductModel,FBaseUnitName )= (select  t2.FName_l2, t2.FNumber, t2.FModel, t3.FName_l2 \n").append(" FROM T_BD_Material t2 \n").append(" INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID where  t1.FProductID = t2.FID ) ").append(" where FTotalProductRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET FPlanQty = null, FFinishedProductQty = null \n").append(" where FTotalProductRow = 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FPeriodNumberOrder)= (select  TO_Char(t2.FNumber)\n").append(" FROM t_BD_Period t2 where  t1.FPeriodID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FManufactureOrderNumberOrder)= (select  t2.FNumber\n").append(" FROM t_MM_ManufactureOrder t2 where  t1.FManufactureOrderID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FProductNumberOrder)= (select t2.FNumber\n").append(" FROM T_BD_Material t2 \n").append(" where  t1.FProductID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostCenterNumberOrder) =(select  t2.FNumber\n").append(" FROM T_ORG_CostCenter t2 \n").append(" WHERE t1.FCostCenterID = t2.FID) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumberOrder)= (select  t2.FNumber \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FActivityNumberOrder)= (select t2.FNumber\n").append(" FROM T_NCM_Activity t2 \n").append(" where  t1.FActivityID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET FActivityQTY = 0,FActivityTotalQTY= 0 \n").append(" where  t1.FTotalActivityRow = 1 \n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET FBcToUnewhQty = 0,FBUntoQty= 0, \n").append("     FCurInputQty = 0,FEcToUnewhQty= 0, \n").append("     FEUntoCntQty = 0,FCurFinishedQty= 0, \n").append("     FTotalFinishedQty = 0 \n").append(" where  t1.FIsTotalRow = 0 \n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FActivityQty)=\n").append("  (SELECT \n").append("\tcase when t1.FActivityUnitName = '" + TimeUnitTypeEnum.minute.getAlias() + "' then FActivityQty/60 \n").append("\t     when t1.FActivityUnitName = '" + TimeUnitTypeEnum.hour.getAlias() + "' then FActivityQty/3600 \n").append("\t     else FActivityQty\n").append("\tend  as FActivityQty \n").append("      FROM T_NCM_Activity t2\n").append("      WHERE t1.FActivityID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FActivityTotalQty)=\n").append("  (SELECT \n").append("\tcase when t1.FActivityUnitName = '" + TimeUnitTypeEnum.minute.getAlias() + "' then FActivityTotalQty/60 \n").append("\t     when t1.FActivityUnitName = '" + TimeUnitTypeEnum.hour.getAlias() + "' then FActivityTotalQty/3600 \n").append("\t     else FActivityTotalQty \n").append("\tend as FActivityTotalQty\n").append("      FROM T_NCM_Activity t2\n").append("      WHERE t1.FActivityID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FActivityTotalQty)=\n").append("  (SELECT t1.FActivityTotalQty + t3.FBopQty \n").append("      FROM " + T_NCM_OrderBalance + " t2\n").append("      left join " + T_NCM_OrderBalanceActivity + " t3  on t2.FID = t3.FParentID \n").append("      WHERE t1.FManufactureOrderID=t2.FOrderID and t1.FActivityID = t3.FActivityID) \n").append(" where  t1.FIsTotalRow = 0 \n").append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        String sql = this.buildDataSql(filter, sTmpTblName);
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTmpTblName);
        return rs;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private void AppendPredicate(StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            this.AppendPredicateString(sb, false, sFieldName, ">=", this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
            this.AppendPredicateString(sb, false, sFieldName, "<=", this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        } else {
            String sFilterValue = filter.getString(sFilterName);
            if (sFilterValue != null && !"".equals(sFilterValue)) {
                this.AppendPredicateString(sb, true, sFieldName, sOP, sFilterValue);
            }
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName nvarchar(255) ");
        createTable.append(",FPeriodNumber nvarchar(255) ");
        createTable.append(",FPeriodNumberOrder nvarchar(255) ");
        createTable.append(",FManufactureOrderID varchar(44)  ");
        createTable.append(",FManufactureOrderName nvarchar(255)  ");
        createTable.append(",FManufactureOrderNumber nvarchar(255)  ");
        createTable.append(",FManufactureOrderNumberOrder nvarchar(255)  ");
        createTable.append(",FProductID varchar(44)");
        createTable.append(",FProductName nvarchar(255)");
        createTable.append(",FProductNumber nvarchar(255)");
        createTable.append(",FProductNumberOrder nvarchar(255)");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FLot nvarchar(80) ");
        createTable.append(",FBaseUnitName nvarchar(255)");
        createTable.append(",FPlanQty numeric(28,10)");
        createTable.append(",FFinishedProductQty numeric(28,10)");
        createTable.append(",FCostCenterID varchar(44)");
        createTable.append(",FCostCenterName nvarchar(255)");
        createTable.append(",FCostCenterNumber nvarchar(255)");
        createTable.append(",FCostCenterNumberOrder nvarchar(255)");
        createTable.append(",FCostItemID varchar(44)");
        createTable.append(",FCostItemName nvarchar(255)");
        createTable.append(",FCostItemNumber nvarchar(255)");
        createTable.append(",FCostItemNumberOrder nvarchar(255)");
        createTable.append(",FActivityID varchar(44)");
        createTable.append(",FActivityName nvarchar(255)");
        createTable.append(",FActivityNumber nvarchar(255)");
        createTable.append(",FActivityNumberOrder nvarchar(255)");
        createTable.append(",FActivityUnitName nvarchar(255)");
        createTable.append(",FActivityQty NUMERIC(21,10) ");
        createTable.append(",FActivityTotalQty NUMERIC(21,10) ");
        createTable.append(",FBcToUnewhQty NUMERIC(21,10) ");
        createTable.append(",FBUntoQty NUMERIC(21,10) ");
        createTable.append(",FBopAmount NUMERIC(17,4) ");
        createTable.append(",FCurInputQty NUMERIC(21,10) ");
        createTable.append(",FCurInputAmount NUMERIC(17,4) ");
        createTable.append(",FTotalInputAmount NUMERIC(17,4)");
        createTable.append(",FEcToUnewhQty NUMERIC(21,10) ");
        createTable.append(",FEUntoCntQty NUMERIC(17,4) ");
        createTable.append(",FWIPAmount NUMERIC(17,4) ");
        createTable.append(",FCurFinishedQty NUMERIC(21,10) ");
        createTable.append(",FCurFinishedAmount NUMERIC(17,4) ");
        createTable.append(",FCurFinishedPrice NUMERIC(17,10) ");
        createTable.append(",FTotalFinishedQty NUMERIC(21,10) ");
        createTable.append(",FTotalFinishedAmount NUMERIC(17,4) ");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalManufactureRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalActivityRow int not null default(0) ");
        createTable.append(",FProductQtyPrecision int default(0) ");
        createTable.append(",FMatQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_CompanyName", (Locale)ctx.getLocale()) + "\uff1a" + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_PeriodRange", (Locale)ctx.getLocale()) + "\uff1a" + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"Year_Name", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"Period_To", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"Year_Name", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"Period_Month", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_OrderRange", (Locale)ctx.getLocale()) + "\uff1a" + this.buildFilterRange(filter.getString("manufacturerOrderFrom"), filter.getString("manufacturerOrderTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_ProductRange", (Locale)ctx.getLocale()) + "\uff1a" + this.buildFilterRange(filter.getString("productFrom"), filter.getString("productTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_CostCenterRange", (Locale)ctx.getLocale()) + "\uff1a" + this.buildFilterRange(filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_ActivityRange", (Locale)ctx.getLocale()) + "\uff1a" + this.buildFilterRange(filter.getString("activityFrom"), filter.getString("activityTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_CostItemRange", (Locale)ctx.getLocale()) + "\uff1a" + this.buildFilterRange(filter.getString("costitemFrom"), filter.getString("costitemTo")));
        return titles;
    }

    private Integer getFromPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Integer getToPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearTo");
        String month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        List tblData = (List)filter.getObject("table");
        ArrayList list = new ArrayList(tblData.size());
        for (i = 0; i < tblData.size(); ++i) {
            Map row = (Map)tblData.get(i);
            list.add(row.get("id"));
        }
        for (i = 0; i < list.size(); ++i) {
            if ("FPeriodID".equals(list.get(i))) {
                reportHeader.addChild("FPeriodNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Period", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            }
            if ("FManufactureOrderID".equals(list.get(i))) {
                reportHeader.addChild("FManufactureOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Order", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Lot", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FProductID".equals(list.get(i))) {
                reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_PorductNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_PorductName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FProductModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Model", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FBaseUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BaseUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                ReportHeader planQtyCol = reportHeader.addChild("FPlanQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_PlanQty", (Locale)ctx.getLocale()), index++);
                planQtyCol.setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
                planQtyCol.setMergeable(true);
                continue;
            }
            if ("FCostCenterID".equals(list.get(i))) {
                reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_CostCenter", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FActivityID".equals(list.get(i))) {
                reportHeader.addChild("FActivityName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Activity", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FActivityUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_TimeUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                ReportHeader activityQtyHeader = reportHeader.addChild("FActivityQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_ActivityQty", (Locale)ctx.getLocale()), index++);
                activityQtyHeader.setAlign(3).setType(2).setMergeable(true);
                activityQtyHeader.setDecimal(8);
                ReportHeader activityTotalQtyHeader = reportHeader.addChild("FActivityTotalQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_ActivityTotalQty", (Locale)ctx.getLocale()), index++);
                activityTotalQtyHeader.setAlign(3).setType(2).setMergeable(true);
                activityTotalQtyHeader.setDecimal(8);
                continue;
            }
            if (!"FCostItemID".equals(list.get(i))) continue;
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_CostItem", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        }
        ReportHeader bopHeader = reportHeader.addChild("FBopBalance", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BopBalance", (Locale)ctx.getLocale()), index++);
        ReportHeader bcToUnewhQtyHeader = bopHeader.addChild("FBcToUnewhQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BcToUnewhQty", (Locale)ctx.getLocale()));
        bcToUnewhQtyHeader.setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
        bcToUnewhQtyHeader.setWidth(160);
        bopHeader.addChild("FBUntoQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BUntoQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
        bopHeader.addChild("FBopAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader curInputHeader = reportHeader.addChild("FCurInput", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_CurInput", (Locale)ctx.getLocale()), index++);
        curInputHeader.addChild("FCurInputQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
        curInputHeader.addChild("FCurInputAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        reportHeader.addChild("FTotalInputAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_TotalAmount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader WIPHeader = reportHeader.addChild("FTotalInput", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_EndWIP", (Locale)ctx.getLocale()), index++);
        ReportHeader ecToUnewhQtyHeader = WIPHeader.addChild("FEcToUnewhQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_EcToUnewhQty", (Locale)ctx.getLocale()));
        ecToUnewhQtyHeader.setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
        ecToUnewhQtyHeader.setWidth(160);
        WIPHeader.addChild("FEUntoCntQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_EUntoCntQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        WIPHeader.addChild("FWIPAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader curFinishedHeader = reportHeader.addChild("FCurFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_FinishedQty", (Locale)ctx.getLocale()), index++);
        curFinishedHeader.addChild("FCurFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
        curFinishedHeader.addChild("FCurFinishedAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        curFinishedHeader.addChild("FCurFinishedPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_UnitCost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader totalFinishedHeader = reportHeader.addChild("Fwip", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_TotalFinishedQty", (Locale)ctx.getLocale()), index++);
        totalFinishedHeader.addChild("FTotalFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FProductQtyPrecision");
        totalFinishedHeader.addChild("FTotalFinishedAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        return reportHeader;
    }

    private String buildFilterRange(String from, String to) {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_All", (Locale)ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_FirstFrom", (Locale)ctx.getLocale()) + " " + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + " " + from + " " + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_ToEnd", (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + " " + from + " " + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_To", (Locale)ctx.getLocale()) + " " + to;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  * FROM ");
        sql.append(tempTableName);
        sql.append(where);
        sql.append(" Order by  FTotalRow " + orderByMode);
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "NumberOrder";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumberOrder")) {
                orderByWhichTotal = ", FTotalPeriodRow " + orderByMode;
                fieldNumber = "FPeriodNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FManufactureOrderNumberOrder")) {
                orderByWhichTotal = ", FTotalManufactureRow " + orderByMode;
                fieldNumber = "FManufactureOrderNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumberOrder")) {
                orderByWhichTotal = ", FTotalProductRow " + orderByMode;
                fieldNumber = "FProductNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumberOrder")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
                fieldNumber = "FCostCenterNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FActivityNumberOrder")) {
                orderByWhichTotal = ", FTotalActivityRow " + orderByMode;
                fieldNumber = "FActivityNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumberOrder")) {
                orderByWhichTotal = ", FTotalCostItemRow " + orderByMode;
                fieldNumber = "FCostItemNumberOrder";
            }
            sql.append("," + fieldNumber);
            sql.append(orderByWhichTotal);
        }
        return sql.toString();
    }
}

