/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OCCostCalDetailReport
extends ReportServerBase {
    public static final String RES_CLASSNAME = "com.kingdee.eas.ncm.order.fact.report.OCCostCalTotalReportResource";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = this.buildReportDataTempTable(filter);
        String ksql = "select * from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = "where FIsTotalRow = 1 or FIsSubTotalRow = 1 \n";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "desc" : "asc";
        StringBuffer ksql = new StringBuffer();
        ksql.append("select * from " + tableName + " \n");
        ksql.append(where);
        ksql.append("order by \n");
        ksql.append("FIsTotalRow " + orderByMode + ",");
        StringBuffer orderBy = new StringBuffer();
        List tblData = (List)filter.getObject("table");
        HashMap row = null;
        String field = null;
        for (int i = 0; i < tblData.size(); ++i) {
            row = (HashMap)tblData.get(i);
            field = (String)row.get("id");
            if ("FCalculatePeriodID".equalsIgnoreCase(field)) {
                orderBy.append(" FCalculatePeriodNumber, FIsCalculatePeriodTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FOrderID".equalsIgnoreCase(field)) {
                orderBy.append(" FOrderNumber, FIsOrderTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FProductID".equalsIgnoreCase(field)) {
                orderBy.append(" FProductNumber, FIsProductTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FCostCenterID".equalsIgnoreCase(field)) {
                orderBy.append(" FCostCenterNumber, FIsCostCenterTotalRow " + orderByMode + ",");
                continue;
            }
            if (!"FCostItemID".equalsIgnoreCase(field)) continue;
            orderBy.append(" FCostItemNumber, FIsCostITemTotalRow " + orderByMode + ",");
        }
        orderBy.deleteCharAt(orderBy.length() - 1);
        ksql.append(orderBy);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql.toString(), (int)start, (int)rows);
        return rs;
    }

    protected String createReportDataTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FCalculatePeriodID varchar(44), \n");
        ksql.append("     FCalculatePeriodNumber varchar(80), \n");
        ksql.append("     FCalculatePeriodName varchar(80), \n");
        ksql.append("     FOrderID varchar(44), \n");
        ksql.append("     FOrderNumber varchar(80), \n");
        ksql.append("     FOrderName varchar(80), \n");
        ksql.append("     FOrderLot varchar(255), \n");
        ksql.append("     FOrderPlanQty decimal(21,8) default(0), \n");
        ksql.append("     FProductID varchar(44), \n");
        ksql.append("     FProductNumber varchar(80), \n");
        ksql.append("     FProductName varchar(255), \n");
        ksql.append("     FProductModel nvarchar(255), \n");
        ksql.append("     FBaseUnitName varchar(255), \n");
        ksql.append("     FBaseQtyPrecision int not null default(4), \n");
        ksql.append("     FCostCenterID varchar(44), \n");
        ksql.append("     FCostCenterNumber varchar(80), \n");
        ksql.append("     FCostCenterName varchar(255), \n");
        ksql.append("     FCostItemID varchar(44), \n");
        ksql.append("     FCostItemNumber varchar(80), \n");
        ksql.append("     FCostItemName varchar(255), \n");
        ksql.append("     FPricePrecision int not null default(2), \n");
        ksql.append("     FAmountPrecision int not null default(2), \n");
        ksql.append("     FBopQty decimal(21,8) default(0), \n");
        ksql.append("     FBopAmount decimal(21,8) default(0), \n");
        ksql.append("     FBopCumFinishedQty decimal(21,8) default(0), \n");
        ksql.append("     FBopCumFinishedAmount decimal(21,8) default(0), \n");
        ksql.append("     FCurInputAmount decimal(21,8) default(0), \n");
        ksql.append("     FTotalAmount decimal(21,8) default(0), \n");
        ksql.append("     FEopQty decimal(21,8) default(0), \n");
        ksql.append("     FEopAmount decimal(21,8) default(0), \n");
        ksql.append("     FCurFinishedQty decimal(21,8) default(0), \n");
        ksql.append("     FCurFinishedAmount decimal(21,8) default(0), \n");
        ksql.append("     FCurFinishedUnitAmount decimal(21,8) default(0), \n");
        ksql.append("     FCumFinishedQty decimal(21,8) default(0), \n");
        ksql.append("     FCumFinishedAmount decimal(21,8) default(0), \n");
        ksql.append("     FIsCalculatePeriodTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsOrderTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsProductTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsCostCenterTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsCostItemTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsSubTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsTotalRow NUMERIC(17,4) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = company.getId().toString();
        int amountPrecision = 2;
        try {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
            amountPrecision = currency.getPrecision();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        String tempTable = this.createReportDataTempTable();
        Integer fromPeriod = this.getFromPeriod(filter);
        Integer toPeriod = this.getToPeriod(filter);
        String periodId2 = null;
        Set periodIds = OrderCMUtils.getPeriodIds(this.getContext(), company, fromPeriod, toPeriod);
        if (periodIds.size() <= 0) {
            return tempTable;
        }
        String T_NCM_OrderBalance = null;
        Map T_NCM_OrderBalances = null;
        String T_NCM_OrderBalanceActivity = null;
        Map T_NCM_OrderBalanceActivitys = null;
        String T_NCM_OrderBalanceActivityEntry = null;
        Map T_NCM_OrderBalanceActivityEntrys = null;
        String T_NCM_OrderBalanceMaterial = null;
        Map T_NCM_OrderBalanceMaterials = null;
        String T_NCM_OrderCostCalResult = null;
        Map T_NCM_OrderCostCalResults = null;
        String T_NCM_DataByOrder = null;
        Map T_NCM_DataByOrders = null;
        try {
            T_NCM_OrderBalances = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OrderBalance");
            T_NCM_OrderBalanceActivitys = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OrderBalanceActivity");
            T_NCM_OrderBalanceActivityEntrys = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OrderBalanceActivityEntry");
            T_NCM_OrderBalanceMaterials = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OrderBalanceMaterial");
            T_NCM_OrderCostCalResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OrderCostCalResult");
            T_NCM_DataByOrders = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_DataByOrder");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String pWhere = this.buildPeriodFilter(filter);
        String oWhere = this.buildOrderFilter(filter);
        String mWhere = this.buildMaterialFilter(filter);
        String ccWhere = this.buildCostCenterFilter(filter);
        String ciWhere = this.buildCostItemFilter(filter);
        String assistTable = this.createReportDataTempTable();
        StringBuffer ksql = new StringBuffer();
        for (String periodId2 : periodIds) {
            T_NCM_OrderBalance = (String)T_NCM_OrderBalances.get(periodId2);
            T_NCM_OrderBalanceActivity = (String)T_NCM_OrderBalanceActivitys.get(periodId2);
            T_NCM_OrderBalanceActivityEntry = (String)T_NCM_OrderBalanceActivityEntrys.get(periodId2);
            T_NCM_OrderBalanceMaterial = (String)T_NCM_OrderBalanceMaterials.get(periodId2);
            T_NCM_OrderCostCalResult = (String)T_NCM_OrderCostCalResults.get(periodId2);
            T_NCM_DataByOrder = (String)T_NCM_DataByOrders.get(periodId2);
            if (T_NCM_OrderBalance != null && T_NCM_OrderBalanceMaterial != null) {
                ksql.append("insert into " + assistTable + " ( \n");
                ksql.append("     FCalculatePeriodID, \n");
                ksql.append("     FOrderID, \n");
                ksql.append("     FCostCenterID, \n");
                ksql.append("     FCostItemID, \n");
                ksql.append("     FBopAmount, \n");
                ksql.append("     FBopCumFinishedAmount, \n");
                ksql.append("     FCurInputAmount, \n");
                ksql.append("     FTotalAmount, \n");
                ksql.append("     FEopAmount, \n");
                ksql.append("     FCurFinishedAmount \n");
                ksql.append(") \n");
                ksql.append("select \n");
                ksql.append("     b.FCalculatePeriod FCalculatePeriodID, \n");
                ksql.append("     b.FOrderID FOrderID, \n");
                ksql.append("     bm.FCostCenterID FCostCenterID, \n");
                ksql.append("     bm.FCostItemID FCostItemID, \n");
                ksql.append("     bm.FBopAmount FBopAmount, \n");
                ksql.append("     bm.FCumFinishedAmount FBopCumFinishedAmount, \n");
                ksql.append("     0 FCurInputAmount, \n");
                ksql.append("     0 FTotalAmount, \n");
                ksql.append("     0 FEopAmount, \n");
                ksql.append("     0 FCurFinishedAmount \n");
                ksql.append("from " + T_NCM_OrderBalance + " b \n");
                ksql.append("join " + T_NCM_OrderBalanceMaterial + " bm on bm.FParentID = b.FID \n");
                if (oWhere.length() > 0 || mWhere.length() > 0) {
                    ksql.append("left join T_MM_ManufactureOrder o on o.FID = b.FOrderID \n");
                }
                if (mWhere.length() > 0) {
                    ksql.append("left join T_BD_Material prd on prd.FID = o.FMaterialID \n");
                }
                if (ccWhere.length() > 0) {
                    ksql.append("left join T_ORG_CostCenter cc on cc.FID = bm.FCostCenterID \n");
                }
                if (ciWhere.length() > 0) {
                    ksql.append("left join T_NCM_CostItem ci on ci.FID = bm.FCostItemID \n");
                }
                ksql.append("where 1 = 1 \n");
                ksql.append(oWhere);
                ksql.append(mWhere);
                ksql.append(ccWhere);
                ksql.append(ciWhere);
                ksql.append(" \n");
                ksql.append("; \n");
            }
            if (T_NCM_OrderBalance != null && T_NCM_OrderBalanceActivity != null && T_NCM_OrderBalanceActivityEntry != null) {
                ksql.append("insert into " + assistTable + " ( \n");
                ksql.append("     FCalculatePeriodID, \n");
                ksql.append("     FOrderID, \n");
                ksql.append("     FCostCenterID, \n");
                ksql.append("     FCostItemID, \n");
                ksql.append("     FBopAmount, \n");
                ksql.append("     FBopCumFinishedAmount, \n");
                ksql.append("     FCurInputAmount, \n");
                ksql.append("     FTotalAmount, \n");
                ksql.append("     FEopAmount, \n");
                ksql.append("     FCurFinishedAmount \n");
                ksql.append(") \n");
                ksql.append("select \n");
                ksql.append("     b.FCalculatePeriod FCalculatePeriodID, \n");
                ksql.append("     b.FOrderID FOrderID, \n");
                ksql.append("     ba.FCostCenterID FCostCenterID, \n");
                ksql.append("     bae.FCostItemID FCostItemID, \n");
                ksql.append("     bae.FBopAmount FBopAmount, \n");
                ksql.append("     bae.FCumFinishedAmount FBopCumFinishedAmount, \n");
                ksql.append("     0 FCurInputAmount, \n");
                ksql.append("     0 FTotalAmount, \n");
                ksql.append("     0 FEopAmount, \n");
                ksql.append("     0 FCurFinishedAmount \n");
                ksql.append("from " + T_NCM_OrderBalance + " b \n");
                ksql.append("join " + T_NCM_OrderBalanceActivity + " ba on ba.FParentID = b.FID \n");
                ksql.append("join " + T_NCM_OrderBalanceActivityEntry + " bae on bae.FParentID = ba.FID \n");
                if (pWhere.length() > 0) {
                    ksql.append("left join T_BD_Period p on p.FID = b.FCalculatePeriod \n");
                }
                if (oWhere.length() > 0 || mWhere.length() > 0) {
                    ksql.append("left join T_MM_ManufactureOrder o on o.FID = b.FOrderID \n");
                }
                if (mWhere.length() > 0) {
                    ksql.append("left join T_BD_Material prd on prd.FID = o.FMaterialID \n");
                }
                if (ccWhere.length() > 0) {
                    ksql.append("left join T_ORG_CostCenter cc on cc.FID = ba.FCostCenterID \n");
                }
                if (ciWhere.length() > 0) {
                    ksql.append("left join T_NCM_CostItem ci on ci.FID = bae.FCostItemID \n");
                }
                ksql.append("where 1 = 1 \n");
                ksql.append(pWhere);
                ksql.append(oWhere);
                ksql.append(mWhere);
                ksql.append(ccWhere);
                ksql.append(ciWhere);
                ksql.append(" \n");
                ksql.append("; \n");
            }
            if (T_NCM_OrderCostCalResult == null) continue;
            ksql.append("insert into " + assistTable + " ( \n");
            ksql.append("     FCalculatePeriodID, \n");
            ksql.append("     FOrderID, \n");
            ksql.append("     FCostCenterID, \n");
            ksql.append("     FCostItemID, \n");
            ksql.append("     FBopAmount, \n");
            ksql.append("     FBopCumFinishedAmount, \n");
            ksql.append("     FCurInputAmount, \n");
            ksql.append("     FTotalAmount, \n");
            ksql.append("     FEopAmount, \n");
            ksql.append("     FCurFinishedAmount \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("     r.FCalculatePeriodID FCalculatePeriodID, \n");
            ksql.append("     r.FOrderID FOrderID, \n");
            ksql.append("     r.FCostCenterID FCostCenterID, \n");
            ksql.append("     r.FCostItemID FCostItemID, \n");
            ksql.append("     0 BopAmount, \n");
            ksql.append("     0 FBopCumFinishedAmount, \n");
            ksql.append("     0 FCurInputAmount, \n");
            ksql.append("     0 FTotalAmount, \n");
            ksql.append("     r.FEoPWIPAmount FEopAmount, \n");
            ksql.append("     r.FFinishedAmount FCurFinishedAmount \n");
            ksql.append("from " + T_NCM_OrderCostCalResult + " r \n");
            if (pWhere.length() > 0) {
                ksql.append("left join T_BD_Period p on p.FID = r.FCalculatePeriodID \n");
            }
            if (oWhere.length() > 0 || mWhere.length() > 0) {
                ksql.append("left join T_MM_ManufactureOrder o on o.FID = r.FOrderID \n");
            }
            if (mWhere.length() > 0) {
                ksql.append("left join T_BD_Material prd on prd.FID = o.FMaterialID \n");
            }
            if (ccWhere.length() > 0) {
                ksql.append("left join T_ORG_CostCenter cc on cc.FID = r.FCostCenterID \n");
            }
            if (ciWhere.length() > 0) {
                ksql.append("left join T_NCM_CostItem ci on ci.FID = r.FCostItemID \n");
            }
            ksql.append("where 1 = 1 \n");
            ksql.append(pWhere);
            ksql.append(oWhere);
            ksql.append(mWhere);
            ksql.append(ccWhere);
            ksql.append(ciWhere);
            ksql.append(" \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("     FCalculatePeriodID, \n");
        ksql.append("     FOrderID, \n");
        ksql.append("     FCostCenterID, \n");
        ksql.append("     FCostItemID, \n");
        ksql.append("     FBopAmount, \n");
        ksql.append("     FBopCumFinishedAmount, \n");
        ksql.append("     FCurInputAmount, \n");
        ksql.append("     FTotalAmount, \n");
        ksql.append("     FEopAmount, \n");
        ksql.append("     FCurFinishedAmount, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FCalculatePeriodID FCalculatePeriodID, \n");
        ksql.append("     r.FOrderID FOrderID, \n");
        ksql.append("     r.FCostCenterID FCostCenterID, \n");
        ksql.append("     r.FCostItemID FCostItemID, \n");
        ksql.append("     sum(r.FBopAmount) FBopAmount, \n");
        ksql.append("     sum(FBopCumFinishedAmount) FBopCumFinishedAmount, \n");
        ksql.append("     0 FCurInputAmount, \n");
        ksql.append("     0 FTotalAmount, \n");
        ksql.append("     sum(r.FEopAmount) FEopAmount, \n");
        ksql.append("     sum(r.FCurFinishedAmount) FCurFinishedAmount, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + assistTable + " r \n");
        ksql.append("group by r.FCalculatePeriodID, r.FOrderID, \n");
        ksql.append("r.FCostCenterID, r.FCostItemID \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FProductID = ( \n");
        ksql.append("    select o.FMaterialID \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    where o.FID = t.FOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FBaseQtyPrecision = isnull(( \n");
        ksql.append("    select max(mmu.FQtyPrecision) \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    join T_BD_MultiMeasureUnit mmu \n");
        ksql.append("    on mmu.FMaterialID = m.Fid and mmu.FMeasureUnitID = m.FBaseUnit \n");
        ksql.append("    where m.FID = t.FProductID \n");
        ksql.append("), 4) \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FPricePrecision = isnull(( \n");
        ksql.append("    select ci.FPricePrecision \n");
        ksql.append("    from T_NCM_CostItem ci \n");
        ksql.append("    where ci.FID = t.FCostItemID \n");
        ksql.append("), 4), FAmountPrecision = " + amountPrecision + " \n");
        ksql.append("; \n");
        List tblData = (List)filter.getObject("table");
        Map row = null;
        String field = null;
        boolean isTotal = false;
        for (int rowIndex = 0; rowIndex < tblData.size(); ++rowIndex) {
            row = (Map)tblData.get(rowIndex);
            field = (String)row.get("id");
            isTotal = false;
            if (row.containsKey("isTotal") && row.get("isTotal") instanceof Boolean) {
                isTotal = (Boolean)row.get("isTotal");
            }
            if (!isTotal) continue;
            String insertTotalRow = "";
            String selectTotalRow = "";
            if ("FCalculatePeriodID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCalculatePeriodTotalRow, \n";
                selectTotalRow = "    1 FIsCalculatePeriodTotalRow, \n";
            } else if ("FOrderID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsOrderTotalRow, \n";
                selectTotalRow = "    1 FIsOrderTotalRow, \n";
            } else if ("FProductID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsProductTotalRow, \n";
                selectTotalRow = "    1 FIsProductTotalRow, \n";
            } else if ("FCostCenterID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCostCenterTotalRow, \n";
                selectTotalRow = "    1 FIsCostCenterTotalRow, \n";
            } else if ("FCostItemID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCostItemTotalRow, \n";
                selectTotalRow = "    1 FIsCostItemTotalRow, \n";
            }
            StringBuffer fields = new StringBuffer();
            for (int i = 0; i <= rowIndex; ++i) {
                row = (HashMap)tblData.get(i);
                field = (String)row.get("id");
                if ("FCalculatePeriodID".equalsIgnoreCase(field)) {
                    fields.append("FCalculatePeriodID,");
                    continue;
                }
                if ("FOrderID".equalsIgnoreCase(field)) {
                    fields.append("FOrderID,");
                    continue;
                }
                if ("FProductID".equalsIgnoreCase(field)) {
                    fields.append("FProductID,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(field)) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if (!"FCostItemID".equalsIgnoreCase(field)) continue;
                fields.append("FCostItemID,");
            }
            fields.deleteCharAt(fields.length() - 1);
            ksql.append("insert into " + tempTable + " ( \n");
            ksql.append("    " + fields + ", \n");
            ksql.append("     FBopAmount, \n");
            ksql.append("     FBopCumFinishedAmount, \n");
            ksql.append("     FCurInputAmount, \n");
            ksql.append("     FTotalAmount, \n");
            ksql.append("     FEopAmount, \n");
            ksql.append("     FCurFinishedAmount, \n");
            ksql.append("     FBaseQtyPrecision, \n");
            ksql.append("     FPricePrecision, \n");
            ksql.append("     FAmountPrecision, \n");
            ksql.append(insertTotalRow);
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    " + fields + ", \n");
            ksql.append("     sum(r.FBopAmount) FBopAmount, \n");
            ksql.append("     sum(FBopCumFinishedAmount) FBopCumFinishedAmount, \n");
            ksql.append("     sum(FCurInputAmount) FCurInputAmount, \n");
            ksql.append("     sum(FTotalAmount) FTotalAmount, \n");
            ksql.append("     sum(r.FEopAmount) FEopAmount, \n");
            ksql.append("     sum(r.FCurFinishedAmount) FCurFinishedAmount, \n");
            ksql.append("     isnull(max(FBaseQtyPrecision), 4) FBaseQtyPrecision, \n");
            ksql.append("     isnull(max(FPricePrecision), 4) FPricePrecision, \n");
            ksql.append("     isnull(max(FAmountPrecision), 2) FAmountPrecision, \n");
            ksql.append(selectTotalRow);
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    0 FIsTotalRow \n");
            ksql.append("from " + tempTable + " r \n");
            ksql.append("where FIsSubTotalRow = 0 \n");
            ksql.append("group by " + fields + " \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("     FBopAmount, \n");
        ksql.append("     FBopCumFinishedAmount, \n");
        ksql.append("     FCurInputAmount, \n");
        ksql.append("     FTotalAmount, \n");
        ksql.append("     FEopAmount, \n");
        ksql.append("     FCurFinishedAmount, \n");
        ksql.append("     FBaseQtyPrecision, \n");
        ksql.append("     FPricePrecision, \n");
        ksql.append("     FAmountPrecision, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     sum(r.FBopAmount) FBopAmount, \n");
        ksql.append("     sum(FBopCumFinishedAmount) FBopCumFinishedAmount, \n");
        ksql.append("     0 FCurInputAmount, \n");
        ksql.append("     0 FTotalAmount, \n");
        ksql.append("     sum(r.FEopAmount) FEopAmount, \n");
        ksql.append("     sum(r.FCurFinishedAmount) FCurFinishedAmount, \n");
        ksql.append("     isnull(max(FBaseQtyPrecision), 4) FBaseQtyPrecision, \n");
        ksql.append("     isnull(max(FPricePrecision), 4) FPricePrecision, \n");
        ksql.append("     isnull(max(FAmountPrecision), 2) FAmountPrecision, \n");
        ksql.append("     1 FIsTotalRow \n");
        ksql.append("from " + tempTable + " r \n");
        ksql.append("where FIsSubTotalRow = 0 \n");
        ksql.append("; \n");
        for (String periodId2 : periodIds) {
            T_NCM_OrderBalance = (String)T_NCM_OrderBalances.get(periodId2);
            T_NCM_DataByOrder = (String)T_NCM_DataByOrders.get(periodId2);
            if (T_NCM_OrderBalance != null) {
                ksql.append("update " + tempTable + " t set ( \n");
                ksql.append("    FBopQty, \n");
                ksql.append("    FCumFinishedQty \n");
                ksql.append(") = ( \n");
                ksql.append("  select FBopQty,FCumFinishedQty from ( \n");
                ksql.append("    select b.FOrderID as FOrderID,isnull(sum(FBopWIPQty),0) FBopQty, isnull(sum(FFinishedQty),0) FCumFinishedQty \n");
                ksql.append("    from " + T_NCM_OrderBalance + " b \n");
                ksql.append("    group by b.FOrderID \n");
                ksql.append("    ) x where x.FOrderID = t.FOrderID  \n");
                ksql.append(") \n");
                ksql.append("where t.FCalculatePeriodID = '" + periodId2 + "' and t.FOrderID is not null \n");
                ksql.append("; \n");
            }
            if (T_NCM_DataByOrder == null) continue;
            ksql.append("update " + tempTable + " t set ( \n");
            ksql.append("    FEopQty, \n");
            ksql.append("    FCurFinishedQty, \n");
            ksql.append("    FCumFinishedQty \n");
            ksql.append(") = ( \n");
            ksql.append("    select top 1 \n");
            ksql.append("    FEoPWIPQty FEopQty, \n");
            ksql.append("    FFinishedQty FCurFinishedQty, \n");
            ksql.append("    (isnull(t.FCumFinishedQty,0) + isnull(r.FFinishedQty,0)) FCumFinishedQty \n");
            ksql.append("    from " + T_NCM_DataByOrder + " r \n");
            ksql.append("    where r.FOrderID = t.FOrderID \n");
            ksql.append(") \n");
            ksql.append("where t.FCalculatePeriodID = '" + periodId2 + "' and t.FOrderID is not null \n");
            ksql.append("; \n");
        }
        ksql.append("update " + tempTable + " t set \n");
        ksql.append("    FCurInputAmount = ( \n");
        ksql.append("        case when (FCurFinishedAmount = 0 and FEopAmount = 0) \n");
        ksql.append("        then 0 \n");
        ksql.append("        else FCurFinishedAmount + FEopAmount - FBopAmount end \n");
        ksql.append("    ), \n");
        ksql.append("    FTotalAmount = ( \n");
        ksql.append("        case when (FCurFinishedAmount = 0 and FEopAmount = 0) \n");
        ksql.append("        then 0 \n");
        ksql.append("        else FCurFinishedAmount + FEopAmount end \n");
        ksql.append("    ), \n");
        ksql.append("    FCurFinishedUnitAmount = ( \n");
        ksql.append("        case when FCurFinishedQty = 0 then 0 \n");
        ksql.append("        else FCurFinishedAmount / FCurFinishedQty end \n");
        ksql.append("    ), \n");
        ksql.append("    FCumFinishedAmount = FBopCumFinishedAmount + FCurFinishedAmount \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set  \n");
        ksql.append("    FBopQty = 0, \n");
        ksql.append("    FEopQty  = 0, \n");
        ksql.append("    FCurFinishedQty  = 0, \n");
        ksql.append("    FCumFinishedQty  = 0 \n");
        ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCalculatePeriodNumber, FCalculatePeriodName) = ( \n");
        ksql.append("    select TO_Char(p.FNumber), TO_Char(p.FNumber)  \n");
        ksql.append("    from T_BD_Period p \n");
        ksql.append("    where p.FID = t.FCalculatePeriodID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FOrderNumber, FOrderName, FOrderLot, FOrderPlanQty) = ( \n");
        ksql.append("    select o.FNumber, o.FNumber, o.FLot, o.FBaseQty \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    where o.FID = t.FOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FProductNumber, FProductName, FProductModel) = ( \n");
        ksql.append("    select m.FNumber, m.FName_L2, m.FModel \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    where m.FID = t.FProductID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FBaseUnitName = ( \n");
        ksql.append("    select mu.FName_L2 \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
        ksql.append("    where m.FID = t.FProductID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCostCenterNumber, FCostCenterName) = ( \n");
        ksql.append("    select cc.FNumber, cc.FName_L2  \n");
        ksql.append("    from T_ORG_CostCenter cc \n");
        ksql.append("    where cc.FID = t.FCostCenterID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCostItemNumber, FCostItemName) = ( \n");
        ksql.append("    select ci.FNumber, ci.FName_L2  \n");
        ksql.append("    from T_NCM_CostItem ci \n");
        ksql.append("    where ci.FID = t.FCostItemID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FCalculatePeriodName = '\u5c0f\u8ba1' where FIsCalculatePeriodTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FOrderName = '\u5c0f\u8ba1' where FIsOrderTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FProductName = '\u5c0f\u8ba1' where FIsProductTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FCostCenterName = '\u5c0f\u8ba1' where FIsCostCenterTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FCostItemName = '\u5c0f\u8ba1' where FIsCostItemTotalRow = 1; \n");
        row = (Map)tblData.get(0);
        field = (String)row.get("id");
        String totalFieldName = null;
        if ("FCalculatePeriodID".equalsIgnoreCase(field)) {
            totalFieldName = "FCalculatePeriodName";
        } else if ("FOrderID".equalsIgnoreCase(field)) {
            totalFieldName = "FOrderName";
        } else if ("FProductID".equalsIgnoreCase(field)) {
            totalFieldName = "FProductNumber";
        } else if ("FCostCenterID".equalsIgnoreCase(field)) {
            totalFieldName = "FCostCenterName";
        } else if ("FCostItemID".equalsIgnoreCase(field)) {
            totalFieldName = "FCostItemName";
        }
        if (totalFieldName != null) {
            ksql.append("update " + tempTable + " t set " + totalFieldName + " = '\u5408\u8ba1' where FIsTotalRow = 1; \n");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(assistTable);
        return tempTable;
    }

    public boolean isOnlyDisplayTotal(RptParams filter) {
        return filter.getBoolean("isOnlyDisPalyTotal");
    }

    public boolean isTotalRowTop(RptParams filter) {
        return filter.getBoolean("isTotalRowTop");
    }

    private String buildPeriodFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            ksql.append(" and p.FNumber >= ").append(this.getPeriodNumber(year, month)).append("");
        }
        year = filter.getString("yearTo");
        month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            ksql.append(" and p.FNumber <= ").append(this.getPeriodNumber(year, month)).append("");
        }
        return ksql.toString();
    }

    private Integer getFromPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Integer getToPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearTo");
        String month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String getPeriodNumber(String year, String month) {
        return year + (month.length() < 2 ? "0" + month : month);
    }

    private String buildOrderFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("orderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and o.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and o.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildMaterialFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("productFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and prd.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("productTo")))) {
            ksql.append(" and prd.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildCostCenterFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("costCenterFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and cc.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costCenterTo")))) {
            ksql.append(" and cc.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildCostItemFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("costItemFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and ci.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costItemTo")))) {
            ksql.append(" and ci.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FIsSubTotalRow", 1, (Object)new BigDecimal(1), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FIsTotalRow", 1, (Object)new BigDecimal(1), a);
        return conditions;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_CompanyName", (Locale)ctx.getLocale()) + "\uff1a" + company.getName());
        String from = filter.getString("yearFrom");
        from = from + "\u5e74";
        from = from + filter.getString("periodFrom");
        from = from + "\u671f";
        String to = filter.getString("yearTo");
        to = to + "\u5e74";
        to = to + filter.getString("periodTo");
        to = to + "\u671f";
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_PeriodRange", (Locale)ctx.getLocale()) + "\uff1a" + from + " \u81f3 " + to);
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_OrderRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("orderFrom"), filter.getString("orderTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_ProductRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("productFrom"), filter.getString("productTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostCenterRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costCenterFrom"), filter.getString("costCenterTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostItemRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costItemFrom"), filter.getString("costItemTo")));
        return titles;
    }

    private String buildFilterRange(String from, String to) {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_All", (Locale)ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_FirstFrom", (Locale)ctx.getLocale()) + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_ToEnd", (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_To", (Locale)ctx.getLocale()) + to;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader reportHeader = new ReportHeader();
        ReportHeader childHeader = null;
        Context ctx = this.getContext();
        int index = 0;
        List tblData = (List)filter.getObject("table");
        ArrayList list = new ArrayList(tblData.size());
        for (i = 0; i < tblData.size(); ++i) {
            Map row = (Map)tblData.get(i);
            list.add(row.get("id"));
        }
        for (i = 0; i < list.size(); ++i) {
            if ("FCalculatePeriodID".equals(list.get(i))) {
                reportHeader.addChild("FCalculatePeriodName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Period", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FOrderID".equals(list.get(i))) {
                reportHeader.addChild("FOrderName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_OrderNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FOrderLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Lot", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FProductID".equals(list.get(i))) {
                reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_PorductNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_PorductName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FProductModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Model", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FBaseUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BaseUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                childHeader = reportHeader.addChild("FOrderPlanQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_PlanQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2);
                childHeader.setDecimalField("FBaseQtyPrecision");
                childHeader.setMergeable(true);
                continue;
            }
            if ("FCostCenterID".equals(list.get(i))) {
                reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_CostCenter", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if (!"FCostItemID".equals(list.get(i))) continue;
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_CostItem", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        }
        ReportHeader bopHeader = reportHeader.addChild("FBopUnfinished", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BopBalance", (Locale)ctx.getLocale()), index++);
        bopHeader.addChild("FBopQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCalDetailReport_BOPQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FBaseQtyPrecision");
        bopHeader.addChild("FBopAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        reportHeader.addChild("FCurInputAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCalDetailReport_CuInputAmount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        reportHeader.addChild("FTotalAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCalDetailReport_TotalAmount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader eopHeader = reportHeader.addChild("FeopUnfinished", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_EndWIP", (Locale)ctx.getLocale()), index++);
        eopHeader.addChild("FEopQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCalDetailReport_EopQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FBaseQtyPrecision");
        eopHeader.addChild("FEopAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader curHeader = reportHeader.addChild("FcurFinished", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCalDetailReport_CurFinished", (Locale)ctx.getLocale()), index++);
        curHeader.addChild("FCurFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FBaseQtyPrecision");
        curHeader.addChild("FCurFinishedAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        curHeader.addChild("FCurFinishedUnitAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_UnitCost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPricePrecision");
        ReportHeader cumHeader = reportHeader.addChild("FcumFinished", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCalDetailReport_CumFinished", (Locale)ctx.getLocale()), index++);
        cumHeader.addChild("FCumFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FBaseQtyPrecision");
        cumHeader.addChild("FCumFinishedAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        return reportHeader;
    }

    protected String getResource(String resName) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)this.getContext().getLocale());
    }
}

