/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OCCostCenterFeeDiffReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.report.app.OCCostCenterFeeDiffReport");

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("company")).getId().toString();
        String sTmpTblName = this.createTmpTableSQL();
        PeriodInfo periodInfo = (PeriodInfo)filter.getObject("period");
        String costTypeNumber = filter.getObject("costType").toString();
        String costCenterData = this.createCostCenterStdCostTmp(filter);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("Insert Into ").append(sTmpTblName);
        insertSql.append("  (FCompanyOrg, \n");
        insertSql.append("  FPeriodID,FPeriodName,FPeriodNumber, \n");
        insertSql.append("  FCostTypeID,FCostTypeName,FCostTypeNumber, \n");
        insertSql.append("  FCostCenterID,FCostCenterName,FCostCenterNumber, \n");
        insertSql.append("  FCostItemID,FCostItemName,FCostItemNumber, \n");
        insertSql.append("  FActCost,FStdCost,FCostDiff,FCostDiffRatio, \n");
        insertSql.append("  FTotalRow,FTotalRow2,FIsTotalRow, \n");
        insertSql.append("  FTotalCostTypeRow,FTotalCostCenterRow, \n");
        insertSql.append("  FAmountPrecision) \n");
        insertSql.append("SELECT '" + companyID + "' as FCompanyOrg, \n");
        insertSql.append("  t1.FCalculatePeriodID as FPeriodID, TO_Char(p.FNumber) as FPeriodName, TO_Char(p.FNumber) as FPeriodNumber, \n");
        insertSql.append("  ct.FID as FCostTypeID, ct.FName_l2 as FCostTypeName, ct.FNumber as FCostTypeNumber, \n");
        insertSql.append("  t1.FCostCenterID as FCostCenterID, cc.FName_l2 as FCostCenterName, cc.FNumber as FCostCenterNumber, \n");
        insertSql.append("  t1.FCostItemID as FCostItemID, ci.FName_l2 as FCostItemName, ci.FNumber as FCostItemNumber, \n");
        insertSql.append("  t1.FActCost as FActCost, t1.FStdCost as FStdCost, t1.FActCost - t1.FStdCost as FCostDiff, \n");
        insertSql.append("  case when t1.FStdCost <> 0 and t1.FStdCost is not null then (t1.FActCost - t1.FStdCost)/FStdCost*100 else 0 end as FCostDiffRatio, \n");
        insertSql.append("  0 as FTotalRow, 0 as FTotalRow2, 0 as FIsTotalRow, \n");
        insertSql.append("  0 as FTotalCostTypeRow,0 as FTotalCostCenterRow, \n");
        insertSql.append("  2 as FAmountPrecision \n");
        insertSql.append("From " + costCenterData + "  t1 \n");
        insertSql.append("  Left Join T_NCM_CostType ct on t1.FCompanyID = ct.FCompanyID  and FNumber = '" + costTypeNumber + "' \n");
        insertSql.append("  Inner Join T_ORG_CostCenter cc on cc.FID = t1.FCostCenterID \n");
        insertSql.append("  Inner Join T_NCM_CostItem ci on ci.FID = t1.FCostItemID and ci.FItemType = '2' \n");
        insertSql.append("  Inner Join T_BD_Period p on p.FID = t1.FCalculatePeriodID \n");
        insertSql.append(" Where ct.FNumber = '").append(filter.getObject("costType") + "'");
        insertSql.append(" and p.FID = '").append(periodInfo.getId().toString() + "'");
        insertSql.append(this.getCostCenterFilter(filter));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT  * FROM " + sTmpTblName + " Order by FCostCenterNumber, FCostItemNumber, FTotalRow , FTotalRow2 "));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTmpTblName);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(costCenterData);
        return rs;
    }

    private String[] getPhysicalTableName(RptParams filter, String companyID, int period) throws BOSException {
        String periodID = ((PeriodInfo)filter.getObject("period")).getId().toString();
        String[] physicalTblNames = new String[5];
        String[] logicalTblNames = new String[]{"T_NCM_OrderCostCalActivityDetailResult", "T_NCM_OSActivityDetail", "T_NCM_OSMaterialDetail", "T_NCM_DataByOrder", "T_NCM_OrderBalance"};
        try {
            physicalTblNames[0] = DynamicTableManager.getPhysicalTblName((Context)this.getContext(), (String)companyID, (String)periodID, (String)logicalTblNames[0]);
            physicalTblNames[1] = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)logicalTblNames[1]);
            physicalTblNames[2] = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)logicalTblNames[2]);
            physicalTblNames[3] = DynamicTableManager.getPhysicalTblName((Context)this.getContext(), (String)companyID, (String)periodID, (String)logicalTblNames[3]);
            physicalTblNames[4] = DynamicTableManager.getPhysicalTblName((Context)this.getContext(), (String)companyID, (String)periodID, (String)logicalTblNames[4]);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return physicalTblNames;
    }

    private String createCostCenterStdCostTmp(RptParams filter) throws BOSException {
        String sTmpTblName;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("company")).getId().toString();
        PeriodInfo periodInfo = (PeriodInfo)filter.getObject("period");
        Integer period = new Integer(((PeriodInfo)filter.getObject("period")).getNumber());
        String costtype = filter.getObject("costType").toString();
        String[] physicalTblNames = this.getPhysicalTableName(filter, companyID, period);
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_CostCenterData( ");
        createTable.append(" FCompanyID varchar(255) ");
        createTable.append(" ,FCalculatePeriodID   varchar(44) \n");
        createTable.append(" ,FCostCenterID varchar(44) \n");
        createTable.append(" ,FProductID varchar(44) \n");
        createTable.append(" ,FCostItemID varchar(44) \n");
        createTable.append(" ,FActCost numeric(28,10) \n");
        createTable.append(" ,FStdCost numeric(28,10) \n");
        createTable.append(" ,FisSum int default(0)) \n");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (physicalTblNames[0] != null && physicalTblNames[1] != null && physicalTblNames[2] != null && physicalTblNames[3] != null && physicalTblNames[4] != null) {
            StringBuffer insertSQL = new StringBuffer();
            insertSQL.append("Insert Into ").append(sTmpTblName);
            insertSQL.append("  (FCompanyID, FCalculatePeriodID, FCostCenterID, FProductID, FCostItemID, FActCost, FStdCost ) \n");
            insertSQL.append(" select FCompanyID, FCalculatePeriodID, FCostCenterID, FProductID, FCostItemID, FActCost, FStdCost from \n");
            insertSQL.append("(Select distinct t1.FCompanyID as FCompanyID, t0.FCalculatePeriodID as FCalculatePeriodID, t0.FCostCenterID as FCostCenterID, \n");
            insertSQL.append("  t1.FParentMaterialID as FProductID, t1.FActCostItemID as FCostItemID, \n");
            insertSQL.append("  0 as FActCost, max(isnull(t1.FActAmount,0))*(isnull(da1.FFinishedQty, 0)) as FStdCost From ").append(physicalTblNames[0]).append(" t0 \n");
            insertSQL.append("  Left Join ").append(physicalTblNames[1]).append(" t1 \n");
            insertSQL.append("  on t1.FCompanyID = t0.FCompanyID \n");
            insertSQL.append("  and t1.FParentMaterialID = t0.FProductID \n");
            insertSQL.append("  and t1.FParentMaterialID = t0.FProductID \n");
            insertSQL.append("  and t1.FActivityID = t0.FActivityID \n");
            insertSQL.append("  Left Join ").append(physicalTblNames[3]).append(" da1 \n");
            insertSQL.append("  on t0.ForderID = da1.FOrderID and t1.FParentMaterialID = da1.FProductID \n");
            insertSQL.append("  Left Join T_NCM_CostType ct on ct.FID = t1.FCostTypeID \n ");
            insertSQL.append("  where ct.FNumber = '").append(costtype).append("' \n");
            insertSQL.append("Group By t1.FCompanyID, t0.FCalculatePeriodID, t0.FCostCenterID, t1.FParentMaterialID,t1.FActivityID, t1.FActCostItemID, da1.FFinishedQty \n");
            insertSQL.append(" UNION ALL \n");
            insertSQL.append("Select t3.FCompanyID as FCompanyID, t2.FCalculatePeriodID as FCalculatePeriodID, t2.FCostCenterID as FCostCenterID, \n");
            insertSQL.append("  t3.FParentMaterialID as FProductID, t3.FChildCostItemID as FCostItemID, \n");
            insertSQL.append("  0 as FActCost, max(isnull(t3.FChildAmount,0))*(isnull(da2.FFinishedQty, 0)) as FStdCost From ").append(physicalTblNames[0]).append(" t2 \n");
            insertSQL.append("  Left Join ").append(physicalTblNames[2]).append(" t3 \n");
            insertSQL.append("  on t2.FCompanyID = t3.FCompanyID \n");
            insertSQL.append("  and t2.FProductID = t3.FParentMaterialID \n");
            insertSQL.append("  and t2.FCostItemID = t3.FChildCostItemID \n");
            insertSQL.append("  Left Join ").append(physicalTblNames[3]).append(" da2 \n");
            insertSQL.append("  on t3.ForderID = da2.FOrderID and t3.FParentMaterialID = da2.FProductID \n");
            insertSQL.append("  Left Join T_NCM_CostType ct1 on ct1.FID = t3.FCostTypeID \n ");
            insertSQL.append("  Left Join ").append(physicalTblNames[4]).append(" initbala2 \n");
            insertSQL.append("  on t2.FProductID = initbala2.FOrderProductID \n");
            insertSQL.append("  where ct1.FNumber = '").append(costtype).append("' \n");
            insertSQL.append("Group By t3.FCompanyID, t2.FCalculatePeriodID, t2.FCostCenterID, t3.FParentMaterialID, t3.FChildCostItemID, da2.FFinishedQty) t \n");
            DbUtil.execute((Context)this.getContext(), (String)insertSQL.toString());
            insertSQL.delete(0, insertSQL.length() - 1);
            insertSQL.append("Insert Into ").append(sTmpTblName);
            insertSQL.append("  (FCompanyID, FCalculatePeriodID, FCostCenterID, FCostItemID, FActCost, FStdCost, FisSum ) \n");
            insertSQL.append("select FCompanyID, FCalculatePeriodID, FCostCenterID, FCostItemID, max(FActCost) as FActCost, sum(FStdCost) as FStdCost, 1 as FisSum from \n");
            insertSQL.append(sTmpTblName).append(" \n");
            insertSQL.append("  Group by FCompanyID, FCalculatePeriodID, FCostCenterID, FCostItemID ");
            DbUtil.execute((Context)this.getContext(), (String)insertSQL.toString());
            String deleteSQL = " delete from " + sTmpTblName + " where FIsSum = 0";
            DbUtil.execute((Context)this.getContext(), (String)deleteSQL);
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ").append(sTmpTblName).append(" m \n");
            updateSql.append(" set FActCost = (select d.FAmount from (");
            updateSql.append("    select bill.FCompanyOrg,bill.FCalculatePeirod,bill.FCostCenterID,entry.FCostItemID as FCostItemID,sum(entry.FAmount) as FAmount from  \n");
            updateSql.append("       (Select b.FID as FID,b.FCompanyOrg as FCompanyOrg,b.FCalculatePeriod as FCalculatePeirod,b.FCostCenterID as FCostCenterID \n");
            updateSql.append("          FROM T_NCM_OrderCCFeeBill b Where b.FCompanyOrg = '" + companyID + "' and b.FCalculatePeriod = '" + periodInfo.getId().toString() + "') bill \n");
            updateSql.append("       Inner join T_NCM_OrderCCFeeBillEntry entry \n");
            updateSql.append("           on entry.FParentID = bill.FID \n");
            updateSql.append("       group by bill.FCompanyOrg,bill.FCalculatePeirod,bill.FCostCenterID,entry.FCostItemID) d");
            updateSql.append("  where d.FCostCenterID = m.FCostCenterID and d.FCostItemID = m.FCostItemID )\n");
            DbUtil.execute((Context)this.getContext(), (String)updateSql.toString());
        }
        return sTmpTblName;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_ActivityCostReport( ");
        createTable.append(" FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName nvarchar(255) ");
        createTable.append(",FPeriodNumber nvarchar(255) ");
        createTable.append(",FCostTypeID   varchar(44)  ");
        createTable.append(",FCostTypeName nvarchar(255) ");
        createTable.append(",FCostTypeNumber nvarchar(255) ");
        createTable.append(",FCostTypeNumberOrder nvarchar(255) ");
        createTable.append(",FCostCenterID varchar(44)  ");
        createTable.append(",FCostCenterName nvarchar(255)  ");
        createTable.append(",FCostCenterNumber nvarchar(255)  ");
        createTable.append(",FCostCenterNumberOrder nvarchar(255)  ");
        createTable.append(",FCostItemID varchar(44)  ");
        createTable.append(",FCostItemName nvarchar(255)  ");
        createTable.append(",FCostItemNumber nvarchar(255)  ");
        createTable.append(",FCostItemNumberOrder nvarchar(255)  ");
        createTable.append(",FActCost numeric(28,10)");
        createTable.append(",FStdCost numeric(28,10)");
        createTable.append(",FCostDiff numeric(28,10)");
        createTable.append(",FCostDiffRatio numeric(28,10)");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalCostTypeRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String getCostCenterFilter(RptParams filter) {
        String filterSql = "";
        String costCenteres = filter.getString("costCenter");
        if (costCenteres == null) {
            return filterSql;
        }
        costCenteres = costCenteres.replaceAll("; ", "', '");
        costCenteres = "'" + costCenteres + "'";
        filterSql = " and cc.FNumber in (" + costCenteres + ")";
        return filterSql;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("company");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Company", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_CostType", (Locale)ctx.getLocale()) + filter.getString("costType"));
        PeriodInfo period = (PeriodInfo)filter.getObject("period");
        if (period != null) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Period", (Locale)ctx.getLocale()) + "\uff1a" + period.getPeriodYear() + "\u5e74" + period.getPeriodNumber() + "\u6708");
        }
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        reportHeader.addChild("FCostCenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostCenterNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FCostCenterName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostItemNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostItemName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_ActualCost", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        reportHeader.addChild("FStdCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_StdCost", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        reportHeader.addChild("FCostDiff", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FStdPriceDifference", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader diffRatioHeader = reportHeader.addChild("FCostDiffRatio", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_CostDiffRatio", (Locale)ctx.getLocale()), index++);
        diffRatioHeader.setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        diffRatioHeader.setWidth(120);
        return reportHeader;
    }
}

