/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OCMatAllocTotalReport
extends ReportServerBase {
    public static final String RES_CLASSNAME = "com.kingdee.eas.ncm.order.fact.report.OCMatAllocTotalReportResource";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = this.buildReportDataTempTable(filter);
        String ksql = "select * from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = "where FIsTotalRow = 1 or FIsSubTotalRow = 1 \n";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "desc" : "asc";
        StringBuffer ksql = new StringBuffer();
        ksql.append("select * from " + tableName + " \n");
        ksql.append(where);
        ksql.append("order by \n");
        ksql.append("FIsTotalRow " + orderByMode + ",");
        StringBuffer orderBy = new StringBuffer();
        List tblData = (List)filter.getObject("table");
        HashMap row = null;
        String field = null;
        for (int i = 0; i < tblData.size(); ++i) {
            row = (HashMap)tblData.get(i);
            field = (String)row.get("id");
            if ("FCostCenterID".equalsIgnoreCase(field)) {
                orderBy.append(" FCostCenterNumber, FIsCostCenterTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FMaterialID".equalsIgnoreCase(field)) {
                orderBy.append(" FMaterialNumber, FIsMaterialTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FOrderID".equalsIgnoreCase(field)) {
                orderBy.append(" FOrderNumber, FIsOrderTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FOperationID".equalsIgnoreCase(field)) {
                orderBy.append(" FOperationNumber, FIsOperationTotalRow " + orderByMode + ",");
                continue;
            }
            if (!"FCostItemID".equalsIgnoreCase(field)) continue;
            orderBy.append(" FCostItemNumber, FIsCostITemTotalRow " + orderByMode + ",");
        }
        orderBy.deleteCharAt(orderBy.length() - 1);
        ksql.append(orderBy);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql.toString(), (int)start, (int)rows);
        return rs;
    }

    protected String createReportDataTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FCostCenterID varchar(44), \n");
        ksql.append("     FCostCenterNumber varchar(80), \n");
        ksql.append("     FCostCenterName varchar(255), \n");
        ksql.append("     FMaterialID varchar(44), \n");
        ksql.append("     FMaterialNumber varchar(80), \n");
        ksql.append("     FMaterialName varchar(255), \n");
        ksql.append("     FMaterialModel nvarchar(255), \n");
        ksql.append("     FMaterialShortName nvarchar(255), \n");
        ksql.append("     FOrderID varchar(44), \n");
        ksql.append("     FOrderNumber varchar(80), \n");
        ksql.append("     FOrderStorageName varchar(255), \n");
        ksql.append("     FOrderMaterialName varchar(255), \n");
        ksql.append("     FOrderMaterialLot nvarchar(255), \n");
        ksql.append("     FOperationID varchar(44), \n");
        ksql.append("     FOperationNumber varchar(80), \n");
        ksql.append("     FOperationName varchar(255), \n");
        ksql.append("     FCostItemID varchar(44), \n");
        ksql.append("     FCostItemNumber varchar(80), \n");
        ksql.append("     FCostItemName varchar(255), \n");
        ksql.append("     FUnitID varchar(44), \n");
        ksql.append("     FUnitName varchar(255), \n");
        ksql.append("     FQtyPrecision int not null default(4), \n");
        ksql.append("     FQty decimal(21,8), \n");
        ksql.append("     FBaseUnitName varchar(255), \n");
        ksql.append("     FBaseQtyPrecision int not null default(4), \n");
        ksql.append("     FBaseQty decimal(21,8), \n");
        ksql.append("     FAssistUnitName varchar(255), \n");
        ksql.append("     FAssistQtyPrecision int not null default(4), \n");
        ksql.append("     FAssistQty decimal(21,8), \n");
        ksql.append("     FPricePrecision int not null default(2), \n");
        ksql.append("     FPrice decimal(21,8), \n");
        ksql.append("     FAmountPrecision int not null default(2), \n");
        ksql.append("     FAmount decimal(17,4), \n");
        ksql.append("     FIsCostCenterTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsMaterialTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsOrderTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsOperationTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsCostItemTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsSubTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsTotalRow NUMERIC(17,4) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = company.getId().toString();
        int amountPrecision = 2;
        try {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
            amountPrecision = currency.getPrecision();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        String tempTable = this.createReportDataTempTable();
        Integer fromPeriod = this.getFromPeriod(filter);
        Integer toPeriod = this.getToPeriod(filter);
        Set periodIds = OrderCMUtils.getPeriodIds(this.getContext(), company, fromPeriod, toPeriod);
        if (periodIds.size() <= 0) {
            return tempTable;
        }
        Map tblMatAllocResults = null;
        String tblMatAllocResult2 = null;
        try {
            tblMatAllocResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OCMatAllocResult");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (tblMatAllocResults.size() <= 0) {
            return tempTable;
        }
        String ccWhere = this.buildCostCenterFilter(filter);
        String mWhere = this.buildMaterialFilter(filter);
        String oWhere = this.buildOrderFilter(filter);
        String opWhere = this.buildOperationFilter(filter);
        String ciWhere = this.buildCostItemFilter(filter);
        String assistTable = this.createReportDataTempTable();
        StringBuffer ksql = new StringBuffer();
        for (String tblMatAllocResult2 : tblMatAllocResults.values()) {
            ksql.append("insert into " + assistTable + " ( \n");
            ksql.append("     FCostCenterID, \n");
            ksql.append("     FMaterialID, \n");
            ksql.append("     FOrderID, \n");
            ksql.append("     FOperationID, \n");
            ksql.append("     FCostItemID, \n");
            ksql.append("     FUnitID, \n");
            ksql.append("     FQty, \n");
            ksql.append("     FBaseQty, \n");
            ksql.append("     FAssistQty, \n");
            ksql.append("     FAmount \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("     r.FCostCenterID FCostCenterID, \n");
            ksql.append("     r.FMaterialID FMaterialID, \n");
            ksql.append("     r.FOrderID FOrderID, \n");
            ksql.append("     r.FOperationID FOperationID, \n");
            ksql.append("     r.FCostItemID FCostItemID, \n");
            ksql.append("     r.FUnitID FUnitID, \n");
            ksql.append("     r.FQty FQty, \n");
            ksql.append("     r.FBaseQty FBaseQty, \n");
            ksql.append("     r.FAssistQty FAssistQty, \n");
            ksql.append("     r.FAmount FAmount \n");
            ksql.append("from " + tblMatAllocResult2 + " r \n");
            if (ccWhere.length() > 0) {
                ksql.append("left join T_ORG_CostCenter cc on cc.FID = r.FCostCenterID \n");
            }
            if (mWhere.length() > 0) {
                ksql.append("left join T_BD_Material m on m.FID = r.FMaterialID \n");
            }
            if (oWhere.length() > 0) {
                ksql.append("left join T_MM_ManufactureOrder o on o.FID = r.FOrderID \n");
            }
            if (opWhere.length() > 0) {
                ksql.append("left join T_MM_Operation op on op.FID = r.FOperationID \n");
            }
            if (ciWhere.length() > 0) {
                ksql.append("left join T_NCM_CostItem ci on ci.FID = r.FCostItemID \n");
            }
            ksql.append("where 1 = 1 \n");
            ksql.append(ccWhere);
            ksql.append(mWhere);
            ksql.append(oWhere);
            ksql.append(opWhere);
            ksql.append(ciWhere);
            ksql.append(" \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("     FCostCenterID, \n");
        ksql.append("     FMaterialID, \n");
        ksql.append("     FOrderID, \n");
        ksql.append("     FOperationID, \n");
        ksql.append("     FCostItemID, \n");
        ksql.append("     FUnitID, \n");
        ksql.append("     FQty, \n");
        ksql.append("     FBaseQty, \n");
        ksql.append("     FAssistQty, \n");
        ksql.append("     FPrice, \n");
        ksql.append("     FAmountPrecision, \n");
        ksql.append("     FAmount, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FCostCenterID FCostCenterID, \n");
        ksql.append("     r.FMaterialID FMaterialID, \n");
        ksql.append("     r.FOrderID FOrderID, \n");
        ksql.append("     r.FOperationID FOperationID, \n");
        ksql.append("     r.FCostItemID FCostItemID, \n");
        ksql.append("     r.FUnitID FUnitID, \n");
        ksql.append("     sum(r.FQty) FQty, \n");
        ksql.append("     sum(r.FBaseQty) FBaseQty, \n");
        ksql.append("     sum(r.FAssistQty) FAssistQty, \n");
        ksql.append("     case \n");
        ksql.append("          when sum(r.FBaseQty) = 0 then 0 \n");
        ksql.append("          else to_decimal(sum(r.FAmount),24,12)/to_decimal(sum(r.FBaseQty),24,12) \n");
        ksql.append("     end FPrice, \n");
        ksql.append("     " + amountPrecision + " FAmountPrecision, \n");
        ksql.append("     sum(r.FAmount) FAmount, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + assistTable + " r \n");
        ksql.append("group by r.FCostCenterID, r.FMaterialID, r.FOrderID, r.FOperationID, r.FCostItemID, r.FUnitID \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("update " + tempTable + " t set FQtyPrecision = isnull(( \n");
        ksql.append("    select max(mmu.FQtyPrecision) \n");
        ksql.append("    from T_BD_MultiMeasureUnit mmu \n");
        ksql.append("    where mmu.FMaterialID = t.FMaterialID and mmu.FMeasureUnitID = t.FUnitID \n");
        ksql.append("), 4); \n");
        ksql.append("update " + tempTable + " t set (FBaseQtyPrecision, FPricePrecision) = ( \n");
        ksql.append("    select mmu.FQtyPrecision, m.FPricePrecision \n");
        ksql.append("    from T_BD_Material m  \n");
        ksql.append("    join T_BD_MultiMeasureUnit mmu \n");
        ksql.append("    on mmu.FMaterialID = m.Fid and mmu.FMeasureUnitID = m.FBaseUnit \n");
        ksql.append("    where m.FID = t.FMaterialID \n");
        ksql.append("); \n");
        ksql.append("update " + tempTable + " t set FAssistQtyPrecision = isnull(( \n");
        ksql.append("    select mmu.FQtyPrecision \n");
        ksql.append("    from T_BD_Material m  \n");
        ksql.append("    join T_BD_MultiMeasureUnit mmu \n");
        ksql.append("    on mmu.FMaterialID = m.Fid and mmu.FMeasureUnitID = m.FAssistUnit \n");
        ksql.append("    where m.FID = t.FMaterialID \n");
        ksql.append("), 4); \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        List tblData = (List)filter.getObject("table");
        Map row = null;
        String field = null;
        boolean isTotal = false;
        for (int rowIndex = 0; rowIndex < tblData.size(); ++rowIndex) {
            row = (Map)tblData.get(rowIndex);
            field = (String)row.get("id");
            isTotal = false;
            if (row.containsKey("isTotal") && row.get("isTotal") instanceof Boolean) {
                isTotal = (Boolean)row.get("isTotal");
            }
            if (!isTotal) continue;
            String insertTotalRow = "";
            String selectTotalRow = "";
            if ("FCostCenterID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCostCenterTotalRow, \n";
                selectTotalRow = "    1 FIsCostCenterTotalRow, \n";
            } else if ("FMaterialID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsMaterialTotalRow, \n";
                selectTotalRow = "    1 FIsMaterialTotalRow, \n";
            } else if ("FOrderID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsOrderTotalRow, \n";
                selectTotalRow = "    1 FIsOrderTotalRow, \n";
            } else if ("FOperationID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsOperationTotalRow, \n";
                selectTotalRow = "    1 FIsOperationTotalRow, \n";
            } else if ("FCostItemID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCostItemTotalRow, \n";
                selectTotalRow = "    1 FIsCostItemTotalRow, \n";
            }
            StringBuffer fields = new StringBuffer();
            for (int i = 0; i <= rowIndex; ++i) {
                row = (HashMap)tblData.get(i);
                field = (String)row.get("id");
                if ("FCostCenterID".equalsIgnoreCase(field)) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if ("FMaterialID".equalsIgnoreCase(field)) {
                    fields.append("FMaterialID,");
                    continue;
                }
                if ("FOrderID".equalsIgnoreCase(field)) {
                    fields.append("FOrderID,");
                    continue;
                }
                if ("FOperationID".equalsIgnoreCase(field)) {
                    fields.append("FOperationID,");
                    continue;
                }
                if (!"FCostItemID".equalsIgnoreCase(field)) continue;
                fields.append("FCostItemID,");
            }
            fields.deleteCharAt(fields.length() - 1);
            ksql.append("insert into " + tempTable + " ( \n");
            ksql.append("    " + fields + ", \n");
            ksql.append("    FQtyPrecision, \n");
            ksql.append("    FQty, \n");
            ksql.append("    FBaseQtyPrecision, \n");
            ksql.append("    FBaseQty, \n");
            ksql.append("    FAssistQtyPrecision, \n");
            ksql.append("    FAssistQty, \n");
            ksql.append("    FPricePrecision, \n");
            ksql.append("    FPrice, \n");
            ksql.append("    FAmountPrecision, \n");
            ksql.append("    FAmount, \n");
            ksql.append(insertTotalRow);
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    " + fields + ", \n");
            ksql.append("    max(FQtyPrecision) FQtyPrecision, \n");
            ksql.append("    sum(FQty) FQty, \n");
            ksql.append("    max(FBaseQtyPrecision) FBaseQtyPrecision, \n");
            ksql.append("    sum(FBaseQty) FBaseQty, \n");
            ksql.append("    max(FAssistQtyPrecision) FAssistQtyPrecision, \n");
            ksql.append("    sum(FAssistQty) FAssistQty, \n");
            ksql.append("    max(FPricePrecision) FPricePrecision, \n");
            ksql.append("    case \n");
            ksql.append("         when sum(FBaseQty) = 0 then 0 \n");
            ksql.append("         else to_decimal(sum(FAmount),24,12)/to_decimal(sum(FBaseQty),24,12) \n");
            ksql.append("    end FPrice, \n");
            ksql.append("    " + amountPrecision + " FAmountPrecision, \n");
            ksql.append("    sum(FAmount) FAmount, \n");
            ksql.append(selectTotalRow);
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    0 FIsTotalRow \n");
            ksql.append("from " + tempTable + " \n");
            ksql.append("where FIsSubTotalRow = 0 \n");
            ksql.append("group by " + fields + " \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FBaseQtyPrecision, \n");
        ksql.append("    FBaseQty, \n");
        ksql.append("    FAssistQtyPrecision, \n");
        ksql.append("    FAssistQty, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    isnull(max(FQtyPrecision), 4) FQtyPrecision, \n");
        ksql.append("    sum(FQty) FQty, \n");
        ksql.append("    isnull(max(FBaseQtyPrecision), 4) FBaseQtyPrecision, \n");
        ksql.append("    sum(FBaseQty) FBaseQty, \n");
        ksql.append("    isnull(max(FAssistQtyPrecision), 4) FAssistQtyPrecision, \n");
        ksql.append("    sum(FAssistQty) FAssistQty, \n");
        ksql.append("    isnull(max(FPricePrecision), 4) FPricePrecision, \n");
        ksql.append("    case \n");
        ksql.append("         when sum(FBaseQty) = 0 then 0 \n");
        ksql.append("         else to_decimal(sum(FAmount),24,12)/to_decimal(sum(FBaseQty),24,12) \n");
        ksql.append("    end FPrice, \n");
        ksql.append("    " + amountPrecision + " FAmountPrecision, \n");
        ksql.append("    sum(FAmount) FAmount, \n");
        ksql.append("    1 FIsTotalRow \n");
        ksql.append("from " + tempTable + " \n");
        ksql.append("where FIsSubTotalRow = 0 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCostCenterNumber, FCostCenterName) = ( \n");
        ksql.append("    select cc.FNumber, cc.FName_L2  \n");
        ksql.append("    from T_ORG_CostCenter cc \n");
        ksql.append("    where cc.FID = t.FCostCenterID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FMaterialNumber, FMaterialName, FMaterialModel, FMaterialShortName) = ( \n");
        ksql.append("    select m.FNumber, m.FName_L2, m.FModel, m.FShortName \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    where m.FID = t.FMaterialID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FOrderNumber, FOrderStorageName, FOrderMaterialName, FOrderMaterialLot) = ( \n");
        ksql.append("    select o.FNumber, s.FName_l2, m.FName_L2, o.FLot \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    left join T_ORG_Storage s on s.FID = o.FStorageOrgUnitID \n");
        ksql.append("    left join T_BD_Material m on m.FID = o.FMaterialID \n");
        ksql.append("    where o.FID = t.FOrderID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FOperationNumber, FOperationName) = ( \n");
        ksql.append("    select op.FNumber, op.FName_L2  \n");
        ksql.append("    from T_MM_Operation op \n");
        ksql.append("    where op.FID = t.FOperationID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCostItemNumber, FCostItemName) = ( \n");
        ksql.append("    select ci.FNumber, ci.FName_L2  \n");
        ksql.append("    from T_NCM_CostItem ci \n");
        ksql.append("    where ci.FID = t.FCostItemID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FUnitName = ( \n");
        ksql.append("    select mu.FName_L2 \n");
        ksql.append("    from T_BD_MeasureUnit mu \n");
        ksql.append("    where mu.FID = t.FUnitID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FBaseUnitName = ( \n");
        ksql.append("    select mu.FName_L2 \n");
        ksql.append("    from T_BD_Material m  \n");
        ksql.append("    left join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
        ksql.append("where m.FID = t.FMaterialID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FAssistUnitName = ( \n");
        ksql.append("    select mu.FName_L2 \n");
        ksql.append("    from T_BD_Material m  \n");
        ksql.append("    left join T_BD_MeasureUnit mu on mu.FID = m.FAssistUnit \n");
        ksql.append("where m.FID = t.FMaterialID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t set FCostCenterName = '\u5c0f\u8ba1' where FIsCostCenterTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FMaterialName = '\u5c0f\u8ba1' where FIsMaterialTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FOrderStorageName = '\u5c0f\u8ba1' where FIsOrderTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FOperationName = '\u5c0f\u8ba1' where FIsOperationTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FCostItemName = '\u5c0f\u8ba1' where FIsCostItemTotalRow = 1; \n");
        row = (Map)tblData.get(0);
        field = (String)row.get("id");
        String totalFieldName = null;
        if ("FCostCenterID".equalsIgnoreCase(field)) {
            totalFieldName = "FCostCenterNumber";
        } else if ("FMaterialID".equalsIgnoreCase(field)) {
            totalFieldName = "FMaterialNumber";
        } else if ("FOrderID".equalsIgnoreCase(field)) {
            totalFieldName = "FOrderNumber";
        } else if ("FOperationID".equalsIgnoreCase(field)) {
            totalFieldName = "FOperationNumber";
        } else if ("FCostItemID".equalsIgnoreCase(field)) {
            totalFieldName = "FCostItemNumber";
        }
        if (totalFieldName != null) {
            ksql.append("update " + tempTable + " t set " + totalFieldName + " = '\u5408\u8ba1' where FIsTotalRow = 1; \n");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(assistTable);
        return tempTable;
    }

    public boolean isOnlyDisplayTotal(RptParams filter) {
        return filter.getBoolean("isOnlyDisPalyTotal");
    }

    public boolean isTotalRowTop(RptParams filter) {
        return filter.getBoolean("isTotalRowTop");
    }

    private String buildPeriodFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            ksql.append(" and p.FNumber >= ").append(this.getPeriodNumber(year, month)).append("");
        }
        year = filter.getString("yearTo");
        month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            ksql.append(" and p.FNumber <= ").append(this.getPeriodNumber(year, month)).append("");
        }
        return ksql.toString();
    }

    private Integer getFromPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Integer getToPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearTo");
        String month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String getPeriodNumber(String year, String month) {
        return year + (month.length() < 2 ? "0" + month : month);
    }

    private String buildCostCenterFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("costCenterFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and cc.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costCenterTo")))) {
            ksql.append(" and cc.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildMaterialFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("materialFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and m.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("materialTo")))) {
            ksql.append(" and m.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildOrderFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("orderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and o.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and o.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildOperationFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("operationFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and op.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("operationTo")))) {
            ksql.append(" and op.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildCostItemFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("costItemFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and ci.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costItemTo")))) {
            ksql.append(" and ci.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FIsSubTotalRow", 1, (Object)new BigDecimal(1), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FIsTotalRow", 1, (Object)new BigDecimal(1), a);
        return conditions;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCCFeeTotalReport_Title_Company", (Locale)ctx.getLocale()) + company.getName());
        String from = filter.getString("yearFrom");
        from = from + "\u5e74";
        from = from + filter.getString("periodFrom");
        from = from + "\u671f";
        String to = filter.getString("yearTo");
        to = to + "\u5e74";
        to = to + filter.getString("periodTo");
        to = to + "\u671f";
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_PeriodRange", (Locale)ctx.getLocale()) + from + " \u81f3 " + to);
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostCenterRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costCenterFrom"), filter.getString("costCenterTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_MaterialRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("materialFrom"), filter.getString("materialTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_OrderRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("orderFrom"), filter.getString("orderTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_OptionRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("operationFrom"), filter.getString("operationTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostItemRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costItemFrom"), filter.getString("costItemTo")));
        return titles;
    }

    private String buildFilterRange(String from, String to) {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_All", (Locale)ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_FirstFrom", (Locale)ctx.getLocale()) + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_ToEnd", (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_To", (Locale)ctx.getLocale()) + to;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        List tblData = (List)filter.getObject("table");
        ArrayList list = new ArrayList(tblData.size());
        for (i = 0; i < tblData.size(); ++i) {
            Map row = (Map)tblData.get(i);
            list.add(row.get("id"));
        }
        for (i = 0; i < list.size(); ++i) {
            if ("FCostCenterID".equals(list.get(i))) {
                reportHeader.addChild("FCostCenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostCenterNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FCostCenterName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FMaterialID".equals(list.get(i))) {
                reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MaterialNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MaterialName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FMaterialModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Model", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FMaterialShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MaterialShortName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FOrderID".equals(list.get(i))) {
                reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_OrderNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FOrderStorageName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCCActivityFeeTotalReport_OrderStorage", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FOrderMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatAllocTotalReport_OrderMatName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FOrderMaterialLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatAllocTotalReport_OrderMatLot", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FOperationID".equals(list.get(i))) {
                reportHeader.addChild("FOperationNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_OperationNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FOperationName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_OperationName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if (!"FCostItemID".equals(list.get(i))) continue;
            reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostItemNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostItemName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        }
        reportHeader.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MatUnit", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FQtyPrecision");
        reportHeader.addChild("FBaseUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_BaseUnit", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FBaseQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FBaseQtyPrecision");
        reportHeader.addChild("FAssistUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MatAUXUnit", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FAssistQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatAllocTotalReport_AssistQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAssistQtyPrecision");
        reportHeader.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_Price", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FPricePrecision");
        reportHeader.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FAmount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        return reportHeader;
    }

    protected String getResource(String resName) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)this.getContext().getLocale());
    }
}

