/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.bill.app.AbstractSTDPriceMaterialControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class STDPriceMaterialControllerBean
extends AbstractSTDPriceMaterialControllerBean {
    private static final long serialVersionUID = 5971857726142568316L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.std.bill.app.STDPriceMaterialControllerBean");

    @Override
    protected void _genData(Context ctx, Map param) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String costTypeId = (String)param.get("costType.id");
        if (costTypeId == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)costTypeId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("level"));
        view.setFilter(filter);
        view.setSelector(selector);
        CostTypeCollection ctColl = CostTypeFactory.getLocalInstance(ctx).getCostTypeCollection(view);
        if (ctColl.size() <= 0) {
            return;
        }
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        if (storageOrgUnitIds.size() <= 0) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer ksql = new StringBuffer();
            ksql.append("insert into T_NCM_STDPriceMaterial \n");
            ksql.append("    ( \n");
            ksql.append("    FID, \n");
            ksql.append("    FCompanyID, \n");
            ksql.append("    FCostTypeID, \n");
            ksql.append("    FMaterialID, \n");
            ksql.append("    FStdCostID, \n");
            ksql.append("    FStdPrice, \n");
            ksql.append("    FCreatorID, \n");
            ksql.append("    FCreateTime, \n");
            ksql.append("    FLastUpdateUserID, \n");
            ksql.append("    FLastUpdateTime, \n");
            ksql.append("    FControlUnitID \n");
            ksql.append("    ) \n");
            ksql.append("select \n");
            ksql.append("    newbosid('C17388F3') FID, \n");
            ksql.append("    '" + companyId + "' FCompanyID, \n");
            ksql.append("    '" + costTypeId + "' FCostTypeID, \n");
            ksql.append("    mc.FMaterialID FMaterialID, \n");
            ksql.append("    mc.FID FStdCostID, \n");
            ksql.append("    0 FStdPrice, \n");
            ksql.append("    '").append(userId).append("' FCreatorID, \n");
            ksql.append("    GetDate() FCreateTime, \n");
            ksql.append("    '").append(userId).append("' FLastUpdateUserID, \n");
            ksql.append("    GetDate() FLastUpdateTime, \n");
            ksql.append("    '").append(cuId).append("' FControlUnitID \n");
            ksql.append("from T_bd_MaterialCompanyInfo mc \n");
            ksql.append("where mc.FCalculateType=0 \n");
            ksql.append("and mc.FStatus=1 \n");
            ksql.append("and mc.FCompanyID='" + companyId + "' \n");
            ksql.append("and not exists ( \n");
            ksql.append("    select top 1 1 from T_NCM_STDPriceMaterial s \n");
            ksql.append("    where \n");
            ksql.append("    FCompanyID = '" + companyId + "' \n");
            ksql.append("    and s.FCostTypeID = '" + costTypeId + "' \n");
            ksql.append("    and s.FMaterialID = mc.FMaterialID \n");
            ksql.append(") \n");
            stmt.addBatch(ksql.toString());
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected Map _updateData(Context ctx, List list) throws BOSException, EASBizException {
        Map result = null;
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer ksql = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                Map info = (Map)list.get(i);
                String id = (String)info.get("id");
                if (id == null) {
                    ksql.append("insert into T_NCM_STDPriceMaterial \n");
                    ksql.append("    ( \n");
                    ksql.append("    FID, \n");
                    ksql.append("    FCompanyID, \n");
                    ksql.append("    FMaterialID, \n");
                    ksql.append("    FStdCostID, \n");
                    ksql.append("    FCostTypeID, \n");
                    ksql.append("    FStdPrice, \n");
                    ksql.append("    FCreatorID, \n");
                    ksql.append("    FCreateTime, \n");
                    ksql.append("    FLastUpdateUserID, \n");
                    ksql.append("    FLastUpdateTime, \n");
                    ksql.append("    FControlUnitID \n");
                    ksql.append("    ) \n");
                    ksql.append("values \n");
                    ksql.append("( \n");
                    ksql.append("'").append(BOSUuid.create((BOSObjectType)this.getBOSType())).append("', \n");
                    ksql.append("'").append(companyId).append("', \n");
                    if (info.get("material.id") != null) {
                        ksql.append("'").append(info.get("material.id")).append("', \n");
                    } else {
                        ksql.append("null, \n");
                    }
                    if (info.get("stdCost.id") != null) {
                        ksql.append("'").append(info.get("stdCost.id")).append("', \n");
                    } else {
                        ksql.append("null, \n");
                    }
                    if (info.get("costType.id") != null) {
                        ksql.append("'").append(info.get("costType.id")).append("', \n");
                    } else {
                        ksql.append("null, \n");
                    }
                    if (info.get("stdPrice") != null && info.get("stdPrice") instanceof BigDecimal) {
                        ksql.append("'").append((BigDecimal)info.get("stdPrice")).append("', \n");
                    } else {
                        ksql.append("0, \n");
                    }
                    ksql.append("'").append(userId).append("', \n");
                    ksql.append("GetDate(), \n");
                    ksql.append("'").append(userId).append("', \n");
                    ksql.append("GetDate(), \n");
                    ksql.append("'").append(cuId).append("' \n");
                    ksql.append(") \n");
                } else {
                    ksql.append("update T_NCM_STDPriceMaterial \n");
                    ksql.append("set \n");
                    if (info.containsKey("costType.id")) {
                        if (info.get("costType.id") != null) {
                            ksql.append("FCostTypeID = '").append(info.get("costType.id")).append("', \n");
                        } else {
                            ksql.append("FCostTypeID = null, \n");
                        }
                    }
                    if (info.containsKey("material.id")) {
                        if (info.get("material.id") != null) {
                            ksql.append("FMaterialID = '").append(info.get("material.id")).append("', \n");
                        } else {
                            ksql.append("FMaterialID = null, \n");
                        }
                    }
                    if (info.containsKey("stdCost.id")) {
                        if (info.get("stdCost.id") != null) {
                            ksql.append("FStdCostID = '").append(info.get("stdCost.id")).append("', \n");
                        } else {
                            ksql.append("FStdCostID = null, \n");
                        }
                    }
                    if (info.containsKey("stdPrice")) {
                        if (info.get("stdPrice") != null) {
                            ksql.append("FStdPrice = ").append((BigDecimal)info.get("stdPrice")).append(", \n");
                        } else {
                            ksql.append("FStdPrice = 0, \n");
                        }
                    }
                    if (info.get("isUsed") != null) {
                        if (info.get("isUsed") instanceof Boolean) {
                            if (((Boolean)info.get("isUsed")).booleanValue()) {
                                ksql.append("FIsUsed = 1, \n");
                            } else {
                                ksql.append("FIsUsed = 0, \n");
                            }
                        } else {
                            ksql.append("FIsUsed = null, \n");
                        }
                    }
                    ksql.append("FLastUpdateTime = GetDate() \n");
                    ksql.append("where FID = \n");
                    ksql.append("'").append(id).append("'");
                }
                stmt.addBatch(ksql.toString());
            }
            stmt.executeBatch();
            ksql.setLength(0);
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected BigDecimal _selectStdCost(Context ctx, String materialId, String companyId) throws BOSException, EASBizException {
        String sql = "select FStandardCost from t_bd_materialCompanyInfo where FMaterialId= ? and FCompanyId= ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal stdCost = new BigDecimal(0);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, materialId);
            pstmt.setString(2, companyId);
            rs = pstmt.executeQuery();
            pstmt.close();
            if (rs.next()) {
                stdCost = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        return stdCost;
    }

    @Override
    protected String _selectStdCostId(Context ctx, String materialId, String companyId) throws BOSException, EASBizException {
        String sql = "select FID from t_bd_materialCompanyInfo where FMaterialId=? and FCompanyId=? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String fid = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, materialId);
            pstmt.setString(2, companyId);
            rs = pstmt.executeQuery();
            pstmt.close();
            if (rs.next()) {
                fid = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        return fid;
    }

    @Override
    protected void _addLineLog(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _copyLineLog(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteLineLog(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _insertLineLog(Context ctx) throws BOSException, EASBizException {
    }
}

