/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.ncm.ActivityCollection;
import com.kingdee.eas.basedata.ncm.ActivityFactory;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.bill.OSActivityStdPriceFactory;
import com.kingdee.eas.ncm.order.std.bill.OSActivityStdPriceInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OSActivityStdPriceDataImport
extends AbstractNCMDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.std.bill.app.transmission.OSActivityStdPriceDataImport");
    private Map costTypeMap = new HashMap();
    private Map activityMap = new HashMap();
    private Map costItemMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OSActivityStdPriceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        OSActivityStdPriceInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private OSActivityStdPriceInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        OSActivityStdPriceInfo info = new OSActivityStdPriceInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompanyOrg(company);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CostTypeInfo costType = null;
        String costTypeValue = this.getStringValue(hsData, "costType.number");
        if (costTypeValue != null) {
            costType = (CostTypeInfo)this.costTypeMap.get(costTypeValue);
            if (costType == null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)costTypeValue));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4), CompareType.EQUALS));
                view.setFilter(filter);
                CostTypeCollection coll = CostTypeFactory.getLocalInstance(ctx).getCostTypeCollection(view);
                if (coll.size() <= 0) {
                    throw new BOSException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a [" + costTypeValue + "] \u7684\u5ba1\u6838\u72b6\u6001\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002");
                }
                costType = coll.get(0);
                this.costTypeMap.put(costTypeValue, costType);
            }
        } else {
            throw new BOSException(this.getResource("CostTypeNumberNotNull", ctx));
        }
        info.setCostType(costType);
        ActivityInfo activity = null;
        String activityValue = this.getStringValue(hsData, "activity.number");
        if (activityValue != null) {
            activity = (ActivityInfo)this.activityMap.get(activityValue);
            if (activity == null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)activityValue));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
                view.setFilter(filter);
                ActivityCollection coll = ActivityFactory.getLocalInstance((Context)ctx).getActivityCollection(view);
                if (coll.size() <= 0) {
                    throw new BOSException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a [" + activityValue + "] \u7684\u542f\u7528\u72b6\u6001\u7684\u4f5c\u4e1a\u4e0d\u5b58\u5728\u3002");
                }
                activity = coll.get(0);
                this.activityMap.put(activityValue, activity);
            }
        } else {
            throw new BOSException("\u4f5c\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        info.setActivity(activity);
        CostItemInfo costItem = null;
        String costItemValue = this.getStringValue(hsData, "costItem.number");
        if (costItemValue != null) {
            costItem = (CostItemInfo)this.costItemMap.get(costItemValue);
            if (costItem == null) {
                List costItemList = this.getCostItemOfActivity(ctx, activity, costItemValue);
                if (costItemList.size() <= 0) {
                    throw new BOSException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a [" + costItemValue + "] \u4e14\u5c5e\u4e8e\u4f5c\u4e1a[" + activityValue + "]\u7684\u6210\u672c\u9879\u76ee\u4e0d\u5b58\u5728\u3002");
                }
                costItem = (CostItemInfo)costItemList.get(0);
                this.costItemMap.put(costItemValue, costItem);
            }
        } else {
            throw new BOSException("\u6210\u672c\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        info.setCostItem(costItem);
        String stdPrice = this.getStringValue(hsData, "stdPrice");
        if (!StringUtil.isEmptyString((String)stdPrice)) {
            if (!OrderCMUtils.isPositiveNumber(stdPrice)) {
                throw new BOSException("\u7efc\u5408\u8d39\u7387\u5fc5\u987b\u5927\u4e8e0\u3002");
            }
        } else {
            throw new BOSException("\u7efc\u5408\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        info.setStdPrice(new BigDecimal(stdPrice));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(userInfo);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(userInfo);
        this.checkExists(ctx, info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCostItemOfActivity(Context ctx, ActivityInfo activity, String costItem) {
        ArrayList<CostItemInfo> list = null;
        if (activity == null || activity.getId() == null || StringUtil.isEmptyString((String)costItem)) {
            return list;
        }
        StringBuffer sql = new StringBuffer(150);
        sql.append(" SELECT a.FID, a.FNumber, a.FName_l2 FROM T_NCM_CostItem  a ");
        sql.append(" INNER JOIN T_NCM_ActivityResource c ON a.FID = c.FCostItemID ");
        sql.append(" INNER JOIN T_NCM_Activity d ON c.FParentID = d.FID ");
        sql.append(" WHERE d.fid = ? and a.fnumber = ?");
        IRowSet rs = null;
        try {
            list = new ArrayList<CostItemInfo>();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{activity.getId().toString(), costItem});
            while (rs.next()) {
                CostItemInfo costItemInfo = new CostItemInfo();
                costItemInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                costItemInfo.setNumber(rs.getString("FNumber"));
                costItemInfo.setName(rs.getString("FName_l2"));
                list.add(costItemInfo);
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return list;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("companyOrg.name", this.getNotBlankString(rs.getString("companyOrg.name")));
            result.put("costType.number", this.getNotBlankString(rs.getString("costType.number")));
            result.put("costType.name", this.getNotBlankString(rs.getString("costType.name")));
            result.put("activity.number", this.getNotBlankString(rs.getString("activity.number")));
            result.put("activity.name", this.getNotBlankString(rs.getString("activity.name")));
            result.put("baseUnit.name", this.getNotBlankString(rs.getString("baseUnit.name")));
            result.put("costItem.number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("costItem.name", this.getNotBlankString(rs.getString("costItem.name")));
            result.put("stdPrice", this.getNotBlankString(rs.getString("stdPrice")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkExists(Context ctx, OSActivityStdPriceInfo info) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)info.getCompanyOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costType.id", (Object)info.getCostType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("activity.id", (Object)info.getActivity().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costItem.id", (Object)info.getCostItem().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        CoreBaseCollection col = OSActivityStdPriceFactory.getLocalInstance(ctx).getCollection(view);
        if (col != null && col.size() > 0) {
            if (this.isSltImportUpdate()) {
                info.setId(col.get(0).getId());
            } else {
                throw new BOSException(this.getResource("EQUIVALENTCOEF_CHECK_PART1", ctx) + this.getResource("OSActivityStdPrice_CHECK_PART2", ctx) + info.getCostType().getNumber() + this.getResource("OSActivityStdPrice_CHECK_PART3", ctx) + info.getActivity().getNumber() + this.getResource("WIPCOUNTINGMATERIAL_CHECK_PART5", ctx) + info.getCostItem().getNumber());
            }
        }
    }

    protected String getResource(String key, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.bill.ImportExportResource", (String)key, (Locale)ctx.getLocale());
    }
}

