/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ActivityChainFactory;
import com.kingdee.eas.basedata.ncm.ActivityChainInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.bill.IOSBomActivitySetting;
import com.kingdee.eas.ncm.order.std.bill.OSBomActivitySettingCollection;
import com.kingdee.eas.ncm.order.std.bill.OSBomActivitySettingFactory;
import com.kingdee.eas.ncm.order.std.bill.OSBomActivitySettingInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class OSBomActivitySettingDataImport
extends AbstractNCMDataImport {
    private Map costTypeMap = new HashMap();
    private Map storageOrgUnitMap = new HashMap();
    private Map orderMap = new HashMap();
    private Map materialMap = new HashMap();
    private Map bomMap = new HashMap();
    private Map activityChainMap = new HashMap();
    private Set storageOrgUnitIds = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OSBomActivitySettingFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        OSBomActivitySettingInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("company.name", this.getNotBlankString(rs.getString("company.name")));
            result.put("costType.number", this.getNotBlankString(rs.getString("costType.number")));
            result.put("costType.name", this.getNotBlankString(rs.getString("costType.name")));
            int level = rs.getInt("costType.level");
            if (level == 6) {
                result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnitOfOrder.number")));
            } else if (level == 3) {
                result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnitOfBom.number")));
            } else {
                result.put("storageOrgUnit.number", this.getNotBlankString(null));
            }
            result.put("order.number", this.getNotBlankString(rs.getString("order.number")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("bom.number", this.getNotBlankString(rs.getString("bom.number")));
            result.put("bom.name", this.getNotBlankString(rs.getString("bom.name")));
            result.put("activityChain.number", this.getNotBlankString(rs.getString("activityChain.number")));
            result.put("activityChain.name", this.getNotBlankString(rs.getString("activityChain.name")));
            result.put("projectNumber.number", this.getNotBlankString(rs.getString("project.number")));
            result.put("trackNumber.number", this.getNotBlankString(rs.getString("trackNumber.number")));
            result.put("lot", this.getNotBlankString(rs.getString("order.lot")));
            result.put("isCal", this.getNotBlankString(rs.getString("isCal")));
            String isCal = this.getResource("NO", ctx);
            if ("true".equals(this.getNotBlankString(rs.getString("isCal")))) {
                isCal = this.getResource("YES", ctx);
            }
            result.put("isCal", isCal);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OSBomActivitySettingInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        MaterialCollection coll;
        BomInfo bom;
        FilterInfo filter;
        EntityViewInfo view;
        OSBomActivitySettingInfo info = new OSBomActivitySettingInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompany(company);
        CostTypeInfo costType = null;
        String value = this.getStringValue(hsData, "costType.number");
        if (value == null) throw new BOSException("\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        costType = (CostTypeInfo)this.costTypeMap.get(value);
        if (costType == null) {
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("number", (Object)value));
            filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            filter2.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4), CompareType.EQUALS));
            view2.setFilter(filter2);
            CostTypeCollection coll2 = CostTypeFactory.getLocalInstance(ctx).getCostTypeCollection(view2);
            if (coll2.size() <= 0) {
                throw new BOSException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a [" + value + "] \u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002");
            }
            costType = coll2.get(0);
            this.costTypeMap.put(value, costType);
        }
        info.setCostType(costType);
        StorageOrgUnitInfo storageOrgUnit = null;
        value = this.getStringValue(hsData, "storageOrgUnit.number");
        if (value == null) throw new BOSException("\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        storageOrgUnit = (StorageOrgUnitInfo)this.storageOrgUnitMap.get(value);
        if (storageOrgUnit == null) {
            EntityViewInfo view3 = new EntityViewInfo();
            FilterInfo filter3 = new FilterInfo();
            filter3.getFilterItems().add(new FilterItemInfo("number", (Object)value));
            view3.setFilter(filter3);
            StorageOrgUnitCollection coll3 = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view3);
            if (coll3.size() <= 0) {
                throw new BOSException("\u7f16\u7801\u4e3a [" + value + "] \u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002");
            }
            storageOrgUnit = coll3.get(0);
            if (this.storageOrgUnitIds == null) {
                this.storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
                if (this.storageOrgUnitIds.size() <= 0) {
                    throw new BOSException("\u6ca1\u6709\u59d4\u6258\u672c\u8d22\u52a1\u7ec4\u7ec7\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002");
                }
            }
            if (!this.storageOrgUnitIds.contains(storageOrgUnit.getId().toString())) {
                throw new BOSException("\u7f16\u7801\u4e3a [" + value + "] \u7684\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u672c\u8d22\u52a1\u7ec4\u7ec7\u3002");
            }
            this.storageOrgUnitMap.put(value, storageOrgUnit);
        }
        if (costType.getLevel().equals((Object)CostTypeLevelEnum.order)) {
            value = this.getStringValue(hsData, "order.number");
            if (value == null) throw new BOSException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            ManufactureOrderInfo order = (ManufactureOrderInfo)this.orderMap.get(value);
            if (order == null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)value));
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString()));
                HashSet<Integer> statuses = new HashSet<Integer>();
                statuses.add(new Integer(4));
                statuses.add(new Integer(5));
                statuses.add(new Integer(8));
                statuses.add(new Integer(7));
                statuses.add(new Integer(11));
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
                view.setFilter(filter);
                ManufactureOrderCollection coll4 = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
                if (coll4.size() <= 0) {
                    throw new BOSException("\u6307\u5b9a\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a " + value + " \u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u5ba1\u6838\u3001\u4e0b\u8fbe\u3001\u5b8c\u5de5\u3001\u5173\u95ed\u6216\u7ed3\u6848\u72b6\u6001\u3002");
                }
                order = coll4.get(0);
                this.orderMap.put(value, order);
            }
            info.setOrder(order);
            bom = new BomInfo();
            bom.setId(BOSUuid.read((String)order.getBomID()));
        } else {
            if (!costType.getLevel().equals((Object)CostTypeLevelEnum.product)) throw new BOSException("\u4e0d\u652f\u6301\u5f53\u524d\u6210\u672c\u7c7b\u578b\u3002");
            value = this.getStringValue(hsData, "material.number");
            MaterialInfo material = null;
            if (value == null) throw new BOSException("\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            material = (MaterialInfo)this.materialMap.get(value);
            if (material == null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)value));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                view.setFilter(filter);
                coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
                if (coll.size() <= 0) {
                    throw new BOSException("\u7f16\u7801\u4e3a " + value + " \u7684\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u6216\u672a\u5ba1\u6838\u3002");
                }
                material = coll.get(0);
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)material.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("calculateType", (Object)new Integer(2)));
                MaterialCompanyInfoCollection mcColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
                if (mcColl.size() <= 0) {
                    throw new BOSException("\u7f16\u7801\u4e3a " + value + " \u7684\u7269\u6599\u4e0d\u662f\u81ea\u5236\u7269\u6599\uff0c\u6216\u8d22\u52a1\u8d44\u6599\u672a\u5ba1\u6838\u3002");
                }
                this.materialMap.put(value, material);
            }
            info.setMaterial(material);
            value = this.getStringValue(hsData, "bom.number");
            if (value == null) throw new BOSException("BOM\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            bom = (BomInfo)this.orderMap.get(value);
            if (bom == null) {
                EntityViewInfo view4 = new EntityViewInfo();
                FilterInfo filter4 = new FilterInfo();
                filter4.getFilterItems().add(new FilterItemInfo("number", (Object)value));
                filter4.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
                filter4.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(40)));
                filter4.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
                filter4.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString()));
                view4.setFilter(filter4);
                BomCollection coll5 = BomFactory.getLocalInstance((Context)ctx).getBomCollection(view4);
                if (coll5.size() <= 0) {
                    throw new BOSException("\u6307\u5b9a\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a " + value + " \u7684BOM\u4e0d\u5b58\u5728\uff0c\u6216\u672a\u5ba1\u6838\uff0c\u6216\u5e76\u4e0d\u5c5e\u4e8e\u7269\u6599 [" + material.getNumber() + "]\u3002");
                }
                bom = coll5.get(0);
                bom.setStorageOrgUnit(storageOrgUnit);
                this.bomMap.put(value, bom);
            }
            info.setBom(bom);
        }
        value = this.getStringValue(hsData, "activityChain.number");
        if (value == null) throw new BOSException("\u4f5c\u4e1a\u94fe\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        ActivityChainInfo activityChain = (ActivityChainInfo)this.materialMap.get(value);
        if (activityChain == null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)value));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4)));
            filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)new Integer(0)));
            view.setFilter(filter);
            coll = ActivityChainFactory.getLocalInstance((Context)ctx).getActivityChainCollection(view);
            if (coll.size() <= 0) {
                throw new BOSException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a " + value + " \u7684\u4f5c\u4e1a\u94fe\u4e0d\u5b58\u5728\uff0c\u672a\u5ba1\u6838\uff0c\u6216\u672a\u542f\u7528\u3002");
            }
            activityChain = coll.get(0);
            this.activityChainMap.put(value, activityChain);
        }
        info.setActivityChain(activityChain);
        value = this.getStringValue(hsData, "isCal");
        info.setIsCal(false);
        if (value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equals(this.getResource("YES", ctx)))) {
            info.setIsCal(true);
        }
        this.checkExists(ctx, info);
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkExists(Context ctx, OSBomActivitySettingInfo info) throws BOSException, EASBizException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costType.id", (Object)info.getCostType().getId().toString()));
        if (info.getCostType().getLevel().equals((Object)CostTypeLevelEnum.order)) {
            if (info.getOrder() == null) return;
            filter.getFilterItems().add(new FilterItemInfo("order.id", (Object)info.getOrder().getId().toString()));
        } else {
            if (!info.getCostType().getLevel().equals((Object)CostTypeLevelEnum.product)) return;
            if (info.getMaterial() == null) return;
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString()));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        OSBomActivitySettingCollection coll = ((IOSBomActivitySetting)this.getController(ctx)).getOSBomActivitySettingCollection(view);
        if (coll == null || coll.size() < 1) return;
        if (this.isSltImportUpdate()) {
            info.setId(coll.get(0).getId());
            return;
        } else {
            String msg = "\u6570\u636e\u91cd\u590d\uff01";
            String costTypeNumber = info.getCostType().getNumber();
            String costTypeName = info.getCostType().getName();
            String costType = "";
            if (costTypeNumber != null) {
                if (costTypeName != null) {
                    costType = costTypeName;
                }
                costType = costType + "[" + costTypeNumber + "]";
            }
            msg = msg + "\u6210\u672c\u7c7b\u578b\uff1a" + costType;
            if (info.getCostType().getLevel().equals((Object)CostTypeLevelEnum.order)) {
                String orderNumber = info.getOrder().getNumber();
                msg = msg + "\uff0c\u8ba2\u5355\uff1a" + orderNumber;
            } else {
                if (!info.getCostType().getLevel().equals((Object)CostTypeLevelEnum.product)) return;
                String materialNumber = info.getMaterial().getNumber();
                String materialName = info.getMaterial().getName();
                String material = "";
                if (materialNumber != null) {
                    if (materialName != null) {
                        material = materialName;
                    }
                    material = material + "[" + materialNumber + "]";
                }
                msg = msg + "\uff0c\u7269\u6599\uff1a" + material;
                String bomNumber = info.getBom().getNumber();
                String bomName = info.getBom().getName();
                String bom = "";
                if (bomNumber != null) {
                    if (bomName != null) {
                        bom = bomName;
                    }
                    bom = bom + "[" + bomNumber + "]";
                }
                String storageNumber = info.getBom().getStorageOrgUnit().getNumber();
                String storageName = info.getBom().getStorageOrgUnit().getName();
                String storage = "";
                if (storageNumber != null) {
                    if (storageName != null) {
                        storage = storageName;
                    }
                    storage = storage + "[" + storageNumber + "]";
                }
                bom = bom + "\uff08" + storage + "\uff09";
                msg = msg + "\uff0cBOM\uff1a" + bom;
            }
            msg = msg + "\u3002";
            throw new BOSException(msg);
        }
    }
}

