/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.bill.ISTDPriceMaterial;
import com.kingdee.eas.ncm.order.std.bill.STDPriceMaterialCollection;
import com.kingdee.eas.ncm.order.std.bill.STDPriceMaterialFactory;
import com.kingdee.eas.ncm.order.std.bill.STDPriceMaterialInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class STDPriceMaterialDataImport
extends AbstractNCMDataImport {
    private Map costTypeMap = new HashMap();
    private Map materialMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDPriceMaterialFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDPriceMaterialInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("company.name", this.getNotBlankString(rs.getString("company.name")));
            result.put("costType.number", this.getNotBlankString(rs.getString("costType.number")));
            result.put("costType.name", this.getNotBlankString(rs.getString("costType.name")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("stdCost.standardCost", this.getNotBlankString(""));
            result.put("stdPrice", this.getNotBlankString(rs.getString("stdPrice")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    private STDPriceMaterialInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        STDPriceMaterialInfo info = new STDPriceMaterialInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompany(company);
        CostTypeInfo costType = null;
        String value = this.getStringValue(hsData, "costType.number");
        if (value != null) {
            costType = (CostTypeInfo)this.costTypeMap.get(value);
            if (costType == null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)value));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4), CompareType.EQUALS));
                view.setFilter(filter);
                CostTypeCollection coll = CostTypeFactory.getLocalInstance(ctx).getCostTypeCollection(view);
                if (coll.size() <= 0) {
                    throw new BOSException("\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7f16\u7801\u4e3a [" + value + "] \u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002");
                }
                costType = coll.get(0);
                this.costTypeMap.put(value, costType);
            }
        } else {
            throw new BOSException("\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        info.setCostType(costType);
        value = this.getStringValue(hsData, "material.number");
        MaterialInfo material = null;
        if (value != null) {
            FilterInfo filter;
            EntityViewInfo view;
            material = (MaterialInfo)this.materialMap.get(value);
            if (material == null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)value));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                view.setFilter(filter);
                MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
                if (coll.size() <= 0) {
                    throw new BOSException("\u7f16\u7801\u4e3a " + value + " \u7684\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u6216\u672a\u5ba1\u6838\u3002");
                }
                material = coll.get(0);
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)material.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("calculateType", (Object)new Integer(0)));
                MaterialCompanyInfoCollection mcColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
                if (mcColl.size() <= 0) {
                    throw new BOSException("\u7f16\u7801\u4e3a " + value + " \u7684\u7269\u6599\u4e0d\u662f\u5916\u8d2d\u7269\u6599\uff0c\u6216\u8d22\u52a1\u8d44\u6599\u672a\u5ba1\u6838\u3002");
                }
                this.materialMap.put(value, material);
                info.setStdCost(mcColl.get(0));
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)material.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("calculateType", (Object)new Integer(0)));
                MaterialCompanyInfoCollection mcColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
                info.setStdCost(mcColl.get(0));
            }
        } else {
            throw new BOSException("\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        info.setMaterial(material);
        value = this.getStringValue(hsData, "stdPrice");
        if (value != null) {
            BigDecimal bigValue = new BigDecimal(value);
            bigValue = bigValue.setScale(costType.getPricePrecision(), 4);
            info.setStdPrice(bigValue);
        } else {
            info.setStdPrice(new BigDecimal(0));
        }
        this.checkExists(ctx, info);
        return info;
    }

    private void checkExists(Context ctx, STDPriceMaterialInfo info) throws BOSException, EASBizException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costType.id", (Object)info.getCostType().getId().toString()));
        if (info.getMaterial() == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        STDPriceMaterialCollection coll = ((ISTDPriceMaterial)this.getController(ctx)).getSTDPriceMaterialCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                info.setId(coll.get(0).getId());
            } else {
                String msg = "\u6570\u636e\u91cd\u590d\uff01";
                String costTypeNumber = info.getCostType().getNumber();
                String costTypeName = info.getCostType().getName();
                String costType = "";
                if (costTypeNumber != null) {
                    if (costTypeName != null) {
                        costType = costTypeName;
                    }
                    costType = costType + "[" + costTypeNumber + "]";
                }
                String materialNumber = info.getMaterial().getNumber();
                String materialName = info.getMaterial().getName();
                String material = "";
                if (materialNumber != null) {
                    if (materialName != null) {
                        material = materialName;
                    }
                    material = material + "[" + materialNumber + "]";
                }
                msg = msg + "\u7269\u6599\uff1a" + material;
                msg = msg + "\u3002";
                throw new BOSException(msg);
            }
        }
    }
}

