/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.order.std.cal.IOSCostCheckItem;
import com.kingdee.eas.ncm.order.std.cal.IOSCostCheckResult;
import com.kingdee.eas.ncm.order.std.cal.IOSCostCheckResultDetail;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckItemCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckItemFactory;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckItemInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailFactory;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultFactory;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultInfo;
import com.kingdee.eas.ncm.order.std.cal.app.AbstractOSCostCheckItemControllerBean;
import com.kingdee.eas.ncm.order.std.cal.app.IOSCostChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.Assert;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OSCostCheckItemControllerBean
extends AbstractOSCostCheckItemControllerBean {
    private static final long serialVersionUID = 7775885477887832290L;
    private static Logger logger = Logger.getLogger((String)OSCostCheckItemControllerBean.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OSCostCheckItemInfo _checkCurrItem(Context ctx, OSCostCheckParam checkParam, OSCostCheckItemInfo currCheckItem) throws BOSException, EASBizException {
        Assert.that((checkParam != null && currCheckItem != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCostType() != null ? 1 : 0) != 0);
        OSCostCheckResultInfo result = new OSCostCheckResultInfo();
        result.setStartDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        LowTimer timer = new LowTimer();
        try {
            String checkerName = currCheckItem.getChecker();
            Class<?> checkerClass = Class.forName(checkerName);
            IOSCostChecker checker = (IOSCostChecker)checkerClass.newInstance();
            result = checker.calChecker(ctx, checkParam, result);
            currCheckItem.getCheckResult().clear();
            currCheckItem.getCheckResult().add(result);
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage());
            OSCostCheckResultDetailInfo detail = new OSCostCheckResultDetailInfo();
            detail.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"15_STDCostCheckItemControllerBean", (Locale)ctx.getLocale()));
            detail.setReason(exc.toString().length() > 200 ? exc.toString().substring(0, 199) : exc.toString());
            detail.setSuggestOperation("");
            result.getDetail().add(detail);
        }
        finally {
            result.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            result.setSpendTime(CalculateUtil.getcalcHMSString((int)((int)timer.msValue())));
        }
        OSCostCheckItemCollection costCheckItems = new OSCostCheckItemCollection();
        costCheckItems.add(currCheckItem);
        this.saveCheckResult(ctx, checkParam, costCheckItems);
        return currCheckItem;
    }

    @Override
    protected OSCostCheckItemCollection _checkAllItems(Context ctx, OSCostCheckParam checkParam) throws BOSException, EASBizException {
        IOSCostCheckItem iOSCheckItem = OSCostCheckItemFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("seq");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        OSCostCheckItemCollection checkItems = iOSCheckItem.getOSCostCheckItemCollection(view);
        int size = checkItems.size();
        for (int i = 0; i < size; ++i) {
            OSCostCheckItemInfo costCheckItem = checkItems.get(i);
            costCheckItem = this._checkCurrItem(ctx, checkParam, costCheckItem);
            checkItems.set(i, costCheckItem);
        }
        this.saveCheckResult(ctx, checkParam, checkItems);
        return checkItems;
    }

    private void saveCheckResult(Context ctx, OSCostCheckParam checkParam, OSCostCheckItemCollection checkItems) throws BOSException, EASBizException {
        Assert.that((checkParam != null && checkItems != null && checkItems.size() > 0 ? 1 : 0) != 0);
        Assert.that((checkParam.getCostType() != null ? 1 : 0) != 0);
        String costTypeId = checkParam.getCostType().getId().toString();
        OSCostCheckItemInfo checkItemInfo = null;
        OSCostCheckResultCollection checkResultCol = null;
        OSCostCheckResultInfo checkResultInfo = null;
        OSCostCheckResultDetailCollection checkResultDetailCol = null;
        OSCostCheckResultDetailInfo checkResultDetailInfo = null;
        String checkResulstID = null;
        String checkResultDetailID = null;
        Connection conn = null;
        PreparedStatement insertRstSta = null;
        PreparedStatement insertRstDetailSta = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer deleteResDetailKSql = new StringBuffer();
            deleteResDetailKSql.append(" DELETE FROM T_NCM_OSCostCheckResultDetail \n");
            deleteResDetailKSql.append("       WHERE FParentID IN (SELECT FID \n");
            deleteResDetailKSql.append("                       \t\t FROM T_NCM_OSCostCheckResult \n");
            deleteResDetailKSql.append("                      \t    WHERE FCostTypeID = ? \n");
            deleteResDetailKSql.append("                              AND FParentID = ? ) \n");
            StringBuffer insertResKSql = new StringBuffer();
            insertResKSql.append(" INSERT INTO T_NCM_OSCostCheckResult \n");
            insertResKSql.append(" \t\t      (FID, \n");
            insertResKSql.append("   \t\t   FParentID, \n");
            insertResKSql.append("             FCostTypeID, \n");
            insertResKSql.append("             FCheckStatus, \n");
            insertResKSql.append("             FStartDateTime, \n");
            insertResKSql.append("             FEndDateTime , \n");
            insertResKSql.append("             FSpendTime) \n");
            insertResKSql.append(" VALUES (?,?,?,?,?,?,?) \n");
            insertRstSta = conn.prepareStatement(insertResKSql.toString());
            StringBuffer insertResDetailKSql = new StringBuffer();
            insertResDetailKSql.append(" INSERT INTO T_NCM_OSCostCheckResultDetail \n");
            insertResDetailKSql.append("            (FID, \n");
            insertResDetailKSql.append("             FParentID, \n");
            insertResDetailKSql.append("             FDescription, \n");
            insertResDetailKSql.append("             FReason, \n");
            insertResDetailKSql.append("             FSuggestOperation )\n");
            insertResDetailKSql.append(" VALUES (?,?,?,?,?) \n");
            insertRstDetailSta = conn.prepareStatement(insertResDetailKSql.toString());
            boolean runUpdate = false;
            int i_size = checkItems.size();
            for (int i = 0; i < i_size; ++i) {
                checkItemInfo = checkItems.get(i);
                String checkItemID = checkItemInfo.getId().toString();
                DbUtil.execute((Context)ctx, (String)deleteResDetailKSql.toString(), (Object[])new String[]{costTypeId, checkItemID});
                DbUtil.execute((Context)ctx, (String)" DELETE FROM T_NCM_OSCostCheckResult WHERE FCostTypeID = ? AND  FParentID = ?", (Object[])new String[]{costTypeId, checkItemID});
                checkResultCol = checkItemInfo.getCheckResult();
                int j_size = checkResultCol.size();
                for (int j = 0; j < j_size; ++j) {
                    checkResultInfo = checkResultCol.get(j);
                    checkResulstID = BOSUuid.create((String)"32D3C2E1").toString();
                    insertRstSta.setString(1, checkResulstID);
                    insertRstSta.setString(2, checkItemID);
                    insertRstSta.setString(3, costTypeId);
                    insertRstSta.setString(4, checkResultInfo.getCheckStatus().getValue());
                    insertRstSta.setTimestamp(5, checkResultInfo.getStartDateTime());
                    insertRstSta.setTimestamp(6, checkResultInfo.getEndDateTime());
                    insertRstSta.setString(7, checkResultInfo.getSpendTime());
                    insertRstSta.execute();
                    checkResultDetailCol = checkResultInfo.getDetail();
                    int k_size = checkResultDetailCol.size();
                    for (int k = 0; k < k_size; ++k) {
                        checkResultDetailInfo = checkResultDetailCol.get(k);
                        checkResultDetailID = BOSUuid.create((String)"75B96239").toString();
                        insertRstDetailSta.setString(1, checkResultDetailID);
                        insertRstDetailSta.setString(2, checkResulstID);
                        insertRstDetailSta.setString(3, checkResultDetailInfo.getDescription());
                        insertRstDetailSta.setString(4, checkResultDetailInfo.getReason());
                        insertRstDetailSta.setString(5, checkResultDetailInfo.getSuggestOperation());
                        insertRstDetailSta.addBatch();
                        runUpdate = true;
                    }
                }
            }
            if (runUpdate) {
                insertRstDetailSta.executeBatch();
            }
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertRstSta);
                SQLUtils.cleanup(insertRstDetailSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertRstSta);
        SQLUtils.cleanup((Statement)insertRstDetailSta);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected OSCostCheckItemCollection _getResults(Context ctx, String costTypeId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("seq");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        OSCostCheckItemCollection checkItemCol = this.getOSCostCheckItemCollection(ctx, view);
        IOSCostCheckResult iOSCostCheckResult = OSCostCheckResultFactory.getLocalInstance(ctx);
        IOSCostCheckResultDetail iOSCostCheckResultDetail = OSCostCheckResultDetailFactory.getLocalInstance(ctx);
        int size = checkItemCol.size();
        for (int i = 0; i < size; ++i) {
            OSCostCheckItemInfo checkItem = checkItemCol.get(i);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("costType.id", (Object)costTypeId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)checkItem.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("checkResult.*"));
            viewInfo.setSelector(sic);
            OSCostCheckResultCollection checkResultCol = iOSCostCheckResult.getOSCostCheckResultCollection(viewInfo);
            for (int j = 0; j < checkResultCol.size(); ++j) {
                OSCostCheckResultInfo resultInfo = checkResultCol.get(j);
                EntityViewInfo _viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)resultInfo.getId().toString(), CompareType.EQUALS));
                _viewInfo.setFilter(filterInfo);
                OSCostCheckResultDetailCollection rstDetailCol = null;
                try {
                    rstDetailCol = iOSCostCheckResultDetail.getOSCostCheckResultDetailCollection(_viewInfo);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
                if (rstDetailCol == null) continue;
                resultInfo.getDetail().addCollection(rstDetailCol);
            }
            checkItem.getCheckResult().addCollection(checkResultCol);
        }
        return checkItemCol;
    }
}

