/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.order.std.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultInfo;
import com.kingdee.eas.ncm.order.std.cal.app.IOSCostChecker;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import org.apache.log4j.Logger;

public class OSActivityPriceChecker
implements IOSCostChecker {
    private static Logger logger = Logger.getLogger((String)OSActivityPriceChecker.class.getName());

    @Override
    public OSCostCheckResultInfo calChecker(Context ctx, OSCostCheckParam checkParam, OSCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam.getCostType() != null ? 1 : 0) != 0);
        String costTypeId = checkParam.getCostType().getId().toString();
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        costCheckResultInfo.getDetail().addCollection(new OSCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select act.FNumber as activityNumber, \n");
        kSql.append("        act.FName_" + ctx.getLocale() + " as activityName \n");
        kSql.append("   from (select distinct FActivityChainID, \n");
        kSql.append("                         FCostTypeID \n");
        kSql.append("           from T_NCM_OSBomActivitySetting \n");
        kSql.append("          where FCostTypeID = ? \n");
        kSql.append("            and FIsCal = 1 \n");
        kSql.append("            and FActivityChainID is not null \n");
        kSql.append("         ) setting \n");
        kSql.append("         inner join T_NCM_ActivityChainEntry chainEntry  \n");
        kSql.append("           on setting.FActivityChainID = chainEntry.FParentID \n");
        kSql.append("         inner join T_NCM_Activity act  \n");
        kSql.append("           on chainEntry.FActivityID = act.FID \n");
        kSql.append("         left outer join T_NCM_OSActivityStdPrice actPrice  \n");
        kSql.append("           on actPrice.FCostTypeID = setting.FCostTypeID \n");
        kSql.append("              and actPrice.FActivityID = act.FID \n");
        kSql.append("   where actPrice.FStdPrice is null or actPrice.FStdPrice = 0 \n");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new String[]{costTypeId});
        try {
            while (rst.next()) {
                String activityNumber = rst.getString("activityNumber");
                String activityName = rst.getString("activityName");
                String costObjectName = activityNumber + " " + activityName;
                String description = "\u6ca1\u6709\u627e\u5230\u4f5c\u4e1a\u3010" + costObjectName + "\u3011\u7684\u7efc\u5408\u8d39\u7387";
                String reason = "\u6ca1\u6709\u8bbe\u7f6e\u4f5c\u4e1a\u3010" + costObjectName + "\u3011\u7684\u7efc\u5408\u8d39\u7387";
                String suggestOperation = "\u8bf7\u5728\u3010\u529f\u80fd\u83dc\u5355-\u7ba1\u7406\u4f1a\u8ba1-\u6210\u672c\u7ba1\u7406-\u8ba2\u5355\u6210\u672c-\u6807\u51c6\u6210\u672c\u6570\u636e\u7ef4\u62a4-\u4f5c\u4e1a\u6807\u51c6\u8d39\u7387\u8bbe\u7f6e\u3011\u91cc\u8bbe\u7f6e";
                OSCostCheckResultDetailInfo detail = new OSCostCheckResultDetailInfo();
                detail.setDescription(description);
                detail.setReason(reason);
                detail.setSuggestOperation(suggestOperation);
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        return costCheckResultInfo;
    }
}

