/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultInfo;
import com.kingdee.eas.ncm.order.std.cal.app.IOSCostChecker;
import com.kingdee.eas.ncm.order.std.cal.app.checker.MFGBomSpreader;
import com.kingdee.eas.ncm.order.std.cal.app.checker.OrderBomSpreader;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OSBomActivityChainChecker
implements IOSCostChecker {
    private static Logger logger = Logger.getLogger((String)OSBomActivityChainChecker.class.getName());

    @Override
    public OSCostCheckResultInfo calChecker(Context ctx, OSCostCheckParam checkParam, OSCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam.getCostType() != null ? 1 : 0) != 0);
        String costTypeId = checkParam.getCostType().getId().toString();
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        costCheckResultInfo.getDetail().addCollection(new OSCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" select ct.FLevel    as FLevel, \n");
        kSql.append("        mo.FNumber   as orderNumber, \n");
        kSql.append("        mat.FID      as matFID, \n");
        kSql.append("        mat.FNumber  as matNumber, \n");
        kSql.append("        mat.FName_" + ctx.getLocale() + " as matName, \n");
        kSql.append("        bom.FID      as bomID, \n");
        kSql.append("        act.FID      as activityChainID \n");
        kSql.append("   from T_NCM_OSBomActivitySetting setting \n");
        kSql.append("        inner join T_NCM_CostType ct  \n");
        kSql.append("          on setting.FCostTypeID = ct.FID \n");
        kSql.append("        left outer join T_MM_ManufactureOrder mo  \n");
        kSql.append("          on setting.FOrderID = mo.FID \n");
        kSql.append("        left outer join T_BD_Material mat  \n");
        kSql.append("          on setting.FMaterialID = mat.FID \n");
        kSql.append("        left outer join T_MM_Bom bom  \n");
        kSql.append("          on setting.FBomID = bom.FID \n");
        kSql.append("            and bom.FBaseStatus = 4  \n");
        kSql.append("        left outer join T_NCM_ActivityChain act  \n");
        kSql.append("          on setting.FActivityChainID = act.FID \n");
        kSql.append("            and act.FStatus = 4 \n");
        kSql.append("  where setting.FCostTypeID = ? \n");
        kSql.append("    and setting.FIsCal = 1 \n");
        kSql.append("    and (bom.FID is null or act.FID is null) \n");
        HashMap matDump = new HashMap();
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new String[]{costTypeId});
        try {
            while (rst.next()) {
                OSCostCheckResultDetailInfo detail;
                String orderNumber = rst.getString("orderNumber");
                String materialId = rst.getString("matFID");
                matDump.put(materialId, null);
                String materialNumber = rst.getString("matNumber");
                String materialName = rst.getString("matName");
                String bomId = rst.getString("bomID");
                String activityChainId = rst.getString("activityChainID");
                String costObjectName = "";
                int level = rst.getInt("FLevel");
                costObjectName = level == 6 ? orderNumber : materialNumber + " " + materialName;
                String description = "";
                String reason = "";
                String suggestOperation = "\u8bf7\u5728\u3010\u529f\u80fd\u83dc\u5355-\u7ba1\u7406\u4f1a\u8ba1-\u6210\u672c\u7ba1\u7406-\u8ba2\u5355\u6210\u672c-\u6807\u51c6\u6210\u672c\u6570\u636e\u7ef4\u62a4-\u6210\u672cBOM\u548c\u4f5c\u4e1a\u94fe\u8bbe\u7f6e\u3011\u91cc\u8bbe\u7f6e";
                if (bomId == null) {
                    description = "\u6ca1\u6709\u627e\u5230\u3010" + costObjectName + "\u3011\u7684BOM";
                    reason = "\u6ca1\u6709\u6307\u5b9a\u3010" + costObjectName + "\u3011\u7684BOM";
                    detail = new OSCostCheckResultDetailInfo();
                    detail.setDescription(description);
                    detail.setReason(reason);
                    detail.setSuggestOperation(suggestOperation);
                    costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                    costCheckResultInfo.getDetail().add(detail);
                }
                if (activityChainId != null) continue;
                description = "\u6ca1\u6709\u627e\u5230\u3010" + costObjectName + "\u3011\u7684\u4f5c\u4e1a\u94fe";
                reason = "\u6ca1\u6709\u6307\u5b9a\u3010" + costObjectName + "\u3011\u7684\u4f5c\u4e1a\u94fe";
                detail = new OSCostCheckResultDetailInfo();
                detail.setDescription(description);
                detail.setReason(reason);
                detail.setSuggestOperation(suggestOperation);
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
            CostTypeLevelEnum level = checkParam.getCostType().getLevel();
            String companyId = checkParam.getCompanyId();
            String T_NCM_OSBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSBomPath");
            DbUtil.execute((Context)ctx, (String)(" delete from " + T_NCM_OSBomPath));
            if (CostTypeLevelEnum.product.equals((Object)level)) {
                MFGBomSpreader mfgBomSpreader = new MFGBomSpreader(ctx, T_NCM_OSBomPath, costTypeId);
                mfgBomSpreader.spreadBom();
            } else {
                OrderBomSpreader orderBomSpreader = new OrderBomSpreader(ctx, T_NCM_OSBomPath, costTypeId);
                orderBomSpreader.spreadBom();
            }
            kSql.setLength(0);
            kSql.append(" select distinct " + checkParam.getCostType().getLevel().getValue() + " as FLevel,\n");
            kSql.append("                 mo.FNumber   as orderNumber, \n");
            kSql.append("                 cMat.FID     as matFID, \n");
            kSql.append("                 cMat.FNumber  as matNumber, \n");
            kSql.append("                 cMat.FName_" + ctx.getLocale() + " as matName \n");
            kSql.append("   from " + T_NCM_OSBomPath + " bomPath \n");
            kSql.append("        inner join T_BD_Material cMat  \n");
            kSql.append("          on bomPath.FMaterialID = cMat.FID \n");
            kSql.append("        inner join T_BD_MaterialCompanyinfo fi  \n");
            kSql.append("          on fi.FMaterialID = cMat.FID \n");
            kSql.append("           and fi.FCalculateType = 2 \n");
            kSql.append("        left outer join T_MM_ManufactureOrder mo  \n");
            kSql.append("          on bomPath.FOrderID = mo.FID \n");
            kSql.append("  where bomPath.FMaterialID not in \n");
            kSql.append("        (select FParentMaterialID \n");
            kSql.append("           from " + T_NCM_OSBomPath + " \n");
            kSql.append("          where FBomID is not null) \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            while (rst.next()) {
                String materialId = rst.getString("matFID");
                if (matDump.containsKey(materialId)) continue;
                String orderNumber = rst.getString("orderNumber");
                String materialNumber = rst.getString("matNumber");
                String materialName = rst.getString("matName");
                String costObjectName = "";
                int _level = rst.getInt("FLevel");
                costObjectName = _level == 6 ? orderNumber + " " + materialName : materialNumber + " " + materialName;
                String description = "";
                String reason = "";
                String suggestOperation = "\u8bf7\u5728\u3010\u529f\u80fd\u83dc\u5355-\u7ba1\u7406\u4f1a\u8ba1-\u6210\u672c\u7ba1\u7406-\u8ba2\u5355\u6210\u672c-\u6807\u51c6\u6210\u672c\u6570\u636e\u7ef4\u62a4-\u6210\u672cBOM\u548c\u4f5c\u4e1a\u94fe\u8bbe\u7f6e\u3011\u91cc\u8bbe\u7f6e";
                description = "\u6ca1\u6709\u627e\u5230\u3010" + costObjectName + "\u3011\u7684BOM";
                reason = "\u6ca1\u6709\u6307\u5b9a\u3010" + costObjectName + "\u3011\u7684BOM";
                OSCostCheckResultDetailInfo detail = new OSCostCheckResultDetailInfo();
                detail.setDescription(description);
                detail.setReason(reason);
                detail.setSuggestOperation(suggestOperation);
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        return costCheckResultInfo;
    }
}

