/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.std.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultInfo;
import com.kingdee.eas.ncm.order.std.cal.app.IOSCostChecker;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class OSMaterialPriceChecker
implements IOSCostChecker {
    private static Logger logger = Logger.getLogger((String)OSMaterialPriceChecker.class.getName());

    @Override
    public OSCostCheckResultInfo calChecker(Context ctx, OSCostCheckParam checkParam, OSCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCostType() != null ? 1 : 0) != 0);
        Assert.that((costCheckResultInfo != null ? 1 : 0) != 0);
        String costTypeId = checkParam.getCostType().getId().toString();
        String companyId = checkParam.getCompanyId();
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        costCheckResultInfo.getDetail().addCollection(new OSCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        IRowSet rst = null;
        try {
            String T_NCM_OSBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSBomPath");
            kSql.setLength(0);
            kSql.append("  select top 1000 mat.FNumber as FMaterialNumber, \n");
            kSql.append("                  mat.FName_" + ctx.getLocale() + " as FMaterialName \n");
            kSql.append("    from (select distinct bomPath.FMaterialID as FMaterialID \n");
            kSql.append("            from " + T_NCM_OSBomPath + " bomPath \n");
            kSql.append("         ) bomMat  \n");
            kSql.append("        inner join T_BD_Material mat \n");
            kSql.append("          on bomMat.FMaterialID = mat.FID \n");
            kSql.append("        inner join T_BD_MaterialCompanyInfo fi \n");
            kSql.append("          on mat.FID = fi.FMaterialID   \n");
            kSql.append("            and fi.FCalculateType = 0 \n");
            kSql.append("            and fi.FCompanyID = '" + companyId + "' \n");
            kSql.append("        left outer join T_NCM_STDPriceMaterial stdPrice   \n");
            kSql.append("          on stdPrice.FMaterialID = bomMat.FMaterialID  \n");
            kSql.append("            and stdPrice.FCostTypeID = ?  \n");
            kSql.append("   where stdPrice.FID is null   \n");
            kSql.append("      or stdPrice.FStdPrice is null  \n");
            kSql.append("      or stdPrice.FStdPrice = 0  \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new String[]{costTypeId});
            while (rst.next()) {
                String matNumber = rst.getString("FMaterialNumber");
                String matName = rst.getString("FMaterialName");
                String costObjectName = matNumber + " " + matName;
                String description = "\u6ca1\u6709\u627e\u5230\u7269\u6599\u3010" + costObjectName + "\u3011\u7684\u6210\u672c";
                String reason = "\u6ca1\u6709\u8bbe\u7f6e\u7269\u6599\u3010" + costObjectName + "\u3011\u7684\u6807\u51c6\u6210\u672c";
                String suggestOperation = "\u8bf7\u5728\u3010\u529f\u80fd\u83dc\u5355-\u7ba1\u7406\u4f1a\u8ba1-\u6210\u672c\u7ba1\u7406-\u8ba2\u5355\u6210\u672c-\u6807\u51c6\u6210\u672c\u6570\u636e\u7ef4\u62a4-\u7269\u6599\u6807\u51c6\u5355\u4ef7\u7ef4\u62a4\u3011\u91cc\u8bbe\u7f6e";
                OSCostCheckResultDetailInfo detail = new OSCostCheckResultDetailInfo();
                detail.setDescription(description);
                detail.setReason(reason);
                detail.setSuggestOperation(suggestOperation);
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return costCheckResultInfo;
    }
}

