/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OCCostTypeDiffReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger(OCCostTypeDiffReport.class);

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        IRowSet costItemsRowSet;
        Connection conn;
        String TEMP_OSCTotalRptColumn;
        block25: {
            CompanyOrgUnitInfo company = null;
            if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
                company = (CompanyOrgUnitInfo)filter.getObject("company");
            }
            CostTypeInfo costTypeInfoFrom = null;
            if (filter.getObject("costTypeFrom") instanceof CostTypeInfo && (costTypeInfoFrom = (CostTypeInfo)filter.getObject("costTypeFrom")).getLevel() == null) {
                try {
                    costTypeInfoFrom = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfoFrom.getId().toString()));
                }
                catch (Exception exc) {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                }
            }
            CostTypeInfo costTypeInfoTo = null;
            if (filter.getObject("costTypeTo") instanceof CostTypeInfo && (costTypeInfoTo = (CostTypeInfo)filter.getObject("costTypeTo")).getLevel() == null) {
                try {
                    costTypeInfoTo = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfoTo.getId().toString()));
                }
                catch (Exception exc) {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                }
            }
            Assert.that((company != null ? 1 : 0) != 0);
            Assert.that((costTypeInfoFrom != null ? 1 : 0) != 0);
            Assert.that((costTypeInfoTo != null ? 1 : 0) != 0);
            String companyId = String.valueOf(company.getId());
            Locale loc = this.getContext().getLocale();
            String T_NCM_OSMaterialDetail = null;
            String T_NCM_OSActivityDetail = null;
            String TEMP_OSCTotalRptRow = null;
            TEMP_OSCTotalRptColumn = null;
            StringBuffer kSql = new StringBuffer(500);
            conn = null;
            costItemsRowSet = null;
            try {
                T_NCM_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSMaterialDetail");
                T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSActivityDetail");
                costItemsRowSet = this.getCostItemsRowSet(filter, costTypeInfoFrom, T_NCM_OSMaterialDetail, T_NCM_OSActivityDetail, costTypeInfoTo);
                TEMP_OSCTotalRptRow = this.createTEMP_OSCTotalRptRow(T_NCM_OSMaterialDetail, T_NCM_OSActivityDetail, filter, companyId, costTypeInfoFrom, costTypeInfoTo);
                StringBuffer defineColumns = this.getDefineColumns(costItemsRowSet);
                kSql.setLength(0);
                kSql.append(" create table TEMP_OSCTotalRptColumn( \n");
                kSql.append("    orderID       varchar(44), \n");
                kSql.append("    orderNumber   nvarchar(255), \n");
                kSql.append("    matID         varchar(44), \n");
                kSql.append("    matNumber     nvarchar(255), \n");
                kSql.append("    matName       nvarchar(255), \n");
                kSql.append("    matDesc       nvarchar(255), \n");
                kSql.append("    matModel      nvarchar(255), \n");
                kSql.append("    projectID     varchar(44), \n");
                kSql.append("    projectNumber nvarchar(255), \n");
                kSql.append("    trackID       varchar(44), \n");
                kSql.append("    trackNumber   nvarchar(255), \n");
                kSql.append("    muName        nvarchar(255), \n");
                kSql.append(defineColumns);
                kSql.append("    FCostType1StdPrice Decimal(21,8) Default(0), \n");
                kSql.append("    FCostType2StdPrice Decimal(21,8) Default(0), \n");
                kSql.append("    FStdPriceDifference Decimal(21,8) Default(0) \n");
                kSql.append("  )\n ");
                TEMP_OSCTotalRptColumn = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TEMP_OSCTotalRptColumn, "matID", false, false);
                kSql.setLength(0);
                kSql.append(" insert into " + TEMP_OSCTotalRptColumn + " \n");
                kSql.append("   (orderID, \n");
                kSql.append("    orderNumber, \n");
                kSql.append("    matID, \n");
                kSql.append("    matNumber, \n");
                kSql.append("    matName, \n");
                kSql.append("    matDesc, \n");
                kSql.append("    matModel, \n");
                kSql.append("    muName, \n");
                kSql.append("    projectID, \n");
                kSql.append("    projectNumber, \n");
                kSql.append("    trackID, \n");
                kSql.append("    trackNumber) \n");
                kSql.append("   select  distinct a.orderid         as   orderID, \n");
                kSql.append("           a.ordernumber              as   orderNumber, \n");
                kSql.append("           b.fid                      as   matID, \n");
                kSql.append("           b.fnumber                  as   matNumber, \n");
                kSql.append("           b.fname_" + loc + "        as   matName, \n");
                kSql.append("           b.fdescription_" + loc + " as   matDesc, \n");
                kSql.append("           b.fmodel                   as   matModel, \n");
                kSql.append("           c.fname_" + loc + "        as   muName, \n");
                kSql.append("           e.fid                      as   projectID, \n");
                kSql.append("           e.fnumber                  as   projectNumber, \n");
                kSql.append("           f.fid                      as   trackID, \n");
                kSql.append("           f.fnumber                  as   trackNumber \n");
                kSql.append("     from " + TEMP_OSCTotalRptRow + " a \n");
                kSql.append("       inner join  T_BD_Material b  \n");
                kSql.append("         on a.matid = b.FID \n ");
                kSql.append("       left outer join T_BD_MeasureUnit c \n");
                kSql.append("         on b.fbaseunit = c.FID \n ");
                kSql.append("       left outer join t_mm_manufactureorder d \n");
                kSql.append("         on a.orderid = d.FID \n ");
                kSql.append("       left outer join t_mm_project e \n");
                kSql.append("         on d.fprojectid = e.FID \n ");
                kSql.append("       left outer join t_mm_tracknumber f \n");
                kSql.append("         on d.ftrackid = f.FID \n ");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TEMP_OSCTotalRptColumn);
                costItemsRowSet.first();
                costItemsRowSet.previous();
                int i = 0;
                while (costItemsRowSet.next()) {
                    String ciId = costItemsRowSet.getString("ciID");
                    String ciAmountColumn1 = "FCostTypeOne" + Integer.toString(i);
                    this.updateCostTypeByCostItem(TEMP_OSCTotalRptColumn, ciAmountColumn1, TEMP_OSCTotalRptRow, ciId, costTypeInfoFrom == null ? "null" : costTypeInfoFrom.getId().toString());
                    String ciAmountColumn2 = "FCostTypeTwo" + Integer.toString(i);
                    this.updateCostTypeByCostItem(TEMP_OSCTotalRptColumn, ciAmountColumn2, TEMP_OSCTotalRptRow, ciId, costTypeInfoTo == null ? "null" : costTypeInfoTo.getId().toString());
                    String ciAmountColumn3 = "FDifference" + Integer.toString(i);
                    kSql.setLength(0);
                    kSql.append(" update " + TEMP_OSCTotalRptColumn + " \n");
                    kSql.append("    set " + ciAmountColumn3 + " = ");
                    kSql.append("isnull(").append(ciAmountColumn1).append(", 0) - ");
                    kSql.append("isnull(").append(ciAmountColumn2).append(", 0)");
                    DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                    ++i;
                }
                this.updateTotalCostType(TEMP_OSCTotalRptColumn, "FCostType1StdPrice", TEMP_OSCTotalRptRow, costTypeInfoFrom == null ? "null" : costTypeInfoFrom.getId().toString());
                this.updateTotalCostType(TEMP_OSCTotalRptColumn, "FCostType2StdPrice", TEMP_OSCTotalRptRow, costTypeInfoTo == null ? "null" : costTypeInfoTo.getId().toString());
                kSql.setLength(0);
                kSql.append(" update " + TEMP_OSCTotalRptColumn + " \n");
                kSql.append("    set FStdPriceDifference = isnull(FCostType1StdPrice, 0)");
                kSql.append(" - isnull(FCostType2StdPrice, 0) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                if (TEMP_OSCTotalRptRow == null) break block25;
            }
            catch (Exception exc) {
                try {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                }
                catch (Throwable throwable) {
                    if (TEMP_OSCTotalRptRow != null) {
                        try {
                            TempTablePool.getInstance((Context)this.getContext()).releaseTable(TEMP_OSCTotalRptRow);
                        }
                        catch (Throwable exc2) {
                            logger.error((Object)exc2.getMessage(), exc2);
                        }
                    }
                    try {
                        SQLUtils.cleanup(costItemsRowSet);
                    }
                    catch (Throwable exc3) {
                        logger.error((Object)exc3.getMessage(), exc3);
                    }
                    try {
                        SQLUtils.cleanup(conn);
                        throw throwable;
                    }
                    catch (Throwable exc4) {
                        logger.error((Object)exc4.getMessage(), exc4);
                    }
                    throw throwable;
                }
            }
            try {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(TEMP_OSCTotalRptRow);
            }
            catch (Throwable exc) {
                logger.error((Object)exc.getMessage(), exc);
            }
        }
        try {
            SQLUtils.cleanup((ResultSet)costItemsRowSet);
        }
        catch (Throwable exc) {
            logger.error((Object)exc.getMessage(), exc);
        }
        try {
            SQLUtils.cleanup(conn);
            return TEMP_OSCTotalRptColumn;
        }
        catch (Throwable exc) {
            logger.error((Object)exc.getMessage(), exc);
            return TEMP_OSCTotalRptColumn;
        }
    }

    private String createTEMP_OSCTotalRptRow(String materialDetailTable, String activityDetailTable, RptParams filter, String companyId, CostTypeInfo costTypeInfoFrom, CostTypeInfo costTypeInfoTo) throws BOSException {
        Locale loc = this.getContext().getLocale();
        StringBuffer kSql = new StringBuffer(500);
        kSql.setLength(0);
        kSql.append(" create table TEMP_OSCTotalRptRow ( \n");
        kSql.append("    orderID       varchar(44), \n");
        kSql.append("    orderNumber   nvarchar(255), \n");
        kSql.append("    matID         varchar(44), \n");
        kSql.append("    matNumber     nvarchar(255), \n");
        kSql.append("    matName       nvarchar(255), \n");
        kSql.append("    projectID     varchar(44), \n");
        kSql.append("    projectNumber nvarchar(255), \n");
        kSql.append("    trackID       varchar(44), \n");
        kSql.append("    trackNumber   nvarchar(255), \n");
        kSql.append("    costTypeID    varchar(44), \n");
        kSql.append("    ciID          varchar(44), \n");
        kSql.append("    ciNumber      nvarchar(255), \n");
        kSql.append("    ciName        nvarchar(255), \n");
        kSql.append("    ciType        int, \n");
        kSql.append("    childAmount   decimal(21,8) default(0) \n ");
        kSql.append("  )\n ");
        String temp_OSCTotalRptRow = null;
        try {
            temp_OSCTotalRptRow = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(temp_OSCTotalRptRow, "matID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(temp_OSCTotalRptRow, "ciID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        kSql.setLength(0);
        kSql.append(" insert into " + temp_OSCTotalRptRow + " ( \n");
        kSql.append("        orderID, \n");
        kSql.append("        orderNumber, \n");
        kSql.append("        matID, \n");
        kSql.append("        matNumber, \n");
        kSql.append("        matName, \n");
        kSql.append("        projectID, \n");
        kSql.append("        projectNumber, \n");
        kSql.append("        trackID, \n");
        kSql.append("        trackNumber, \n");
        kSql.append("        costTypeID, \n");
        kSql.append("        ciID, \n");
        kSql.append("        ciNumber, \n");
        kSql.append("        ciType, \n");
        kSql.append("        ciName, \n");
        kSql.append("        childAmount) \n");
        kSql.append(" select orderID, \n");
        kSql.append("        orderNumber, \n");
        kSql.append("        matID, \n");
        kSql.append("        matNumber, \n");
        kSql.append("        matName, \n");
        kSql.append("        projectID, \n");
        kSql.append("        projectNumber, \n");
        kSql.append("        trackID, \n");
        kSql.append("        trackNumber, \n");
        kSql.append("        costTypeID, \n");
        kSql.append("        ciID, \n");
        kSql.append("        ciNumber, \n");
        kSql.append("        ciType, \n");
        kSql.append("        ciName, \n");
        kSql.append("        childAmount \n");
        kSql.append("   from (select mOrder.FID             as orderID, \n");
        kSql.append("                mOrder.FNumber         as orderNumber, \n");
        kSql.append("                pMat.FID               as matID, \n");
        kSql.append("                pMat.FNumber           as matNumber, \n");
        kSql.append("                pMat.FName_" + loc + " as matName, \n");
        kSql.append("                project.FID            as projectID, \n");
        kSql.append("                project.FNumber        as projectNumber, \n");
        kSql.append("                trackNum.FID           as trackID, \n");
        kSql.append("                trackNum.FNumber       as trackNumber, \n");
        kSql.append("                matDetail.FCostTypeID  as costTypeID, \n");
        kSql.append("                matDetail.FCompanyID   as companyID, \n");
        kSql.append("                ci.FID                 as ciID, \n");
        kSql.append("                ci.FNumber             as ciNumber, \n");
        kSql.append("                ci.FName_" + loc + "   as ciName, \n");
        kSql.append("                ci.FItemType           as ciType, \n");
        kSql.append("                matDetail.FChildAMount as childAmount \n");
        kSql.append("           from " + materialDetailTable + " matDetail \n");
        kSql.append("                inner join T_BD_Material pMat  \n");
        kSql.append("                  on matDetail.FParentMaterialID = pMat.FID \n");
        if (CostTypeLevelEnum.product.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
        }
        kSql.append("                left outer join T_NCM_CostItem ci  \n");
        kSql.append("                  on matDetail.FChildCostItemID = ci.FID \n");
        kSql.append("                left outer join T_MM_ManufactureOrder mOrder  \n");
        kSql.append("                  on matDetail.FOrderID = mOrder.FID \n");
        kSql.append("                left outer join T_MM_Project project  \n");
        kSql.append("                  on matDetail.FProjectID = project.FID \n");
        kSql.append("                left outer join T_MM_TrackNumber trackNum  \n");
        kSql.append("                  on matDetail.FTrackID = trackNum.FID \n");
        kSql.append("          where (matDetail.FCostTypeID = '" + costTypeInfoFrom.getId().toString() + "' \n");
        kSql.append("                or matDetail.FCostTypeID = '" + costTypeInfoTo.getId().toString() + "') \n");
        kSql.append("            and CHARINDEX(pMat.FNumber || ',' ,matDetail.FSpreadPath) = 1 \n");
        if (CostTypeLevelEnum.order.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append("            and  mOrder.fbasestatus in (4,5,6,7,8,90,10,11) \n");
        }
        kSql.append("         union all \n");
        kSql.append("         select mOrder.FID              as orderID, \n");
        kSql.append("                mOrder.FNumber          as orderNumber, \n");
        kSql.append("                pMat.FID                as matID, \n");
        kSql.append("                pMat.FNumber            as matNumber, \n");
        kSql.append("                pMat.FName_" + loc + "  as matName, \n");
        kSql.append("                project.FID          as projectID, \n");
        kSql.append("                project.FNumber      as projectNumber, \n");
        kSql.append("                trackNum.FID         as trackID, \n");
        kSql.append("                trackNum.FNumber     as trackNumber, \n");
        kSql.append("                actDetail.FCostTypeID   as costTypeID, \n");
        kSql.append("                actDetail.FCompanyID    as companyID, \n");
        kSql.append("                ci.FID                  as ciID, \n");
        kSql.append("                ci.FNumber              as ciNumber, \n");
        kSql.append("                ci.FName_" + loc + "    as ciName, \n");
        kSql.append("                ci.FItemType            as ciType, \n");
        kSql.append("                actDetail.FActAmount    as childAmount \n");
        kSql.append("           from " + activityDetailTable + " actDetail \n");
        kSql.append("                inner join T_BD_Material pMat  \n");
        kSql.append("                  on actDetail.FParentMaterialID = pMat.FID \n");
        if (CostTypeLevelEnum.product.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
        }
        kSql.append("                left outer join T_NCM_CostItem ci  \n");
        kSql.append("                  on actDetail.FActCostItemID = ci.FID \n");
        kSql.append("                left outer join T_MM_ManufactureOrder mOrder  \n");
        kSql.append("                  on actDetail.FOrderID = mOrder.FID \n");
        kSql.append("                left outer join T_MM_Project project  \n");
        kSql.append("                  on actDetail.FProjectID = project.FID \n");
        kSql.append("                left outer join T_MM_TrackNumber trackNum  \n");
        kSql.append("                  on actDetail.FTrackID = trackNum.FID \n");
        kSql.append("          where (actDetail.FCostTypeID = '" + costTypeInfoFrom.getId().toString() + "'\n");
        kSql.append("                or actDetail.FCostTypeID = '" + costTypeInfoTo.getId().toString() + "')\n");
        if (CostTypeLevelEnum.order.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append("               and  mOrder.fbasestatus in (4,5,6,7,8,90,10,11) \n");
        }
        kSql.append(") costData \n");
        kSql.append("  where companyID = '").append(companyId).append("'\n");
        if (CostTypeLevelEnum.order.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append(this.buildOrderFilter(filter, "costData.orderNumber"));
        }
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, temp_OSCTotalRptRow);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                SQLUtils.cleanup((Connection)conn);
            }
            catch (Throwable exc) {
                logger.error((Object)exc.getMessage(), exc);
            }
        }
        return temp_OSCTotalRptRow;
    }

    private void updateCostTypeByCostItem(String rptResultTable, String ciAmountColumn, String temp_OSCTotalRptRow, String costItem, String costType) throws BOSException {
        StringBuffer kSql = new StringBuffer(500);
        kSql.append("  update " + rptResultTable + " rptCol \n");
        kSql.append("     set " + ciAmountColumn + " =  \n");
        kSql.append("                     (select sumAmount \n");
        kSql.append("                        from (select orderID, \n");
        kSql.append("                                     matID, \n");
        kSql.append("                                     costTypeID, \n");
        kSql.append("                                     ciID, \n");
        kSql.append("                                     SUM(ISNULL(childAmount, 0)) as sumAmount \n");
        kSql.append("                                from " + temp_OSCTotalRptRow + " \n");
        kSql.append("                               group by orderID, matID, costTypeID, ciID \n");
        kSql.append("                              ) ciData \n");
        kSql.append("                       where ciData.ciID = '" + costItem + "' \n");
        kSql.append("                         and ciData.costTypeID = '" + costType + "'\n");
        kSql.append("                         and ISNULL(ciData.orderID, ' ') = ISNULL(rptCol.orderID, ' ') \n");
        kSql.append("                         and ISNULL(ciData.matID, ' ') = ISNULL(rptCol.matID, ' ') \n");
        kSql.append("                      )    \n");
        kSql.append("   where exists \n");
        kSql.append("             ( \n");
        kSql.append("              select 1 \n");
        kSql.append("                from " + temp_OSCTotalRptRow + " \n");
        kSql.append("                where ciID = '" + costItem + "' \n");
        kSql.append("                  and costTypeID = '" + costType + "'\n");
        kSql.append("                  and ISNULL(orderID, ' ') = ISNULL(rptCol.orderID, ' ') \n");
        kSql.append("                  and ISNULL(matID, ' ') = ISNULL(rptCol.matID, ' ') \n");
        kSql.append("              ) \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
    }

    private void updateTotalCostType(String rptResultTable, String ciAmountColumn, String temp_OSCTotalRptRow, String costType) throws BOSException {
        StringBuffer kSql = new StringBuffer(500);
        kSql.append("  update " + rptResultTable + " rptCol \n");
        kSql.append("     set " + ciAmountColumn + " =  \n");
        kSql.append("                     (select sumAmount \n");
        kSql.append("                        from (select orderID, \n");
        kSql.append("                                     matID, \n");
        kSql.append("                                     costTypeID, \n");
        kSql.append("                                     SUM(ISNULL(childAmount, 0)) as sumAmount \n");
        kSql.append("                                from " + temp_OSCTotalRptRow + " \n");
        kSql.append("                               group by orderID, matID, costTypeID \n");
        kSql.append("                              ) ciData \n");
        kSql.append("                       where ciData.costTypeID = '" + costType + "'\n");
        kSql.append("                         and ISNULL(ciData.orderID, ' ') = ISNULL(rptCol.orderID, ' ') \n");
        kSql.append("                         and ISNULL(ciData.matID, ' ') = ISNULL(rptCol.matID, ' ') \n");
        kSql.append("                      )    \n");
        kSql.append("   where exists \n");
        kSql.append("             ( \n");
        kSql.append("              select 1 \n");
        kSql.append("                from " + temp_OSCTotalRptRow + " \n");
        kSql.append("                where costTypeID = '" + costType + "'\n");
        kSql.append("                  and ISNULL(orderID, ' ') = ISNULL(rptCol.orderID, ' ') \n");
        kSql.append("                  and ISNULL(matID, ' ') = ISNULL(rptCol.matID, ' ') \n");
        kSql.append("              ) \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
    }

    private IRowSet getCostItemsRowSet(RptParams filter, CostTypeInfo costTypeInfoFrom, String NCM_TBL_OSMaterialDetail, String NCM_TBL_OSActivityDetail, CostTypeInfo costTypeInfoTo) throws BOSException {
        StringBuffer kSql = new StringBuffer(500);
        kSql.append(" SELECT   DISTINCT ciData.ciID, \n");
        kSql.append("                   ciData.ciNumber, \n");
        kSql.append("                   ciData.ciName, \n");
        kSql.append("                   ciData.ciType \n");
        kSql.append(" FROM     (\n");
        kSql.append("           SELECT ci.FID AS ciID,\n");
        kSql.append("                  ci.FNumber AS ciNumber, \n");
        kSql.append("                  ci.FName_l2 AS ciName, \n");
        kSql.append("                  ci.FItemType AS ciType \n");
        kSql.append("           FROM   " + NCM_TBL_OSMaterialDetail + " matDetail \n");
        kSql.append("                  INNER JOIN T_BD_Material pMat \n");
        kSql.append("                    ON matDetail.FParentMaterialID = pMat.FID \n");
        if (CostTypeLevelEnum.product.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
        } else if (CostTypeLevelEnum.order.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append("              INNER join T_MM_ManufactureOrder mOrder  \n");
            kSql.append("                on matDetail.FOrderID = mOrder.FID \n ");
            kSql.append(this.buildOrderFilter(filter, "mOrder.FNumber"));
            kSql.append(" and  mOrder.fbasestatus in (4,5,6,7,8,90,10,11) \n");
        }
        kSql.append("                  INNER JOIN T_NCM_CostItem ci \n");
        kSql.append("                    ON matDetail.FChildCostItemID = ci.FID \n");
        kSql.append("           WHERE  matDetail.FCostTypeID = ? or matDetail.FCostTypeID = ? \n");
        kSql.append("           UNION ALL \n");
        kSql.append("           SELECT ci.FID AS ciID, \n");
        kSql.append("                  ci.FNumber AS ciNumber, \n");
        kSql.append("                  ci.FName_l2 AS ciName, \n");
        kSql.append("                  ci.FItemType AS ciType \n");
        kSql.append("           FROM   " + NCM_TBL_OSActivityDetail + " actDetail \n");
        kSql.append("                  INNER JOIN T_BD_Material pMat \n");
        kSql.append("                    ON actDetail.FParentMaterialID = pMat.FID \n");
        if (CostTypeLevelEnum.product.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
        } else if (CostTypeLevelEnum.order.equals((Object)costTypeInfoFrom.getLevel())) {
            kSql.append("              INNER join T_MM_ManufactureOrder mOrder  \n");
            kSql.append("                on actDetail.FOrderID = mOrder.FID \n ");
            kSql.append(this.buildOrderFilter(filter, "mOrder.FNumber"));
            kSql.append(" and  mOrder.fbasestatus in (4,5,6,7,8,90,10,11) \n");
        }
        kSql.append("                  INNER JOIN T_NCM_CostItem ci \n");
        kSql.append("                    ON actDetail.FActCostItemID = ci.FID \n");
        kSql.append("                left outer join T_MM_Project project  \n");
        kSql.append("                  on actDetail.FProjectID = project.FID \n");
        kSql.append("                left outer join T_MM_TrackNumber trackNum  \n");
        kSql.append("                  on actDetail.FTrackID = trackNum.FID \n");
        kSql.append("           WHERE  actDetail.FCostTypeID = ? or actDetail.FCostTypeID = ? \n");
        kSql.append("          ) ciData \n");
        kSql.append(" ORDER BY ciData.ciType, \n");
        kSql.append("          ciData.ciNumber \n");
        return DbUtil.executeQuery((Context)this.getContext(), (String)kSql.toString(), (Object[])new String[]{costTypeInfoFrom.getId().toString(), costTypeInfoTo.getId().toString(), costTypeInfoFrom.getId().toString(), costTypeInfoTo.getId().toString()});
    }

    private StringBuffer buildOrderFilter(RptParams filter, String alias) {
        ManufactureOrderInfo orderFrom = null;
        if (filter.getObject("orderFrom") instanceof ManufactureOrderInfo) {
            orderFrom = (ManufactureOrderInfo)filter.getObject("orderFrom");
        }
        ManufactureOrderInfo orderTo = null;
        if (filter.getObject("orderTo") instanceof ManufactureOrderInfo) {
            orderTo = (ManufactureOrderInfo)filter.getObject("orderTo");
        }
        StringBuffer fiterString = new StringBuffer("");
        if (orderFrom != null && orderFrom.getNumber() != null) {
            fiterString.append(" and " + alias + ">='" + orderFrom.getNumber() + "' \n");
        }
        if (orderTo != null && orderTo.getNumber() != null) {
            fiterString.append(" and " + alias + "<='" + orderTo.getNumber() + "' \n");
        }
        return fiterString;
    }

    private StringBuffer buildProductFilter(RptParams filter, String alias) {
        MaterialInfo materialFrom = null;
        if (filter.getObject("productFrom") instanceof MaterialInfo) {
            materialFrom = (MaterialInfo)filter.getObject("productFrom");
        }
        MaterialInfo materialTo = null;
        if (filter.getObject("productTo") instanceof MaterialInfo) {
            materialTo = (MaterialInfo)filter.getObject("productTo");
        }
        StringBuffer fiterString = new StringBuffer("");
        if (materialFrom != null && materialFrom.getNumber() != null) {
            fiterString.append(" and " + alias + ">='" + materialFrom.getNumber() + "' \n");
        }
        if (materialTo != null && materialTo.getNumber() != null) {
            fiterString.append(" and " + alias + "<='" + materialTo.getNumber() + "' \n");
        }
        return fiterString;
    }

    private StringBuffer getDefineColumns(IRowSet costItemsRowSet) throws BOSException {
        StringBuffer defineColumns = new StringBuffer();
        try {
            costItemsRowSet.first();
            costItemsRowSet.previous();
            int i = 0;
            while (costItemsRowSet.next()) {
                String colName = Integer.toString(i);
                defineColumns.append("FCostTypeOne" + colName + " Decimal(21,8) Default(0), \n");
                defineColumns.append("FCostTypeTwo" + colName + " Decimal(21,8) Default(0), \n");
                defineColumns.append("FDifference" + colName + " Decimal(21,8) Default(0), \n");
                ++i;
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        return defineColumns;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        String companyName = "";
        if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("company");
            companyName = company.getName();
        }
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_Tile_Company", (Locale)ctx.getLocale()) + companyName);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        reportHeader.addChild("orderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_Order", (Locale)ctx.getLocale())).setAlign(1).setIndex(0);
        reportHeader.addChild("matNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_matNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(1);
        reportHeader.addChild("matName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_matName", (Locale)ctx.getLocale())).setAlign(1).setIndex(2);
        reportHeader.addChild("matModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_Model", (Locale)ctx.getLocale())).setAlign(1).setIndex(3);
        reportHeader.addChild("projectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ProjectNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(4);
        reportHeader.addChild("trackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TrackNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(5);
        reportHeader.addChild("muName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FProductUnit", (Locale)ctx.getLocale())).setAlign(1).setIndex(6);
        String companyId = "";
        if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("company");
            companyId = company.getId().toString();
        }
        CostTypeInfo costTypeInfoFrom = null;
        if (filter.getObject("costTypeFrom") instanceof CostTypeInfo && (costTypeInfoFrom = (CostTypeInfo)filter.getObject("costTypeFrom")).getLevel() == null) {
            try {
                costTypeInfoFrom = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfoFrom.getId().toString()));
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
        }
        CostTypeInfo costTypeInfoTo = null;
        if (filter.getObject("costTypeTo") instanceof CostTypeInfo && (costTypeInfoTo = (CostTypeInfo)filter.getObject("costTypeTo")).getLevel() == null) {
            try {
                costTypeInfoTo = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfoTo.getId().toString()));
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
        }
        String NCM_TBL_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSMaterialDetail");
        String NCM_TBL_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSActivityDetail");
        IRowSet costItemsRowSet = this.getCostItemsRowSet(filter, costTypeInfoFrom, NCM_TBL_OSMaterialDetail, NCM_TBL_OSActivityDetail, costTypeInfoTo);
        int i = 0;
        try {
            costItemsRowSet.beforeFirst();
            String ciFieldName = null;
            ReportHeader secondHeader = null;
            while (costItemsRowSet.next()) {
                ciFieldName = costItemsRowSet.getString("ciName");
                if (ciFieldName.equals("\u539f\u6750\u6599")) {
                    secondHeader = reportHeader.addChild("FCostItem" + String.valueOf(i), costItemsRowSet.getString("ciName"));
                    secondHeader.addChild("FCostTypeOne" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType1StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                    secondHeader.addChild("FCostTypeTwo" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType2StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                    secondHeader.addChild("FDifference" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FStdPriceDifference", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                    reportHeader.setIndex(7 + i);
                    ++i;
                    continue;
                }
                if (ciFieldName.equals("\u5de5\u8d44")) {
                    secondHeader = reportHeader.addChild("FCostItem" + String.valueOf(i), costItemsRowSet.getString("ciName"));
                    secondHeader.addChild("FCostTypeOne" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType1StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                    secondHeader.addChild("FCostTypeTwo" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType2StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                    secondHeader.addChild("FDifference" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FStdPriceDifference", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                    reportHeader.setIndex(7 + i);
                    ++i;
                    continue;
                }
                if (!ciFieldName.equals("\u5176\u4ed6")) continue;
                secondHeader = reportHeader.addChild("FCostItem" + String.valueOf(i), costItemsRowSet.getString("ciName"));
                secondHeader.addChild("FCostTypeOne" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType1StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                secondHeader.addChild("FCostTypeTwo" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType2StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                secondHeader.addChild("FDifference" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FStdPriceDifference", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
                reportHeader.setIndex(7 + i);
                ++i;
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        ReportHeader secondHeader = reportHeader.addChild("stdPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OSCostTotalReport_stdPrice", (Locale)ctx.getLocale()));
        secondHeader.addChild("FCostType1StdPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType1StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        secondHeader.addChild("FCostType2StdPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FCostType2StdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        secondHeader.addChild("FStdPriceDifference", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_FStdPriceDifference", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(8 + i);
        return reportHeader;
    }
}

