/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OSCostTotalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger(OSCostTotalReport.class);

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        IRowSet costItemsRowSet;
        Connection conn;
        String TEMP_OSCTotalRptColumn;
        block26: {
            CompanyOrgUnitInfo company = null;
            if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
                company = (CompanyOrgUnitInfo)filter.getObject("company");
            }
            CostTypeInfo costTypeInfo = null;
            if (filter.getObject("costType") instanceof CostTypeInfo && (costTypeInfo = (CostTypeInfo)filter.getObject("costType")).getLevel() == null) {
                try {
                    costTypeInfo = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfo.getId().toString()));
                }
                catch (Exception exc) {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                }
            }
            Assert.that((company != null ? 1 : 0) != 0);
            Assert.that((costTypeInfo != null ? 1 : 0) != 0);
            String companyId = String.valueOf(company.getId());
            String costTypeId = String.valueOf(costTypeInfo.getId());
            Locale loc = this.getContext().getLocale();
            String T_NCM_OSMaterialDetail = null;
            String T_NCM_OSActivityDetail = null;
            String TEMP_OSCTotalRptRow = null;
            TEMP_OSCTotalRptColumn = null;
            StringBuffer kSql = new StringBuffer();
            conn = null;
            costItemsRowSet = null;
            try {
                T_NCM_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSMaterialDetail");
                T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSActivityDetail");
                costItemsRowSet = this.getCostItemsRowSet(filter, costTypeInfo, T_NCM_OSMaterialDetail, T_NCM_OSActivityDetail, costTypeId);
                kSql.setLength(0);
                kSql.append(" create table TEMP_OSCTotalRptRow ( \n");
                kSql.append("    orderID       varchar(44), \n");
                kSql.append("    orderNumber   nvarchar(255), \n");
                kSql.append("    matID         varchar(44), \n");
                kSql.append("    matNumber     nvarchar(255), \n");
                kSql.append("    matName       nvarchar(255), \n");
                kSql.append("    matModel      nvarchar(255), \n");
                kSql.append("    projectID     varchar(44), \n");
                kSql.append("    projectNumber nvarchar(255), \n");
                kSql.append("    trackID       varchar(44), \n");
                kSql.append("    trackNumber   nvarchar(255), \n");
                kSql.append("    orderLot      nvarchar(255), \n");
                kSql.append("    ciID          varchar(44), \n");
                kSql.append("    ciNumber      nvarchar(255), \n");
                kSql.append("    ciName        nvarchar(255), \n");
                kSql.append("    ciType        varchar(80), \n");
                kSql.append("    childAmount   decimal(21,8) default(0) \n ");
                kSql.append("  )\n ");
                TEMP_OSCTotalRptRow = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TEMP_OSCTotalRptRow, "matID", false, false);
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TEMP_OSCTotalRptRow, "ciID", false, false);
                kSql.setLength(0);
                kSql.append(" insert into " + TEMP_OSCTotalRptRow + " ( \n");
                kSql.append("        orderID, \n");
                kSql.append("        orderNumber, \n");
                kSql.append("        matID, \n");
                kSql.append("        matNumber, \n");
                kSql.append("        matName, \n");
                kSql.append("        matModel, \n");
                kSql.append("        projectID, \n");
                kSql.append("        projectNumber, \n");
                kSql.append("        trackID, \n");
                kSql.append("        trackNumber, \n");
                kSql.append("        orderLot, \n");
                kSql.append("        ciID, \n");
                kSql.append("        ciNumber, \n");
                kSql.append("        ciType, \n");
                kSql.append("        ciName, \n");
                kSql.append("        childAmount) \n");
                kSql.append(" select orderID, \n");
                kSql.append("        orderNumber, \n");
                kSql.append("        matID, \n");
                kSql.append("        matNumber, \n");
                kSql.append("        matName, \n");
                kSql.append("        matModel, \n");
                kSql.append("        projectID, \n");
                kSql.append("        projectNumber, \n");
                kSql.append("        trackID, \n");
                kSql.append("        trackNumber, \n");
                kSql.append("        orderLot, \n");
                kSql.append("        ciID, \n");
                kSql.append("        ciNumber, \n");
                kSql.append("        ciType, \n");
                kSql.append("        ciName, \n");
                kSql.append("        childAmount \n");
                kSql.append("   from (select mOrder.FID             as orderID, \n");
                kSql.append("                mOrder.FNumber         as orderNumber, \n");
                kSql.append("                pMat.FID               as matID, \n");
                kSql.append("                pMat.FNumber           as matNumber, \n");
                kSql.append("                pMat.FName_" + loc + "          as matName, \n");
                kSql.append("                pMat.FModel            as matModel, \n");
                kSql.append("                project.FID            as projectID, \n");
                kSql.append("                project.FNumber        as projectNumber, \n");
                kSql.append("                trackNum.FID           as trackID, \n");
                kSql.append("                trackNum.FNumber       as trackNumber, \n");
                kSql.append("                mOrder.FLot            as orderLot, \n");
                kSql.append("                ci.FID                 as ciID, \n");
                kSql.append("                ci.FNumber             as ciNumber, \n");
                kSql.append("                ci.FName_" + loc + "            as ciName, \n");
                kSql.append("                ci.FItemType           as ciType, \n");
                kSql.append("                matDetail.FChildAMount as childAmount \n");
                kSql.append("           from " + T_NCM_OSMaterialDetail + " matDetail \n");
                kSql.append("                inner join T_BD_Material pMat  \n");
                kSql.append("                  on matDetail.FParentMaterialID = pMat.FID \n");
                if (CostTypeLevelEnum.product.equals((Object)costTypeInfo.getLevel())) {
                    kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
                }
                kSql.append("                left outer join T_NCM_CostItem ci  \n");
                kSql.append("                  on matDetail.FChildCostItemID = ci.FID \n");
                kSql.append("                left outer join T_MM_ManufactureOrder mOrder  \n");
                kSql.append("                  on matDetail.FOrderID = mOrder.FID \n");
                kSql.append("                left outer join T_MM_Project project  \n");
                kSql.append("                  on mOrder.FProjectID = project.FID \n");
                kSql.append("                left outer join T_MM_TrackNumber trackNum  \n");
                kSql.append("                  on mOrder.FTrackID = trackNum.FID \n");
                kSql.append("          where matDetail.FCostTypeID = '" + costTypeId + "' \n");
                kSql.append("            and CHARINDEX(pMat.FNumber || ',' ,matDetail.FSpreadPath) = 1 \n");
                kSql.append("         union all \n");
                kSql.append("         select mOrder.FID           as orderID, \n");
                kSql.append("                mOrder.FNumber       as orderNumber, \n");
                kSql.append("                pMat.FID             as matID, \n");
                kSql.append("                pMat.FNumber         as matNumber, \n");
                kSql.append("                pMat.FName_" + loc + "        as matName, \n");
                kSql.append("                pMat.FModel          as matModel, \n");
                kSql.append("                project.FID          as projectID, \n");
                kSql.append("                project.FNumber      as projectNumber, \n");
                kSql.append("                trackNum.FID         as trackID, \n");
                kSql.append("                trackNum.FNumber     as trackNumber, \n");
                kSql.append("                mOrder.FLot          as orderLot, \n");
                kSql.append("                ci.FID               as ciID, \n");
                kSql.append("                ci.FNumber           as ciNumber, \n");
                kSql.append("                ci.FName_" + loc + "          as ciName, \n");
                kSql.append("                ci.FItemType         as ciType, \n");
                kSql.append("                actDetail.FActAmount as childAmount \n");
                kSql.append("           from " + T_NCM_OSActivityDetail + " actDetail \n");
                kSql.append("                inner join T_BD_Material pMat  \n");
                kSql.append("                  on actDetail.FParentMaterialID = pMat.FID \n");
                if (CostTypeLevelEnum.product.equals((Object)costTypeInfo.getLevel())) {
                    kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
                }
                kSql.append("                left outer join T_NCM_CostItem ci  \n");
                kSql.append("                  on actDetail.FActCostItemID = ci.FID \n");
                kSql.append("                left outer join T_MM_ManufactureOrder mOrder  \n");
                kSql.append("                  on actDetail.FOrderID = mOrder.FID \n");
                kSql.append("                left outer join T_MM_Project project  \n");
                kSql.append("                  on mOrder.FProjectID = project.FID \n");
                kSql.append("                left outer join T_MM_TrackNumber trackNum  \n");
                kSql.append("                  on mOrder.FTrackID = trackNum.FID \n");
                kSql.append("          where actDetail.FCostTypeID = '" + costTypeId + "') costData \n");
                kSql.append("  where 1 = 1 \n");
                if (CostTypeLevelEnum.order.equals((Object)costTypeInfo.getLevel())) {
                    kSql.append(this.buildOrderFilter(filter, "costData.orderNumber"));
                }
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                conn = EJBFactory.getConnection((Context)this.getContext());
                TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TEMP_OSCTotalRptRow);
                StringBuffer defineColumns = this.getDefineColumns(costItemsRowSet);
                kSql.setLength(0);
                kSql.append(" create table TEMP_OSCTotalRptColumn( \n");
                kSql.append("    orderID       varchar(44), \n");
                kSql.append("    orderNumber   nvarchar(255), \n");
                kSql.append("    matID         varchar(44), \n");
                kSql.append("    matNumber     nvarchar(255), \n");
                kSql.append("    matName       nvarchar(255), \n");
                kSql.append("    matModel      nvarchar(255), \n");
                kSql.append("    projectID     varchar(44), \n");
                kSql.append("    projectNumber nvarchar(255), \n");
                kSql.append("    trackID       varchar(44), \n");
                kSql.append("    trackNumber   nvarchar(255), \n");
                kSql.append("    orderLot      nvarchar(255), \n");
                kSql.append("    muName        nvarchar(255), \n");
                kSql.append(defineColumns);
                kSql.append("    stdPrice      decimal(21,8) default(0) \n ");
                kSql.append("  )\n ");
                TEMP_OSCTotalRptColumn = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).createIndex(TEMP_OSCTotalRptColumn, "matID", false, false);
                kSql.setLength(0);
                kSql.append(" insert into " + TEMP_OSCTotalRptColumn + " \n");
                kSql.append("   (orderID, \n");
                kSql.append("    orderNumber, \n");
                kSql.append("    matID, \n");
                kSql.append("    matNumber, \n");
                kSql.append("    matName, \n");
                kSql.append("    matModel, \n");
                kSql.append("    projectID, \n");
                kSql.append("    projectNumber, \n");
                kSql.append("    trackID,\n");
                kSql.append("    trackNumber, \n");
                kSql.append("    OrderLot) \n");
                kSql.append("   select distinct orderID, \n");
                kSql.append("                   orderNumber, \n");
                kSql.append("                   matID, \n");
                kSql.append("                   matNumber, \n");
                kSql.append("                   matName, \n");
                kSql.append("                   matModel, \n");
                kSql.append("                   projectID, \n");
                kSql.append("                   projectNumber, \n");
                kSql.append("                   trackID,\n");
                kSql.append("                   trackNumber, \n");
                kSql.append("                   OrderLot \n");
                kSql.append("     from " + TEMP_OSCTotalRptRow + " \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TEMP_OSCTotalRptColumn);
                costItemsRowSet.first();
                costItemsRowSet.previous();
                int i = 0;
                while (costItemsRowSet.next()) {
                    String ciAmountColumn = "FAmountF" + Integer.toString(i++);
                    String ciId = costItemsRowSet.getString("ciID");
                    kSql.setLength(0);
                    kSql.append("  update " + TEMP_OSCTotalRptColumn + " rptCol \n");
                    kSql.append("     set " + ciAmountColumn + " =  \n");
                    kSql.append("                     (select sumAmount \n");
                    kSql.append("                        from (select orderID, \n");
                    kSql.append("                                     matID, \n");
                    kSql.append("                                     ciID, \n");
                    kSql.append("                                     SUM(ISNULL(childAmount, 0)) as sumAmount \n");
                    kSql.append("                                from " + TEMP_OSCTotalRptRow + " \n");
                    kSql.append("                               group by orderID, matID, ciID \n");
                    kSql.append("                              ) ciData \n");
                    kSql.append("                       where ciData.ciID = '" + ciId + "' \n");
                    kSql.append("                         and ISNULL(ciData.orderID, ' ') = ISNULL(rptCol.orderID, ' ') \n");
                    kSql.append("                         and ISNULL(ciData.matID, ' ') = ISNULL(rptCol.matID, ' ') \n");
                    kSql.append("                      )    \n");
                    kSql.append("   where exists \n");
                    kSql.append("             ( \n");
                    kSql.append("              select 1 \n");
                    kSql.append("                from " + TEMP_OSCTotalRptRow + " \n");
                    kSql.append("                where ciID = '" + ciId + "' \n");
                    kSql.append("                  and ISNULL(orderID, ' ') = ISNULL(rptCol.orderID, ' ') \n");
                    kSql.append("                  and ISNULL(matID, ' ') = ISNULL(rptCol.matID, ' ') \n");
                    kSql.append("              ) \n");
                    DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                }
                kSql.setLength(0);
                kSql.append(" update " + TEMP_OSCTotalRptColumn + " \n");
                kSql.append("    set stdPrice = (select top 1 FStdPrice \n");
                kSql.append("                      from " + T_NCM_OSMaterialDetail + " \n");
                kSql.append("                     where FParentMaterialID = " + TEMP_OSCTotalRptColumn + ".MatID \n");
                kSql.append("                       and ISNULL(FOrderID, ' ') = ISNULL(" + TEMP_OSCTotalRptColumn + ".orderID, ' ') \n");
                kSql.append("                       and FCostTypeID = ? ) \n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString(), (Object[])new String[]{costTypeId});
                kSql.setLength(0);
                kSql.append(" update " + TEMP_OSCTotalRptColumn + " \n");
                kSql.append("    set muName = (select mu.FName_" + loc + " \n");
                kSql.append("                    from T_BD_Material mat \n");
                kSql.append("                    left outer join T_BD_MeasureUnit mu  \n");
                kSql.append("                      on mat.FBaseUnit = mu.FID \n");
                kSql.append("                   where mat.FID = " + TEMP_OSCTotalRptColumn + ".matID)\n");
                DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
                if (TEMP_OSCTotalRptRow == null) break block26;
            }
            catch (SQLException exc) {
                try {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                    catch (Exception exc2) {
                        logger.error((Object)exc2.getMessage(), (Throwable)exc2);
                        throw new BOSException((Throwable)exc2);
                    }
                }
                catch (Throwable throwable) {
                    if (TEMP_OSCTotalRptRow != null) {
                        try {
                            TempTablePool.getInstance((Context)this.getContext()).releaseTable(TEMP_OSCTotalRptRow);
                        }
                        catch (Throwable exc3) {
                            logger.error((Object)exc3.getMessage(), exc3);
                        }
                    }
                    try {
                        SQLUtils.cleanup(costItemsRowSet);
                    }
                    catch (Throwable exc4) {
                        logger.error((Object)exc4.getMessage(), exc4);
                    }
                    try {
                        SQLUtils.cleanup(conn);
                        throw throwable;
                    }
                    catch (Throwable exc5) {
                        logger.error((Object)exc5.getMessage(), exc5);
                    }
                    throw throwable;
                }
            }
            try {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(TEMP_OSCTotalRptRow);
            }
            catch (Throwable exc) {
                logger.error((Object)exc.getMessage(), exc);
            }
        }
        try {
            SQLUtils.cleanup((ResultSet)costItemsRowSet);
        }
        catch (Throwable exc) {
            logger.error((Object)exc.getMessage(), exc);
        }
        try {
            SQLUtils.cleanup((Connection)conn);
            return TEMP_OSCTotalRptColumn;
        }
        catch (Throwable exc) {
            logger.error((Object)exc.getMessage(), exc);
            return TEMP_OSCTotalRptColumn;
        }
    }

    private IRowSet getCostItemsRowSet(RptParams filter, CostTypeInfo costTypeInfo, String NCM_TBL_OSMaterialDetail, String NCM_TBL_OSActivityDetail, String costTypeId) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT   DISTINCT ciData.ciID, \n");
        kSql.append("                   ciData.ciNumber, \n");
        kSql.append("                   ciData.ciName, \n");
        kSql.append("                   ciData.ciType \n");
        kSql.append(" FROM     (\n");
        kSql.append("           SELECT ci.FID AS ciID,\n");
        kSql.append("                  ci.FNumber AS ciNumber, \n");
        kSql.append("                  ci.FName_l2 AS ciName, \n");
        kSql.append("                  ci.FItemType AS ciType \n");
        kSql.append("           FROM   " + NCM_TBL_OSMaterialDetail + " matDetail \n");
        kSql.append("                  INNER JOIN T_BD_Material pMat \n");
        kSql.append("                    ON matDetail.FParentMaterialID = pMat.FID \n");
        if (CostTypeLevelEnum.product.equals((Object)costTypeInfo.getLevel())) {
            kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
        }
        kSql.append("                  INNER JOIN T_NCM_CostItem ci \n");
        kSql.append("                    ON matDetail.FChildCostItemID = ci.FID \n");
        kSql.append("           WHERE  matDetail.FCostTypeID = ? \n");
        kSql.append("           UNION ALL \n");
        kSql.append("           SELECT ci.FID AS ciID, \n");
        kSql.append("                  ci.FNumber AS ciNumber, \n");
        kSql.append("                  ci.FName_l2 AS ciName, \n");
        kSql.append("                  ci.FItemType AS ciType \n");
        kSql.append("           FROM   " + NCM_TBL_OSActivityDetail + " actDetail \n");
        kSql.append("                  INNER JOIN T_BD_Material pMat \n");
        kSql.append("                    ON actDetail.FParentMaterialID = pMat.FID \n");
        if (CostTypeLevelEnum.product.equals((Object)costTypeInfo.getLevel())) {
            kSql.append(this.buildProductFilter(filter, "pMat.FNumber"));
        }
        kSql.append("                  INNER JOIN T_NCM_CostItem ci \n");
        kSql.append("                    ON actDetail.FActCostItemID = ci.FID \n");
        kSql.append("           WHERE  actDetail.FCostTypeID = ? \n");
        kSql.append("          ) ciData \n");
        kSql.append(" ORDER BY ciData.ciType, \n");
        kSql.append("          ciData.ciNumber \n");
        IRowSet costItemsRowSet = DbUtil.executeQuery((Context)this.getContext(), (String)kSql.toString(), (Object[])new String[]{costTypeId, costTypeId});
        return costItemsRowSet;
    }

    private StringBuffer buildOrderFilter(RptParams filter, String alias) {
        ManufactureOrderInfo orderFrom = null;
        if (filter.getObject("orderFrom") instanceof ManufactureOrderInfo) {
            orderFrom = (ManufactureOrderInfo)filter.getObject("orderFrom");
        }
        ManufactureOrderInfo orderTo = null;
        if (filter.getObject("orderTo") instanceof ManufactureOrderInfo) {
            orderTo = (ManufactureOrderInfo)filter.getObject("orderTo");
        }
        StringBuffer fiterString = new StringBuffer("");
        if (orderFrom != null && orderFrom.getNumber() != null) {
            fiterString.append(" and " + alias + ">='" + orderFrom.getNumber() + "' \n");
        }
        if (orderTo != null && orderTo.getNumber() != null) {
            fiterString.append(" and " + alias + "<='" + orderTo.getNumber() + "' \n");
        }
        return fiterString;
    }

    private StringBuffer buildProductFilter(RptParams filter, String alias) {
        MaterialInfo materialFrom = null;
        if (filter.getObject("productFrom") instanceof MaterialInfo) {
            materialFrom = (MaterialInfo)filter.getObject("productFrom");
        }
        MaterialInfo materialTo = null;
        if (filter.getObject("productTo") instanceof MaterialInfo) {
            materialTo = (MaterialInfo)filter.getObject("productTo");
        }
        StringBuffer fiterString = new StringBuffer("");
        if (materialFrom != null && materialFrom.getNumber() != null) {
            fiterString.append(" and " + alias + ">='" + materialFrom.getNumber() + "' \n");
        }
        if (materialTo != null && materialTo.getNumber() != null) {
            fiterString.append(" and " + alias + "<='" + materialTo.getNumber() + "' \n");
        }
        return fiterString;
    }

    private StringBuffer getDefineColumns(IRowSet costItemsRowSet) throws BOSException {
        StringBuffer defineColumns = new StringBuffer();
        try {
            costItemsRowSet.first();
            costItemsRowSet.previous();
            int i = 0;
            String colName = "F" + Integer.toString(i);
            while (costItemsRowSet.next()) {
                defineColumns.append("FAmount" + colName + " Decimal(21,8) Default(0), \n");
                colName = "F" + Integer.toString(++i);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        return defineColumns;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        String companyName = "";
        if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("company");
            companyName = company.getName();
        }
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_Tile_Company", (Locale)ctx.getLocale()) + companyName);
        String costTypeName = "";
        if (filter.getObject("costType") instanceof CostTypeInfo) {
            CostTypeInfo costTypeInfo = (CostTypeInfo)filter.getObject("costType");
            costTypeName = costTypeInfo.getName();
        }
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_Tile_CostType", (Locale)ctx.getLocale()) + costTypeName);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        reportHeader.addChild("orderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_Order", (Locale)ctx.getLocale())).setAlign(1).setIndex(0);
        reportHeader.addChild("matNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(1);
        reportHeader.addChild("matName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductName", (Locale)ctx.getLocale())).setAlign(1).setIndex(2);
        reportHeader.addChild("matModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_Model", (Locale)ctx.getLocale())).setAlign(1).setIndex(3);
        reportHeader.addChild("projectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ProjectNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(4);
        reportHeader.addChild("trackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TrackNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(5);
        reportHeader.addChild("orderLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Lot", (Locale)ctx.getLocale())).setAlign(1).setIndex(6);
        reportHeader.addChild("muName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FProductUnit", (Locale)ctx.getLocale())).setAlign(1).setIndex(7);
        String companyId = "";
        if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("company");
            companyId = company.getId().toString();
        }
        CostTypeInfo costTypeInfo = new CostTypeInfo();
        String costTypeId = "";
        if (filter.getObject("costType") instanceof CostTypeInfo) {
            costTypeInfo = (CostTypeInfo)filter.getObject("costType");
            if (costTypeInfo.getLevel() == null) {
                try {
                    costTypeInfo = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfo.getId().toString()));
                }
                catch (Exception exc) {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                }
            }
            costTypeId = costTypeInfo.getId().toString();
        }
        String NCM_TBL_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSMaterialDetail");
        String NCM_TBL_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSActivityDetail");
        IRowSet costItemsRowSet = this.getCostItemsRowSet(filter, costTypeInfo, NCM_TBL_OSMaterialDetail, NCM_TBL_OSActivityDetail, costTypeId);
        int i = 0;
        try {
            costItemsRowSet.beforeFirst();
            String ciFieldName = null;
            while (costItemsRowSet.next()) {
                ciFieldName = costItemsRowSet.getString("ciName");
                if (ciFieldName.equals("\u539f\u6750\u6599")) {
                    reportHeader.addChild("FAmountF" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OSCostTotalReport_01", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(3);
                    reportHeader.setIndex(8 + i);
                    ++i;
                    continue;
                }
                if (ciFieldName.equals("\u5de5\u8d44")) {
                    reportHeader.addChild("FAmountF" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OSCostTotalReport_02", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(3);
                    reportHeader.setIndex(8 + i);
                    ++i;
                    continue;
                }
                if (!ciFieldName.equals("\u5176\u4ed6")) continue;
                reportHeader.addChild("FAmountF" + String.valueOf(i), ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OSCostTotalReport_03", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(3);
                reportHeader.setIndex(8 + i);
                ++i;
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        reportHeader.addChild("stdPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OSCostTotalReport_stdPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(3);
        reportHeader.setIndex(9 + i);
        return reportHeader;
    }
}

