/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeInfo;
import com.kingdee.eas.ncm.std.basedata.app.AbstractSTDResourceTypeControllerBean;
import com.kingdee.util.StringUtils;

public class STDResourceTypeControllerBean
extends AbstractSTDResourceTypeControllerBean {
    private static final long serialVersionUID = 1698856309505565384L;

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        STDResourceTypeInfo info = (STDResourceTypeInfo)model;
        this.checkBlank(info);
        this.checkNumberDup(ctx, info);
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        STDResourceTypeInfo info = (STDResourceTypeInfo)model;
        this.checkBlank(info);
        this.checkNumberDup(ctx, info);
        return super._addnew(ctx, model);
    }

    private void checkBlank(STDResourceTypeInfo info) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    private void checkNumberDup(Context ctx, STDResourceTypeInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }
}

