/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeStateEnum;
import com.kingdee.eas.ncm.std.bill.STDCostDataFilterParam;
import com.kingdee.eas.ncm.std.bill.STDCostDataInfo;
import com.kingdee.eas.ncm.std.bill.app.AbstractSTDCostDataControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class STDCostDataControllerBean
extends AbstractSTDCostDataControllerBean {
    private static final long serialVersionUID = 7514155896976747152L;
    private static Logger logger = Logger.getLogger((String)STDCostDataControllerBean.class.getName());

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_STDCostData";
    }

    @Override
    protected void _generateData(Context ctx, String storageOrgUnitId, String companyId, List schemeIds, STDCostDataFilterParam filterParam) throws BOSException, EASBizException {
        StorageOrgUnitInfo storage;
        String logDetail = "";
        if (!StringUtils.isEmpty((String)storageOrgUnitId) && (storage = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitId)))) != null && storage.getName() != null) {
            logDetail = storage.getName();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"generateData", (BOSObjectType)this.getBOSType(), null, (String)logDetail, (String)"std_STDCostData_gen");
        if (StringUtils.isEmpty((String)storageOrgUnitId) || StringUtils.isEmpty((String)companyId)) {
            return;
        }
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (!sysctrol.isStart(1001, companyId)) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String userId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getId() != null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" INSERT INTO T_NCM_STDCostData \n");
        kSql.append("            (FID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FMaterialID, \n");
        kSql.append("             FStdAmount, \n");
        kSql.append("             FDataType, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FBillStatus, \n");
        kSql.append("             FCreatorID, \n");
        kSql.append("             FCreateTime) \n");
        kSql.append(" SELECT NEWBOSID('8925A08C') AS FID, \n");
        kSql.append("        estimateScheme.FID AS FEstimateSchemeID, \n");
        kSql.append("        estimateType.FMaterialID AS FMaterialID, \n");
        kSql.append("        0 AS FStdAmount, \n");
        kSql.append("        estimateType.FEstimateType AS FDataType, \n");
        kSql.append("        estimateType.FCompanyOrg AS FCompanyOrg, \n");
        kSql.append("        estimateType.FCalculatePeriod AS FCalculatePeriod, \n");
        kSql.append("        100 AS FBillStatus, \n");
        kSql.append("        '" + userId + "' AS FCreatorID, \n");
        kSql.append("        now() AS FCreateTime \n");
        kSql.append(" FROM   T_NCM_STDCostEstimateType estimateType, \n");
        kSql.append("        T_NCM_SCEstimateScheme estimateScheme \n");
        kSql.append(" WHERE  estimateType.FStorageOrgUnitID = '" + storageOrgUnitId + "' \n");
        kSql.append("   AND  NOT EXISTS (SELECT fid \n");
        kSql.append("                      FROM T_NCM_STDCostData \n");
        kSql.append("                     WHERE FMaterialID = estimateType.FMaterialID \n");
        kSql.append("                        AND FEstimateSchemeID = estimateScheme.FID \n");
        kSql.append("                    ) \n");
        if (schemeIds != null && !schemeIds.isEmpty()) {
            kSql.append("        AND estimateScheme.FID IN (");
            int size = schemeIds.size();
            for (int i = 0; i < size; ++i) {
                String schemeId = (String)schemeIds.get(i);
                if (i != size - 1) {
                    kSql.append("'" + schemeId + "',");
                    continue;
                }
                kSql.append("'" + schemeId + "')");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        } else {
            kSql.append("        AND estimateScheme.FSchemeType = 1 \n");
            kSql.append("        AND estimateScheme.FState <> 2 \n");
            kSql.append("        AND estimateScheme.FEndDate >= ? \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{period.getEndDate()});
        }
        String T_NCM_STDCostDataMatDetail = null;
        try {
            T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataMatDetail");
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (T_NCM_STDCostDataMatDetail != null) {
            kSql.setLength(0);
            kSql.append(" UPDATE T_NCM_STDCostData \n");
            kSql.append(" SET    FStdAmount = (SELECT TOP 1 FStdPrice \n");
            kSql.append("                      FROM   " + T_NCM_STDCostDataMatDetail + " \n");
            kSql.append("                      WHERE  FEstimateSchemeID = T_NCM_STDCostData.FEstimateSchemeID \n");
            kSql.append("                             AND FParentMaterialID = T_NCM_STDCostData.FMaterialID) \n");
            kSql.append(" WHERE  FBillStatus = 100 \n");
            kSql.append("        AND EXISTS (SELECT 1 \n");
            kSql.append("                    FROM   " + T_NCM_STDCostDataMatDetail + " \n");
            kSql.append("                    WHERE  FEstimateSchemeID = T_NCM_STDCostData.FEstimateSchemeID \n");
            kSql.append("                           AND FParentMaterialID = T_NCM_STDCostData.FMaterialID) \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        }
        NCMDbUtil.execute((Context)ctx, (String)"update T_NCM_STDCostData set FBillStatus = 1 where FBillStatus = 100 ");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _updateData(Context ctx, Map data, List pks, ArrayList addObjList) throws BOSException, EASBizException {
        HashSet set = new HashSet();
        if (data != null && !data.isEmpty()) {
            for (Map.Entry entry : data.entrySet()) {
                set.add(entry.getKey());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("estimateScheme.name"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        StringBuffer logInfo = new StringBuffer();
        CoreBaseCollection cbc = this.getCollection(ctx, view);
        for (STDCostDataInfo info : cbc) {
            String str = info.getLogInfo();
            if (str == null || str.length() <= 0) continue;
            logInfo.append(str).append(",");
        }
        if (logInfo.length() > 0) {
            logInfo.deleteCharAt(logInfo.length() - 1);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"updateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"std_STDCostData_save");
        if (pks != null && !pks.isEmpty()) {
            IObjectPK[] _pks = new IObjectPK[pks.size()];
            int size = pks.size();
            for (int i = 0; i < size; ++i) {
                _pks[i] = (IObjectPK)pks.get(i);
            }
            this._delete(ctx, _pks);
        }
        if (data != null && !data.isEmpty()) {
            for (Map.Entry entry : data.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getKey().toString())) continue;
                BigDecimal stdAmount = (BigDecimal)data.get(entry.getKey());
                NCMDbUtil.execute((Context)ctx, (String)" update T_NCM_STDCostData set FStdAmount = ? where FID = ? ", (Object[])new Object[]{stdAmount, entry.getKey()});
            }
        }
        if (addObjList == null || addObjList.size() == 0) {
            return;
        }
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append(" INSERT INTO T_NCM_STDCostData \n");
        sqlInsert.append("            (FID, \n");
        sqlInsert.append("             FEstimateSchemeID, \n");
        sqlInsert.append("             FMaterialID, \n");
        sqlInsert.append("             FStdAmount, \n");
        sqlInsert.append("             FDataType, \n");
        sqlInsert.append("             FCompanyOrg, \n");
        sqlInsert.append("             FCalculatePeriod, \n");
        sqlInsert.append("             FBillStatus, \n");
        sqlInsert.append("             FCreatorID, \n");
        sqlInsert.append("             FCreateTime) \n").append("values (?,?,?,?,?,?,?,?,?,now())");
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = null;
        String companyID = null;
        if (addObjList.size() > 0) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        }
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int i = 0; i < addObjList.size(); ++i) {
                pstmtInsert.setString(1, ((STDCostDataInfo)addObjList.get(i)).getId().toString());
                pstmtInsert.setString(2, ((STDCostDataInfo)addObjList.get(i)).getEstimateScheme().getId().toString());
                pstmtInsert.setString(3, ((STDCostDataInfo)addObjList.get(i)).getMaterial().getId().toString());
                pstmtInsert.setBigDecimal(4, ((STDCostDataInfo)addObjList.get(i)).getStdAmount());
                pstmtInsert.setInt(5, ((STDCostDataInfo)addObjList.get(i)).getDataType().getValue());
                pstmtInsert.setString(6, ((STDCostDataInfo)addObjList.get(i)).getEstimateScheme().getCompany().getId().toString());
                pstmtInsert.setString(7, periodInfo == null ? "period null" : String.valueOf(periodInfo.getId()));
                pstmtInsert.setInt(8, 1);
                pstmtInsert.setString(9, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        sqlInsert.setLength(0);
        sqlInsert.append(" select STDdata.FEstimateSchemeID,STDdata.FMaterialID,estimateScheme.Fnumber as esNumber, ma.Fnumber as maNumber  from T_NCM_STDCostData STDdata\n");
        sqlInsert.append("          inner join T_NCM_SCEstimateScheme estimateScheme \n");
        sqlInsert.append("                on STDdata.FEstimateSchemeID = estimateScheme.fid \n");
        sqlInsert.append("          inner join T_BD_Material ma \n");
        sqlInsert.append("                on STDdata.FMaterialID = ma.fid \n");
        sqlInsert.append("          group by STDdata.FEstimateSchemeID,STDdata.FMaterialID,estimateScheme.Fnumber , ma.Fnumber \n");
        sqlInsert.append("          HAVING COUNT(1)>1 \n");
        try {
            IRowSet rsda = NCMDbUtil.executeQuery((Context)ctx, (String)sqlInsert.toString());
            StringBuffer message = new StringBuffer();
            boolean flag = false;
            message.append("\n");
            while (rsda.next()) {
                flag = true;
                message.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"5_STDCostDataImport", (Locale)ctx.getLocale())).append(rsda.getString("esNumber")).append("  ").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"6_STDCostDataImport", (Locale)ctx.getLocale())).append(rsda.getString("maNumber") + "\n");
            }
            Object[] messages = new String[]{message.toString()};
            if (flag) {
                throw new NcmBillException(NcmBillException.CHECK_COMBIN, messages);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void checkStart(Context ctx, IObjectCollection billColl) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _hasDetail(Context ctx, String stdCostDataID) throws BOSException, EASBizException {
        IRowSet rst;
        block8: {
            boolean bl;
            String companyID;
            String materialID;
            String estimateSchemeID;
            block7: {
                if (StringUtils.isEmpty((String)stdCostDataID)) {
                    return false;
                }
                estimateSchemeID = null;
                materialID = null;
                companyID = null;
                rst = null;
                rst = NCMDbUtil.executeQuery((Context)ctx, (String)" SELECT FEstimateSchemeID,FMaterialID,FCompanyOrg FROM T_NCM_STDCostData WHERE FID = ? ", (Object[])new Object[]{stdCostDataID});
                if (rst.next()) {
                    estimateSchemeID = rst.getString("FEstimateSchemeID");
                    materialID = rst.getString("FMaterialID");
                    companyID = rst.getString("FCompanyOrg");
                    break block7;
                }
                boolean bl2 = false;
                SQLUtils.cleanup((ResultSet)rst);
                return bl2;
            }
            try {
                String T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataMatDetail");
                String T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataResDetail");
                StringBuffer kSql = new StringBuffer();
                kSql.append(" SELECT 1 ");
                kSql.append("   FROM T_NCM_STDCostData ");
                kSql.append("  WHERE FID = ? ");
                kSql.append("   AND ( \n");
                kSql.append("    \t exists (select 1 \n");
                kSql.append("                  from " + T_NCM_STDCostDataMatDetail + " matDetail \n");
                kSql.append("                 where matDetail.FEstimateSchemeID = ? \n");
                kSql.append("                   and matDetail.FParentMaterialID = ? \n");
                kSql.append("                   and matDetail.FParentMaterialID <> matDetail.FMaterialID \n");
                kSql.append("                   and matDetail.FStdPrice IS NOT NULL \n");
                kSql.append("                   and matDetail.FStdPrice <> 0 \n");
                kSql.append("               )  \n");
                kSql.append("        or \n");
                kSql.append("        exists (select 1 \n");
                kSql.append("                  from " + T_NCM_STDCostDataResDetail + " resDetail \n");
                kSql.append("                 where resDetail.FEstimateSchemeID = ? \n");
                kSql.append("                  and resDetail.FParentMaterialID = ? \n");
                kSql.append("                  and resDetail.FStdPrice IS NOT NULL \n");
                kSql.append("                  and resDetail.FStdPrice <> 0 \n");
                kSql.append("                ) \n");
                kSql.append("        ) \n");
                rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{stdCostDataID, estimateSchemeID, materialID, estimateSchemeID, materialID});
                if (!rst.next()) break block8;
                bl = true;
            }
            catch (Exception exc) {
                try {
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                    throw new BOSException((Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return false;
    }

    @Override
    protected List _getStdCostDataIds(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        if (filter == null) {
            return ids;
        }
        String companyID = null;
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            return ids;
        }
        companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        IRowSet rst = null;
        try {
            String T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataMatDetail");
            String T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataResDetail");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.ncm.std.bill.app", "STDCostDataQuery"));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("estimateScheme.id"));
            sic.add(new SelectorItemInfo("estimateScheme.number"));
            sic.add(new SelectorItemInfo("storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("stdAmount"));
            view.setSelector(sic);
            queryExecutor.setObjectView(view);
            String SQL = queryExecutor.getSQL();
            StringBuffer kSql = new StringBuffer();
            kSql.append("   ( \n");
            kSql.append("    exists (select 1 \n");
            kSql.append("               from " + T_NCM_STDCostDataMatDetail + " matDetail \n");
            kSql.append("              where matDetail.FEstimateSchemeID = \"ESTIMATESCHEME\".FID \n");
            kSql.append("                and matDetail.FParentMaterialID = \"MATERIAL\".FID \n");
            kSql.append("                and matDetail.FParentMaterialID <> matDetail.FMaterialID \n");
            kSql.append("                and matDetail.FStdPrice IS NOT NULL \n");
            kSql.append("                and matDetail.FStdPrice <> 0 \n");
            kSql.append("     )  \n");
            kSql.append("     or \n");
            kSql.append("     exists (select 1 \n");
            kSql.append("               from " + T_NCM_STDCostDataResDetail + " resDetail \n");
            kSql.append("              where resDetail.FEstimateSchemeID = \"ESTIMATESCHEME\".FID \n");
            kSql.append("                and resDetail.FParentMaterialID = \"MATERIAL\".FID \n");
            kSql.append("                and resDetail.FStdPrice IS NOT NULL \n");
            kSql.append("                and resDetail.FStdPrice <> 0 \n");
            kSql.append("            ) \n");
            kSql.append("     ) \n");
            SQL = SQL.replaceAll("WHERE ", "WHERE " + kSql.toString() + " AND ");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)SQL.toString());
            HashMap dump = new HashMap();
            while (rst.next()) {
                String id = rst.getString("id");
                if (dump.containsKey(id)) continue;
                dump.put(id, null);
                ids.add(id);
            }
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return ids;
    }

    @Override
    protected Map _getDetail(Context ctx, String stdCostDataId) throws BOSException, EASBizException {
        String companyID;
        String materialID;
        String estimateSchemeID;
        ArrayList<Object[]> dataList;
        String caption;
        StringBuffer kSql;
        String T_NCM_STDCostDataResDetail;
        String T_NCM_STDCostDataMatDetail;
        IRowSet rst;
        HashMap detailMap;
        block8: {
            detailMap = new HashMap();
            if (StringUtils.isEmpty((String)stdCostDataId)) {
                return detailMap;
            }
            rst = null;
            T_NCM_STDCostDataMatDetail = null;
            T_NCM_STDCostDataResDetail = null;
            kSql = new StringBuffer();
            caption = null;
            dataList = new ArrayList<Object[]>();
            estimateSchemeID = null;
            materialID = null;
            companyID = null;
            kSql.setLength(0);
            kSql.append(" SELECT scheme.FID AS schemeID, \n");
            kSql.append("        scheme.FNumber AS schemeNumber, \n");
            kSql.append("        scheme.FName_" + ctx.getLocale() + " AS schemeName, \n");
            kSql.append("        mat.FID AS matID, \n");
            kSql.append("        mat.FNumber AS matNumber, \n");
            kSql.append("        mat.FName_" + ctx.getLocale() + " AS matName, \n");
            kSql.append("        costData.FCompanyOrg AS companyID \n");
            kSql.append(" FROM   T_NCM_STDCostData costData \n");
            kSql.append("        INNER JOIN T_NCM_SCEstimateScheme scheme \n");
            kSql.append("          ON costData.FEstimateSchemeID = scheme.FID \n");
            kSql.append("        INNER JOIN T_BD_Material mat \n");
            kSql.append("          ON costData.FMaterialID = mat.FID \n");
            kSql.append(" WHERE  costData.FID = ? \n");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{stdCostDataId});
            if (rst.next()) {
                String schemeNumber = rst.getString("schemeNumber");
                String schemeName = rst.getString("schemeName");
                String matNumber = rst.getString("matNumber");
                String matName = rst.getString("matName");
                caption = schemeNumber + " " + schemeName + "," + matNumber + " " + matName;
                estimateSchemeID = rst.getString("schemeID");
                materialID = rst.getString("matID");
                companyID = rst.getString("companyID");
                break block8;
            }
            HashMap schemeNumber = detailMap;
            SQLUtils.cleanup((ResultSet)rst);
            return schemeNumber;
        }
        try {
            T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataMatDetail");
            T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataResDetail");
            kSql.setLength(0);
            kSql.append(" SELECT   costItem.FName_" + ctx.getLocale() + " AS FCostItemName, \n");
            kSql.append("          detail.FResTypeName AS FResTypeName, \n");
            kSql.append("          mu.FName_" + ctx.getLocale() + " AS FMeasureUnitName, \n");
            kSql.append("          detail.FQty AS FQty, \n");
            kSql.append("          detail.FStdPrice AS FStdPrice, \n");
            kSql.append("          detail.FStdAmount AS FStdAmount \n");
            kSql.append(" FROM     ((SELECT matDetail.FChildCostItemID AS FCostItemID, \n");
            kSql.append("                   material.FName_" + ctx.getLocale() + " AS FResTypeName, \n");
            kSql.append("                   matDetail.FMeasureUnitID AS FMeasureUnitID, \n");
            kSql.append("                   matDetail.FChildQty AS FQty, \n");
            kSql.append("                   matDetail.FChildStdPrice AS FStdPrice, \n");
            kSql.append("                   matDetail.FChildAmount AS FStdAmount \n");
            kSql.append("            FROM   " + T_NCM_STDCostDataMatDetail + " matDetail \n");
            kSql.append("                   LEFT OUTER JOIN T_BD_Material material \n");
            kSql.append("                     ON matDetail.FMaterialID = material.FID \n");
            kSql.append("            WHERE  matDetail.FEstimateSchemeID = ? \n");
            kSql.append("                   AND matDetail.FParentMaterialID = ?) \n");
            kSql.append("           UNION  \n");
            kSql.append("           (SELECT resDetail.FResCostItemID AS FCostItemID, \n");
            kSql.append("                   resType.FName_" + ctx.getLocale() + " AS FResTypeName, \n");
            kSql.append("                   resDetail.FResMeasureUnitID AS FMeasureUnitID, \n");
            kSql.append("                   resDetail.FResQty AS FQty, \n");
            kSql.append("                   resDetail.FResStdPrice AS FStdPrice, \n");
            kSql.append("                   resDetail.FResAmount AS FStdAmount \n");
            kSql.append("            FROM   " + T_NCM_STDCostDataResDetail + " resDetail \n");
            kSql.append("                   LEFT OUTER JOIN T_NCM_SCResourceType resType \n");
            kSql.append("                     ON resDetail.FResourceTypeID = resType.FID \n");
            kSql.append("            WHERE  resDetail.FEstimateSchemeID = ? \n");
            kSql.append("                   AND resDetail.FParentMaterialID = ?)) detail \n");
            kSql.append("          LEFT OUTER JOIN T_NCM_CostItem costItem \n");
            kSql.append("            ON detail.FCostItemID = costItem.FID \n");
            kSql.append("          INNER JOIN T_BD_MeasureUnit mu \n");
            kSql.append("            ON detail.FMeasureUnitID = mu.FID \n");
            kSql.append(" ORDER BY costItem.FNumber ASC, \n");
            kSql.append("          detail.FResTypeName ASC \n");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{estimateSchemeID, materialID, estimateSchemeID, materialID});
            while (rst.next()) {
                Object[] values = new Object[]{rst.getString("FCostItemName"), rst.getString("FResTypeName"), rst.getString("FMeasureUnitName"), rst.getBigDecimal("FQty"), rst.getBigDecimal("FStdPrice"), rst.getBigDecimal("FStdAmount")};
                dataList.add(values);
            }
            detailMap.put(caption, dataList);
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return detailMap;
    }

    @Override
    protected void _removeDetail(Context ctx, String stdCostDataID) throws BOSException, EASBizException {
        IRowSet rst;
        String companyID;
        String materialID;
        String estimateSchemeID;
        block6: {
            if (StringUtils.isEmpty((String)stdCostDataID)) {
                return;
            }
            estimateSchemeID = null;
            materialID = null;
            companyID = null;
            rst = null;
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)" SELECT FEstimateSchemeID,FMaterialID,FCompanyOrg FROM T_NCM_STDCostData WHERE FID = ? ", (Object[])new Object[]{stdCostDataID});
            if (!rst.next()) break block6;
            estimateSchemeID = rst.getString("FEstimateSchemeID");
            materialID = rst.getString("FMaterialID");
            companyID = rst.getString("FCompanyOrg");
        }
        SQLUtils.cleanup((ResultSet)rst);
        return;
        try {
            String T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataMatDetail");
            String T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataResDetail");
            NCMDbUtil.execute((Context)ctx, (String)("DELETE FROM " + T_NCM_STDCostDataMatDetail + " WHERE FEstimateSchemeID = ? AND FParentMaterialID = ? "), (Object[])new Object[]{estimateSchemeID, materialID});
            NCMDbUtil.execute((Context)ctx, (String)("DELETE FROM " + T_NCM_STDCostDataResDetail + " WHERE FEstimateSchemeID = ? AND FParentMaterialID = ? "), (Object[])new Object[]{estimateSchemeID, materialID});
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    protected boolean isSupportBotp() {
        return false;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("estimateScheme.name"));
        sic.add(new SelectorItemInfo("material.name"));
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk, sic);
        return info.getLogInfo();
    }

    @Override
    protected Map _copyMatStdCost(Context ctx, Map param) throws BOSException, EASBizException {
        List dataInRows = (List)param.get("dataInRows");
        if (dataInRows == null || dataInRows.size() <= 0) {
            return null;
        }
        HashMap validDataMap = new HashMap();
        StringBuffer errorData_checked = new StringBuffer();
        HashMap errorData_hasDetail = new HashMap();
        HashSet schemeIdSet = new HashSet();
        ArrayList checkedDataList = new ArrayList();
        this.checkEstimateSchema(ctx, dataInRows, schemeIdSet, checkedDataList, errorData_checked);
        if (schemeIdSet.size() > checkedDataList.size()) {
            String companyID = (String)param.get("companyID");
            this.checkHasDetail(ctx, companyID, dataInRows, checkedDataList, errorData_hasDetail, validDataMap);
            this.updataStdMatPrice(ctx, validDataMap);
        }
        return this.returnResult(errorData_checked, errorData_hasDetail, ctx);
    }

    private void checkEstimateSchema(Context ctx, List dataInRows, Set schemeIdSet, List checkedDataList, StringBuffer errorData_checked) throws BOSException {
        Map tempData = null;
        for (int i = 0; i < dataInRows.size(); ++i) {
            tempData = (Map)dataInRows.get(i);
            String schemeId = (String)tempData.get("schemeId");
            if (schemeIdSet.contains(schemeId)) continue;
            schemeIdSet.add(schemeId);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)schemeIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        STDCostEstimateSchemeCollection coll = STDCostEstimateSchemeFactory.getLocalInstance(ctx).getSTDCostEstimateSchemeCollection(view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                STDCostEstimateSchemeInfo info = coll.get(i);
                if (!STDCostEstimateSchemeStateEnum.check.equals((Object)info.getState())) continue;
                String schemeNumber = info.getNumber();
                String schemeName = info.getName();
                errorData_checked.append("\u3010" + schemeNumber + "\u3001" + schemeName + "\u3011");
                checkedDataList.add(info.getId().toString());
            }
        }
    }

    private void checkHasDetail(Context ctx, String companyID, List dataInRows, List checkedDataList, Map errorData_hasDetail, Map validDataMap) throws EASBizException, BOSException {
        String T_NCM_STDCostDataMatDetail = null;
        String T_NCM_STDCostDataResDetail = null;
        try {
            T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataMatDetail");
            T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostDataResDetail");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Map tempData = null;
        for (int i = 0; i < dataInRows.size(); ++i) {
            tempData = (Map)dataInRows.get(i);
            if (checkedDataList.contains((String)tempData.get("schemeId")) || this.checkHasDetail(ctx, tempData, T_NCM_STDCostDataMatDetail, T_NCM_STDCostDataResDetail, errorData_hasDetail)) continue;
            this.setDataInValidMap(tempData, validDataMap);
        }
    }

    private void updataStdMatPrice(Context ctx, Map validDataMap) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_NCM_STDCostData set FStdAmount = ? where FID = ?");
            pstmt = conn.prepareStatement(sb.toString());
            Set set = validDataMap.entrySet();
            for (Map.Entry entry : set) {
                String id = (String)entry.getKey();
                BigDecimal stdAmount = null;
                if (entry.getValue() != null) {
                    stdAmount = (BigDecimal)entry.getValue();
                }
                pstmt.setString(2, id);
                pstmt.setBigDecimal(1, stdAmount);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private Map returnResult(StringBuffer errorData_checked, Map errorData_hasDetail, Context ctx) {
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        if (errorData_checked.length() > 0) {
            result.put("errorData_checked", ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"0_STDCostDataControllerBean", (Locale)ctx.getLocale()) + errorData_checked + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"1_STDCostDataControllerBean", (Locale)ctx.getLocale()));
        }
        if (errorData_hasDetail.size() > 0) {
            StringBuffer error = new StringBuffer();
            Set keySet = errorData_hasDetail.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                StringBuffer msg = (StringBuffer)errorData_hasDetail.get(it.next());
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"2_STDCostDataControllerBean", (Locale)ctx.getLocale()));
                if (it.hasNext()) {
                    msg.append("\n");
                }
                error.append(msg);
            }
            result.put("errorData_hasDetail", error);
        }
        return result;
    }

    private void setDataInValidMap(Map tempData, Map validDataMap) {
        String id = (String)tempData.get("id");
        BigDecimal matStdPrice = null;
        if (tempData.get("matStdPrice") != null && !"".equals(tempData.get("matStdPrice"))) {
            matStdPrice = new BigDecimal((String)tempData.get("matStdPrice"));
        }
        validDataMap.put(id, matStdPrice);
    }

    private boolean checkHasDetail(Context ctx, Map tempData, String T_NCM_STDCostDataMatDetail, String T_NCM_STDCostDataResDetail, Map errorData_hasDetail) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT 1 ");
        kSql.append("   FROM T_NCM_STDCostData ");
        kSql.append("  WHERE FID = ? ");
        kSql.append("   AND ( \n");
        kSql.append("    \t exists (select 1 \n");
        kSql.append("                  from " + T_NCM_STDCostDataMatDetail + " matDetail \n");
        kSql.append("                 where matDetail.FEstimateSchemeID = ? \n");
        kSql.append("                   and matDetail.FParentMaterialID = ? \n");
        kSql.append("                   and matDetail.FParentMaterialID <> matDetail.FMaterialID \n");
        kSql.append("                   and matDetail.FStdPrice IS NOT NULL \n");
        kSql.append("                   and matDetail.FStdPrice <> 0 \n");
        kSql.append("               )  \n");
        kSql.append("        or \n");
        kSql.append("        exists (select 1 \n");
        kSql.append("                  from " + T_NCM_STDCostDataResDetail + " resDetail \n");
        kSql.append("                 where resDetail.FEstimateSchemeID = ? \n");
        kSql.append("                  and resDetail.FParentMaterialID = ? \n");
        kSql.append("                  and resDetail.FStdPrice IS NOT NULL \n");
        kSql.append("                  and resDetail.FStdPrice <> 0 \n");
        kSql.append("                ) \n");
        kSql.append("        ) \n");
        String stdCostDataID = (String)tempData.get("id");
        String materialID = (String)tempData.get("matId");
        String estimateSchemeID = (String)tempData.get("schemeId");
        IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{stdCostDataID, estimateSchemeID, materialID, estimateSchemeID, materialID});
        try {
            if (rst.next()) {
                String matNumber = (String)tempData.get("matNumber");
                String matName = (String)tempData.get("matName");
                if (errorData_hasDetail.containsKey(estimateSchemeID)) {
                    StringBuffer sb = (StringBuffer)errorData_hasDetail.get(estimateSchemeID);
                    sb.append("\u3001");
                    sb.append("\u3010" + matNumber + "\u3001" + matName + "\u3011");
                } else {
                    StringBuffer sb = new StringBuffer();
                    String schemeNumber = (String)tempData.get("schemeNumber");
                    String schemeName = (String)tempData.get("schemeName");
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"3_STDCostDataControllerBean", (Locale)ctx.getLocale()) + schemeNumber + "\u3001" + schemeName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"4_STDCostDataControllerBean", (Locale)ctx.getLocale()));
                    sb.append("\u3010" + matNumber + "\u3001" + matName + "\u3011");
                    errorData_hasDetail.put(estimateSchemeID, sb);
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String[] _getDebugKSql(Context ctx, String companyId, String estimateSchemeId, String materialId) throws BOSException, EASBizException {
        String T_NCM_STDCostBomPath = null;
        String T_NCM_STDCostRollUpMat = null;
        String T_NCM_STDCostRollUpRes = null;
        String T_NCM_STDCostDataMatDetail = null;
        String T_NCM_STDCostDataResDetail = null;
        try {
            T_NCM_STDCostBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostBomPath");
            T_NCM_STDCostRollUpMat = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostRollUpMat");
            T_NCM_STDCostRollUpRes = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostRollUpRes");
            T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataMatDetail");
            T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataResDetail");
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        StringBuffer bomPath = new StringBuffer();
        bomPath.append("SELECT pm.FName_l2,                                                      \n");
        bomPath.append("       cm.FName_l2,                                                      \n");
        bomPath.append("       bomPath.FBomPath,                                                 \n");
        bomPath.append("       bomPath.FLevelCode,                                               \n");
        bomPath.append("       bomPath.FBomId,                                                   \n");
        bomPath.append("       bomPath.FBomEntryId                                               \n");
        bomPath.append(" FROM  " + T_NCM_STDCostBomPath + " bomPath                              \n");
        bomPath.append("       INNER JOIN T_BD_Material pm ON bomPath.FParentMaterialId = pm.FID \n");
        bomPath.append("       INNER JOIN T_BD_Material cm ON bomPath.FMaterialId = cm.FID       \n");
        bomPath.append("WHERE  1 = 1                                                             \n");
        bomPath.append("  AND  bomPath.FParentMaterialId='" + materialId + "'                    \n");
        bomPath.append("  --AND  bomPath.fmaterialid=''                          \n");
        bomPath.append("ORDER BY bomPath.FLevelCode,bomPath.FBomPath                             \n");
        StringBuffer rollUpMat = new StringBuffer();
        rollUpMat.append("SELECT pm.FName_l2,rollMat.FStdPrice,cm.FName_l2,rollMat.FChildQty,     \n");
        rollUpMat.append("       rollMat.FChildStdPrice,rollMat.FChildAmount,rollMat.FSPreadPath, \n");
        rollUpMat.append("       rollMat.FLowLevelCode                                            \n");
        rollUpMat.append("FROM   " + T_NCM_STDCostRollUpMat + " rollMat                           \n");
        rollUpMat.append("       INNER JOIN T_BD_Material pm ON rollMat.FParentMaterialId = pm.FID\n");
        rollUpMat.append("       INNER JOIN T_BD_Material cm ON rollMat.FMaterialId = cm.FID      \n");
        rollUpMat.append("WHERE  1 = 1                                                            \n");
        rollUpMat.append("  AND  rollMat.FEstimateSchemeId='" + estimateSchemeId + "'             \n");
        rollUpMat.append("  AND  rollMat.FParentmaterialId='" + materialId + "'                   \n");
        rollUpMat.append("  --AND  rollMat.FMaterialId=''                                         \n");
        rollUpMat.append("ORDER BY rollMat.FLowLevelCode,rollMat.FSPreadPath;                     \n");
        StringBuffer rollUpRes = new StringBuffer();
        rollUpRes.append("SELECT pm.FName_l2,rollRes.FStdPrice,res.fname_l2,                              \n");
        rollUpRes.append("       rollRes.FResQty,rollRes.FResStdPrice,rollRes.FResAmount                  \n");
        rollUpRes.append("FROM   " + T_NCM_STDCostRollUpRes + " rollRes                                   \n");
        rollUpRes.append("       INNER JOIN T_BD_Material pm ON rollRes.FParentMaterialId = pm.fid        \n");
        rollUpRes.append("       INNER JOIN T_NCM_ScresourceType res ON rollRes.FResourceTypeID = res.FID \n");
        rollUpRes.append("WHERE  1 = 1                                                                    \n");
        rollUpRes.append("  AND rollRes.FEstimateSchemeId = '" + estimateSchemeId + "'                    \n");
        rollUpRes.append("  AND rollRes.FParentMaterialId = '" + materialId + "'                          \n");
        StringBuffer matDetail = new StringBuffer();
        matDetail.append("SELECT   pm.FName_l2,matDetail.FStdPrice,cm.FName_l2,matDetail.FChildQty,     \n");
        matDetail.append("        matDetail.FChildStdPrice,matDetail.FChildAmount,                      \n");
        matDetail.append("        matDetail.FSPreadPath,matDetail.FLowLevelCode                         \n");
        matDetail.append("FROM    " + T_NCM_STDCostDataMatDetail + " matDetail                          \n");
        matDetail.append("        INNER JOIN T_BD_Material pm ON matDetail.FParentMaterialId = pm.FID   \n");
        matDetail.append("        INNER JOIN T_BD_Material cm ON matDetail.FMaterialId = cm.FID         \n");
        matDetail.append("WHERE    1 = 1                                                                \n");
        matDetail.append(" AND  matDetail.FEstimateSchemeID='" + estimateSchemeId + "'                  \n");
        matDetail.append(" AND  matDetail.FParentMaterialId='" + materialId + "'                        \n");
        matDetail.append(" --AND  matDetail.FMaterialId=''                                              \n");
        matDetail.append("ORDER BY matDetail.FLowLevelCode,matDetail.FSPreadPath;                       \n");
        StringBuffer resDetail = new StringBuffer();
        resDetail.append("SELECT pm.FName_l2,resDetail.FStdPrice,res.FName_l2,                               \n");
        resDetail.append("       resDetail.FResQty,resDetail.FResStdPrice,resDetail.FResAmount               \n");
        resDetail.append("FROM   " + T_NCM_STDCostDataResDetail + " resDetail                                \n");
        resDetail.append("       INNER JOIN T_BD_Material pm ON resDetail.FParentMaterialId = pm.FID         \n");
        resDetail.append("       INNER JOIN T_NCM_SCResourceType res ON resDetail.FResourceTypeID = res.FID  \n");
        resDetail.append("WHERE  1 = 1                                                                       \n");
        resDetail.append("  AND resDetail.FEstimateSchemeID='" + estimateSchemeId + "'                       \n");
        resDetail.append("  AND resDetail.fparentmaterialid='" + materialId + "'                              \n");
        return new String[]{bomPath.toString(), rollUpMat.toString(), rollUpRes.toString(), matDetail.toString(), resDetail.toString()};
    }
}

