/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.basedata.ISTDCostEstimateScheme;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.ISTDCostEstimateType;
import com.kingdee.eas.ncm.std.bill.STDCostDataFactory;
import com.kingdee.eas.ncm.std.bill.STDCostDataInfo;
import com.kingdee.eas.ncm.std.bill.STDCostDataSourceTypeEnum;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeCollection;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeFactory;
import com.kingdee.eas.ncm.std.bill.app.STDCostDataImportVerify;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostDataImport
extends AbstractNCMDataImport {
    private static Logger logger = Logger.getLogger((String)STDCostDataImport.class.getName());
    private STDCostDataImportVerify verify = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDCostDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDCostDataInfo info = null;
        try {
            info = this.parse(ctx, hsData);
            this.getVerify().verify(ctx, info, this.isSltImportUpdate());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("estimateScheme.number", this.getNotBlankString(rs.getString("estimateScheme.number")));
            result.put("estimateScheme.name", this.getNotBlankString(rs.getString("estimateScheme.name")));
            result.put("stdAmount", this.getNotBlankString(rs.getString("stdAmount")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private STDCostDataInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        STDCostDataInfo info = new STDCostDataInfo();
        Object data = null;
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(1001, currCompany.getId().toString());
        info.setCompanyOrg(currCompany);
        info.setCalculatePeriod(currentPeriod);
        data = this.getData(hsData, "estimateScheme.number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setEstimateScheme(this.getEstimateSchemeByNumber(ctx, data.toString(), currCompany.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"5_STDCostDataImport", (Locale)ctx.getLocale())));
        }
        if ((data = this.getData(hsData, "material.number")) != null && data.toString().trim().length() > 0) {
            MaterialInfo material = this.getMaterialByNumber(ctx, data.toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"6_STDCostDataImport", (Locale)ctx.getLocale()));
            info.setMaterial(material);
            if (info.getEstimateScheme() != null && info.getEstimateScheme().getStorageOrgUnit() != null && material != null && material.getId() != null) {
                EntityViewInfo view = new EntityViewInfo();
                ISTDCostEstimateType iType = STDCostEstimateTypeFactory.getLocalInstance(ctx);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)info.getEstimateScheme().getStorageOrgUnit().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("estimateType");
                STDCostEstimateTypeCollection coll = iType.getSTDCostEstimateTypeCollection(view);
                if (coll.size() > 0 && coll.get(0).getEstimateType() != null) {
                    info.setDataType(coll.get(0).getEstimateType());
                } else {
                    IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)"select FCalculateType from T_BD_MaterialCompanyInfo where FMaterialID = ? and FCompanyID = ?", (Object[])new Object[]{material.getId().toString(), currCompany.getId().toString()});
                    try {
                        if (rst.next()) {
                            int calcuType = rst.getInt(1);
                            if (2 == calcuType || 1 == calcuType) {
                                info.setDataType(STDCostDataSourceTypeEnum.BOMRollUp);
                            } else {
                                info.setDataType(STDCostDataSourceTypeEnum.manual);
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
        if ((data = this.getData(hsData, "stdAmount")) instanceof BigDecimal) {
            info.setStdAmount((BigDecimal)data);
        } else if (data instanceof String) {
            try {
                info.setStdAmount(new BigDecimal(data.toString()));
            }
            catch (Exception ex) {
                info.setStdAmount(null);
            }
        }
        info.setBillStatus(BillBaseStatusEnum.ADD);
        info.setNumber(String.valueOf(SysUtil.getAppServerTime((Context)ctx).getTime()));
        return info;
    }

    private STDCostDataImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new STDCostDataImportVerify();
        }
        return this.verify;
    }

    private STDCostEstimateSchemeInfo getEstimateSchemeByNumber(Context ctx, String number, String companyID, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        view.setFilter(filter);
        ISTDCostEstimateScheme iScheme = STDCostEstimateSchemeFactory.getLocalInstance(ctx);
        STDCostEstimateSchemeCollection col = null;
        try {
            col = iScheme.getSTDCostEstimateSchemeCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostDataImport.getExceptionMessage(fieldName, ctx));
    }

    private MaterialInfo getMaterialByNumber(Context ctx, String number, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCollection col = null;
        try {
            col = iMaterial.getMaterialCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostDataImport.getExceptionMessage(fieldName, ctx));
    }

    private static String getExceptionMessage(String fieldName, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"7_STDCostDataImport", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"8_STDCostDataImport", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"9_STDCostDataImport", (Locale)ctx.getLocale());
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }
}

