/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.bill.STDCostDataSourceTypeEnum;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeInfo;
import com.kingdee.eas.ncm.std.bill.app.AbstractSTDCostEstimateTypeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class STDCostEstimateTypeControllerBean
extends AbstractSTDCostEstimateTypeControllerBean {
    private static final long serialVersionUID = -2676097459535851203L;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_STDCostEstimateType";
    }

    @Override
    protected void _generateData(Context ctx, String companyID, String storageOrgUnitID, boolean isCover) throws BOSException, EASBizException {
        StorageOrgUnitInfo storage;
        String logInfo = "";
        if (!StringUtils.isEmpty((String)storageOrgUnitID) && (storage = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitID)))) != null && storage.getName() != null) {
            logInfo = storage.getName();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"generateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"std_STDCostEstimateType_gen");
        if (StringUtils.isEmpty((String)companyID)) {
            return;
        }
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (!sysctrol.isStart(1001, companyID)) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        String periodId = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyID).getId().toString();
        String userId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getId() != null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" INSERT INTO T_NCM_STDCostEstimateType \n");
        kSql.append("            (FID, \n");
        kSql.append("             FStorageOrgUnitID, \n");
        kSql.append("             FMaterialID, \n");
        kSql.append("             FEstimateType, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FBillStatus, \n");
        kSql.append("             FCreatorID, \n");
        kSql.append("             FCreateTime) \n");
        kSql.append(" SELECT   NEWBOSID('A2A20364') AS FID, \n");
        kSql.append("          materialInventory.FOrgUnit AS FStorageOrgUnitID, \n");
        kSql.append("          material.FID AS FMaterialID, \n");
        kSql.append("          CASE materialCompanyInfo.FCalculateType  \n");
        kSql.append("            WHEN 1 THEN 2 \n");
        kSql.append("            WHEN 2 THEN 2 \n");
        kSql.append("            ELSE 1 \n");
        kSql.append("          END AS FEstimateType, \n");
        kSql.append("          materialCompanyInfo.FCompanyID AS FCompanyOrg, \n");
        kSql.append("          '" + periodId + "' AS FCalculatePeriod, \n");
        kSql.append("          1, \n");
        kSql.append("          '" + userId + "' AS FCreatorID, \n");
        kSql.append("          now() AS FCreateTime \n");
        kSql.append(" FROM     T_BD_Material material \n");
        kSql.append("          INNER JOIN T_BD_MaterialCompanyInfo materialCompanyInfo \n");
        kSql.append("            ON material.FID = materialCompanyInfo.FMaterialID \n");
        kSql.append("          INNER JOIN T_BD_MaterialInventory materialInventory \n");
        kSql.append("            ON material.FID = materialInventory.FMaterialID \n");
        kSql.append(" WHERE    materialCompanyInfo.FCompanyID = ? \n");
        kSql.append("          AND materialCompanyInfo.FStatus = 1 \n");
        kSql.append("          AND materialInventory.FOrgUnit = ? \n");
        kSql.append("          AND materialInventory.FStatus = 1 \n");
        if (!isCover) {
            kSql.append("          AND NOT EXISTS (SELECT FID \n");
            kSql.append("                            FROM T_NCM_STDCostEstimateType \n");
            kSql.append("                           WHERE FStorageOrgUnitID = ? \n");
            kSql.append("                             AND FMaterialID = material.FID \n");
            kSql.append("                            ) \n");
        }
        kSql.append(" ORDER BY materialInventory.FOrgUnit, \n");
        kSql.append("          material.FID, \n");
        kSql.append("          materialCompanyInfo.FCalculateType \n");
        NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyID, storageOrgUnitID, storageOrgUnitID});
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _updateData(Context ctx, Map data, List deletePks, ArrayList addObjList) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (data != null && !data.isEmpty()) {
            for (String id : data.keySet()) {
                set.add(id);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("storageOrgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        StringBuffer logInfo = new StringBuffer();
        CoreBaseCollection cbc = this.getCollection(ctx, view);
        for (STDCostEstimateTypeInfo info : cbc) {
            String str = info.getLogInfo();
            if (str == null || str.length() <= 0) continue;
            logInfo.append(str).append(",");
        }
        if (logInfo.length() > 0) {
            logInfo.deleteCharAt(logInfo.length() - 1);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"updateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"std_STDCostEstimateType_save");
        if (deletePks != null && !deletePks.isEmpty()) {
            IObjectPK[] pks = new IObjectPK[deletePks.size()];
            int size = deletePks.size();
            for (int i = 0; i < size; ++i) {
                pks[i] = (IObjectPK)deletePks.get(i);
            }
            super._delete(ctx, pks);
        }
        if (!(data != null && !data.isEmpty() || addObjList != null && addObjList.size() != 0)) {
            return;
        }
        for (String id : data.keySet()) {
            if (StringUtils.isEmpty((String)id)) continue;
            String type = null;
            if (data.get(id) instanceof STDCostDataSourceTypeEnum) {
                type = String.valueOf(((STDCostDataSourceTypeEnum)((Object)data.get(id))).getValue());
            } else if (data.get(id) instanceof BizEnumValueDTO) {
                type = ((BizEnumValueDTO)data.get(id)).getValue().toString();
            }
            if (type == null) continue;
            NCMDbUtil.execute((Context)ctx, (String)" update T_NCM_STDCostEstimateType set FEstimateType = ? where FID = ? ", (Object[])new Object[]{new Integer(type), id});
        }
        if (addObjList != null && addObjList.size() > 0) {
            ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            PeriodInfo periodInfo = null;
            String companyID = null;
            if (addObjList.size() > 0) {
                if (ContextUtil.getCurrentFIUnit((Context)ctx) != null) {
                    companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                } else {
                    IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    OrgUnitCollection coll = iOUR.getToUnit(((STDCostEstimateTypeInfo)addObjList.get(0)).getStorageOrgUnit().getId().toString(), 4, 1);
                    companyID = coll.get(0).getId().toString();
                }
                periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
            }
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append(" INSERT INTO T_NCM_STDCostEstimateType \n");
            sqlInsert.append("            (FID, \n");
            sqlInsert.append("             FStorageOrgUnitID, \n");
            sqlInsert.append("             FMaterialID, \n");
            sqlInsert.append("             FEstimateType, \n");
            sqlInsert.append("             FCompanyOrg, \n");
            sqlInsert.append("             FCalculatePeriod, \n");
            sqlInsert.append("             FBillStatus, \n");
            sqlInsert.append("             FCreatorID, \n");
            sqlInsert.append("             FCreateTime) \n").append(" values (?,?,?,?,?,?,1,?,now())");
            Connection conn = null;
            PreparedStatement pstmtInsert = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmtInsert = conn.prepareStatement(sqlInsert.toString());
                for (int i = 0; i < addObjList.size(); ++i) {
                    pstmtInsert.setString(1, ((STDCostEstimateTypeInfo)addObjList.get(i)).getId().toString());
                    pstmtInsert.setString(2, ((STDCostEstimateTypeInfo)addObjList.get(i)).getStorageOrgUnit().getId().toString());
                    pstmtInsert.setString(3, ((STDCostEstimateTypeInfo)addObjList.get(i)).getMaterial().getId().toString());
                    pstmtInsert.setInt(4, ((STDCostEstimateTypeInfo)addObjList.get(i)).getEstimateType().getValue());
                    pstmtInsert.setString(5, companyID);
                    pstmtInsert.setString(6, periodInfo == null ? "period null" : String.valueOf(periodInfo.getId()));
                    pstmtInsert.setString(7, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    pstmtInsert.addBatch();
                }
                pstmtInsert.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        }
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FNumber FStorageNumber, m.FNumber FMaterialNumber \n");
        sql.append("from T_NCM_STDCostEstimateType t \n");
        sql.append("join T_ORG_Storage s on s.FID = t.FStorageOrgUnitID \n");
        sql.append("join T_BD_Material m on m.FID = t.FMaterialID \n");
        sql.append("where t.FCompanyOrg = '" + companyID + "' \n");
        sql.append("group by s.FNumber, m.FNumber \n");
        sql.append("having count(1) > 1 \n");
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer message = new StringBuffer();
            boolean flag = false;
            message.append("\n");
            while (rs.next()) {
                flag = true;
                message.append("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801[");
                message.append(rs.getString("FStorageNumber")).append("] \u7269\u6599\u7f16\u7801 [").append(rs.getString("FMaterialNumber") + "] \n");
            }
            Object[] messages = new String[]{message.toString()};
            if (flag) {
                throw new NcmBillException(NcmBillException.CHECK_COMBIN, messages);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("material.name"));
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk, sic);
        return info.getLogInfo();
    }

    protected boolean isSupportBotp() {
        return false;
    }

    protected void checkStart(Context ctx, IObjectCollection billColl) throws BOSException, EASBizException {
    }
}

