/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.CMBillBaseCollection;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeCollection;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeFactory;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeInfo;
import com.kingdee.eas.ncm.std.bill.ISTDCostResourceTypeMaterialPrice;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeMaterialPriceFactory;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeMaterialPriceInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class STDCostResourceTypeMaterialPriceImport
extends AbstractNCMDataImport {
    private static Logger logger = Logger.getLogger((String)STDCostResourceTypeMaterialPriceImport.class.getName());
    private Map schemeMap = new HashMap();
    private Map resTypeMap = new HashMap();
    private Map materialMap = new HashMap();
    private Set storageIds = null;
    private IQueryExecutor queryExecutor = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDCostResourceTypeMaterialPriceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDCostResourceTypeMaterialPriceInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("scheme.number", this.getNotBlankString(rs.getString("estimateScheme.number")));
            result.put("scheme.name", this.getNotBlankString(rs.getString("estimateScheme.name")));
            result.put("resType.number", this.getNotBlankString(rs.getString("resourceType.number")));
            result.put("resType.name", this.getNotBlankString(rs.getString("resourceType.name")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            BigDecimal stdPrice = rs.getBigDecimal("stdPrice");
            if (stdPrice != null) {
                result.put("stdPrice", stdPrice.setScale(4, 4).toString());
            } else {
                result.put("stdPrice", "");
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    private Set getStorageIds(Context ctx, String companyOrgUnitId) throws EASBizException, BOSException {
        if (this.storageIds == null) {
            this.storageIds = new HashSet();
            IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgUnitId, 1, 4);
            for (int i = 0; i < ccColl.size(); ++i) {
                this.storageIds.add(ccColl.get(i).getId().toString());
            }
            if (this.storageIds.size() == 0) {
                this.storageIds.add("aaaaaaa11111111");
            }
        }
        return this.storageIds;
    }

    private EntityViewInfo getSchemeEntityViewInfo(Context ctx, String companyOrgUnitId, PeriodInfo currPeriod, String number) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        Set storageIds = this.getStorageIds(ctx, companyOrgUnitId);
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)currPeriod.getEndDate(), CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("storageOrgUnit.id");
        view.setSelector(selector);
        return view;
    }

    private EntityViewInfo getResTypeEntityViewInfo(Context ctx, String companyOrgUnitId, String number) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        view.setSelector(selector);
        return view;
    }

    private EntityViewInfo getMaterialEntityViewInfo(Context ctx, String companyOrgUnitId, String storageOrgUnitId, String number) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)companyOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("stdEstimateType.estimateType", (Object)2, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        return view;
    }

    private STDCostResourceTypeMaterialPriceInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        MaterialInfo material;
        STDResourceTypeInfo resType;
        EntityViewInfo view;
        STDCostEstimateSchemeInfo scheme;
        STDCostResourceTypeMaterialPriceInfo info = new STDCostResourceTypeMaterialPriceInfo();
        Object data = null;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyOrgUnitId = company.getId().toString();
        info.setCompanyOrg(company);
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(1001, company.getId().toString());
        String value = this.getStringValue(hsData, "scheme.number");
        if (value != null) {
            scheme = (STDCostEstimateSchemeInfo)this.schemeMap.get(value);
            if (scheme == null) {
                view = this.getSchemeEntityViewInfo(ctx, companyOrgUnitId, currentPeriod, value);
                STDCostEstimateSchemeCollection schemes = STDCostEstimateSchemeFactory.getLocalInstance(ctx).getSTDCostEstimateSchemeCollection(view);
                if (schemes.size() <= 0) {
                    String msg = MessageFormat.format(this.getResource("SCHEME_NUMBER_ERROR", ctx), value);
                    throw new BOSException(msg);
                }
                scheme = schemes.get(0);
                this.schemeMap.put(value, scheme);
            }
        } else {
            throw new BOSException(this.getResource("SCHEME_NUMBER_CANNOT_EMPTY", ctx));
        }
        info.setEstimateScheme(scheme);
        value = this.getStringValue(hsData, "resType.number");
        if (value != null) {
            resType = (STDResourceTypeInfo)this.schemeMap.get(value);
            if (resType == null) {
                view = this.getResTypeEntityViewInfo(ctx, companyOrgUnitId, value);
                STDResourceTypeCollection coll = STDResourceTypeFactory.getLocalInstance(ctx).getSTDResourceTypeCollection(view);
                if (coll.size() <= 0) {
                    String msg = MessageFormat.format(this.getResource("RESTYPE_NUMBER_ERROR", ctx), value);
                    throw new BOSException(msg);
                }
                resType = coll.get(0);
                this.resTypeMap.put(value, resType);
            }
        } else {
            throw new BOSException(this.getResource("RESTYPE_NUMBER_CANNOT_EMPTY", ctx));
        }
        info.setResourceType(resType);
        value = this.getStringValue(hsData, "material.number");
        if (value != null) {
            String storageOrgUnitId = info.getEstimateScheme().getStorageOrgUnit().getId().toString();
            material = (MaterialInfo)this.materialMap.get(storageOrgUnitId + "_" + value);
            if (material == null) {
                if (this.queryExecutor == null) {
                    MetaDataPK mdPk = new MetaDataPK("com.kingdee.eas.ncm.std.bill.app.MaterialFiStorageRollUpCostQuery");
                    this.queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mdPk);
                    this.queryExecutor.option().isAutoTranslateEnum = true;
                    this.queryExecutor.option().isAutoTranslateBoolean = true;
                    this.queryExecutor.option().isAutoIgnoreZero = true;
                }
                EntityViewInfo view2 = this.getMaterialEntityViewInfo(ctx, companyOrgUnitId, storageOrgUnitId, value);
                this.queryExecutor.setObjectView(view2);
                IRowSet rowSet = this.queryExecutor.executeQuery();
                try {
                    if (!rowSet.next()) {
                        String msg = MessageFormat.format(this.getResource("MATERIAL_NUMBER_ERROR", ctx), value);
                        throw new BOSException(msg);
                    }
                    material = new MaterialInfo();
                    material.setId(BOSUuid.read((String)rowSet.getString("id")));
                    material.setNumber(rowSet.getString("number"));
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                this.materialMap.put(info.getEstimateScheme().getNumber() + "_" + value, material);
            }
        } else {
            throw new BOSException(this.getResource("MATERIAL_NUMBER_CANNOT_EMPTY", ctx));
        }
        info.setMaterial(material);
        data = this.getData(hsData, "stdPrice");
        if (data instanceof BigDecimal) {
            info.setStdPrice((BigDecimal)data);
        } else if (data instanceof String) {
            try {
                info.setStdPrice(new BigDecimal(data.toString()));
            }
            catch (Exception ex) {
                info.setStdPrice(null);
            }
        }
        this.checkExists(ctx, info);
        return info;
    }

    private void checkExists(Context ctx, STDCostResourceTypeMaterialPriceInfo info) throws BOSException, EASBizException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)info.getCompanyOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("estimateScheme", (Object)info.getEstimateScheme().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("resourceType", (Object)info.getResourceType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        CMBillBaseCollection coll = ((ISTDCostResourceTypeMaterialPrice)this.getController(ctx)).getCMBillBaseCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                info.setId(coll.get(0).getId());
            } else {
                String empty = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)"CHECK_EMPTY", (Locale)ctx.getLocale());
                String schemeNumber = info.getEstimateScheme().getNumber();
                String schemeName = info.getEstimateScheme().getName();
                String scheme = empty;
                if (schemeNumber != null) {
                    scheme = "";
                    if (schemeName != null) {
                        scheme = schemeName;
                    }
                    scheme = scheme + "[" + schemeNumber + "]";
                }
                String resTypeNumber = info.getResourceType().getNumber();
                String resTypeName = info.getResourceType().getName();
                String resType = empty;
                if (resTypeNumber != null) {
                    resType = "";
                    if (resTypeName != null) {
                        resType = resTypeName;
                    }
                    resType = resType + "[" + resTypeNumber + "]";
                }
                String materialNumber = info.getMaterial().getNumber();
                String materialName = info.getMaterial().getName();
                String material = empty;
                if (materialNumber != null) {
                    material = "";
                    if (materialName != null) {
                        material = materialName;
                    }
                    material = material + "[" + materialNumber + "]";
                }
                Object[] params = new String[]{scheme, resType, material};
                String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.STDCostResourceTypeMaterialPriceResource", (String)"CHECK_ResTypeMatPrice_EXIST", (Locale)ctx.getLocale()), params);
                throw new BOSException(msg);
            }
        }
    }

    protected String getResource(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.STDCostResourceTypeMaterialPriceResource", (String)key, (Locale)locale);
    }
}

