/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillBaseCollection;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypePriceInfo;
import com.kingdee.eas.ncm.std.bill.app.AbstractSTDCostResourceTypePriceControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class STDCostResourceTypePriceControllerBean
extends AbstractSTDCostResourceTypePriceControllerBean {
    private static final long serialVersionUID = 4310298688184423563L;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_STDCostResTypePrice";
    }

    @Override
    protected void _generateData(Context ctx, String storageOrgUnitId, String companyId, List schemeList) throws BOSException, EASBizException {
        StorageOrgUnitInfo storage;
        String logInfo = "";
        if (!StringUtils.isEmpty((String)storageOrgUnitId) && (storage = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitId)))) != null && storage.getName() != null) {
            logInfo = storage.getName();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"generateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"std_STDCostResourceTypePrice_gen");
        if (StringUtils.isEmpty((String)storageOrgUnitId) || StringUtils.isEmpty((String)companyId)) {
            return;
        }
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (!sysctrol.isStart(1001, companyId)) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String periodId = period.getId().toString();
        String userId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getId() != null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" INSERT INTO T_NCM_STDCostResTypePrice \n");
        kSql.append("            (FID, \n");
        kSql.append("             FEstimateSchemeID, \n");
        kSql.append("             FResourceTypeID, \n");
        kSql.append("             FStdPrice, \n");
        kSql.append("             FDescription, \n");
        kSql.append("             FCompanyOrg, \n");
        kSql.append("             FCalculatePeriod, \n");
        kSql.append("             FBillStatus, \n");
        kSql.append("             FCreatorID, \n");
        kSql.append("             FCreateTime) \n");
        kSql.append(" SELECT NEWBOSID('481B001F') AS FID, \n");
        kSql.append("        scheme.FID AS FEstimateSchemeID, \n");
        kSql.append("        resType.FID AS FResourceTypeID, \n");
        kSql.append("        0 AS FStdPrice, \n");
        kSql.append("        NULL AS FDescription, \n");
        kSql.append("        '" + companyId + "' AS FCompanyOrg, \n");
        kSql.append("        '" + periodId + "' AS FCalculatePeriod, \n");
        kSql.append("        1 AS FBillStatus, \n");
        kSql.append("        '" + userId + "' AS FCreatorID, \n");
        kSql.append("        NOW() AS FCreateTime \n");
        kSql.append(" FROM   T_NCM_SCEstimateScheme scheme, \n");
        kSql.append("        T_NCM_SCResourceType resType \n");
        kSql.append(" WHERE  scheme.FStorageOrgUnitID = '" + storageOrgUnitId + "' \n");
        kSql.append("        AND scheme.FCompanyID = '" + companyId + "' \n");
        kSql.append("        AND resType.FCompanyID = '" + companyId + "' \n");
        kSql.append("        AND NOT EXISTS (SELECT * \n");
        kSql.append("                        FROM   T_NCM_STDCostResTypePrice \n");
        kSql.append("                        WHERE  FEstimateSchemeID = scheme.FID \n");
        kSql.append("                               AND FResourceTypeID = resType.FID) \n");
        if (schemeList != null && !schemeList.isEmpty()) {
            kSql.append("        AND scheme.FID IN (\n");
            int size = schemeList.size();
            for (int i = 0; i < size; ++i) {
                String schemeId = (String)schemeList.get(i);
                if (i != size - 1) {
                    kSql.append("'" + schemeId + "',");
                    continue;
                }
                kSql.append("'" + schemeId + "')");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        } else {
            kSql.append("        AND scheme.FSchemeType = 1 \n");
            kSql.append("        AND scheme.FState <> 2 \n");
            kSql.append("        AND scheme.FEndDate >= ? \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{period.getEndDate()});
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _updateData(Context ctx, Map data, List pks, ArrayList addObjList) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (data != null && !data.isEmpty()) {
            for (String id : data.keySet()) {
                set.add(id);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("estimateScheme.name"));
        view.getSelector().add(new SelectorItemInfo("resourceType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        StringBuffer logInfo = new StringBuffer();
        CoreBaseCollection cbc = this.getCollection(ctx, view);
        for (STDCostResourceTypePriceInfo info : cbc) {
            String str = info.getLogInfo();
            if (str == null || str.length() <= 0) continue;
            logInfo.append(str).append(",");
        }
        if (logInfo.length() > 0) {
            logInfo.deleteCharAt(logInfo.length() - 1);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"updateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"std_STDCostResourceTypePrice_save");
        if (pks != null && !pks.isEmpty()) {
            IObjectPK[] _pks = new IObjectPK[pks.size()];
            int size = pks.size();
            for (int i = 0; i < size; ++i) {
                _pks[i] = (IObjectPK)pks.get(i);
            }
            this._delete(ctx, _pks);
        }
        if ((data == null || data.isEmpty()) && addObjList.isEmpty()) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update T_NCM_STDCostResTypePrice set FStdPrice = ?,FDescription = ? where FID = ? ");
        PreparedStatement pstmtUpdate = null;
        Connection conn1 = null;
        try {
            conn1 = EJBFactory.getConnection((Context)ctx);
            pstmtUpdate = conn1.prepareStatement(updateSql.toString());
            for (String id : data.keySet()) {
                List values;
                if (StringUtils.isEmpty((String)id) || (values = (List)data.get(id)) == null || values.isEmpty()) continue;
                BigDecimal stdPrice = null;
                if (values.get(0) != null) {
                    stdPrice = (BigDecimal)values.get(0);
                }
                String desc = (String)values.get(1);
                pstmtUpdate.setBigDecimal(1, stdPrice);
                pstmtUpdate.setString(2, desc);
                pstmtUpdate.setString(3, id);
                pstmtUpdate.addBatch();
            }
            pstmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtUpdate, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtUpdate, (Connection)conn1);
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = null;
        String companyID = null;
        if (addObjList.size() > 0) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO T_NCM_STDCostResTypePrice \n").append("            (FID, \n").append("             FEstimateSchemeID, \n").append("             FResourceTypeID, \n").append("             FStdPrice, \n").append("             FDescription, \n").append("             FCompanyOrg, \n").append("             FCalculatePeriod, \n").append("             FBillStatus, \n").append("             FCreatorID, \n").append("             FCreateTime) \n").append("VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(insertSql.toString());
            for (int j = 0; j < addObjList.size(); ++j) {
                pstmtInsert.setString(1, ((STDCostResourceTypePriceInfo)addObjList.get(j)).getId().toString());
                pstmtInsert.setString(2, ((STDCostResourceTypePriceInfo)addObjList.get(j)).getEstimateScheme().getId().toString());
                pstmtInsert.setString(3, ((STDCostResourceTypePriceInfo)addObjList.get(j)).getResourceType().getId().toString());
                pstmtInsert.setBigDecimal(4, ((STDCostResourceTypePriceInfo)addObjList.get(j)).getStdPrice());
                pstmtInsert.setString(5, ((STDCostResourceTypePriceInfo)addObjList.get(j)).getDescription());
                pstmtInsert.setString(6, companyID);
                pstmtInsert.setString(7, periodInfo == null ? "period null" : String.valueOf(periodInfo.getId()));
                pstmtInsert.setString(8, "1");
                pstmtInsert.setString(9, UserInfo2.getId().toString());
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("estimateScheme.name"));
        sic.add(new SelectorItemInfo("resourceType.name"));
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk, sic);
        return info.getLogInfo();
    }

    protected void checkStart(Context ctx, CMBillBaseCollection billColl) throws BOSException, EASBizException {
    }

    protected boolean isUsingPeriod() {
        return false;
    }

    protected boolean isCheckStart() {
        return false;
    }
}

