/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.CMBillBaseCollection;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeQtyInfo;
import com.kingdee.eas.ncm.std.bill.app.AbstractSTDCostResourceTypeQtyControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class STDCostResourceTypeQtyControllerBean
extends AbstractSTDCostResourceTypeQtyControllerBean {
    private static final long serialVersionUID = 5607162875611140965L;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_STDCostResTypeQty";
    }

    @Override
    protected void _generateData(Context ctx, String storageOrgUnitId, String companyId, List schemeList, boolean onlyHasStdPrice) throws BOSException, EASBizException {
        StorageOrgUnitInfo storage;
        String logInfo = "";
        if (!StringUtils.isEmpty((String)storageOrgUnitId) && (storage = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitId)))) != null && storage.getName() != null) {
            logInfo = storage.getName();
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"generateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo, (String)"std_STDCostResourceTypeQty_gen");
        if (StringUtils.isEmpty((String)storageOrgUnitId) || StringUtils.isEmpty((String)companyId)) {
            return;
        }
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (!sysctrol.isStart(1001, companyId)) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        String periodId = period.getId().toString();
        String userId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getId() != null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" INSERT INTO T_NCM_STDCostResTypeQty \n");
        kSql.append("            (FID,\n");
        kSql.append("             FEstimateSchemeID,\n");
        kSql.append("             FMaterialID,\n");
        kSql.append("             FResourceTypeID,\n");
        kSql.append("             FStdQty,\n");
        kSql.append("             FCompanyOrg,\n");
        kSql.append("             FCalculatePeriod,\n");
        kSql.append("             FDescription,\n");
        kSql.append("             FBillStatus,\n");
        kSql.append("             FCreatorID,\n");
        kSql.append("             FCreateTime)\n");
        kSql.append(" SELECT NEWBOSID('40CEC30C') AS FID,\n");
        kSql.append("        scheme.FID AS FEstimateSchemeID,\n");
        kSql.append("        mat.FID AS FMaterialID,\n");
        kSql.append("        resType.FID AS FResourceTypeID,\n");
        kSql.append("        0 AS FStdQty,\n");
        kSql.append("        '" + companyId + "' AS FCompanyOrg,\n");
        kSql.append("        '" + periodId + "' AS FCalculatePeriod,\n");
        kSql.append("        NULL AS FDescription,\n");
        kSql.append("        1 AS FBillStatus,\n");
        kSql.append("        '" + userId + "' AS FCreatorID,\n");
        kSql.append("        NOW() AS FCreateTime\n");
        kSql.append(" FROM   T_BD_Material mat,\n");
        kSql.append("        T_BD_MaterialCompanyInfo matCompany,\n");
        kSql.append("        T_BD_MaterialInventory matInventory,\n");
        kSql.append("        T_NCM_SCEstimateScheme scheme,\n");
        kSql.append("        T_NCM_SCResourceType resType\n");
        kSql.append(" WHERE  mat.FID = matCompany.FMaterialID\n");
        kSql.append("        AND mat.FID = matInventory.FMaterialID\n");
        kSql.append("        AND matCompany.FCompanyID = '" + companyId + "'\n");
        kSql.append("        AND matInventory.FOrgUnit = '" + storageOrgUnitId + "'\n");
        kSql.append("        AND matCompany.FStatus = 1\n");
        kSql.append("        AND matInventory.FStatus = 1\n");
        kSql.append("        AND scheme.FStorageOrgUnitID = '" + storageOrgUnitId + "' \n");
        kSql.append("        AND scheme.FCompanyID = '" + companyId + "' \n");
        kSql.append("        AND resType.FCompanyID = '" + companyId + "' \n");
        kSql.append("        AND EXISTS (SELECT *\n");
        kSql.append("                    FROM   T_NCM_STDCostEstimateType t\n");
        kSql.append("                    WHERE  FMaterialID = mat.FID\n");
        kSql.append("                           AND FStorageOrgUnitID = '" + storageOrgUnitId + "'\n");
        kSql.append("                           AND FCompanyOrg = '" + companyId + "'\n");
        kSql.append("                           AND FEstimateType = 2)\n");
        kSql.append("        AND NOT EXISTS (SELECT *\n");
        kSql.append("                        FROM   T_NCM_STDCostResTypeQty\n");
        kSql.append("                        WHERE  FMaterialID = mat.FID\n");
        kSql.append("                               AND FEstimateSchemeID = scheme.FID\n");
        kSql.append("                               AND FResourceTypeID = resType.FID)\n");
        if (onlyHasStdPrice) {
            kSql.append("        AND resType.FID IN (SELECT FResourceTypeID FROM T_NCM_STDCostResTypePrice)\n");
        }
        if (schemeList != null && !schemeList.isEmpty()) {
            kSql.append("        AND scheme.FID IN (\n");
            int size = schemeList.size();
            for (int i = 0; i < size; ++i) {
                String schemeId = (String)schemeList.get(i);
                if (i != size - 1) {
                    kSql.append("'" + schemeId + "',");
                    continue;
                }
                kSql.append("'" + schemeId + "')");
            }
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
        } else {
            kSql.append("        AND scheme.FSchemeType = 1 \n");
            kSql.append("        AND scheme.FState <> 2 \n");
            kSql.append("        AND scheme.FEndDate >= ? \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{period.getEndDate()});
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _updateData(Context ctx, Map data, List pks, ArrayList addObjList) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (data != null && !data.isEmpty()) {
            for (String id : data.keySet()) {
                set.add(id);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("estimateScheme.name"));
        view.getSelector().add(new SelectorItemInfo("resourceType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        StringBuffer logInfo = new StringBuffer();
        CoreBaseCollection cbc = this.getCollection(ctx, view);
        for (STDCostResourceTypeQtyInfo info : cbc) {
            String str = info.getLogInfo();
            if (str == null || str.length() <= 0) continue;
            logInfo.append(str).append(",");
        }
        if (logInfo.length() > 0) {
            logInfo.deleteCharAt(logInfo.length() - 1);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"updateData", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"std_STDCostResourceTypeQty_save");
        if (pks != null && !pks.isEmpty()) {
            IObjectPK[] _pks = new IObjectPK[pks.size()];
            int size = pks.size();
            for (int i = 0; i < size; ++i) {
                _pks[i] = (IObjectPK)pks.get(i);
            }
            this._delete(ctx, _pks);
        }
        if ((data == null || data.isEmpty()) && addObjList.isEmpty()) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update T_NCM_STDCostResTypeQty set FStdQty = ?,FDescription = ? where FID = ? ");
        PreparedStatement pstmtUpdate = null;
        Connection conn1 = null;
        try {
            conn1 = EJBFactory.getConnection((Context)ctx);
            pstmtUpdate = conn1.prepareStatement(updateSql.toString());
            for (String id : data.keySet()) {
                List values;
                if (StringUtils.isEmpty((String)id) || (values = (List)data.get(id)) == null || values.isEmpty()) continue;
                BigDecimal stdQty = null;
                if (values.get(0) != null) {
                    stdQty = (BigDecimal)values.get(0);
                }
                String desc = (String)values.get(1);
                pstmtUpdate.setBigDecimal(1, stdQty);
                pstmtUpdate.setString(2, desc);
                pstmtUpdate.setString(3, id);
                pstmtUpdate.addBatch();
            }
            pstmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtUpdate, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtUpdate, (Connection)conn1);
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = null;
        String companyID = null;
        if (addObjList.size() > 0) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO T_NCM_STDCostResTypeQty \n").append("            (FID,\n").append("             FEstimateSchemeID,\n").append("             FMaterialID,\n").append("             FResourceTypeID,\n").append("             FStdQty,\n").append("             FCompanyOrg,\n").append("             FCalculatePeriod,\n").append("             FDescription,\n").append("             FBillStatus,\n").append("             FCreatorID,\n").append("             FCreateTime)\n").append("VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(insertSql.toString());
            for (int j = 0; j < addObjList.size(); ++j) {
                pstmtInsert.setString(1, ((STDCostResourceTypeQtyInfo)addObjList.get(j)).getId().toString());
                pstmtInsert.setString(2, ((STDCostResourceTypeQtyInfo)addObjList.get(j)).getEstimateScheme().getId().toString());
                pstmtInsert.setString(3, ((STDCostResourceTypeQtyInfo)addObjList.get(j)).getMaterial().getId().toString());
                pstmtInsert.setString(4, ((STDCostResourceTypeQtyInfo)addObjList.get(j)).getResourceType().getId().toString());
                pstmtInsert.setBigDecimal(5, ((STDCostResourceTypeQtyInfo)addObjList.get(j)).getStdQty());
                pstmtInsert.setString(6, companyID);
                pstmtInsert.setString(7, periodInfo == null ? "period null" : String.valueOf(periodInfo.getId()));
                pstmtInsert.setString(8, ((STDCostResourceTypeQtyInfo)addObjList.get(j)).getDescription());
                pstmtInsert.setString(9, "1");
                pstmtInsert.setString(10, UserInfo2.getId().toString());
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        insertSql.setLength(0);
        insertSql.append(" select STDdata.FEstimateSchemeID,STDdata.FMaterialID,STDdata.FResourceTypeID,estimateScheme.Fnumber as esNumber, ma.Fnumber as maNumber,type.Fnumber as tyNumer from t_ncm_STDCostResTypeqty STDdata\n");
        insertSql.append("          inner join T_NCM_SCEstimateScheme estimateScheme \n");
        insertSql.append("                on STDdata.FEstimateSchemeID = estimateScheme.fid \n");
        insertSql.append("          inner join T_BD_Material ma \n");
        insertSql.append("                on STDdata.FMaterialID = ma.fid \n");
        insertSql.append("          inner join t_ncm_SCResourceType type \n");
        insertSql.append("                on STDdata.FResourceTypeID = type.fid \n");
        insertSql.append("          group by STDdata.FEstimateSchemeID,STDdata.FMaterialID,STDdata.FResourceTypeID,estimateScheme.Fnumber , ma.Fnumber,type.Fnumber \n");
        insertSql.append("          HAVING COUNT(1)>1 \n");
        try {
            IRowSet rsda = NCMDbUtil.executeQuery((Context)ctx, (String)insertSql.toString());
            StringBuffer message = new StringBuffer();
            boolean flag = false;
            message.append("\n");
            while (rsda.next()) {
                flag = true;
                message.append("\u65b9\u6848\u7f16\u7801\uff1a").append(rsda.getString("esNumber")).append("  ").append("\u7269\u6599\u7f16\u7801\uff1a").append(rsda.getString("maNumber")).append("  ").append("\u4f5c\u4e1a\u7c7b\u578b\uff1a").append(rsda.getString("tyNumer") + "\n");
            }
            Object[] messages = new String[]{message.toString()};
            if (flag) {
                throw new NcmBillException(NcmBillException.CHECK_COMBIN, messages);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected boolean isSupportBotp() {
        return false;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("estimateScheme.name"));
        sic.add(new SelectorItemInfo("resourceType.name"));
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk, sic);
        return info.getLogInfo();
    }

    protected void checkStart(Context ctx, CMBillBaseCollection billColl) throws BOSException, EASBizException {
    }
}

