/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.cal.ISTDCostCheckItem;
import com.kingdee.eas.ncm.std.cal.ISTDCostCheckResult;
import com.kingdee.eas.ncm.std.cal.ISTDCostCheckResultDetail;
import com.kingdee.eas.ncm.std.cal.STDCostCheckItemCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckItemFactory;
import com.kingdee.eas.ncm.std.cal.STDCostCheckItemInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCheckParam;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailFactory;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultFactory;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultInfo;
import com.kingdee.eas.ncm.std.cal.app.AbstractSTDCostCheckItemControllerBean;
import com.kingdee.eas.ncm.std.cal.app.ISTDCostChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostCheckItemControllerBean
extends AbstractSTDCostCheckItemControllerBean {
    private static final long serialVersionUID = 9134305217762547595L;
    private static Logger logger = Logger.getLogger((String)STDCostCheckItemControllerBean.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected STDCostCheckItemInfo _checkCurrItem(Context ctx, STDCostCheckParam checkParam, STDCostCheckItemInfo currCheckItem) throws BOSException, EASBizException {
        Assert.that((checkParam != null && currCheckItem != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCompanyID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getEstimateSchemeID() != null ? 1 : 0) != 0);
        STDCostCheckResultInfo result = new STDCostCheckResultInfo();
        result.setStartDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        LowTimer timer = new LowTimer();
        try {
            String checkerName = currCheckItem.getChecker();
            Class<?> checkerClass = Class.forName(checkerName);
            ISTDCostChecker checker = (ISTDCostChecker)checkerClass.newInstance();
            result = checker.calChecker(ctx, checkParam, result);
            currCheckItem.getCheckResult().clear();
            currCheckItem.getCheckResult().add(result);
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage());
            STDCostCheckResultDetailInfo detail = new STDCostCheckResultDetailInfo();
            detail.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"15_STDCostCheckItemControllerBean", (Locale)ctx.getLocale()));
            detail.setReason(exc.toString().length() > 200 ? exc.toString().substring(0, 199) : exc.toString());
            detail.setSuggestOperation("");
            result.getDetail().add(detail);
        }
        finally {
            result.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            result.setSpendTime(CalculateUtil.getcalcHMSString((int)((int)timer.msValue())));
        }
        STDCostCheckItemCollection costCheckItems = new STDCostCheckItemCollection();
        costCheckItems.add(currCheckItem);
        this.saveCheckResult(ctx, checkParam, costCheckItems);
        return currCheckItem;
    }

    @Override
    protected STDCostCheckItemCollection _checkAllItems(Context ctx, STDCostCheckParam checkParam) throws BOSException, EASBizException {
        ISTDCostCheckItem iSTDCostCheckItem = STDCostCheckItemFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("seq");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        STDCostCheckItemCollection checkItems = iSTDCostCheckItem.getSTDCostCheckItemCollection(view);
        int size = checkItems.size();
        for (int i = 0; i < size; ++i) {
            STDCostCheckItemInfo costCheckItem = checkItems.get(i);
            costCheckItem = this._checkCurrItem(ctx, checkParam, costCheckItem);
            checkItems.set(i, costCheckItem);
        }
        this.saveCheckResult(ctx, checkParam, checkItems);
        return checkItems;
    }

    private void saveCheckResult(Context ctx, STDCostCheckParam checkParam, STDCostCheckItemCollection checkItems) throws BOSException, EASBizException {
        Assert.that((checkParam != null && checkItems != null && checkItems.size() > 0 ? 1 : 0) != 0);
        Assert.that((checkParam.getEstimateSchemeID() != null ? 1 : 0) != 0);
        String estimateSchemeID = checkParam.getEstimateSchemeID();
        STDCostCheckItemInfo checkItemInfo = null;
        STDCostCheckResultCollection checkResultCol = null;
        STDCostCheckResultInfo checkResultInfo = null;
        STDCostCheckResultDetailCollection checkResultDetailCol = null;
        STDCostCheckResultDetailInfo checkResultDetailInfo = null;
        String checkResulstID = null;
        String checkResultDetailID = null;
        Connection conn = null;
        PreparedStatement insertRstSta = null;
        PreparedStatement insertRstDetailSta = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer deleteResDetailKSql = new StringBuffer();
            deleteResDetailKSql.append(" DELETE FROM T_NCM_STDCostCheckRstDetail \n");
            deleteResDetailKSql.append("       WHERE FParentID IN (SELECT FID \n");
            deleteResDetailKSql.append("                       \t\t FROM T_NCM_STDCostCheckResult \n");
            deleteResDetailKSql.append("                      \t    WHERE FEstimateSchemeID = ? \n");
            deleteResDetailKSql.append("                              AND FParentID = ? ) \n");
            StringBuffer insertResKSql = new StringBuffer();
            insertResKSql.append(" INSERT INTO T_NCM_STDCostCheckResult \n");
            insertResKSql.append(" \t\t      (FID, \n");
            insertResKSql.append("   \t\t   FParentID, \n");
            insertResKSql.append("             FEstimateSchemeID, \n");
            insertResKSql.append("             FCheckStatus, \n");
            insertResKSql.append("             FStartDateTime, \n");
            insertResKSql.append("             FEndDateTime , \n");
            insertResKSql.append("             FSpendTime) \n");
            insertResKSql.append(" VALUES (?,?,?,?,?,?,?) \n");
            insertRstSta = conn.prepareStatement(insertResKSql.toString());
            StringBuffer insertResDetailKSql = new StringBuffer();
            insertResDetailKSql.append(" INSERT INTO T_NCM_STDCostCheckRstDetail \n");
            insertResDetailKSql.append("            (FID, \n");
            insertResDetailKSql.append("             FParentID, \n");
            insertResDetailKSql.append("             FDescription_l2, \n");
            insertResDetailKSql.append("             FDescription_l3, \n");
            insertResDetailKSql.append("             FReason_l2, \n");
            insertResDetailKSql.append("             FReason_l3, \n");
            insertResDetailKSql.append("             FSuggestOperation_l2, \n");
            insertResDetailKSql.append("             FSuggestOperation_l3) \n");
            insertResDetailKSql.append(" VALUES (?,?,?,?,?,?,?,?) \n");
            insertRstDetailSta = conn.prepareStatement(insertResDetailKSql.toString());
            boolean runUpdate = false;
            int i_size = checkItems.size();
            for (int i = 0; i < i_size; ++i) {
                checkItemInfo = checkItems.get(i);
                String checkItemID = checkItemInfo.getId().toString();
                NCMDbUtil.execute((Context)ctx, (String)deleteResDetailKSql.toString(), (Object[])new String[]{estimateSchemeID, checkItemID});
                NCMDbUtil.execute((Context)ctx, (String)" DELETE FROM T_NCM_STDCostCheckResult WHERE FEstimateSchemeID = ? AND  FParentID = ?", (Object[])new String[]{estimateSchemeID, checkItemID});
                checkResultCol = checkItemInfo.getCheckResult();
                int j_size = checkResultCol.size();
                for (int j = 0; j < j_size; ++j) {
                    checkResultInfo = checkResultCol.get(j);
                    checkResulstID = BOSUuid.create((String)"5B5653C8").toString();
                    insertRstSta.setString(1, checkResulstID);
                    insertRstSta.setString(2, checkItemID);
                    insertRstSta.setString(3, estimateSchemeID);
                    insertRstSta.setString(4, checkResultInfo.getCheckStatus().getValue());
                    insertRstSta.setTimestamp(5, checkResultInfo.getStartDateTime());
                    insertRstSta.setTimestamp(6, checkResultInfo.getEndDateTime());
                    insertRstSta.setString(7, checkResultInfo.getSpendTime());
                    insertRstSta.execute();
                    checkResultDetailCol = checkResultInfo.getDetail();
                    int k_size = checkResultDetailCol.size();
                    for (int k = 0; k < k_size; ++k) {
                        checkResultDetailInfo = checkResultDetailCol.get(k);
                        checkResultDetailID = BOSUuid.create((String)"75B96239").toString();
                        insertRstDetailSta.setString(1, checkResultDetailID);
                        insertRstDetailSta.setString(2, checkResulstID);
                        insertRstDetailSta.setString(3, checkResultDetailInfo.getDescription());
                        insertRstDetailSta.setString(4, checkResultDetailInfo.getDescription());
                        insertRstDetailSta.setString(5, checkResultDetailInfo.getReason());
                        insertRstDetailSta.setString(6, checkResultDetailInfo.getReason());
                        insertRstDetailSta.setString(7, checkResultDetailInfo.getSuggestOperation());
                        insertRstDetailSta.setString(8, checkResultDetailInfo.getSuggestOperation());
                        insertRstDetailSta.addBatch();
                        runUpdate = true;
                    }
                }
            }
            if (runUpdate) {
                insertRstDetailSta.executeBatch();
            }
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertRstSta);
                SQLUtils.cleanup(insertRstDetailSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertRstSta);
        SQLUtils.cleanup((Statement)insertRstDetailSta);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected STDCostCheckItemCollection _getResults(Context ctx, String estimateSchemeID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("seq");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        STDCostCheckItemCollection checkItemCol = this.getSTDCostCheckItemCollection(ctx, view);
        ISTDCostCheckResult iSTDCostCheckResult = STDCostCheckResultFactory.getLocalInstance(ctx);
        ISTDCostCheckResultDetail iSTDCostCheckResultDetail = STDCostCheckResultDetailFactory.getLocalInstance(ctx);
        int size = checkItemCol.size();
        for (int i = 0; i < size; ++i) {
            STDCostCheckItemInfo checkItem = checkItemCol.get(i);
            checkItem.getCheckResult().clear();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("estimateScheme.id", (Object)estimateSchemeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)checkItem.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            viewInfo.setSelector(sic);
            STDCostCheckResultCollection checkResultCol = iSTDCostCheckResult.getSTDCostCheckResultCollection(viewInfo);
            for (int j = 0; j < checkResultCol.size(); ++j) {
                STDCostCheckResultInfo resultInfo = checkResultCol.get(j);
                EntityViewInfo _viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)resultInfo.getId().toString(), CompareType.EQUALS));
                _viewInfo.setFilter(filterInfo);
                STDCostCheckResultDetailCollection rstDetailCol = null;
                try {
                    rstDetailCol = iSTDCostCheckResultDetail.getSTDCostCheckResultDetailCollection(_viewInfo);
                }
                catch (ObjectNotFoundException exc) {
                    throw new BOSException((Throwable)exc);
                }
                if (rstDetailCol == null) continue;
                resultInfo.getDetail().addCollection(rstDetailCol);
            }
            checkItem.getCheckResult().addCollection(checkResultCol);
        }
        return checkItemCol;
    }
}

