/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.cal.STDCostCheckParam;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultInfo;
import com.kingdee.eas.ncm.std.cal.app.ISTDCostChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostResTypePriceChecker
implements ISTDCostChecker {
    private static Logger logger = Logger.getLogger((String)STDCostResTypePriceChecker.class.getName());

    @Override
    public STDCostCheckResultInfo calChecker(Context ctx, STDCostCheckParam checkParam, STDCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        Assert.that((checkParam.getResStdQtySchemeID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getResStdPriceSchemeID() != null ? 1 : 0) != 0);
        Assert.that((costCheckResultInfo != null ? 1 : 0) != 0);
        String resStdQtySchemeID = checkParam.getResStdQtySchemeID();
        String resStdPriceSchemeID = checkParam.getResStdPriceSchemeID();
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        costCheckResultInfo.getDetail().addCollection(new STDCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT DISTINCT \n");
        kSql.append("        mat.FNumber AS matNumber, \n");
        kSql.append("        mat.FName_" + ctx.getLocale() + " AS matName, \n");
        kSql.append("        res.FNumber AS resNumber, \n");
        kSql.append("        res.FName_" + ctx.getLocale() + " AS resName \n");
        kSql.append(" FROM   T_NCM_STDCostResTypeQty resQty \n");
        kSql.append("        INNER JOIN T_NCM_SCResourceType res ");
        kSql.append("        ON res.FID = resQty.FResourceTypeID ");
        kSql.append("        AND resQty.FEstimateSchemeID = ? \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostResTypePrice resPrice \n");
        kSql.append("        ON resPrice.FResourceTypeID = resQty.FResourceTypeID \n");
        kSql.append("        AND resPrice.FEstimateSchemeID = ? \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostResTypeMatPrice matPrice \n");
        kSql.append("        ON matPrice.FResourceTypeID = resQty.FResourceTypeID \n");
        kSql.append("        AND matPrice.FMaterialID = resQty.FMaterialID \n");
        kSql.append("        AND matPrice.FEstimateSchemeID = ? \n");
        kSql.append("        INNER JOIN T_BD_Material mat \n");
        kSql.append("        ON mat.FID = resQty.FMaterialID \n");
        kSql.append(" WHERE  resPrice.FSTDPrice IS NULL \n");
        kSql.append("        AND matPrice.FSTDPrice IS NULL \n");
        String[] materialIds = checkParam.getMaterialIDs();
        if (materialIds != null && materialIds.length > 0) {
            kSql.append("        AND mat.FID in (\n");
            StringBuffer idsSql = new StringBuffer();
            idsSql.append("        ");
            for (int i = 0; i < materialIds.length; ++i) {
                idsSql.append("'").append(materialIds[i]).append("',");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            kSql.append(idsSql).append("\n");
            kSql.append("        )\n");
        }
        kSql.append(" ORDER BY mat.FNumber, res.FNumber \n");
        IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{resStdQtySchemeID, resStdPriceSchemeID, resStdPriceSchemeID});
        try {
            String description = ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.STDCALResource", (String)"RTPChecker_Description", (Locale)ctx.getLocale());
            String reason = ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.STDCALResource", (String)"RTPChecker_Reason", (Locale)ctx.getLocale());
            String suggestOperation = ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.STDCALResource", (String)"RTPChecker_SuggestOperation", (Locale)ctx.getLocale());
            while (rst.next()) {
                STDCostCheckResultDetailInfo detail = new STDCostCheckResultDetailInfo();
                detail.setDescription(MessageFormat.format(description, rst.getString("matNumber"), rst.getString("matName"), rst.getString("resNumber"), rst.getString("resName")));
                detail.setReason(reason);
                detail.setSuggestOperation(suggestOperation);
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return costCheckResultInfo;
    }
}

